/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph;

import java.awt.Color;
import org.apache.log4j.Logger;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.data.xy.XYSeries;

public class XYData {
    private Logger logger = Logger.getLogger(XYData.class.getName());
    private double[] xdata;
    private double[] ydata;
    public static int DOUBLE = 0;
    public static int INTEGER = 1;
    public int collectionIndex = 0;
    public int seriesIndex = -1;
    public String xAxisName = "";
    public String yAxisName = "";
    public boolean xisLog = false;
    public boolean yisLog = false;
    public int xValType = DOUBLE;
    public int yValType = DOUBLE;
    public AxisLocation yAxisLocation = AxisLocation.BOTTOM_OR_LEFT;
    public Color seriesColor = null;
    private String name = "";
    private XYSeries series;

    public XYData(double[] xdata, double[] ydata, String name) {
        this.xdata = xdata;
        this.ydata = ydata;
        this.name = name;
    }

    public XYData(String[] strxData, String[] stryData, String name) throws NumberFormatException {
        int i;
        this.xdata = new double[strxData.length];
        this.ydata = new double[stryData.length];
        this.name = name;
        for (i = 0; i < this.xdata.length; ++i) {
            this.xdata[i] = Double.parseDouble(strxData[i].replaceAll("D", "E"));
        }
        for (i = 0; i < this.ydata.length; ++i) {
            this.ydata[i] = Double.parseDouble(stryData[i].replaceAll("D", "E"));
        }
    }

    public XYData(String name) {
        this.name = name;
    }

    public double[] getXData() {
        return this.xdata;
    }

    public double[] getYData() {
        return this.ydata;
    }

    public XYSeries createXYSeries() {
        this.series = new XYSeries((Comparable)((Object)this.name));
        if (this.xdata == null || this.ydata == null) {
            return this.series;
        }
        int numData = this.xdata.length;
        if (numData > this.ydata.length) {
            numData = this.ydata.length;
        }
        for (int i = 0; i < numData; ++i) {
            this.series.add(this.xdata[i], this.ydata[i]);
        }
        return this.series;
    }

    public XYSeries getXYSeries() {
        if (this.series == null) {
            return this.createXYSeries();
        }
        return this.series;
    }

    public void add(double x, double y) {
        if (this.series == null) {
            this.createXYSeries();
        }
        try {
            this.series.add(x, y);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

