/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.file.ChaseFileInfoSpec;
import java.awt.Color;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

class FileTransferSchemeTable
extends JTable {
    private Logger logger = Logger.getLogger(FileTransferSchemeTable.class.getName());
    private DefaultTableModel tableModel;
    private ChaseFileInfoSpec[] spec;

    protected FileTransferSchemeTable(DefaultTableModel tableModel, ChaseFileInfoSpec[] spec) {
        super(tableModel);
        this.tableModel = tableModel;
        this.spec = spec;
        this.setSelectionForeground(Color.white);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.spec.length; ++i) {
            int j;
            ChaseFileInfoSpec cfspec = this.spec[i];
            if (cfspec.getEditor().equals(ChaseFileInfoSpec.EDITOR_TEXTFIELD)) {
                JTextField textField = new JTextField(cfspec.getDefaultValue());
                textField.setEditable(cfspec.isEditable());
                this.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(textField));
                for (j = 0; j < this.getRowCount(); ++j) {
                    this.setValueAt(cfspec.getDefaultValue(), j, i);
                }
                continue;
            }
            if (cfspec.getEditor().equals(ChaseFileInfoSpec.EDITOR_COMBO)) {
                JComboBox<String> combo = new JComboBox<String>(cfspec.getChoices());
                combo.setSelectedItem(cfspec.getDefaultValue());
                this.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(combo));
                for (j = 0; j < this.getRowCount(); ++j) {
                    this.setValueAt(cfspec.getDefaultValue(), j, i);
                }
                continue;
            }
            if (!cfspec.getEditor().equals(ChaseFileInfoSpec.EDITOR_CHECKBOX)) continue;
            JCheckBox checkBox = new JCheckBox();
            checkBox.setEnabled(cfspec.isEditable());
            boolean val = new Boolean(cfspec.getDefaultValue());
            checkBox.setSelected(val);
            this.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(checkBox));
            for (int j2 = 0; j2 < this.getRowCount(); ++j2) {
                this.setValueAt(new Boolean(cfspec.getDefaultValue()), j2, i);
            }
        }
    }
}

