/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PhaseUtils {
    private static Logger logger = Logger.getLogger(PhaseUtils.class.getName());

    private PhaseUtils() {
    }

    public static Cell getCellFrom(InputInterface inputInterface) {
        inputInterface.selectRoot();
        inputInterface.selectBlock("structure.unit_cell");
        String avec = inputInterface.getPrimitiveEntry("a_vector").getValue();
        String bvec = inputInterface.getPrimitiveEntry("b_vector").getValue();
        String cvec = inputInterface.getPrimitiveEntry("c_vector").getValue();
        String a = "";
        String b = "";
        String c = "";
        String alpha = "";
        String beta = "";
        String gamma = "";
        if (avec.trim().length() == 0) {
            a = inputInterface.getPrimitiveEntry("a").getValue();
            b = inputInterface.getPrimitiveEntry("b").getValue();
            c = inputInterface.getPrimitiveEntry("c").getValue();
            alpha = inputInterface.getPrimitiveEntry("alpha").getValue();
            beta = inputInterface.getPrimitiveEntry("beta").getValue();
            gamma = inputInterface.getPrimitiveEntry("gamma").getValue();
        }
        inputInterface.selectRoot();
        if (avec.trim().length() != 0) {
            try {
                String[] av = avec.split("\\s+");
                String[] bv = bvec.split("\\s+");
                String[] cv = cvec.split("\\s+");
                double[][] tmp = new double[3][3];
                for (int i = 0; i < 3; ++i) {
                    tmp[0][i] = Double.parseDouble(av[i]);
                    tmp[1][i] = Double.parseDouble(bv[i]);
                    tmp[2][i] = Double.parseDouble(cv[i]);
                }
                Cell cel = new Cell(tmp[0], tmp[1], tmp[2]);
                return cel;
            }
            catch (Exception exc) {
                return null;
            }
        }
        try {
            double da = Double.parseDouble(a);
            double db = Double.parseDouble(b);
            double dc = Double.parseDouble(c);
            double dalpha = Double.parseDouble(alpha);
            double dbeta = Double.parseDouble(beta);
            double dgamma = Double.parseDouble(gamma);
            Cell cel = new Cell(da, db, dc, dalpha, dbeta, dgamma);
            AtomCoords coo = new AtomCoords();
            coo.setCell(cel);
            coo.convertCell(0);
            Cell cell0 = coo.getCell(0);
            return cell0;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static double[][] getReciprocalLatticeFrom(InputInterface inputInterface) {
        double[][] cell = null;
        Cell ce = PhaseUtils.getCellFrom(inputInterface);
        if (ce == null) {
            return null;
        }
        if (BravaisLattice.isBravais(inputInterface)) {
            double[][] dcell;
            BravaisLattice blat;
            if (ce.getCellScheme() == 0) {
                AtomCoords coord = new AtomCoords();
                coord.setCell(ce);
                coord.convertCell(1);
                ce = coord.getCell(1);
            }
            if ((blat = BravaisLattice.getBravaisLattice((dcell = ce.getDouble())[0][0], dcell[0][1], dcell[0][2], dcell[1][0], dcell[1][1], dcell[1][2], BravaisLattice.getLatticeSystemFrom(inputInterface))) != null) {
                double[][] prim = blat.getPrimitiveLatticeVector();
                Cell tmpcell = new Cell(prim[0], prim[1], prim[2]);
                cell = tmpcell.getReciprocalLattice();
            }
        }
        if (cell == null && (cell = ce.getReciprocalLattice()) != null) {
            for (int i = 0; i < 3; ++i) {
                logger.debug("reclat " + cell[i][0] + ", " + cell[i][1] + ", " + cell[i][2]);
            }
        }
        return cell;
    }

    public static double[][] getReciprocalLatticeFrom(AtomCoords coords) {
        double[][] cell = new double[3][3];
        try {
            Cell ce = coords.getCell()[0];
            cell = ce.getReciprocalLattice();
        }
        catch (Exception exc) {
            logger.error("failed to obtain cell.");
            return null;
        }
        return cell;
    }

    public static boolean hasUSPP(AtomCoords coords) {
        AtomList atomList = coords.getAtomList();
        Vector<String> elemNames = new Vector<String>();
        for (int i = 0; i < atomList.getNumAt(); ++i) {
            Atom atom = atomList.getAtomAt(i);
            elemNames.add(atom.getElementName());
        }
        return PhaseUtils.hasUSPPSub(elemNames);
    }

    public static boolean hasUSPP(InputInterface inputInterface) {
        InputInterfaceTable table = inputInterface.getInputInterfaceTable("structure.atom_list.atoms");
        int elem = table.getIndexFor("element");
        Vector dat = table.getTableData();
        Vector<String> elemNames = new Vector<String>();
        for (int i = 0; i < dat.size(); ++i) {
            String ele = ((String[])dat.get(i))[elem];
            elemNames.add(ele);
        }
        return PhaseUtils.hasUSPPSub(elemNames);
    }

    private static boolean hasUSPPSub(Vector elemNames) {
        File ppdir = new File(Utils.getDefaultPPDir());
        File[] ppfiles = ppdir.listFiles();
        Vector elements = Utils.removeDupli(elemNames);
        for (int i = 0; i < elements.size(); ++i) {
            for (int j = 0; j < ppfiles.length; ++j) {
                String comp = ppfiles[j].getName().split("_")[0] + "\\d*";
                if (!elements.get(i).toString().matches(comp) || ppfiles[j].getName().split("_us_").length != 2) continue;
                return true;
            }
        }
        return false;
    }

    private static int getNumBandsSub(Vector elemNames, double factor) {
        return PhaseUtils.getNumBandsSub(elemNames, null, factor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNumBandsSub(Vector elemNames, Vector weight, double factor) {
        File ppdir = new File(Utils.getDefaultPPDir());
        File[] ppfiles = ppdir.listFiles();
        Vector elements = Utils.removeDupli(elemNames);
        HashMap<String, String> numElectrons = new HashMap<String, String>();
        if (elements == null) {
            return -1;
        }
        block15: for (int i = 0; i < elements.size(); ++i) {
            String name = (String)elements.get(i);
            for (int j = ppfiles.length - 1; j >= 0; --j) {
                logger.debug("name: " + name);
                String comp = ppfiles[j].getName().split("_")[0] + "\\d*";
                if (!name.matches(comp)) continue;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(ppfiles[j]));
                    String firstLine = "";
                    while ((firstLine = reader.readLine().trim()).startsWith("#") || firstLine.startsWith("*") || firstLine.length() == 0) {
                    }
                    numElectrons.put(name, firstLine.split("\\s+")[1]);
                    continue block15;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    logger.error("encountered error while reading ppfile " + name);
                    continue block15;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {}
                }
            }
        }
        int numbands = 0;
        for (int i = 0; i < elemNames.size(); ++i) {
            Object tmp = numElectrons.get(elemNames.get(i));
            int wei = 1;
            if (weight != null && weight.size() > i) {
                try {
                    wei = (Integer)weight.get(i);
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
            }
            if (tmp == null || tmp.toString().trim().length() == 0) continue;
            try {
                numbands += Integer.parseInt(tmp.toString()) * wei;
                continue;
            }
            catch (NumberFormatException nfe) {
                logger.error("invalid num. electrons :" + tmp.toString() + " for element: " + elemNames.get(i));
            }
        }
        logger.debug("total number of valence electrons: " + ++numbands);
        return (int)Math.round((double)numbands * 0.5 * factor);
    }

    public static int getNumBands(InputInterface inputInterface, boolean metallic, boolean spin, double factor) {
        if (metallic) {
            factor *= 1.2;
        }
        Vector<String> elemNames = new Vector<String>();
        InputInterfaceTable atmtable = inputInterface.getInputInterfaceTable("structure.atom_list.atoms");
        int elemInd = atmtable.getIndexFor("element");
        int weiInd = atmtable.getIndexFor("weight");
        Vector data = atmtable.getTableData();
        Vector<Integer> weight = new Vector<Integer>();
        for (int i = 0; i < data.size(); ++i) {
            String[] dat = (String[])data.get(i);
            elemNames.add(dat[elemInd]);
            if (weiInd < dat.length) {
                try {
                    weight.add(new Integer(dat[weiInd]));
                }
                catch (NumberFormatException nfe) {
                    weight.add(new Integer(1));
                }
                continue;
            }
            weight.add(new Integer(1));
        }
        logger.debug("elemnames.size(): " + elemNames.size());
        logger.debug("size of atmtable: " + atmtable.getTableData().size());
        return PhaseUtils.getNumBandsSub(elemNames, weight, factor);
    }

    public static int getDefaultNumBands(InputInterface inputInterface, boolean metallic, boolean spin) {
        return PhaseUtils.getNumBands(inputInterface, metallic, spin, 1.2);
    }

    public static int getDefaultNumBands(AtomCoords coords, boolean metallic, boolean spin) {
        double factor = 1.2;
        if (metallic) {
            factor = 1.5;
        }
        if (spin) {
            factor *= 1.5;
        }
        AtomList atomList = coords.getAtomList();
        Vector<String> elemNames = new Vector<String>();
        Vector<Integer> weight = new Vector<Integer>();
        for (int i = 0; i < atomList.getNumAt(); ++i) {
            Atom atom = atomList.getAtomAt(i);
            elemNames.add(atom.getElementName());
            String wei = atom.getProperty("weight");
            if (wei != null && wei.trim().equals("2")) {
                weight.add(new Integer(2));
                continue;
            }
            weight.add(new Integer(1));
        }
        return PhaseUtils.getNumBandsSub(elemNames, weight, factor);
    }

    public static int[] getDefaultKmesh(Cell cell, boolean metallic) {
        int[] ret = new int[]{1, 1, 1};
        double[][] dcell = null;
        double factor = 30.0;
        if (metallic) {
            factor = 60.0;
        }
        if (cell != null) {
            dcell = cell.getDouble();
        }
        if (dcell == null) {
            logger.error("invalid cell.");
            return ret;
        }
        try {
            double lenx = Math.sqrt(Math.pow(dcell[0][0], 2.0) + Math.pow(dcell[0][1], 2.0) + Math.pow(dcell[0][2], 2.0));
            double leny = Math.sqrt(Math.pow(dcell[1][0], 2.0) + Math.pow(dcell[1][1], 2.0) + Math.pow(dcell[1][2], 2.0));
            double lenz = Math.sqrt(Math.pow(dcell[2][0], 2.0) + Math.pow(dcell[2][1], 2.0) + Math.pow(dcell[2][2], 2.0));
            ret[0] = (int)Math.round(factor / lenx);
            ret[1] = (int)Math.round(factor / leny);
            ret[2] = (int)Math.round(factor / lenz);
            for (int i = 0; i < 3; ++i) {
                if (ret[i] != 0) continue;
                ret[i] = 1;
            }
        }
        catch (Exception exc) {
            logger.error("failed to get default kmesh.");
        }
        return ret;
    }

    public static int checkNumBands(JComponent parent, int currnumbands, InputInterface inputInterface) {
        int retval = -1;
        try {
            int defaultNumBands = PhaseUtils.getDefaultNumBands(inputInterface, false, false);
            int minNumBands = PhaseUtils.getNumBands(inputInterface, false, false, 1.0);
            if (currnumbands >= defaultNumBands) {
                JOptionPane.showInternalMessageDialog(parent, "There are enough number of bands;\n current number of bands: " + String.valueOf(currnumbands) + " minimum number of bands: " + String.valueOf(minNumBands) + " recommended number of bands: " + String.valueOf(defaultNumBands));
            } else {
                int ret = JOptionPane.showInternalConfirmDialog(parent, "Current number of bands: " + String.valueOf(currnumbands) + ", minimum number of bands: " + String.valueOf(minNumBands) + ", recommended number of bands: " + String.valueOf(defaultNumBands) + ". Fix it?", "", 2);
                if (ret == 0) {
                    retval = defaultNumBands;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }
}

