/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LineEditor {
    public static final int NOT_FOUND = -1;
    private String fullString;
    private Vector vecLine;
    private int numLines;

    public LineEditor(String fullString) {
        this.fullString = fullString;
        this.divideIntoLines();
    }

    public void setFullString(String fullString) {
        this.fullString = fullString;
        this.divideIntoLines();
    }

    public String getFullString() {
        this.fullString = new String();
        for (int i = 0; i < this.numLines; ++i) {
            this.fullString = this.fullString + (String)this.vecLine.get(i) + System.getProperty("line.separator");
        }
        return this.fullString;
    }

    public int getNumLines() {
        return this.numLines;
    }

    private void divideIntoLines() {
        this.vecLine = new Vector();
        StringTokenizer st = new StringTokenizer(this.fullString, System.getProperty("line.separator"));
        this.numLines = st.countTokens();
        for (int i = 0; i < this.numLines; ++i) {
            this.vecLine.addElement(st.nextToken());
        }
    }

    public String getLine(int index) {
        if (!this.testIndex(index)) {
            return null;
        }
        return (String)this.vecLine.get(index);
    }

    public int find(String searchString) {
        int i;
        for (i = 0; i < this.numLines && !((String)this.vecLine.get(i)).trim().startsWith(searchString); ++i) {
        }
        if (i == this.numLines) {
            return -1;
        }
        return i;
    }

    public int find(int istart, String searchString) {
        int i;
        if (istart >= this.numLines) {
            return -1;
        }
        for (i = istart; i < this.numLines && !((String)this.vecLine.get(i)).trim().startsWith(searchString); ++i) {
        }
        if (i == this.numLines) {
            return -1;
        }
        return i;
    }

    public int findIgnoreCase(String searchString) {
        int i;
        for (i = 0; i < this.numLines && !((String)this.vecLine.get(i)).trim().toLowerCase().startsWith(searchString.trim().toLowerCase()); ++i) {
        }
        if (i == this.numLines) {
            return -1;
        }
        return i;
    }

    public int findIgnoreCase(int istart, String searchString) {
        int i;
        if (!this.testIndex(istart)) {
            return -1;
        }
        for (i = istart; i < this.numLines && !((String)this.vecLine.get(i)).trim().toLowerCase().startsWith(searchString.trim().toLowerCase()); ++i) {
        }
        if (i == this.numLines) {
            return -1;
        }
        return i;
    }

    public void replaceLine(int index, String replaceString) {
        if (!this.testIndex(index)) {
            return;
        }
        this.vecLine.remove(index);
        this.vecLine.add(index, replaceString);
        this.numLines = this.vecLine.size();
    }

    public void addLine(int index, String addString) {
        if (!this.testIndex(index)) {
            return;
        }
        this.vecLine.add(index, addString);
        this.numLines = this.vecLine.size();
    }

    public void deleteLine(int index) {
        if (!this.testIndex(index)) {
            return;
        }
        this.vecLine.remove(index);
        this.numLines = this.vecLine.size();
    }

    private boolean testIndex(int index) {
        if (index >= this.numLines) {
            return false;
        }
        return index >= 0;
    }

    public static void main(String[] args) {
        String str = new String();
        String string = new String();
        try {
            FileReader freader = new FileReader(args[0]);
            BufferedReader breader = new BufferedReader(freader);
            while ((str = breader.readLine()) != null) {
                string = string + str + System.getProperty("line.separator");
            }
            freader.close();
        }
        catch (IOException e) {
            System.out.println("failed read from file: " + args[0]);
        }
        LineEditor lineeditor = new LineEditor(string);
        for (int i = 0; i < lineeditor.getNumLines(); ++i) {
        }
        System.out.println(lineeditor.findIgnoreCase(lineeditor.findIgnoreCase("ek_convergence"), "}"));
        System.out.println(lineeditor.findIgnoreCase(args[1]));
    }
}

