/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class ExternalProgramPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(ExternalProgramPanel.class.getName());
    private Container cont;
    private JButton btnok;
    private JButton btncancel;
    protected String exeString = new String();
    protected final String FS = System.getProperty("file.separator");
    protected String baseDir;
    private JPanel pbutton;
    private MyMessageBox mbox = new MyMessageBox();
    private String currDir = System.getProperty("user.dir");

    public ExternalProgramPanel(String title) {
        super(title, true, true, true, true);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createMainPanel());
        this.cont.add(this.createButtonPanel());
    }

    public ExternalProgramPanel(String title, Dimension size) {
        super(title, true, true, true, true, size);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createMainPanel());
        this.cont.add(this.createButtonPanel());
    }

    public ExternalProgramPanel(String title, String baseDir, Dimension size) {
        super(title, true, true, true, true, size);
        this.baseDir = baseDir;
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createMainPanel());
        this.cont.add(this.createButtonPanel());
    }

    public String getExeString() {
        return this.exeString;
    }

    public void setExeString(String exeString) {
        this.exeString = exeString;
    }

    protected void setCurrDir(String currDir) {
        this.currDir = currDir;
    }

    private JPanel createButtonPanel() {
        this.pbutton = new JPanel();
        this.pbutton.setLayout(new FlowLayout());
        this.btnok = new JButton("OK");
        this.btncancel = new JButton("cancel");
        this.pbutton.add(this.btnok);
        this.pbutton.add(this.btncancel);
        this.btnok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ExternalProgramPanel.this.createExeString()) {
                    ExternalProgramPanel.this.dispose();
                    return;
                }
                if (!ExternalProgramPanel.this.bootExecuter()) {
                    ExternalProgramPanel.this.dispose();
                    return;
                }
                ExternalProgramPanel.this.bootPostProcess();
            }
        });
        this.btncancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalProgramPanel.this.dispose();
            }
        });
        return this.pbutton;
    }

    public boolean bootExecuter() {
        this.logger.info("executing: " + this.exeString);
        try {
            String str;
            BufferedReader[] br = ExternalProgramExecuter.executeGetBR(this.exeString, new File(this.currDir));
            while ((str = br[0].readLine()) != null) {
                this.logger.info(str);
            }
            br[0].close();
            br[1].close();
        }
        catch (Exception e) {
            this.mbox.setText("failed execution of " + this.exeString);
            return false;
        }
        return true;
    }

    public void bootPostProcess() {
    }

    public abstract boolean createExeString();

    public abstract JPanel createMainPanel();

    protected String getPerlScript(String name) {
        String ret = "";
        String FS = System.getProperty("file.separator");
        GlobalProperties pm = PropertiesManager.getGlobalProperties(0);
        ret = System.getProperty("pviewer.home") + FS + pm.getProperty("phasetoolsdir") + FS + name;
        if (!new File(ret).exists()) {
            ret = name;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            ret = "perl.exe " + Utils.getPathDQ(ret);
        }
        return ret;
    }
}

