/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ElementDef;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.ComboBoxChoices;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.settings.PropertiesManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ElementInfo
implements ComboBoxChoices {
    private static Logger logger = Logger.getLogger(ElementInfo.class.getName());
    int MAX_ELEMENTS;
    int NOSUCHELEMENT;
    public int num_elements;
    public ElementDef[] edef;
    private String elementInfoFile = new String();
    private static ElementInfo elementInfo;
    private ElementDef[] hbondCandidates;

    public static ElementInfo getElementInfo() {
        if (elementInfo == null) {
            elementInfo = new ElementInfo();
        }
        return elementInfo;
    }

    public static void updateElement(InputInterface inpint) {
        if (inpint == null) {
            logger.error("inputinterface is null.");
            return;
        }
        InputInterfaceTable table = inpint.getInputInterfaceTable("structure.atom_list.atoms");
        if (table == null) {
            logger.error("tablecolumns are null.");
            return;
        }
        String[] cols = table.getColumnIdentifiers();
        if (cols == null) {
            return;
        }
        int elemIndex = table.getIndexFor("element");
        if (elemIndex < 0) {
            logger.debug("couldn't find 'element' column");
            return;
        }
        Vector vec = table.getTableData();
        if (vec == null || vec.size() == 0) {
            logger.debug("no data.");
            return;
        }
        Vector<String> vec2 = new Vector<String>();
        for (int i = 0; i < vec.size(); ++i) {
            String[] row = (String[])vec.elementAt(i);
            String elem = row[elemIndex];
            if (elem.trim().length() != 0) {
                vec2.addElement(elem.trim());
            }
            logger.debug("element of atom no. " + i + ": " + elem);
        }
        if (vec2.size() == 0) {
            return;
        }
        Object[] string = new String[vec2.size()];
        vec2.copyInto(string);
        Vector foo = Utils.removeDupli(string);
        Object[] bar = new String[foo.size()];
        foo.copyInto(bar);
        Arrays.sort(bar);
        ElementInfo info = ElementInfo.getElementInfo();
        InputInterfaceTable tableelem = inpint.getInputInterfaceTable("structure.element_list");
        Vector exiData = tableelem.getTableData();
        String[] exiIdents = tableelem.getColumnIdentifiers();
        int exiElemInd = tableelem.getIndexFor("element");
        Object[] elements = new String[exiData.size()];
        if (exiElemInd >= 0) {
            for (int i = 0; i < exiData.size(); ++i) {
                elements[i] = ((String[])exiData.get(i))[exiElemInd];
            }
            Arrays.sort(elements);
            if (Arrays.equals(bar, elements)) {
                return;
            }
        }
        tableelem.initializeData();
        String[] identifiers = new String[]{"element", "atomicnumber", "mass", "zeta", "deviation"};
        for (int i = 0; i < foo.size(); ++i) {
            String[] dat = null;
            String el = (String)foo.get(i);
            Object useThis = null;
            if (exiData != null) {
                for (int j = 0; j < exiData.size(); ++j) {
                    String[] exirow = (String[])exiData.elementAt(j);
                    if (!el.equals(exirow[exiElemInd])) continue;
                    dat = exirow;
                    identifiers = exiIdents;
                }
            }
            if (dat == null) {
                dat = new String[]{el, String.valueOf(info.getNumberFromSymbol(el)), info.getMassFromSymbol(el), "0.0", "1.83"};
            }
            tableelem.insertTableDataRow(identifiers, dat, i);
        }
        inpint.selectRoot();
    }

    public ElementInfo() {
        this.MAX_ELEMENTS = ConstParameters.MAX_ELEMENTS;
        this.NOSUCHELEMENT = ConstParameters.NOSUCHELEMENT;
        this.elementInfoFile = PropertiesManager.getGlobalProperties(3).getFileName();
        this.setEdef();
        this.num_elements = this.edef.length;
    }

    public int getNumEl() {
        int num = 0;
        for (int i = 0; i < this.edef.length; ++i) {
            if (this.edef[i] == null || this.edef[i].getSymbol() == null) continue;
            ++num;
        }
        return num;
    }

    public ElementDef[] getElementDef() {
        return this.edef;
    }

    public void addElementDef(ElementDef ed) {
        ElementDef[] newdef = new ElementDef[this.edef.length + 1];
        for (int i = 0; i < this.edef.length; ++i) {
            newdef[i] = this.edef[i];
        }
        newdef[newdef.length - 1] = ed;
        this.edef = newdef;
    }

    private void setEdef() {
        String str = new String();
        Vector<ElementDef> vec = new Vector<ElementDef>();
        ElementDef ed = new ElementDef();
        ed.setSymbol("");
        ed.setRadius(0.0f);
        ed.setCovalentRadius(0.0);
        ed.setMass("0");
        ed.setColor(new float[]{0.0f, 0.0f, 0.0f});
        vec.addElement(ed);
        try {
            FileReader reader = new FileReader(this.elementInfoFile);
            BufferedReader br = new BufferedReader(reader);
            while ((str = br.readLine()) != null) {
                if ((str = str.trim()).startsWith("#")) continue;
                ElementDef edf = new ElementDef();
                StringTokenizer st = new StringTokenizer(str);
                edf.setSymbol(st.nextToken());
                String rad = st.nextToken();
                edf.setRadius(Float.parseFloat(rad));
                String covrad = st.nextToken();
                edf.setCovalentRadius(Double.parseDouble(covrad));
                String r = st.nextToken();
                String g = st.nextToken();
                String b = st.nextToken();
                edf.setColor(new float[]{Float.parseFloat(r), Float.parseFloat(g), Float.parseFloat(b)});
                String mass = st.nextToken();
                mass = Double.toString(Double.parseDouble(mass) * ConstParameters.AMU);
                char[] value = new char[10];
                for (int ic = 0; ic < 10; ++ic) {
                    value[ic] = mass.charAt(ic);
                }
                edf.setMass(new String(value, 0, 10));
                if (st.hasMoreTokens()) {
                    String hmax = st.nextToken();
                    edf.hasHbond(true);
                    edf.setMaxHbondDistance(Double.parseDouble(hmax));
                }
                vec.addElement(edf);
            }
            reader.close();
        }
        catch (Exception e) {
            logger.error("failed to read element info");
            e.printStackTrace();
        }
        this.edef = new ElementDef[vec.size()];
        vec.copyInto(this.edef);
    }

    public String getSymbolFromNumber(int iat) {
        if (iat >= this.num_elements) {
            return "";
        }
        if (iat < 1) {
            return "";
        }
        return this.edef[iat].getSymbol();
    }

    public String getMassFromNumber(int iat) {
        if (iat >= this.num_elements) {
            return "";
        }
        if (iat < 1) {
            return "";
        }
        return this.edef[iat].getMass();
    }

    public String getMassFromSymbol(String symbol) {
        boolean iret = false;
        for (int i = 1; i < this.num_elements; ++i) {
            String comp = this.edef[i].getSymbol() + "\\d*";
            if (!symbol.matches(comp)) continue;
            return this.edef[i].getMass();
        }
        return "";
    }

    public int getNumberFromSymbol(String symbol) {
        boolean iret = false;
        for (int i = 1; i < this.num_elements; ++i) {
            String comp = this.edef[i].getSymbol() + "\\d*";
            if (!symbol.matches(comp)) continue;
            return i;
        }
        return -1;
    }

    public Object[] getChoices() {
        Object[] ret = new String[this.num_elements];
        ret[0] = "";
        for (int i = 1; i < this.num_elements; ++i) {
            ret[i] = this.getSymbolFromNumber(i);
        }
        return ret;
    }

    public Object[] getChoices(int index) {
        if (index == 0) {
            return this.getChoices();
        }
        if (index == 1) {
            Object[] ret = new String[this.num_elements];
            for (int i = 0; i < this.num_elements; ++i) {
                ret[i] = String.valueOf(i + 1);
            }
            return ret;
        }
        if (index == 2) {
            Object[] ret = new String[this.num_elements];
            ret[0] = "";
            for (int i = 1; i < this.num_elements; ++i) {
                ret[i] = this.getMassFromNumber(i);
            }
            return ret;
        }
        logger.error("wrong specification of index!");
        return null;
    }

    public Object[] getChoices(String index) {
        if (index.trim().equals("element")) {
            return this.getChoices();
        }
        if (index.trim().equals("atomic_number")) {
            Object[] ret = new String[this.num_elements];
            for (int i = 0; i < this.num_elements; ++i) {
                ret[i] = String.valueOf(i + 1);
            }
            return ret;
        }
        if (index.trim().equals("mass")) {
            Object[] ret = new String[this.num_elements];
            for (int i = 0; i < this.num_elements; ++i) {
                ret[i] = this.getMassFromNumber(i);
            }
            return ret;
        }
        logger.error("wrong specification of index!");
        return null;
    }

    public String getToolTipTexts(int index) {
        return "";
    }

    public ElementDef[] getHBondDonorAcceptorCandidates() {
        if (this.hbondCandidates == null) {
            Vector<ElementDef> vec = new Vector<ElementDef>();
            for (int i = 0; i < this.edef.length; ++i) {
                if (!this.edef[i].hasHbond()) continue;
                vec.addElement(this.edef[i]);
            }
            this.hbondCandidates = new ElementDef[vec.size()];
            vec.copyInto(this.hbondCandidates);
        }
        return this.hbondCandidates;
    }

    public void toDisk() {
        try {
            String write = this.toString();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.elementInfoFile));
            writer.write(write, 0, write.length());
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            System.out.println("failed write to elementinfo");
        }
    }

    public String toString() {
        String LS = System.getProperty("line.separator");
        String ret = "#element(symbol)    radius(A)   covalent_radius (A)    color(rgb)    mass   Hbond" + LS;
        for (int i = 0; i < this.edef.length; ++i) {
            String str;
            if (this.edef[i] == null || (str = this.edef[i].toString()).trim().length() == 0) continue;
            ret = ret + str + LS;
        }
        return ret;
    }
}

