/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.symmetry;

import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import org.apache.log4j.Logger;

public class Orthorhombic
extends BravaisLattice {
    private Logger logger = Logger.getLogger(Orthorhombic.class.getName());

    public String getName() {
        return this.latticeSystem + " orthorhombic";
    }

    public double[][] getPrimitiveLatticeVector() {
        Object ret = null;
        ret = this.latticeSystem.equals("basecentered") ? (Object)new double[][]{{0.5 * this.a, -0.5 * this.b, 0.0}, {0.5 * this.a, 0.5 * this.b, 0.0}, {0.0, 0.0, this.c}} : (this.latticeSystem.equals("bodycentered") ? (Object)new double[][]{{-0.5 * this.a, 0.5 * this.b, 0.5 * this.c}, {0.5 * this.a, -0.5 * this.b, 0.5 * this.c}, {0.5 * this.a, 0.5 * this.b, -0.5 * this.c}} : (this.latticeSystem.equals("facecentered") ? (Object)new double[][]{{0.0, 0.5 * this.b, 0.5 * this.c}, {0.5 * this.a, 0.0, 0.5 * this.c}, {0.5 * this.a, 0.5 * this.b, 0.0}} : (Object)new double[][]{{this.a, 0.0, 0.0}, {0.0, this.b, 0.0}, {0.0, 0.0, this.c}}));
        return ret;
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha, double beta, double gamma) {
        boolean checkAngle = false;
        if (this.epsilonEquals(alpha, 90.0) && this.epsilonEquals(beta, 90.0) && this.epsilonEquals(gamma, 90.0)) {
            checkAngle = true;
        }
        boolean checkLength = false;
        if (!(this.epsilonEquals(a, b) || this.epsilonEquals(a, c) || this.epsilonEquals(b, c))) {
            checkLength = true;
        }
        return checkAngle && checkLength;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[]{"primitive", "facecentered", "bodycentered", "basecentered"};
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec, double[] bvec, double[] cvec) {
        boolean fb3;
        boolean bob4;
        boolean bb2;
        boolean pb2;
        boolean pb1 = !this.epsilonEquals(avec[0], bvec[1]) && !this.epsilonEquals(avec[0], cvec[2]) && !this.epsilonEquals(bvec[1], cvec[2]);
        boolean bl = pb2 = this.epsilonEquals(avec[1], 0.0) && this.epsilonEquals(avec[2], 0.0) && this.epsilonEquals(bvec[0], 0.0) && this.epsilonEquals(bvec[2], 0.0) && this.epsilonEquals(cvec[0], 0.0) && this.epsilonEquals(cvec[1], 0.0);
        if (pb1 && pb2) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = avec[0];
            ortho.b = bvec[1];
            ortho.c = cvec[2];
            ortho.gamma = 90.0;
            ortho.beta = 90.0;
            ortho.alpha = 90.0;
            ortho.latticeSystem = "primitive";
            return ortho;
        }
        boolean bb1 = this.epsilonEquals(avec[0], bvec[0]) && !this.epsilonEquals(avec[0], -avec[1]) && this.epsilonEquals(avec[2], 0.0) && this.epsilonEquals(bvec[2], 0.0) && this.epsilonEquals(avec[1], -bvec[1]);
        boolean bl2 = bb2 = this.epsilonEquals(cvec[0], 0.0) && this.epsilonEquals(cvec[1], 0.0) && !this.epsilonEquals(cvec[2], 0.0);
        if (bb1 && bb2) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = 2.0 * avec[0];
            ortho.b = 2.0 * bvec[1];
            ortho.c = cvec[2];
            ortho.gamma = 90.0;
            ortho.beta = 90.0;
            ortho.alpha = 90.0;
            ortho.latticeSystem = "basecentered";
            return ortho;
        }
        boolean bob1 = this.epsilonEquals(-avec[0], bvec[0]) && this.epsilonEquals(-avec[0], cvec[0]);
        boolean bob2 = this.epsilonEquals(avec[1], -bvec[1]) && this.epsilonEquals(avec[1], cvec[1]);
        boolean bob3 = this.epsilonEquals(avec[2], bvec[2]) && this.epsilonEquals(bvec[2], -cvec[2]);
        boolean bl3 = bob4 = !this.epsilonEquals(-avec[0], avec[1]) && !this.epsilonEquals(-avec[0], avec[2]) && !this.epsilonEquals(avec[1], avec[2]);
        if (bob1 && bob2 && bob3 && bob4) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = Math.abs(avec[0]) * 2.0;
            ortho.b = Math.abs(avec[1]) * 2.0;
            ortho.c = Math.abs(avec[2]) * 2.0;
            ortho.alpha = 90.0;
            ortho.beta = 90.0;
            ortho.gamma = 90.0;
            ortho.latticeSystem = "bodycentered";
            return ortho;
        }
        boolean fb1 = this.epsilonEquals(avec[0], 0.0) && this.epsilonEquals(bvec[1], 0.0) && this.epsilonEquals(cvec[2], 0.0);
        boolean fb2 = this.epsilonEquals(bvec[0], cvec[0]) && this.epsilonEquals(avec[1], cvec[1]) && this.epsilonEquals(avec[2], bvec[2]);
        boolean bl4 = fb3 = !this.epsilonEquals(avec[1], avec[2]) && !this.epsilonEquals(bvec[0], bvec[2]);
        if (fb1 && fb2 && fb3) {
            Orthorhombic ortho = new Orthorhombic();
            ortho.a = 2.0 * bvec[0];
            ortho.b = 2.0 * avec[1];
            ortho.c = 2.0 * bvec[2];
            ortho.gamma = 90.0;
            ortho.beta = 90.0;
            ortho.alpha = 90.0;
            ortho.latticeSystem = "facecentered";
            return ortho;
        }
        return null;
    }

    public String getCrystalSystem() {
        return "orthorhombic";
    }
}

