/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.symmetry;

import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import org.apache.log4j.Logger;

public class Hexagonal
extends BravaisLattice {
    private Logger logger = Logger.getLogger(Hexagonal.class.getName());

    public String getName() {
        if (this.latticeSystem.equals("rhombohedral")) {
            return "rhombohedral";
        }
        return "hexagonal";
    }

    public double[][] getPrimitiveLatticeVector() {
        if (this.latticeSystem.equals("rhombohedral")) {
            return new double[][]{{0.5 * this.a, 0.5 / Math.sqrt(3.0) * this.a, this.c / 3.0}, {-0.5 * this.a, 0.5 / Math.sqrt(3.0) * this.a, this.c / 3.0}, {0.0, -this.a / Math.sqrt(3.0), this.c / 3.0}};
        }
        return this.getGenericPrimitiveVector();
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha, double beta, double gamma) {
        boolean len = this.epsilonEquals(a, b) && !this.epsilonEquals(a, c);
        boolean ang = this.epsilonEquals(gamma, 120.0);
        return len && ang;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[]{"hexagonal", "rhombohedral"};
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec, double[] bvec, double[] cvec) {
        if (this.epsilonEquals(this.a, this.b) && !this.epsilonEquals(this.a, this.c) && this.epsilonEquals(this.gamma, 120.0) && this.epsilonEquals(this.alpha, 90.0) && this.epsilonEquals(this.beta, 90.0)) {
            this.latticeSystem = "hexagonal";
            return this;
        }
        if (this.epsilonEquals(this.a, this.c) && this.epsilonEquals(this.b, this.c) && this.epsilonEquals(this.alpha, this.beta) && this.epsilonEquals(this.beta, this.gamma) && !this.epsilonEquals(this.alpha, 90.0) && !this.epsilonEquals(this.beta, 90.0) && !this.epsilonEquals(this.gamma, 90.0)) {
            Hexagonal hexa = new Hexagonal();
            hexa.a = hexa.b = avec[0] * 2.0;
            hexa.c = avec[2] * 3.0;
            hexa.alpha = 90.0;
            hexa.beta = 90.0;
            hexa.gamma = 120.0;
            hexa.latticeSystem = "rhombohedral";
            return hexa;
        }
        return null;
    }

    public String getCrystalSystem() {
        return "hexagonal";
    }
}

