/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Exporter;
import ciss.phase_viewer.atomcoord.io.FrameCombo;
import ciss.phase_viewer.atomcoord.io.XYZFileFilter;
import ciss.phase_viewer.atomcoord.io.XYZHeavyOptions;
import ciss.phase_viewer.atomcoord.io.XYZOptions;
import ciss.phase_viewer.atomcoord.io.XYZOptionsPanel;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class XYZExporter
implements Exporter {
    private Logger logger = Logger.getLogger(XYZExporter.class.getName());
    private PropertyChangeListener listener;
    private FrameCombo select;
    private HashMap options = new HashMap();
    private double doubleforce = 1.0;
    private String type = XYZOptionsPanel.GENERIC;
    private int targetFrame = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeAtomCoordsTo(AtomCoords[] coords, String fileName) {
        this.logger.info("exporting atomic coordinates in xyz-format to file " + fileName);
        if (coords == null || coords.length == 0) {
            return false;
        }
        PrintWriter writer = null;
        int numFrame = coords.length;
        if (this.options.get(XYZOptionsPanel.FRAME) != null) {
            this.targetFrame = ((FrameCombo)this.options.get(XYZOptionsPanel.FRAME)).getTargetFrame(numFrame);
        }
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            for (int i = 0; i < coords.length; ++i) {
                if (i != this.targetFrame && this.targetFrame >= 0) continue;
                this.logger.info("doing frame no. " + i);
                boolean ret = this.writeCoordsTo(coords[i], writer, i);
                if (ret) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exc) {
            this.logger.error("failed export");
            exc.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        this.logger.info("...done");
        return true;
    }

    private boolean writeCoordsTo(AtomCoords coords, PrintWriter writer, int i) {
        String numAt = String.valueOf(coords.getNumAt());
        Cell cell = coords.getCell(0);
        String strcell = "frame no. " + String.valueOf(i);
        if (cell != null) {
            String[][] array = cell.getCell();
            try {
                strcell = strcell + " cell: " + array[0][0] + " " + array[0][1] + " " + array[0][2] + " " + array[1][0] + " " + array[1][1] + " " + array[1][2] + " " + array[2][0] + " " + array[2][1] + " " + array[2][2];
            }
            catch (Exception exc) {
                strcell = "frame no. " + String.valueOf(i);
            }
        }
        writer.println(numAt);
        writer.println(strcell);
        AtomList list = coords.getAtomList();
        for (int iat = 0; iat < list.size(); ++iat) {
            Atom at = list.getAtomAt(iat);
            String ele = at.getElementName();
            String[] pos = at.getPos();
            double[] dforce = at.getForceDouble();
            String vector = " ";
            if (this.type.equals(XYZOptionsPanel.XMAKEMOL)) {
                vector = " atom_vector ";
            }
            if (dforce != null && dforce.length >= 3) {
                writer.println(ele + " " + pos[0] + " " + pos[1] + " " + pos[2] + vector + dforce[0] * this.doubleforce + " " + dforce[1] * this.doubleforce + " " + dforce[2] * this.doubleforce);
                continue;
            }
            writer.println(ele + " " + pos[0] + " " + pos[1] + " " + pos[2]);
        }
        return true;
    }

    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
        this.listener = listener;
        if (!heavy) {
            XYZOptions opts = new XYZOptions(this, listener);
        } else {
            XYZHeavyOptions hopts = new XYZHeavyOptions(this, listener);
        }
    }

    public boolean hasOptions() {
        return true;
    }

    public String getType() {
        return "XYZ";
    }

    public FileFilter getFileFilter() {
        return new XYZFileFilter();
    }

    public void setOptions(HashMap options) {
        if (options == null) {
            return;
        }
        this.options = options;
        try {
            String forceFactor = options.get(XYZOptionsPanel.FORCE).toString();
            this.doubleforce = Double.parseDouble(forceFactor);
        }
        catch (Exception exc) {
            this.logger.debug(exc);
        }
        try {
            this.type = options.get(XYZOptionsPanel.TYPE).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.debug("type: " + this.type);
    }
}

