/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.AtomState;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AtomStateList {
    private Logger logger = Logger.getLogger(AtomStateList.class.getName());
    private Vector stateVector;
    private int origNumAt;

    public AtomStateList(int numAt) {
        this.origNumAt = numAt;
        this.stateVector = new Vector();
        for (int i = 0; i < numAt; ++i) {
            this.stateVector.addElement(new AtomState(AtomState.UNCHANGED, i));
        }
    }

    public AtomStateList(int[] indeces) {
        this.origNumAt = indeces.length;
        this.stateVector = new Vector();
        for (int i = 0; i < this.origNumAt; ++i) {
            this.stateVector.addElement(new AtomState(AtomState.UNCHANGED, indeces[i]));
        }
    }

    private int getNumAdded() {
        int ret = 0;
        for (int i = 0; i < this.stateVector.size(); ++i) {
            AtomState as = (AtomState)this.stateVector.get(i);
            if (as.mode != AtomState.ADDED) continue;
            ++ret;
        }
        return ret;
    }

    public int[] getIndexMap() {
        int added = this.getNumAdded();
        int[] ret = new int[this.origNumAt + added];
        for (int i = 0; i < this.stateVector.size(); ++i) {
            AtomState as = (AtomState)this.stateVector.get(i);
            ret[as.origIndex] = as.mode != AtomState.REMOVED ? as.index : -1;
        }
        return ret;
    }

    public void atomAdded() {
        this.logger.debug("atom added");
        int natNow = this.getNumAt();
        this.stateVector.addElement(new AtomState(AtomState.ADDED, natNow));
    }

    public void atomAdded(int index) {
        this.logger.debug("atom added at " + index);
        for (int i = 0; i < this.stateVector.size(); ++i) {
            AtomState as = (AtomState)this.stateVector.get(i);
            if (as.index < index) continue;
            ++as.index;
        }
        this.stateVector.add(new AtomState(AtomState.ADDED, index));
    }

    public void atomRemoved(int removed) {
        if (removed < 0 || removed >= this.stateVector.size()) {
            return;
        }
        for (int i = 0; i < this.stateVector.size(); ++i) {
            AtomState as = (AtomState)this.stateVector.get(i);
            if (as.index <= removed) continue;
            --as.index;
        }
        this.stateVector.set(removed, new AtomState(AtomState.REMOVED, removed));
    }

    public void atomModified(int mod) {
        if (mod < 0 || mod >= this.stateVector.size()) {
            return;
        }
        this.stateVector.set(mod, new AtomState(AtomState.MODIFIED, mod));
    }

    public int getNumAt() {
        int ret = 0;
        for (int i = 0; i < this.stateVector.size(); ++i) {
            if (((AtomState)this.stateVector.get((int)i)).mode == AtomState.REMOVED) continue;
            ++ret;
        }
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }

    public AtomState[] getResults() {
        Object[] res = new AtomState[this.stateVector.size()];
        this.stateVector.copyInto(res);
        Arrays.sort(res);
        return res;
    }

    public int getOrigNumAt() {
        return this.origNumAt;
    }
}

