/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.common.TaggedString;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class Atom {
    private static Logger logger = Logger.getLogger(Atom.class.getName());
    private String elementName = "";
    private String[] pos;
    private TaggedString[] auxil;
    private String[] force;
    private boolean boundary = false;
    private boolean issublat = false;
    private boolean savesublat = false;
    boolean isInvSymAtom = false;
    private int numValenceElectrons = -1;
    private double epsilon = 1.0E-7;

    public Atom(String elementName, String[] pos) {
        this.elementName = elementName;
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = pos[i].replaceAll("d", "e").replaceAll("D", "E");
        }
        this.pos = pos;
    }

    public Atom(String elementName, String[] pos, String[] force) {
        this.elementName = elementName;
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = pos[i].replaceAll("d", "e").replaceAll("D", "E");
        }
        this.pos = pos;
        this.force = force;
    }

    public Atom(String elementName, String[] pos, TaggedString[] auxil) {
        this.elementName = elementName;
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = pos[i].replaceAll("d", "e").replaceAll("D", "E");
        }
        this.pos = pos;
        this.auxil = auxil;
    }

    public Atom(String elementName, double[] pos, TaggedString[] auxil) {
        this.elementName = elementName;
        this.pos = new String[3];
        for (int i = 0; i < 3; ++i) {
            this.pos[i] = String.valueOf(pos[i]);
        }
        this.auxil = auxil;
    }

    public boolean isSubLatticeAtom() {
        return this.issublat;
    }

    public void saveSubLatticeAtom(boolean savesublat) {
        this.savesublat = savesublat;
    }

    public boolean saveSubLatticeAtom() {
        return this.savesublat;
    }

    public void isSubLatticeAtom(boolean issublat) {
        this.issublat = issublat;
    }

    public boolean isVirtualAtom() {
        return this.issublat || this.boundary;
    }

    public Atom(String elementName, double[] pos) {
        this.elementName = elementName;
        this.pos = new String[3];
        for (int i = 0; i < 3; ++i) {
            this.pos[i] = String.valueOf(pos[i]);
        }
    }

    public Atom(String elementName, String[] pos, Vector aux) {
        this.elementName = elementName;
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = pos[i].replaceAll("d", "e").replaceAll("D", "E");
        }
        this.pos = pos;
        if (aux != null) {
            this.auxil = new TaggedString[aux.size()];
            aux.copyInto(this.auxil);
        }
    }

    public Atom(String elementName, double[] pos, Vector aux) {
        int i;
        this.elementName = elementName;
        this.pos = new String[3];
        for (i = 0; i < 3; ++i) {
            this.pos[i] = String.valueOf(pos[i]);
        }
        if (aux != null) {
            this.auxil = new TaggedString[aux.size()];
            for (i = 0; i < aux.size(); ++i) {
                try {
                    this.auxil[i] = (TaggedString)aux.elementAt(i);
                    continue;
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
            }
        }
    }

    public Atom getCopy() {
        String elembuf = new String(this.elementName);
        String[] posbuf = new String[3];
        for (int i = 0; i < posbuf.length; ++i) {
            posbuf[i] = new String(this.pos[i]);
        }
        TaggedString[] aubuf = null;
        if (this.auxil != null && this.auxil.length != 0) {
            aubuf = new TaggedString[this.auxil.length];
            for (int i = 0; i < aubuf.length; ++i) {
                if (this.auxil[i].getTag() == null || this.auxil[i].getValue() == null) continue;
                aubuf[i] = new TaggedString(this.auxil[i].getTag(), this.auxil[i].getValue());
            }
        }
        Atom ret = new Atom(elembuf, posbuf, aubuf);
        ret.setForce(this.force);
        ret.isBoundaryAtom(this.isBoundaryAtom());
        ret.isSubLatticeAtom(this.isSubLatticeAtom());
        ret.isInvSymAtom(this.isInvSymAtom);
        return ret;
    }

    public boolean isInvSymAtom() {
        return this.isInvSymAtom;
    }

    public void isInvSymAtom(boolean isInvSymAtom) {
        this.isInvSymAtom = isInvSymAtom;
    }

    public boolean isBoundaryAtom() {
        return this.boundary;
    }

    public void isBoundaryAtom(boolean boundary) {
        this.boundary = boundary;
    }

    public void setNumValenceElectrons(int numValenceElectrons) {
        this.numValenceElectrons = numValenceElectrons;
    }

    public int getNumValenceElectrons() {
        return this.numValenceElectrons;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String[] getForce() {
        return this.force;
    }

    public double[] getForceDouble() {
        if (this.force == null || this.force.length < 3) {
            return null;
        }
        double[] ret = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                ret[i] = Double.parseDouble(this.force[i]);
                continue;
            }
            catch (Exception exc) {
                return null;
            }
        }
        return ret;
    }

    public void setForce(String[] force) {
        this.force = force;
    }

    public String[] getPos() {
        return this.pos;
    }

    public double[] getDouble() {
        double[] ret = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                ret[i] = Double.parseDouble(this.pos[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                logger.warn("failed to get 'double' representation for atom coords.");
                return null;
            }
        }
        return ret;
    }

    public void setPos(String[] pos) {
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = pos[i].replaceAll("d", "e").replaceAll("D", "E");
        }
        this.pos = pos;
    }

    public void setPos(double[] pos) {
        if (pos == null || pos.length < 3) {
            return;
        }
        logger.debug("setting pos: " + pos[0] + " " + pos[1] + " " + pos[2]);
        for (int i = 0; i < 3; ++i) {
            this.pos[i] = Double.toString(pos[i]);
        }
    }

    public TaggedString[] getAuxil() {
        return this.auxil;
    }

    public String getProperty(String key) {
        if (this.auxil == null) {
            return null;
        }
        for (int i = 0; i < this.auxil.length; ++i) {
            if (!this.auxil[i].getTag().equalsIgnoreCase(key)) continue;
            return this.auxil[i].getValue();
        }
        return null;
    }

    public void setAuxil(TaggedString[] auxil_) {
        if (auxil_ == null || auxil_.length == 0) {
            return;
        }
        if (this.auxil != null && this.auxil.length != 0) {
            int i;
            Vector<TaggedString> vector = new Vector<TaggedString>();
            TaggedString[] tmp = new TaggedString[this.auxil.length];
            for (i = 0; i < tmp.length; ++i) {
                tmp[i] = this.auxil[i];
            }
            for (int j = 0; j < auxil_.length; ++j) {
                boolean exi = false;
                for (int i2 = 0; i2 < tmp.length; ++i2) {
                    if (!tmp[i2].getTag().equals(auxil_[j].getTag())) continue;
                    tmp[i2].setValue(auxil_[j].getValue());
                    exi = true;
                }
                if (exi) continue;
                vector.addElement(auxil_[j]);
            }
            if (vector.size() != 0) {
                this.auxil = new TaggedString[tmp.length + vector.size()];
                for (i = 0; i < tmp.length; ++i) {
                    this.auxil[i] = tmp[i];
                }
                for (i = 0; i < vector.size(); ++i) {
                    this.auxil[i + tmp.length] = (TaggedString)vector.get(i);
                }
            } else {
                this.auxil = tmp;
            }
        } else {
            this.auxil = auxil_;
        }
    }

    public void setAuxil(Vector aux) {
        if (aux != null) {
            Object[] tmpauxil = new TaggedString[aux.size()];
            aux.copyInto(tmpauxil);
            this.setAuxil((TaggedString[])tmpauxil);
        }
    }

    public Element getXMLElement() {
        Element atom = new Element("atom");
        Element elemname = new Element("element").setText(this.elementName);
        atom.addContent(elemname);
        if (this.pos != null && this.pos.length >= 3) {
            Element elex = new Element("posx").setText(this.pos[0]);
            Element eley = new Element("posy").setText(this.pos[1]);
            Element elez = new Element("posz").setText(this.pos[2]);
            atom.addContent(elex);
            atom.addContent(eley);
            atom.addContent(elez);
        }
        if (this.force != null && this.force.length >= 3) {
            Element forcx = new Element("forcx").setText(this.force[0]);
            Element forcy = new Element("forcy").setText(this.force[1]);
            Element forcz = new Element("forcz").setText(this.force[2]);
            atom.addContent(forcx);
            atom.addContent(forcy);
            atom.addContent(forcz);
        }
        if (this.auxil != null && this.auxil.length != 0) {
            for (int i = 0; i < this.auxil.length; ++i) {
                if (this.auxil[i].getValue().trim().length() == 0) continue;
                Element aux = new Element(this.auxil[i].getTag()).setText(this.auxil[i].getValue());
                atom.addContent(aux);
            }
        }
        return atom;
    }

    public static Atom createFrom(Element atom) {
        Atom ret = null;
        List list = atom.getChildren();
        String ele = null;
        String px = null;
        String py = null;
        String pz = null;
        String forcx = null;
        String forcy = null;
        String forcz = null;
        Vector<TaggedString> auxvector = new Vector<TaggedString>();
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            String ident = element.getName().trim();
            if (ident.equals("element")) {
                ele = element.getValue().trim();
                continue;
            }
            if (ident.equals("posx")) {
                px = element.getValue().trim();
                continue;
            }
            if (ident.equals("posy")) {
                py = element.getValue().trim();
                continue;
            }
            if (ident.equals("posz")) {
                pz = element.getValue().trim();
                continue;
            }
            if (ident.equals("forcx")) {
                forcx = element.getValue().trim();
                continue;
            }
            if (ident.equals("forcy")) {
                forcy = element.getValue().trim();
                continue;
            }
            if (ident.equals("forcz")) {
                forcz = element.getValue().trim();
                continue;
            }
            TaggedString tag = new TaggedString(ident, element.getValue().trim());
            auxvector.addElement(tag);
        }
        if (ele != null && px != null && py != null && pz != null) {
            ret = new Atom(ele, new String[]{px, py, pz});
        }
        if (ret == null) {
            logger.error("invalid atom");
            return null;
        }
        if (forcx != null && forcy != null && forcz != null) {
            ret.setForce(new String[]{forcx, forcy, forcz});
        }
        if (auxvector.size() != 0) {
            ret.setAuxil(auxvector);
        }
        return ret;
    }

    public void nullify() {
        this.elementName = null;
        this.pos = null;
        this.auxil = null;
        this.force = null;
    }

    public String toString() {
        String ret = "";
        ret = "symbol: " + this.elementName + " x: " + this.pos[0] + " y: " + this.pos[1] + " z: " + this.pos[2];
        if (this.auxil != null) {
            for (int i = 0; i < this.auxil.length; ++i) {
                if (this.auxil[i] == null || this.auxil[i].getTag() == null || this.auxil[i].getValue() == null) continue;
                ret = ret + " " + this.auxil[i].getTag() + ": " + this.auxil[i].getValue();
            }
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Atom)) {
            return false;
        }
        return this.epsilonEquals((Atom)obj);
    }

    public boolean epsilonEquals(Atom atom) {
        if (atom == null) {
            return false;
        }
        double[] mypos = this.getDouble();
        double[] frompos = atom.getDouble();
        String elem = atom.getElementName();
        return Math.abs(mypos[0] - frompos[0]) < this.epsilon && Math.abs(mypos[1] - frompos[1]) < this.epsilon && Math.abs(mypos[2] - frompos[2]) < this.epsilon && elem.equalsIgnoreCase(this.elementName);
    }
}

