/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;

class Circle
extends BranchGroup {
    private Shape3D circle;
    private float radius = 0.5f;
    private int resolution = 512;
    private int length = this.resolution + 1;
    private float resolutionh = (float)this.resolution * 0.5f;

    protected Circle(float radius, int resolution) {
        this.radius = radius;
        this.resolution = resolution;
        this.setCapability(17);
        this.setCapability(12);
        this.circle = this.createCircle();
        OrientedShape3D oscircle = new OrientedShape3D(this.circle.getGeometry(), this.circle.getAppearance(), 1, new Point3f(0.0f, 0.0f, 0.0f));
        this.addChild((Node)oscircle);
    }

    protected Circle(float radius) {
        this.radius = radius;
        this.circle = this.createCircle();
        this.setCapability(17);
        this.setCapability(12);
        OrientedShape3D oscircle = new OrientedShape3D(this.circle.getGeometry(), this.circle.getAppearance(), 1, new Point3f(0.0f, 0.0f, 0.0f));
        this.addChild((Node)oscircle);
    }

    public Shape3D getCircle() {
        return this.circle;
    }

    private Shape3D createCircle() {
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(0.9f, 0.9f, 0.5f, 1));
        LineAttributes lineAttrib = new LineAttributes();
        lineAttrib.setLineWidth(5.0f);
        appearance.setLineAttributes(lineAttrib);
        LineStripArray lsa = new LineStripArray(this.length, 1, new int[]{this.length});
        Point3f pt0 = new Point3f(this.radius, 0.0f, 0.0f);
        lsa.setCoordinate(0, pt0);
        Point3f pt = new Point3f();
        for (int i = 1; i < this.resolution; ++i) {
            pt.x = (float)((double)this.radius * Math.cos((double)i * Math.PI / (double)this.resolutionh));
            pt.y = (float)((double)this.radius * Math.sin((double)i * Math.PI / (double)this.resolutionh));
            lsa.setCoordinate(i, pt);
        }
        lsa.setCoordinate(this.resolution, pt0);
        Shape3D circle = new Shape3D((Geometry)lsa, appearance);
        try {
            lsa.setCapability(18);
        }
        catch (RestrictedAccessException rae) {
            // empty catch block
        }
        return circle;
    }
}

