/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.operations;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.VolumetricData;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EnlargeCell {
    private Logger logger = Logger.getLogger(EnlargeCell.class.getName());
    private Vector origCell = new Vector();
    private Vector origAtoms = new Vector();
    private int na = 1;
    private int nb = 1;
    private int nc = 1;
    private boolean doallframes = false;
    private Vector frames;
    private MainPanel parent;

    public EnlargeCell(Vector frames, MainPanel parent) {
        this.frames = frames;
        this.parent = parent;
        this.createOrig();
    }

    public void setDoAllFrames(boolean doallframes) {
        this.doallframes = doallframes;
    }

    public void setEnlargeParams(int na, int nb, int nc) {
        this.na = na;
        this.nb = nb;
        this.nc = nc;
    }

    public void doEnlarge() {
        this.doEnlarge(this.na, this.nb, this.nc);
    }

    public void doEnlarge(int na, int nb, int nc) {
        ConfigDataManager mCD = this.parent.getCD();
        int start = 0;
        int end2 = this.origAtoms.size();
        int currentFrame = mCD.getFrameNum();
        if (!this.doallframes) {
            start = currentFrame;
            end2 = start + 1;
        }
        int orignumat = this.parent.getCD().getNumAt();
        this.parent.getCD().getAtomCoords().saveState();
        double[] com = new double[3];
        Vector sublatatoms = new Vector();
        for (int ii = start; ii < end2; ++ii) {
            this.logger.debug("doing 'enlarge' for frame no.: " + ii);
            double[][] dCell = new double[3][3];
            double[][] baseAtom = new double[3][3];
            Cell originalCell = (Cell)this.origCell.get(ii);
            Atom[] originalAtoms = (Atom[])this.origAtoms.get(ii);
            double[][] dcell = originalCell.getDouble();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    dCell[i][j] = dcell[i][j];
                }
            }
            if (originalAtoms == null) {
                this.logger.error("no atoms allocated.");
                return;
            }
            AtomCoords coords = (AtomCoords)this.frames.get(ii);
            AtomList atomList = coords.getAtomList();
            int orgnumat = atomList.size();
            for (int i = orgnumat - 1; i >= 0; --i) {
                atomList.removeAtomAt(i);
            }
            int newAtomCount = 0;
            double celloffsetx = (double)(na - 1) * dCell[0][0] * 0.5 + (double)(nb - 1) * dCell[1][0] * 0.5 + (double)(nc - 1) * dCell[2][0] * 0.5;
            double celloffsety = (double)(na - 1) * dCell[0][1] * 0.5 + (double)(nb - 1) * dCell[1][1] * 0.5 + (double)(nc - 1) * dCell[2][1] * 0.5;
            double celloffsetz = (double)(na - 1) * dCell[0][2] * 0.5 + (double)(nb - 1) * dCell[1][2] * 0.5 + (double)(nc - 1) * dCell[2][2] * 0.5;
            for (int iat = 0; iat < originalAtoms.length; ++iat) {
                double[] origpos = originalAtoms[iat].getDouble();
                Atom newAtom = originalAtoms[iat].getCopy();
                newAtom.setPos(new double[]{origpos[0] - celloffsetx, origpos[1] - celloffsety, origpos[2] - celloffsetz});
                ++newAtomCount;
                atomList.addAtom(newAtom, true);
            }
            for (int ia = 0; ia < na; ++ia) {
                for (int ib = 0; ib < nb; ++ib) {
                    for (int ic = 0; ic < nc; ++ic) {
                        if (ia == 0 && ib == 0 && ic == 0) continue;
                        for (int iat = 0; iat < originalAtoms.length; ++iat) {
                            double[] origpos = originalAtoms[iat].getDouble();
                            double xtmp = origpos[0] + (double)ia * dCell[0][0] + (double)ib * dCell[1][0] + (double)ic * dCell[2][0] - celloffsetx;
                            double ytmp = origpos[1] + (double)ia * dCell[0][1] + (double)ib * dCell[1][1] + (double)ic * dCell[2][1] - celloffsety;
                            double ztmp = origpos[2] + (double)ia * dCell[0][2] + (double)ib * dCell[1][2] + (double)ic * dCell[2][2] - celloffsetz;
                            Atom newAtom = originalAtoms[iat].getCopy();
                            newAtom.setPos(new double[]{xtmp, ytmp, ztmp});
                            ++newAtomCount;
                            atomList.addAtom(newAtom, true);
                        }
                    }
                }
            }
            double[][] newCell = new double[3][3];
            for (int i = 0; i < 3; ++i) {
                newCell[0][i] = (double)na * dCell[0][i];
                newCell[1][i] = (double)nb * dCell[1][i];
                newCell[2][i] = (double)nc * dCell[2][i];
            }
            this.logger.debug("newcell: " + newCell[0][0] + ", " + newCell[0][1] + ", " + newCell[0][2]);
            this.logger.debug("newcell: " + newCell[1][0] + ", " + newCell[1][1] + ", " + newCell[1][2]);
            this.logger.debug("newcell: " + newCell[2][0] + ", " + newCell[2][1] + ", " + newCell[2][2]);
            Cell newcell = new Cell(newCell[0], newCell[1], newCell[2]);
            newcell.setCellOffset(new double[]{celloffsetx, celloffsety, celloffsetz});
            coords.setCell(newcell);
            VolumetricData[] cden = coords.getChargeDensities();
            if (cden != null) {
                for (int i = 0; i < cden.length; ++i) {
                    cden[i].enlarge(na, nb, nc);
                }
            }
            atomList.setUndoCount(orgnumat + newAtomCount + 1);
        }
        try {
            AtomList list = this.parent.getCD().getAtomCoords().getAtomList();
            this.logger.debug("size: " + list.size());
            this.logger.debug("new COM: " + com[0] + ", " + com[1] + ", " + com[2]);
            this.parent.getCD().isRenderingManual(true);
            this.parent.prepareRedraw();
            int[] sele = ((TGAtom)this.parent.getRootTransform()).getSelectedAtomsIndex();
            ((TGAtom)this.parent.getRootTransform()).deselectAll();
            this.parent.getCD().setCoords((AtomCoords)this.frames.get(currentFrame), ConfigDataUpdateEvent.CELL_CHANGED);
            AtomObject[] objs = ((TGAtom)this.parent.getRootTransform()).getAtomObjects();
            if (sele != null && objs != null) {
                for (int i = 0; i < sele.length; ++i) {
                    if (sele[i] >= objs.length) continue;
                    objs[sele[i]].setSelected();
                }
            }
            this.parent.doUnitCell(true);
            this.parent.postRedraw();
            this.parent.getCD().isRenderingManual(false);
            this.parent.getCD().getAtomCoords().finalizeState();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void recreateOrig() {
        ConfigDataManager mCD = this.parent.getCD();
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        AtomList atomList = coords.getAtomList();
        int numOrgAt = atomList.size();
        Vector<Atom> tmpvec = new Vector<Atom>();
        for (int i = 0; i < numOrgAt; ++i) {
            Atom tmp = atomList.getAtomAt(i);
            if (tmp.isBoundaryAtom()) continue;
            Atom buf = tmp.getCopy();
            tmpvec.add(buf);
        }
        if (tmpvec.size() == 0) {
            return;
        }
        Object[] oatoms = new Atom[tmpvec.size()];
        tmpvec.copyInto(oatoms);
        Cell ocell = coords.getCell(0);
        this.origAtoms.set(mCD.getFrameNum(), oatoms);
        this.origCell.set(mCD.getFrameNum(), ocell);
    }

    private void createOrig() {
        for (int i = 0; i < this.frames.size(); ++i) {
            AtomCoords coords = (AtomCoords)this.frames.get(i);
            AtomList atomList = coords.getAtomList();
            int numOrgAt = atomList.size();
            Vector<Atom> tmpvec = new Vector<Atom>();
            for (int j = 0; j < numOrgAt; ++j) {
                Atom tmp = atomList.getAtomAt(j);
                if (tmp.isBoundaryAtom()) continue;
                Atom buf = tmp.getCopy();
                tmpvec.addElement(buf);
            }
            if (tmpvec.size() == 0) {
                return;
            }
            Object[] originalAtoms = new Atom[tmpvec.size()];
            tmpvec.copyInto(originalAtoms);
            Cell originalCell = coords.getCell(0);
            this.origAtoms.addElement(originalAtoms);
            this.origCell.addElement(originalCell);
        }
    }
}

