/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.measure;

import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.MeasureBranchGroup;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class Measure {
    private Logger logger = Logger.getLogger(Measure.class.getName());
    protected Measurable measurable;
    protected int numAt;
    protected double[][] pos_moto;
    protected String[] id;
    protected double lenmax;
    protected double[] com;
    protected double[][] xyz;
    protected double result;
    protected boolean updating = false;
    protected boolean validData = true;
    protected Vector atomVectorNow;
    protected MeasureBranchGroup bg;

    public Measure(Measurable measurable) {
        this.measurable = measurable;
        this.lenmax = measurable.getLenMax();
        this.com = measurable.getCOM();
        this.bg = new MeasureBranchGroup();
        this.bg.setCapability(13);
        this.bg.setCapability(14);
        measurable.addShape(this.bg);
    }

    public abstract int getNumberOfNecessaryAtoms();

    public abstract void calculate();

    public abstract void draw();

    public abstract void redraw(int var1, boolean var2);

    protected abstract void initUpdate();

    protected abstract void finalizeUpdate();

    public void measure(Stack atomList) {
        int i;
        this.atomVectorNow = new Vector();
        int numAt = this.getNumberOfNecessaryAtoms();
        this.xyz = new double[numAt][3];
        this.id = new String[numAt];
        for (i = 0; i < numAt; ++i) {
            AtomObject atom = (AtomObject)atomList.pop();
            this.atomVectorNow.addElement(atom);
            this.xyz[i] = atom.getPosDouble();
            this.id[i] = atom.getID();
        }
        for (i = 0; i < numAt - 1; ++i) {
            for (int j = i + 1; j < numAt; ++j) {
                if (!this.id[i].equals(this.id[j])) continue;
                this.validData = false;
                return;
            }
        }
        this.pos_moto = new double[numAt][3];
        for (int j = 0; j < numAt; ++j) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.pos_moto[j][i2] = this.xyz[j][i2] * this.lenmax + this.com[i2];
            }
        }
        this.calculate();
    }

    public void update(AtomObject[] currAtoms) {
        this.initUpdate();
        this.lenmax = this.measurable.getLenMax();
        this.com = this.measurable.getCOM();
        int numAt = this.getNumberOfNecessaryAtoms();
        if (numAt < 0) {
            return;
        }
        this.xyz = new double[numAt][3];
        this.id = new String[numAt];
        for (int i = 0; i < this.bg.numChildren(); ++i) {
            int j;
            boolean valid = true;
            MeasureObject mobj = (MeasureObject)this.bg.getChild(i);
            Vector vec = mobj.getAtomVector();
            for (j = 0; j < numAt; ++j) {
                AtomObject atom = (AtomObject)vec.get(j);
                this.xyz[j] = atom.getPosDouble();
                this.id[j] = atom.getID();
                int ind = -1;
                for (int k = 0; k < currAtoms.length; ++k) {
                    if (currAtoms[k].getIDint() != atom.getIDint()) continue;
                    ind = k;
                    this.xyz[j] = currAtoms[k].getPosDouble();
                    break;
                }
                if (ind >= 0) continue;
                valid = false;
            }
            this.pos_moto = new double[numAt][3];
            for (j = 0; j < numAt; ++j) {
                for (int k = 0; k < 3; ++k) {
                    this.pos_moto[j][k] = this.xyz[j][k] * this.lenmax + this.com[k];
                }
            }
            int mind = i;
            this.calculate();
            this.redraw(i, valid);
        }
        this.finalizeUpdate();
    }

    public MeasureObject getMeasureObject(int i) {
        return (MeasureObject)this.bg.getChild(i);
    }

    public MeasureBranchGroup getMeasureBranch() {
        return this.bg;
    }
}

