/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.keylistener;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class RotateKeyListener
implements KeyListener,
PropertiesListener {
    private Logger logger = Logger.getLogger(RotateKeyListener.class.getName());
    private double factor = Math.PI / 180;
    private double rotFactorX = 2.5 * this.factor;
    private double rotFactorY = 2.5 * this.factor;
    private double ninetyDegrees = 1.5707963267948966;
    private TransformGroup[] transformGroups;
    private double rotx;
    private double roty;

    public RotateKeyListener(TransformGroup[] transformGroups) {
        this.transformGroups = transformGroups;
        PropertiesManager.getGlobalProperties(1);
        GlobalProperties.addPropertiesListener(this);
        this.init();
    }

    private void init() {
        GlobalProperties props = PropertiesManager.getGlobalProperties(1);
        try {
            this.rotFactorX = Double.parseDouble(props.getProperty("keylistener_rot")) * this.factor;
            this.rotFactorY = Double.parseDouble(props.getProperty("keylistener_rot")) * this.factor;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rotate(int xincre, int yincre) {
        double x_angle = (double)yincre * this.roty;
        double y_angle = (double)xincre * this.rotx;
        Transform3D transformX = new Transform3D();
        Transform3D transformY = new Transform3D();
        transformX.rotX(x_angle);
        transformY.rotY(y_angle);
        for (int i = 0; i < this.transformGroups.length; ++i) {
            Transform3D currTrans = new Transform3D();
            TransformGroup transformGroup = this.transformGroups[i];
            transformGroup.getTransform(currTrans);
            Matrix4d mat = new Matrix4d();
            currTrans.get(mat);
            currTrans.setTranslation(new Vector3d(0.0, 0.0, 0.0));
            currTrans.mul(transformX, currTrans);
            currTrans.mul(transformY, currTrans);
            Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
            currTrans.setTranslation(translation);
            transformGroup.setTransform(currTrans);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.isShiftDown()) {
            return;
        }
        if (e.isAltDown()) {
            return;
        }
        if (e.isControlDown()) {
            this.rotx = this.ninetyDegrees;
            this.roty = this.ninetyDegrees;
        }
        if (e.getKeyCode() == 38 || e.getKeyCode() == 75) {
            this.rotate(0, -1);
        } else if (e.getKeyCode() == 40 || e.getKeyCode() == 74) {
            this.rotate(0, 1);
        } else if (e.getKeyCode() == 37 || e.getKeyCode() == 72) {
            this.rotate(-1, 0);
        } else if (e.getKeyCode() == 39 || e.getKeyCode() == 76) {
            this.rotate(1, 0);
        }
        this.rotx = this.rotFactorX;
        this.roty = this.rotFactorY;
    }

    public void propertiesStored(GlobalProperties properties) {
        this.init();
    }
}

