/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.keylistener;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.apache.log4j.Logger;

public class ExpandKeyListener
implements KeyListener,
PropertiesListener {
    private Logger logger = Logger.getLogger(ExpandKeyListener.class.getName());
    private TransformGroup[] tgroup;
    private double factor = 1.1f;
    private Transform3D scale3d = new Transform3D();
    private Transform3D currTrans = new Transform3D();

    public ExpandKeyListener(TransformGroup[] tgroup) {
        this.tgroup = tgroup;
        PropertiesManager.getGlobalProperties(1);
        GlobalProperties.addPropertiesListener(this);
        try {
            this.factor = Double.parseDouble(PropertiesManager.getGlobalProperties(1).getProperty("keylistener_zoom"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int i;
        if (e.getKeyCode() == 59 && e.isShiftDown()) {
            this.logger.debug("'+'");
            this.scale3d.set(this.factor);
            for (i = 0; i < this.tgroup.length; ++i) {
                this.tgroup[i].getTransform(this.currTrans);
                this.currTrans.mul(this.scale3d);
                this.tgroup[i].setTransform(this.currTrans);
            }
        }
        if (e.getKeyCode() == 45 && !e.isMetaDown()) {
            this.logger.debug("'-'");
            this.scale3d.set(1.0 / this.factor);
            for (i = 0; i < this.tgroup.length; ++i) {
                this.tgroup[i].getTransform(this.currTrans);
                this.currTrans.mul(this.scale3d);
                this.tgroup[i].setTransform(this.currTrans);
            }
        }
    }

    public void propertiesStored(GlobalProperties properties) {
        try {
            this.factor = Double.parseDouble(properties.getProperty("keylistener_zoom"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

