/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.fbz.FBZUtils;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointBG;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

public class Kpoint {
    private Logger logger = Logger.getLogger(Kpoint.class.getName());
    private int[] numerators;
    private int[] denomenator;
    private int weight = 1;
    private String symbol = "";
    private int commonDenom = 1;
    private int[] scale;

    public Kpoint(int[] numerators, int[] denomenator) {
        this.numerators = numerators;
        this.denomenator = denomenator;
    }

    public Kpoint(int[][] kpts) {
        int i;
        this.numerators = new int[3];
        this.denomenator = new int[3];
        for (i = 0; i < 3; ++i) {
            this.numerators[i] = kpts[i][0];
            this.denomenator[i] = kpts[i][1];
        }
        this.commonDenom = Kpoint.getCommonDenomenator(this.denomenator[0], this.denomenator[1], this.denomenator[2]);
        this.scale = new int[3];
        for (i = 0; i < 3; ++i) {
            this.scale[i] = this.commonDenom / this.denomenator[i];
        }
    }

    public Kpoint(float[] kps) {
        int i;
        this.numerators = new int[3];
        this.denomenator = new int[3];
        for (i = 0; i < kps.length; ++i) {
            int[] buns = FBZUtils.getBunsu(kps[i]);
            this.numerators[i] = buns[1];
            this.denomenator[i] = buns[2];
        }
        this.commonDenom = Kpoint.getCommonDenomenator(this.denomenator[0], this.denomenator[1], this.denomenator[2]);
        this.scale = new int[3];
        for (i = 0; i < 3; ++i) {
            this.scale[i] = this.commonDenom / this.denomenator[i];
        }
    }

    public Kpoint(SymmetryPointBG bg) {
        int i;
        int[][] kpts = bg.getBunsuCoords();
        this.numerators = new int[3];
        this.denomenator = new int[3];
        for (i = 0; i < 3; ++i) {
            this.numerators[i] = kpts[i][0];
            this.denomenator[i] = kpts[i][1];
        }
        this.commonDenom = Kpoint.getCommonDenomenator(this.denomenator[0], this.denomenator[1], this.denomenator[2]);
        this.scale = new int[3];
        for (i = 0; i < 3; ++i) {
            this.scale[i] = this.commonDenom / this.denomenator[i];
        }
        this.setSymbol(bg.getSymbol());
    }

    private void init() {
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int[][] getBunsuCoords() {
        return new int[][]{this.numerators, this.denomenator};
    }

    public static int getCommonDenomenator(int denom1, int denom2, int denom3) {
        int lcm1 = FBZUtils.lcm(denom1, denom2);
        return FBZUtils.lcm(lcm1, denom3);
    }

    public double[] getDouble() {
        double[] ret = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                ret[i] = (double)this.numerators[i] / (double)this.denomenator[i];
                continue;
            }
            catch (RuntimeException e) {
                this.logger.error("invalid denomenator");
                return null;
            }
        }
        return ret;
    }

    public Point3f getPoint3f() {
        double[] d = this.getDouble();
        float[] f = new float[3];
        for (int i = 0; i < 3; ++i) {
            f[i] = (float)d[i];
        }
        Point3f ret = new Point3f(f);
        return ret;
    }

    public String toString_bandkptpl() {
        if (this.scale == null) {
            return this.toString();
        }
        String ret = String.valueOf(this.numerators[0] * this.scale[0]) + " " + String.valueOf(this.numerators[1] * this.scale[1]) + " " + String.valueOf(this.numerators[2] * this.scale[2]) + " " + String.valueOf(this.commonDenom);
        if (this.symbol != null && this.symbol.trim().length() != 0) {
            ret = ret + " # " + this.symbol;
        }
        return ret;
    }

    public double getDistanceFrom(Kpoint from) {
        double[] dfrom = from.getDouble();
        double[] d = this.getDouble();
        return Math.sqrt(Math.pow(dfrom[0] - d[0], 2.0) + Math.pow(dfrom[1] - d[1], 2.0) + Math.pow(dfrom[2] - d[2], 2.0));
    }

    public String toString() {
        String ret = String.valueOf(this.numerators[0]) + "/" + String.valueOf(this.denomenator[0]) + " " + String.valueOf(this.numerators[1]) + "/" + String.valueOf(this.denomenator[1]) + " " + String.valueOf(this.numerators[2]) + "/" + String.valueOf(this.denomenator[2]);
        if (this.symbol != null && this.symbol.trim().length() != 0) {
            ret = ret + " # " + this.symbol;
        }
        return ret;
    }

    public boolean equals(Object obj) {
        double eps = 1.0E-5;
        if (!(obj instanceof Kpoint)) {
            return false;
        }
        double[] comp = ((Kpoint)obj).getDouble();
        double[] dk = this.getDouble();
        for (int i = 0; i < dk.length; ++i) {
            if (!(Math.abs(comp[i] - dk[i]) > eps)) continue;
            return false;
        }
        return true;
    }
}

