/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class FBZUtils {
    private Logger logger = Logger.getLogger(FBZUtils.class.getName());

    public static int[] getBunsu(float val) {
        DecimalFormat form = new DecimalFormat("0.000");
        if ((val = Float.parseFloat(form.format(val))) == 0.0f) {
            return new int[]{0, 0, 1};
        }
        int intval = (int)val;
        int deci = (int)((val - (float)intval) * 1000.0f);
        if (deci == 0) {
            return new int[]{intval, 0, 1};
        }
        if (Math.abs(deci) == 333) {
            return new int[]{intval, FBZUtils.sign(deci) * 1, 3};
        }
        if (Math.abs(deci) == 667) {
            return new int[]{intval, FBZUtils.sign(deci) * 2, 3};
        }
        if (Math.abs(deci) == 111) {
            return new int[]{intval, FBZUtils.sign(deci) * 1, 9};
        }
        if (Math.abs(deci) == 222) {
            return new int[]{intval, FBZUtils.sign(deci) * 2, 9};
        }
        if (Math.abs(deci) == 444) {
            return new int[]{intval, FBZUtils.sign(deci) * 4, 9};
        }
        if (Math.abs(deci) == 556) {
            return new int[]{intval, FBZUtils.sign(deci) * 5, 9};
        }
        if (Math.abs(deci) == 778) {
            return new int[]{intval, FBZUtils.sign(deci) * 7, 9};
        }
        if (Math.abs(deci) == 889) {
            return new int[]{intval, FBZUtils.sign(deci) * 8, 9};
        }
        int gcd = FBZUtils.gcd(1000, deci);
        int denom = 1000 / gcd;
        int nume = FBZUtils.sign(denom) * deci / gcd;
        return new int[]{intval, nume, Math.abs(denom)};
    }

    private static int sign(int val) {
        if (val == 0) {
            return 1;
        }
        return val / Math.abs(val);
    }

    public static int gcd(int m, int n) {
        int t = 0;
        while (n != 0) {
            t = m % n;
            m = n;
            n = t;
        }
        return m;
    }

    public static int lcm(int m, int n) {
        return m * n / FBZUtils.gcd(m, n);
    }
}

