/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.ACVButtons;
import ciss.phase_viewer.acviewer.ACVMenuBar;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.fbz.FBZData;
import ciss.phase_viewer.acviewer.fbz.FBZTransform;
import ciss.phase_viewer.acviewer.fbz.SymmetryPointPicker;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.acviewer.keylistener.J3DKeyListener;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseRotate;
import ciss.phase_viewer.acviewer.mouselistener.MyMouseTranslate;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.atomcoord.VolumetricData;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import java.awt.Component;
import java.awt.event.KeyListener;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class FBZ
extends BaseJ3DPanel {
    private Logger logger = Logger.getLogger(FBZ.class.getName());
    private float[][] reciprocalLatticeVector = new float[3][3];
    private Transform3D translateorigin = new Transform3D();
    private FBZData data;
    private float scale = -100.0f;
    private float scalescale = 1.2f;
    private WignerSeitzCell wscell;
    private ChaseTransformGroup rootTransform;
    private TransformGroup objTransformAxis;
    private ACVButtons btns;

    public FBZ(double[][] vec) {
        super("FBZ viewer", defaultSize);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.reciprocalLatticeVector[i][j] = (float)vec[i][j];
            }
        }
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
        this.setVisible(true);
    }

    public FBZ(FBZData data) {
        super("FBZ viewer", defaultSize);
        this.data = data;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.reciprocalLatticeVector[i][j] = (float)data.reciprocalLattice[i][j];
            }
        }
        this.parentDir = data.baseDir;
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
        this.setVisible(true);
    }

    public FBZData getFBZData() {
        return this.data;
    }

    public boolean supportsFrame() {
        return false;
    }

    public float[][] getReciprocalLatticeVector() {
        return this.reciprocalLatticeVector;
    }

    protected String getExportFileNamePrefix() {
        return "FBZ";
    }

    protected String getPluginPath() {
        return "/ciss/phase_viewer/acviewer/fbz/plugins.xml";
    }

    public TransformGroup getRootTransform() {
        return this.rootTransform;
    }

    public TransformGroup[] getRotatingTransform() {
        return new TransformGroup[]{this.rootTransform, this.objTransformAxis};
    }

    private void init() {
        int j;
        int i;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                if (!(Math.abs(this.reciprocalLatticeVector[i][j]) > this.scale)) continue;
                this.scale = this.reciprocalLatticeVector[i][j];
            }
        }
        this.scale *= this.scalescale;
        for (i = 0; i < 3; ++i) {
            j = 0;
            while (j < 3) {
                float[] fArray = this.reciprocalLatticeVector[i];
                int n = j++;
                fArray[n] = fArray[n] / this.scale;
            }
        }
        this.translateorigin.set(new Vector3f(-0.8f, -0.7f, 0.0f));
        Point3f[] point3f = new Point3f[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            point3f[i2] = new Point3f(this.reciprocalLatticeVector[i2]);
        }
        this.wscell = new WignerSeitzCell(point3f[0], point3f[1], point3f[2], this.parentDir, this.data.kpointGenerator);
        this.rootBranch = new BranchGroup();
        this.rootBranch.setCapability(17);
        this.rootBranch.setCapability(12);
        this.rootBranch.setCapability(13);
        this.rootBranch.setCapability(14);
        this.rootTransform = new FBZTransform(this);
        this.rootTransform.setCapability(12);
        this.rootTransform.setCapability(18);
        this.rootTransform.setCapability(17);
        this.rootTransform.setCapability(1);
        this.rootTransform.setCapability(14);
        this.rootTransform.setCapability(13);
        this.rootTransform.addChild((Node)this.wscell);
        this.rootBranch.addChild((Node)this.rootTransform);
        MyMouseRotate myMouseRotate = null;
        myMouseRotate = BaseJ3DPanel.useJCanvas3D() ? new MyMouseRotate(this.getJCanvas3D()) : new MyMouseRotate();
        myMouseRotate.setTransformGroup(this.rootTransform);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseRotate);
        MyMouseTranslate myMouseTranslate = null;
        myMouseTranslate = BaseJ3DPanel.useJCanvas3D() ? new MyMouseTranslate(this.getJCanvas3D()) : new MyMouseTranslate();
        myMouseTranslate.setTransformGroup(this.rootTransform);
        myMouseTranslate.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = null;
        myMouseZoom = BaseJ3DPanel.useJCanvas3D() ? new MouseZoom((Component)this.getJCanvas3D()) : new MouseZoom();
        myMouseZoom.setTransformGroup((TransformGroup)this.rootTransform);
        myMouseZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseZoom);
        MouseWheelZoom myMouseWheelZoom = null;
        myMouseWheelZoom = BaseJ3DPanel.useJCanvas3D() ? new MouseWheelZoom((Component)this.getJCanvas3D()) : new MouseWheelZoom();
        myMouseWheelZoom.setTransformGroup((TransformGroup)this.rootTransform);
        myMouseWheelZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        this.rootBranch.addChild((Node)myMouseWheelZoom);
        J3DDataManager mACVD = new J3DDataManager();
        SceneGraphElementCreator creator = new SceneGraphElementCreator(mACVD, null);
        this.rootBranch.addChild((Node)creator.getSceneGraphElement(5));
        this.rootBranch.addChild((Node)creator.getSceneGraphElement(6));
        if (mACVD.getAxis()) {
            Transform3D translateorigin = new Transform3D();
            translateorigin.set(new Vector3f(-0.8f, -0.7f, 0.0f));
            this.objTransformAxis = creator.getSceneGraphElement(3);
            this.objTransformAxis.setTransform(translateorigin);
            MyMouseRotate myMouseRotateAxis = new MyMouseRotate();
            myMouseRotateAxis.setTransformGroup(this.objTransformAxis);
            myMouseRotateAxis.setSchedulingBounds((Bounds)new BoundingSphere());
            this.rootBranch.addChild((Node)myMouseRotateAxis);
            this.rootBranch.addChild((Node)this.objTransformAxis);
        }
        SymmetryPointPicker picker = new SymmetryPointPicker(this.canvas3d, this.rootBranch, (Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0), this.wscell);
        BranchGroup pickerBG = new BranchGroup();
        pickerBG.addChild((Node)picker);
        this.rootBranch.addChild((Node)pickerBG);
        KeyListener[] listeners = J3DKeyListener.getKeyListeners(this);
        for (int i3 = 0; i3 < listeners.length; ++i3) {
            this.canvas3d.addKeyListener(listeners[i3]);
        }
        this.rootBranch.compile();
        this.simpleU.addBranchGraph(this.rootBranch);
        if (this.btns == null) {
            this.btns = new ACVButtons(this);
            this.getContentPane().add((Component)this.btns, "North");
        }
    }

    public WignerSeitzCell getFBZ() {
        return this.wscell;
    }

    public VolumetricData[] getAssociatedVolumetricData() {
        return this.getFBZData().eigenValues;
    }
}

