/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.common.Utils;
import java.util.Vector;
import org.apache.log4j.Logger;

class NewElementCreater {
    private Logger logger = Logger.getLogger(NewElementCreater.class.getName());
    private J3DDataManager mACVD;
    private ConfigDataManager mCD;
    private Vector newElementVector = new Vector();
    private Vector newElementVectorExt = new Vector();
    private String[] element;
    private int numNewEl = 0;

    public NewElementCreater(J3DDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
    }

    int createNewElement() {
        boolean numNewElements = false;
        int NumAt = this.mCD.getNumAt();
        this.element = this.mACVD.getElement();
        String[] elements = this.mCD.getElements();
        for (int i = 0; i < elements.length; ++i) {
            String elementi = elements[i].toLowerCase();
            for (int j = 0; j < this.element.length; ++j) {
                char[] ch;
                String extention;
                if (!elementi.startsWith(this.element[j].toLowerCase())) continue;
                int identLength = this.element[j].length();
                if (elementi.length() == identLength || !Utils.isNumber(extention = String.copyValueOf(ch = elementi.toCharArray(), identLength, ch.length - identLength)) || !this.isUnique(elementi)) continue;
                this.newElementVector.addElement(this.element[j]);
                this.newElementVectorExt.addElement(extention);
            }
        }
        this.registerNewElement();
        return this.newElementVector.size();
    }

    private void registerNewElement() {
        int nnew = this.newElementVector.size();
        for (int i = 0; i < nnew; ++i) {
            String newel = (String)this.newElementVector.get(i);
            String newelext = (String)this.newElementVectorExt.get(i);
            this.logger.debug("found new element ... ");
            this.logger.debug("base: " + newel + ", extention: " + newelext);
            int elementIndex = 0;
            for (int ifind = 0; ifind < this.element.length; ++ifind) {
                if (!this.element[ifind].equalsIgnoreCase(newel)) continue;
                elementIndex = ifind;
                break;
            }
            float[] color = this.mACVD.getColor()[elementIndex];
            double covrad = this.mACVD.getCovRad()[elementIndex];
            float rad = this.mACVD.getRad()[elementIndex];
            this.mACVD.addElementInfo(newel + newelext, rad, covrad, color);
        }
    }

    private boolean isUnique(String string) {
        boolean ret = true;
        for (int i = 0; i < this.newElementVector.size(); ++i) {
            String comp = (String)this.newElementVector.get(i) + (String)this.newElementVectorExt.get(i);
            if (!string.equals(comp.toLowerCase())) continue;
            ret = false;
        }
        return ret;
    }
}

