/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.python.compiler.Attribute;
import org.python.compiler.Code;
import org.python.compiler.ConstantPool;
import org.python.compiler.Method;

public class ClassFile {
    ConstantPool pool;
    int access;
    public String name;
    String superclass;
    int[] interfaces;
    Vector methods;
    Vector fields;
    Vector attributes;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int NATIVE = 256;
    public static final int ABSTRACT = 1024;

    public static String fixName(String n) {
        if (n.indexOf(46) == -1) {
            return n;
        }
        char[] c = n.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != '.') continue;
            c[i] = 47;
        }
        return new String(c);
    }

    public ClassFile(String name) {
        this(name, "java/lang/Object", 33);
    }

    public ClassFile(String name, String superclass, int access) {
        this.name = ClassFile.fixName(name);
        this.superclass = ClassFile.fixName(superclass);
        this.interfaces = new int[0];
        this.access = access;
        this.pool = new ConstantPool();
        this.methods = new Vector();
        this.fields = new Vector();
        this.attributes = new Vector();
    }

    public void addInterface(String name) throws IOException {
        int[] new_interfaces = new int[this.interfaces.length + 1];
        System.arraycopy(this.interfaces, 0, new_interfaces, 0, this.interfaces.length);
        new_interfaces[this.interfaces.length] = this.pool.Class(name);
        this.interfaces = new_interfaces;
    }

    public Code addMethod(String name, String type, int access) throws IOException {
        Code code = new Code(type, this.pool, (access & 8) == 8);
        Method m = new Method(this.pool.UTF8(name), this.pool.UTF8(type), access, new Attribute[]{code});
        this.methods.addElement(m);
        return code;
    }

    public void addField(String name, String type, int access) throws IOException {
        Method m = new Method(this.pool.UTF8(name), this.pool.UTF8(type), access, new Attribute[0]);
        this.fields.addElement(m);
    }

    public static void writeAttributes(DataOutputStream stream, Attribute[] atts) throws IOException {
        stream.writeShort(atts.length);
        for (int i = 0; i < atts.length; ++i) {
            atts[i].write(stream);
        }
    }

    public void writeMethods(DataOutputStream stream, Vector methods) throws IOException {
        stream.writeShort(methods.size());
        for (int i = 0; i < methods.size(); ++i) {
            Method m = (Method)methods.elementAt(i);
            m.write(stream);
        }
    }

    public void addAttribute(Attribute attr) throws IOException {
        this.attributes.addElement(attr);
    }

    public void write(DataOutputStream stream) throws IOException {
        int thisclass = this.pool.Class(this.name);
        int superclass = this.pool.Class(this.superclass);
        stream.writeInt(-889275714);
        stream.writeShort(3);
        stream.writeShort(45);
        this.pool.write(stream);
        stream.writeShort(this.access);
        stream.writeShort(thisclass);
        stream.writeShort(superclass);
        stream.writeShort(this.interfaces.length);
        for (int i = 0; i < this.interfaces.length; ++i) {
            stream.writeShort(this.interfaces[i]);
        }
        this.writeMethods(stream, this.fields);
        this.writeMethods(stream, this.methods);
        int n = this.attributes.size();
        stream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            ((Attribute)this.attributes.elementAt(i)).write(stream);
        }
    }

    public void write(OutputStream stream) throws IOException {
        this.write(new DataOutputStream(stream));
    }
}

