/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.PdbFile;
import AbinitMp.Common.ResidueData;
import AbinitMp.Structure.SelectionData;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.TreeInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePanel
extends MyPanel {
    public JTree tree;
    private DefaultMutableTreeNode root;
    public DefaultTreeModel treeModel;
    private TreePath currentPath = null;
    private AbinitMpViewer abinitMpViewer;
    public FileItem fileItem;

    public TreePanel(FileItem fileItem, AbinitMpViewer abinitMpViewer) {
        this.abinitMpViewer = abinitMpViewer;
        this.root = new DefaultMutableTreeNode(new TreeInfo(fileItem.filename.substring(0, fileItem.filename.indexOf(".")), -1, null));
        this.tree = new JTree(this.root);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree.setModel(this.treeModel);
        this.createTree(fileItem);
        this.tree.expandPath(this.tree.getPathForRow(0));
        this.tree.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setCellRenderer(new MyRenderer());
        this.tree.addMouseListener(new PickNode());
    }

    public void createTree(FileItem fileItem) {
        this.fileItem = fileItem;
        PdbFile pdbFile = fileItem.getPdbFile();
        if (pdbFile == null) {
            return;
        }
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            AtomData atomData;
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            String string;
            int n2;
            AtomData atomData2;
            ResidueData residueData;
            int n3;
            ChainData chainData = (ChainData)vector.get(i);
            String string2 = new String(chainData.id);
            if (string2 == null || string2.equals("CPF") || string2.equals(" ")) {
                string2 = "Chain";
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new TreeInfo(string2, 1, chainData));
            this.root.add(defaultMutableTreeNode2);
            Vector vector2 = chainData.atomTable;
            Vector vector3 = chainData.hemTable;
            Vector vector4 = chainData.residueTable;
            Vector vector5 = chainData.hemResidueTable;
            for (n3 = 0; n3 < vector4.size(); ++n3) {
                residueData = (ResidueData)vector4.get(n3);
                atomData2 = (AtomData)vector2.get(residueData.startNo);
                if (residueData.cutFlag) continue;
                n2 = 0;
                if (fileItem.type == 4) {
                    string = atomData2.iCode == null || atomData2.iCode.trim().length() == 0 ? residueData.name + residueData.no : residueData.name + residueData.no + atomData2.iCode;
                } else {
                    if (residueData.name.equals("A") || residueData.name.equals("G") || residueData.name.equals("C") || residueData.name.equals("T")) {
                        object2 = null;
                        for (int j = residueData.startNo; j <= residueData.endNo; ++j) {
                            object2 = (AtomData)vector2.get(j);
                            if (((AtomData)object2).allAtomName.equals("C3'")) break;
                        }
                        n2 = ((AtomData)object2).fragmentNo;
                    } else {
                        n2 = ((AtomData)vector2.get((int)residueData.startNo)).fragmentNo;
                    }
                    string = atomData2.iCode == null || atomData2.iCode.trim().length() == 0 ? residueData.name + residueData.no + " (" + Integer.toString(n2) + ")" : residueData.name + residueData.no + atomData2.iCode + " (" + Integer.toString(n2) + ")";
                }
                object2 = new TreeInfo(string, 2, residueData, n2);
                ((TreeInfo)object2).residueNo = residueData.no;
                defaultMutableTreeNode = new DefaultMutableTreeNode(object2);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                    atomData = (AtomData)vector2.get(n);
                    if (atomData.cutFlag) continue;
                    object = new DefaultMutableTreeNode(new TreeInfo(atomData.allAtomName, 3, atomData));
                    defaultMutableTreeNode.add((MutableTreeNode)object);
                }
            }
            for (n3 = 0; n3 < vector5.size(); ++n3) {
                residueData = (ResidueData)vector5.get(n3);
                atomData2 = (AtomData)vector3.get(residueData.startNo);
                if (residueData.cutFlag) continue;
                n2 = 0;
                if (fileItem.type == 4) {
                    string = atomData2.iCode == null || atomData2.iCode.trim().length() == 0 ? residueData.name + residueData.no : residueData.name + residueData.no + atomData2.iCode;
                } else {
                    if (residueData.name.equals("A") || residueData.name.equals("G") || residueData.name.equals("C") || residueData.name.equals("T")) {
                        object2 = null;
                        for (int j = residueData.startNo; j <= residueData.endNo; ++j) {
                            object2 = (AtomData)vector3.get(j);
                            if (((AtomData)object2).allAtomName.equals("C3'")) break;
                        }
                        n2 = ((AtomData)object2).fragmentNo;
                    } else {
                        n2 = ((AtomData)vector3.get((int)residueData.startNo)).fragmentNo;
                    }
                    string = atomData2.iCode == null || atomData2.iCode.trim().length() == 0 ? residueData.name + residueData.no + " (" + Integer.toString(n2) + ")" : residueData.name + residueData.no + atomData2.iCode + " (" + Integer.toString(n2) + ")";
                }
                object2 = new TreeInfo(string, 2, residueData, n2);
                ((TreeInfo)object2).residueNo = residueData.no;
                defaultMutableTreeNode = new DefaultMutableTreeNode(object2);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                    atomData = (AtomData)vector3.get(n);
                    if (atomData.cutFlag) continue;
                    object = atomData.allAtomName;
                    if (fileItem.type == 5 && (residueData.name.equals("A") || residueData.name.equals("G") || residueData.name.equals("C") || residueData.name.equals("T"))) {
                        object = (String)object + "(" + atomData.fragmentNo + ")";
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new TreeInfo((String)object, 3, atomData));
                    defaultMutableTreeNode.add(defaultMutableTreeNode3);
                }
            }
        }
    }

    public void reCreateTree() {
        this.root.removeAllChildren();
        this.createTree(this.fileItem);
        this.treeModel.reload();
        this.tree.expandRow(1);
    }

    public TreeInfo getSelectedNodeInfo() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        return (TreeInfo)defaultMutableTreeNode.getUserObject();
    }

    public int selectNodeFromStructureViewer(AtomData atomData) {
        int n = 0;
        this.treeModel.reload();
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            AtomData atomData2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() == null) continue;
            TreeInfo treeInfo = (TreeInfo)defaultMutableTreeNode.getUserObject();
            if (treeInfo.kind != 3 || (atomData2 = (AtomData)treeInfo.data) != atomData) continue;
            TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
            for (int i = 1; i < treeNodeArray.length; ++i) {
                for (int j = 1; j < this.tree.getRowCount(); ++j) {
                    TreePath treePath = this.tree.getPathForRow(j);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeNode2 != (DefaultMutableTreeNode)treeNodeArray[i]) continue;
                    this.tree.expandPath(treePath);
                    if (n == 0) {
                        this.tree.setSelectionPath(treePath);
                    } else {
                        this.tree.addSelectionPath(treePath);
                    }
                    ++n;
                }
            }
        }
        this.tree.scrollRowToVisible(this.tree.getLeadSelectionRow());
        return n;
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon[] titleIcon = new ImageIcon[6];

        public MyRenderer() {
            this.titleIcon[1] = new ImageIcon(this.getClass().getResource("/AbinitMp/images/chain.gif"));
            this.titleIcon[2] = new ImageIcon(this.getClass().getResource("/AbinitMp/images/residue.gif"));
            this.titleIcon[3] = new ImageIcon(this.getClass().getResource("/AbinitMp/images/atom.gif"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (!defaultMutableTreeNode.isRoot()) {
                Object object2 = defaultMutableTreeNode.getUserObject();
                TreeInfo treeInfo = (TreeInfo)defaultMutableTreeNode.getUserObject();
                this.setIcon(this.titleIcon[treeInfo.kind]);
                switch (treeInfo.kind) {
                    case 2: {
                        ResidueData residueData = (ResidueData)treeInfo.data;
                        float f = residueData.charge;
                        if (f == 0.0f) break;
                        Color color = f < 0.0f ? TreeInfo.ColMinusBig : TreeInfo.ColPlusBig;
                        this.setForeground(color);
                        break;
                    }
                }
            }
            return this;
        }
    }

    private class PickNode
    extends MouseAdapter {
        private PickNode() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if (TreePanel.this.abinitMpViewer.getMoColor() == 13) {
                return;
            }
            if (mouseEvent.getClickCount() == 1) {
                TreePath treePath = TreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    TreePanel.this.tree.clearSelection();
                    TreePanel.this.abinitMpViewer.clearHighlightSelection(true);
                    return;
                }
                TreePath[] treePathArray = TreePanel.this.tree.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                TreePanel.this.abinitMpViewer.clearHighlightSelection(true);
                int n2 = TreePanel.this.abinitMpViewer.getSelectedTabIndex();
                for (int i = 0; i < treePathArray.length; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                    if ((n & 0x10) == 0 && (n & 4) == 0) continue;
                    TreeInfo treeInfo = (TreeInfo)defaultMutableTreeNode.getUserObject();
                    SelectionData selectionData = null;
                    if (treeInfo.kind == 3 || treeInfo.kind == 2 || treeInfo.kind == 1) {
                        Cloneable cloneable;
                        Cloneable cloneable2;
                        Object object;
                        int n3 = 0;
                        selectionData = new SelectionData();
                        selectionData.type = treeInfo.kind;
                        if (treeInfo.kind == 3) {
                            selectionData.atomData = (AtomData)treeInfo.data;
                            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                            cloneable2 = (TreeInfo)((DefaultMutableTreeNode)object).getUserObject();
                            selectionData.residueData = (ResidueData)((TreeInfo)cloneable2).data;
                            TreePanel.this.abinitMpViewer.setOverlayInfo(n2, selectionData.atomData.no);
                            TreePanel.this.abinitMpViewer.setFragmentInfo(selectionData.atomData.fragmentNo);
                            n3 = selectionData.atomData.fragmentNo;
                        } else if (treeInfo.kind == 2) {
                            selectionData.residueData = (ResidueData)treeInfo.data;
                            TreePanel.this.abinitMpViewer.setOverlayInfo(n2, selectionData.residueData.no);
                            object = selectionData.residueData;
                            n3 = ((ResidueData)object).name.equals("A") || ((ResidueData)object).name.equals("G") || ((ResidueData)object).name.equals("C") || ((ResidueData)object).name.equals("T") ? treeInfo.fragmentNo : selectionData.residueData.atomData.fragmentNo;
                            TreePanel.this.abinitMpViewer.setFragmentInfo(n3);
                            cloneable2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
                            cloneable = (TreeInfo)((DefaultMutableTreeNode)cloneable2).getUserObject();
                            selectionData.atomData = (AtomData)((TreeInfo)cloneable).data;
                        } else {
                            ResidueData residueData;
                            int n4;
                            object = (ChainData)treeInfo.data;
                            cloneable2 = ((ChainData)object).residueTable;
                            cloneable = ((ChainData)object).atomTable;
                            int n5 = 0;
                            for (n4 = 0; n4 < ((Vector)cloneable2).size(); ++n4) {
                                selectionData.type = 2;
                                selectionData.residueData = residueData = (ResidueData)((Vector)cloneable2).get(n4);
                                selectionData.atomData = (AtomData)((Vector)cloneable).get(residueData.startNo);
                                if (n4 == 0 && i == 0) {
                                    TreePanel.this.abinitMpViewer.setSelection(selectionData);
                                } else {
                                    TreePanel.this.abinitMpViewer.addSelection(selectionData);
                                }
                                selectionData = new SelectionData();
                                ++n5;
                            }
                            cloneable2 = ((ChainData)object).hemResidueTable;
                            cloneable = ((ChainData)object).hemTable;
                            for (n4 = 0; n4 < ((Vector)cloneable2).size(); ++n4) {
                                selectionData.type = 2;
                                selectionData.residueData = residueData = (ResidueData)((Vector)cloneable2).get(n4);
                                selectionData.atomData = (AtomData)((Vector)cloneable).get(residueData.startNo);
                                if (n4 == 0 && i == 0 && n5 == 0) {
                                    TreePanel.this.abinitMpViewer.setSelection(selectionData);
                                } else {
                                    TreePanel.this.abinitMpViewer.addSelection(selectionData);
                                }
                                selectionData = new SelectionData();
                            }
                            n4 = 0;
                            TreePanel.this.tree.expandPath(treePathArray[i]);
                            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                                for (int k = 1; k < TreePanel.this.tree.getRowCount(); ++k) {
                                    TreePath treePath2 = TreePanel.this.tree.getPathForRow(k);
                                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
                                    if (defaultMutableTreeNode2 != defaultMutableTreeNode3) continue;
                                    if (n4 == 0) {
                                        TreePanel.this.tree.setSelectionPath(treePath2);
                                    } else {
                                        TreePanel.this.tree.addSelectionPath(treePath2);
                                    }
                                    ++n4;
                                }
                            }
                        }
                        if (treeInfo.kind != 1) {
                            if (i == 0) {
                                TreePanel.this.abinitMpViewer.setSelection(selectionData);
                            } else {
                                TreePanel.this.abinitMpViewer.addSelection(selectionData);
                            }
                            TreePanel.this.abinitMpViewer.setNumberCalculateChargeWindow(selectionData.residueData.no, n3, selectionData.atomData.no);
                        }
                    }
                    if ((n & 4) == 0 || i != treePathArray.length - 1 || treeInfo.kind == 1) continue;
                    TreePanel.this.abinitMpViewer.popupAttributeWindow(selectionData);
                }
                TreePanel.this.abinitMpViewer.highlightSelection();
            }
        }
    }
}

