/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.sftp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jp.advancesoft.chase.common.MyJMenuItem;
import jp.advancesoft.chase.filebrowser.FileBrowserNode;
import jp.advancesoft.chase.filebrowser.FileBrowserParent;
import jp.advancesoft.chase.filebrowser.FileBrowserTree;
import jp.advancesoft.chase.ssh.sftp.SftpClient;
import org.apache.log4j.Logger;

public class SftpNode
extends FileBrowserNode {
    private static Logger logger = Logger.getLogger(FileBrowserTree.class.getName());
    private FileBrowserParent parent;
    private int mode = 0;
    private MyJMenuItem transfer;

    public SftpNode() {
    }

    public SftpNode(Object userObject) {
        super(userObject);
    }

    public SftpNode(Object userObject, boolean allowChildren) {
        super(userObject, allowChildren);
    }

    public void mousePressed(MouseEvent e, FileBrowserParent parent, int mode) {
        if (e.getButton() == 3) {
            this.parent = parent;
            this.mode = mode;
            this.showMenu(e);
        }
    }

    private void showMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        MyJMenuItem[] items = this.mode == 1 ? this.getLocalItems() : this.getRemoteItems();
        String transfer_mode = "download";
        if (this.mode == 1) {
            transfer_mode = "upload";
        }
        this.transfer = new MyJMenuItem(transfer_mode);
        popup.add(this.transfer);
        popup.addSeparator();
        for (int i = 0; i < items.length; ++i) {
            popup.add(items[i]);
        }
        popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SftpNode.this.transfer.setEnabled(((SftpClient)SftpNode.this.parent).isConnected());
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
        });
        popup.show(e.getComponent(), e.getX(), e.getY());
        this.transfer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SftpNode.this.mode == 1) {
                    ((SftpClient)SftpNode.this.parent).uploadFiles();
                } else if (SftpNode.this.mode == 0) {
                    ((SftpClient)SftpNode.this.parent).downloadFiles();
                }
            }
        });
    }

    private MyJMenuItem[] getLocalItems() {
        MyJMenuItem locdel = new MyJMenuItem("delete", 68);
        MyJMenuItem locchfname = new MyJMenuItem("rename", 67);
        MyJMenuItem locmkdir = new MyJMenuItem("create new dir", 78);
        MyJMenuItem locprops = new MyJMenuItem("property", 80);
        MyJMenuItem[] ret = new MyJMenuItem[]{locchfname, locmkdir, locprops, locdel};
        locdel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.deleteSelectedFiles(1);
            }
        });
        locchfname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.rename(1);
            }
        });
        locmkdir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.mkdir(1);
            }
        });
        locprops.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.bootFilePropertyViewer(1);
            }
        });
        return ret;
    }

    private MyJMenuItem[] getRemoteItems() {
        MyJMenuItem remdel = new MyJMenuItem("delete", 68);
        MyJMenuItem remchfname = new MyJMenuItem("rename", 67);
        MyJMenuItem remmkdir = new MyJMenuItem("create new dir", 78);
        MyJMenuItem remprops = new MyJMenuItem("property", 80);
        MyJMenuItem[] ret = new MyJMenuItem[]{remchfname, remmkdir, remprops, remdel};
        remdel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.deleteSelectedFiles(0);
            }
        });
        remchfname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.rename(0);
            }
        });
        remmkdir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.mkdir(0);
            }
        });
        remprops.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpNode.this.parent.bootFilePropertyViewer(0);
            }
        });
        return ret;
    }
}

