/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.fileinfo;

import java.io.File;
import java.net.URL;
import java.util.Vector;
import jp.advancesoft.chase.common.RegExpedString;
import jp.advancesoft.chase.projectbrowser.fileinfo.DefaultFileInfo;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfo;

public abstract class FileInfoParser {
    protected DefaultFileInfo fileinfo;
    protected File filefile;
    protected URL filefileurl;
    protected boolean useURL = false;
    protected boolean parseFromFile = true;
    protected File defaultParent;
    private Vector fileinfovec;

    public FileInfoParser(File filefile, File defaultParent, DefaultFileInfo fileinfo) {
        this.filefile = filefile;
        this.defaultParent = defaultParent;
        this.fileinfo = fileinfo;
        this.fileinfovec = fileinfo.getFileInfoVec();
    }

    public FileInfoParser(URL filefileurl, File defaultParent, DefaultFileInfo fileinfo) {
        this.filefileurl = filefileurl;
        this.defaultParent = defaultParent;
        this.fileinfo = fileinfo;
        this.fileinfovec = fileinfo.getFileInfoVec();
        this.useURL = true;
    }

    public FileInfoParser(File defaultParent, DefaultFileInfo fileinfo) {
        this.defaultParent = defaultParent;
        this.fileinfo = fileinfo;
        this.fileinfovec = fileinfo.getFileInfoVec();
        this.parseFromFile = false;
    }

    public File getDefaultParent() {
        return this.defaultParent;
    }

    public FileInfo getFileInfo(String identifier) {
        FileInfo[] fileinfos = this.getFileInfos();
        if (fileinfos != null && fileinfos.length != 0) {
            for (int i = 0; i < fileinfos.length; ++i) {
                RegExpedString ident = fileinfos[i].getIdentifier();
                if (!ident.equals(identifier)) continue;
                return fileinfos[i];
            }
        }
        return null;
    }

    public FileInfo[] getFileInfos() {
        return this.fileinfo.getFileInfos();
    }

    public void addFileInfo(FileInfo inf) {
        this.fileinfovec.addElement(inf);
    }

    public void removeFileInfo(FileInfo inf) {
        for (int i = 0; i < this.fileinfovec.size(); ++i) {
            if (this.fileinfovec.elementAt(i) != inf) continue;
            this.fileinfovec.remove(i);
            return;
        }
    }

    public abstract String getFileInfoName();

    public abstract void save();
}

