/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.process;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.mainpanel.Chase;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;

public class ProcessFrame
extends InternalFrameChase {
    private final int TA_MAX_SIZE = 20000;
    private Chase parent;
    private Container cont;
    private JTextField tfcom;
    private JTextArea ta;
    private JScrollPane scrta;
    private JButton btnexe;
    private JButton btnclose;
    private String comstr;
    private String outstr;
    private StringBuffer outbuf = new StringBuffer(21000);

    public ProcessFrame(Chase frame) {
        super("shell", true, true, true);
        this.setDefaultCloseOperation(1);
        this.parent = frame;
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.tfcom = new JTextField(20);
        this.tfcom.setBorder(new TitledBorder("Command"));
        this.tfcom.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ProcessFrame.this.exeaction();
                }
            }
        });
        this.cont.add(this.tfcom);
        this.ta = new JTextArea(25, 30);
        this.ta.setEditable(false);
        this.scrta = new JScrollPane(this.ta);
        this.scrta.setBorder(new TitledBorder("Output"));
        this.cont.add(this.scrta);
        JPanel panelok = new JPanel(new GridLayout(1, 2));
        this.btnexe = new JButton("Execute");
        this.btnclose = new JButton("Close");
        this.btnexe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessFrame.this.exeaction();
            }
        });
        this.btnexe.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ProcessFrame.this.exeaction();
                }
            }
        });
        panelok.add(this.btnexe);
        this.btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessFrame.this.dispose();
            }
        });
        panelok.add(this.btnclose);
        this.cont.add(panelok);
        this.setBackground(Color.gray.brighter());
        this.setResizable(true);
        this.setLocation(200, 300);
        this.setSize(400, 500);
        this.setVisible(false);
    }

    public void displayProc() {
        this.comstr = "";
        this.outstr = "";
        this.tfcom.setText(this.comstr);
        this.ta.setText(this.outstr);
        this.setVisible(true);
    }

    private void exeaction() {
        this.comstr = this.tfcom.getText();
        try {
            System.out.println("executing: " + this.comstr);
            BufferedReader[] bin = ExternalProgramExecuter.executeGetBR(this.comstr);
            this.outstr = this.getStdout(bin[0]);
            this.showoutput();
        }
        catch (Exception exception) {
            this.errorout("Failed to execute command: " + this.comstr);
            exception.printStackTrace();
        }
        this.tfcom.setText("");
    }

    private String getStdout(BufferedReader br) {
        String string = new String();
        String outString = new String();
        try {
            while ((string = br.readLine()) != null) {
                outString = outString + string + System.getProperty("line.separator");
            }
        }
        catch (Exception exception) {
            System.out.println("failed to create string from stdout");
            exception.printStackTrace();
            return "";
        }
        return outString;
    }

    private void showoutput() {
        this.ta.setEditable(true);
        if (this.outstr.length() == 0) {
            this.outstr = "No output.";
            this.ta.setForeground(Color.green.darker().darker());
        } else {
            this.outstr = this.outstr + "\n\t-End of the Result-\n";
        }
        Integer ii = new Integer(this.outstr.length());
        this.ta.setText(this.outstr);
        Font font = new Font("Serif", 0, 15);
        this.ta.setFont(font);
        this.ta.setEditable(false);
        this.ta.setForeground(Color.black);
    }

    private void errorout(String str) {
        this.ta.setEditable(true);
        this.ta.setText(str);
        Font font = new Font("Serif", 0, 15);
        this.ta.setFont(font);
        this.ta.setEditable(false);
    }
}

