/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.InitialGradientCalculator;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserTransformation;

class Numerical2PGradientCalculator
implements GradientCalculator {
    private MnFcn theFcn;
    private MnUserTransformation theTransformation;
    private MnStrategy theStrategy;

    Numerical2PGradientCalculator(MnFcn fcn, MnUserTransformation par, MnStrategy stra) {
        this.theFcn = fcn;
        this.theTransformation = par;
        this.theStrategy = stra;
    }

    public FunctionGradient gradient(MinimumParameters par) {
        InitialGradientCalculator gc = new InitialGradientCalculator(this.theFcn, this.theTransformation, this.theStrategy);
        FunctionGradient gra = gc.gradient(par);
        return this.gradient(par, gra);
    }

    public FunctionGradient gradient(MinimumParameters par, FunctionGradient gradient) {
        if (!par.isValid()) {
            throw new IllegalArgumentException("Parameters are invalid");
        }
        MnAlgebraicVector x = (MnAlgebraicVector)par.vec().clone();
        double fcnmin = par.fval();
        double dfmin = 8.0 * this.precision().eps2() * (Math.abs(fcnmin) + this.theFcn.errorDef());
        double vrysml = 8.0 * this.precision().eps() * this.precision().eps();
        int n = x.size();
        MnAlgebraicVector grd = (MnAlgebraicVector)gradient.grad().clone();
        MnAlgebraicVector g2 = (MnAlgebraicVector)gradient.g2().clone();
        MnAlgebraicVector gstep = (MnAlgebraicVector)gradient.gstep().clone();
        block0: for (int i = 0; i < n; ++i) {
            double xtf = x.get(i);
            double epspri = this.precision().eps2() + Math.abs(grd.get(i) * this.precision().eps2());
            double stepb4 = 0.0;
            for (int j = 0; j < this.ncycle(); ++j) {
                double stpmin;
                double stpmax;
                double optstp = Math.sqrt(dfmin / (Math.abs(g2.get(i)) + epspri));
                double step = Math.max(optstp, Math.abs(0.1 * gstep.get(i)));
                if (this.trafo().parameter(this.trafo().extOfInt(i)).hasLimits() && step > 0.5) {
                    step = 0.5;
                }
                if (step > (stpmax = 10.0 * Math.abs(gstep.get(i)))) {
                    step = stpmax;
                }
                if (step < (stpmin = Math.max(vrysml, 8.0 * Math.abs(this.precision().eps2() * x.get(i))))) {
                    step = stpmin;
                }
                if (Math.abs((step - stepb4) / step) < this.stepTolerance()) continue block0;
                gstep.set(i, step);
                stepb4 = step;
                x.set(i, xtf + step);
                double fs1 = this.theFcn.valueOf(x);
                x.set(i, xtf - step);
                double fs2 = this.theFcn.valueOf(x);
                x.set(i, xtf);
                double grdb4 = grd.get(i);
                grd.set(i, 0.5 * (fs1 - fs2) / step);
                g2.set(i, (fs1 + fs2 - 2.0 * fcnmin) / step / step);
                if (Math.abs(grdb4 - grd.get(i)) / (Math.abs(grd.get(i)) + dfmin / step) < this.gradTolerance()) continue block0;
            }
        }
        return new FunctionGradient(grd, g2, gstep);
    }

    MnFcn fcn() {
        return this.theFcn;
    }

    MnUserTransformation trafo() {
        return this.theTransformation;
    }

    MnMachinePrecision precision() {
        return this.theTransformation.precision();
    }

    MnStrategy strategy() {
        return this.theStrategy;
    }

    int ncycle() {
        return this.strategy().gradientNCycles();
    }

    double stepTolerance() {
        return this.strategy().gradientStepTolerance();
    }

    double gradTolerance() {
        return this.strategy().gradientTolerance();
    }
}

