/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.Common.PdbFile;
import AbinitMp.Viewer.DisplayPreference;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class XyzFile {
    public String filename = null;
    public String[] atomName;
    public float[] x;
    public float[] y;
    public float[] z;
    public float[] vx;
    public float[] vy;
    public float[] vz;
    public float[] vLength;
    public boolean hasVector = false;
    public int no;
    public float vMin;
    public float vMax;
    public PdbFile pdbFile;

    public XyzFile(String string) {
        this.readFile(string);
        if (this.filename != null) {
            this.pdbFile = new PdbFile(this);
        }
    }

    public XyzFile(String string, int n, String[] stringArray, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float[] fArray7, boolean bl) {
        this.filename = string;
        this.no = n;
        this.atomName = stringArray;
        this.x = fArray;
        this.y = fArray2;
        this.z = fArray3;
        this.vx = fArray4;
        this.vy = fArray5;
        this.vz = fArray6;
        this.vLength = fArray7;
        this.hasVector = bl;
        if (bl) {
            this.vMin = fArray7[0];
            this.vMax = fArray7[0];
            for (int i = 1; i < n; ++i) {
                if (this.vMin > fArray7[i]) {
                    this.vMin = fArray7[i];
                }
                if (!(this.vMax < fArray7[i])) continue;
                this.vMax = fArray7[i];
            }
            if (DisplayPreference.arrow.defaultMin == 0.0f) {
                DisplayPreference.arrow.min = this.vMin;
                DisplayPreference.arrow.defaultMin = this.vMin;
                DisplayPreference.arrow.max = this.vMax;
                DisplayPreference.arrow.defaultMax = this.vMax;
            } else {
                if (DisplayPreference.arrow.min > this.vMin) {
                    DisplayPreference.arrow.min = this.vMin;
                    DisplayPreference.arrow.defaultMin = this.vMin;
                }
                if (DisplayPreference.arrow.max < this.vMax) {
                    DisplayPreference.arrow.max = this.vMax;
                    DisplayPreference.arrow.defaultMax = this.vMax;
                }
            }
        }
        this.pdbFile = new PdbFile(this);
    }

    public void readFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = this.readLine(bufferedReader).trim();
            this.no = Integer.parseInt(string2);
            this.atomName = new String[this.no];
            this.x = new float[this.no];
            this.y = new float[this.no];
            this.z = new float[this.no];
            string2 = this.readLine(bufferedReader);
            int n = 0;
            while ((string2 = this.readLine(bufferedReader)) != null) {
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken()).equals("//") || string3.equals("#") || Character.isDigit(string3.charAt(0))) continue;
                this.atomName[n] = new String(string3);
                this.x[n] = Float.parseFloat(stringTokenizer.nextToken());
                this.y[n] = Float.parseFloat(stringTokenizer.nextToken());
                this.z[n] = Float.parseFloat(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    if (!this.hasVector) {
                        this.vx = new float[this.no];
                        this.vy = new float[this.no];
                        this.vz = new float[this.no];
                        this.vLength = new float[this.no];
                        this.hasVector = true;
                    }
                    this.vx[n] = Float.parseFloat(stringTokenizer.nextToken());
                    this.vy[n] = Float.parseFloat(stringTokenizer.nextToken());
                    this.vz[n] = Float.parseFloat(stringTokenizer.nextToken());
                    this.vLength[n] = (float)Math.sqrt(this.vx[n] * this.vx[n] + this.vy[n] * this.vy[n] + this.vz[n] * this.vz[n]);
                }
                ++n;
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
            if (this.hasVector) {
                this.vMin = this.vLength[0];
                this.vMax = this.vLength[0];
                for (int i = 1; i < this.no; ++i) {
                    if (this.vMin > this.vLength[i]) {
                        this.vMin = this.vLength[i];
                    }
                    if (!(this.vMax < this.vLength[i])) continue;
                    this.vMax = this.vLength[i];
                }
                if (DisplayPreference.arrow.defaultMin == 0.0f) {
                    DisplayPreference.arrow.min = this.vMin;
                    DisplayPreference.arrow.defaultMin = this.vMin;
                    DisplayPreference.arrow.max = this.vMax;
                    DisplayPreference.arrow.defaultMax = this.vMax;
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new Frame(), "Xyz file read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        StringTokenizer stringTokenizer;
        String string;
        String string2;
        while ((string2 = bufferedReader.readLine()) != null && ((string = (stringTokenizer = new StringTokenizer(string2)).nextToken()).equals("//") || string.equals("#"))) {
        }
        return string2;
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println("XYZ file (" + this.filename + ")");
        if (this.hasVector) {
            for (int i = 0; i < this.no; ++i) {
                System.out.println(this.atomName[i] + " " + this.x[i] + " " + this.y[i] + " " + this.z[i] + " " + this.vx[i] + " " + this.vy[i] + " " + this.vz[i]);
            }
        } else {
            for (int i = 0; i < this.no; ++i) {
                System.out.println(this.atomName[i] + " " + this.x[i] + " " + this.y[i] + " " + this.z[i]);
            }
        }
    }

    public static void main(String[] stringArray) {
        XyzFile xyzFile = new XyzFile(stringArray[0]);
        xyzFile.debugPrint(System.out);
    }
}

