/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.Common.AtomData;
import AbinitMp.Common.Constants;
import java.io.PrintStream;
import java.util.Vector;

public class ResidueData {
    public int no;
    public String name;
    public float charge;
    public int startNo;
    public int endNo;
    public AtomData atomData;
    public Vector atomTable;
    public boolean cutFlag = false;
    public boolean inDisplayFlag = true;
    public boolean isMolecularSurface = false;

    public ResidueData(int n, String string, float f, int n2, int n3, AtomData atomData, Vector vector) {
        this.no = n;
        this.name = string;
        this.charge = f;
        this.startNo = n2;
        this.endNo = n3;
        this.atomData = atomData;
        this.atomTable = vector;
    }

    public void set(int n, String string, float f, int n2, int n3, AtomData atomData, Vector vector) {
        this.no = n;
        this.name = string;
        this.charge = f;
        this.startNo = n2;
        this.endNo = n3;
        this.atomData = atomData;
        this.atomTable = vector;
    }

    public void setEndNo(int n) {
        this.endNo = n;
    }

    public void setCutFlag(Vector vector, boolean bl) {
        for (int i = this.startNo; i <= this.endNo; ++i) {
            AtomData atomData = (AtomData)vector.get(i);
            atomData.cutFlag = bl;
            this.cutFlag = bl;
        }
    }

    public float calcCharge(Vector vector) {
        if (!this.isResidue()) {
            return 0.0f;
        }
        float f = 0.0f;
        int n = 0;
        if (this.name.equalsIgnoreCase("Asp") || this.name.equalsIgnoreCase("Glu") || this.name.equalsIgnoreCase("Lys") || this.name.equalsIgnoreCase("Arg") || this.name.equalsIgnoreCase("His")) {
            for (int i = this.startNo; i <= this.endNo; ++i) {
                AtomData atomData = (AtomData)vector.get(i);
                if (!atomData.atomName.equalsIgnoreCase("H")) continue;
                ++n;
            }
            if (this.name.equalsIgnoreCase("Asp")) {
                f = -5.0f + (float)n;
            }
            if (this.name.equalsIgnoreCase("Glu") || this.name.equalsIgnoreCase("His")) {
                f = -7.0f + (float)n;
            }
            if (this.name.equalsIgnoreCase("Lys") || this.name.equalsIgnoreCase("Arg")) {
                f = -12.0f + (float)n;
            }
        } else {
            f = 0.0f;
        }
        this.charge = f;
        return f;
    }

    public float calcNTermCharge(Vector vector) {
        if (!this.isResidue()) {
            return 0.0f;
        }
        float f = 0.0f;
        int n = 0;
        if (this.name.equalsIgnoreCase("Asp") || this.name.equalsIgnoreCase("Glu") || this.name.equalsIgnoreCase("Lys") || this.name.equalsIgnoreCase("Arg") || this.name.equalsIgnoreCase("His")) {
            for (int i = this.startNo; i <= this.endNo; ++i) {
                AtomData atomData = (AtomData)vector.get(i);
                if (!atomData.atomName.equalsIgnoreCase("H")) continue;
                ++n;
            }
            if (this.name.equalsIgnoreCase("Asp")) {
                f = -6.0f + (float)n;
            }
            if (this.name.equalsIgnoreCase("Glu") || this.name.equalsIgnoreCase("His")) {
                f = -8.0f + (float)n;
            }
            if (this.name.equalsIgnoreCase("Lys") || this.name.equalsIgnoreCase("Arg")) {
                f = -13.0f + (float)n;
            }
        } else {
            f = 0.0f;
            for (int i = this.startNo; i <= this.endNo; ++i) {
                AtomData atomData = (AtomData)vector.get(i);
                if (!atomData.allAtomName.equalsIgnoreCase("H3") && !atomData.allAtomName.equalsIgnoreCase("3H")) continue;
                f = 1.0f;
            }
        }
        this.charge = f;
        return f;
    }

    public float calcCTermCharge(Vector vector) {
        if (!this.isResidue()) {
            return 0.0f;
        }
        float f = 0.0f;
        int n = 0;
        if (this.name.equalsIgnoreCase("Asp") || this.name.equalsIgnoreCase("Glu") || this.name.equalsIgnoreCase("Lys") || this.name.equalsIgnoreCase("Arg") || this.name.equalsIgnoreCase("His")) {
            for (int i = this.startNo; i <= this.endNo; ++i) {
                AtomData atomData = (AtomData)vector.get(i);
                if (!atomData.atomName.equalsIgnoreCase("H")) continue;
                ++n;
            }
            if (this.name.equalsIgnoreCase("Asp")) {
                f = -6.0f + (float)n;
            }
            if (this.name.equalsIgnoreCase("Glu") || this.name.equalsIgnoreCase("His")) {
                f = -8.0f + (float)n;
            }
            if (this.name.equalsIgnoreCase("Lys") || this.name.equalsIgnoreCase("Arg")) {
                f = -13.0f + (float)n;
            }
        } else if (this.name.equalsIgnoreCase("H2O")) {
            f = 0.0f;
        } else {
            f = -1.0f;
            for (int i = this.startNo; i <= this.endNo; ++i) {
                AtomData atomData = (AtomData)vector.get(i);
                if (!atomData.allAtomName.equalsIgnoreCase("HXT")) continue;
                f = 0.0f;
            }
        }
        this.charge = f;
        return f;
    }

    public boolean isResidue() {
        for (int i = 0; i < Constants.RESIDUE_NAME.length; ++i) {
            if (!this.name.equalsIgnoreCase(Constants.RESIDUE_NAME[i])) continue;
            return true;
        }
        return false;
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println(" no " + this.no + " name " + this.name + " charge " + this.charge + " start no " + this.startNo + " end no " + this.endNo + " atom " + this.atomData.allAtomName + this.atomData.no);
    }
}

