/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.VersionID;

public class SecurityBaseline {
    private static final String BASELINE_VERSION_131 = "1.3.1_21";
    private static final String BASELINE_VERSION_142 = "1.4.2_36";
    private static final String BASELINE_VERSION_150 = "1.5.0_34";
    private static final String BASELINE_VERSION_160 = "1.6.0_31";
    private static final String CURRENT_VERSION = "1.7.0_03";
    private static final String CURRENT_NODOT_VERSION = "170";
    private static final String DEPLOY_VERSION = "10.3.0.5";
    private static final String DEPLOY_NODOT_VERSION = "1030";

    private static String getBaselineVersion131() {
        return BASELINE_VERSION_131;
    }

    private static String getBaselineVersion142() {
        return BASELINE_VERSION_142;
    }

    private static String getBaselineVersion150() {
        return BASELINE_VERSION_150;
    }

    private static String getBaselineVersion160() {
        return BASELINE_VERSION_160;
    }

    private static String getBaselineVersion(String string) {
        if (string.startsWith("1.3.1")) {
            return SecurityBaseline.getBaselineVersion131();
        }
        if (string.startsWith("1.4.2")) {
            return SecurityBaseline.getBaselineVersion142();
        }
        if (string.startsWith("1.5")) {
            return SecurityBaseline.getBaselineVersion150();
        }
        if (string.startsWith("1.6")) {
            return SecurityBaseline.getBaselineVersion160();
        }
        return CURRENT_VERSION;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        VersionID versionID = new VersionID(string);
        if (string.compareTo(SecurityBaseline.getBaselineVersion(string)) >= 0) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(false));
    }

    public static String getDeployVersion() {
        return DEPLOY_VERSION;
    }

    public static String getDeployNoDotVersion() {
        return DEPLOY_NODOT_VERSION;
    }

    public static String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static String getCurrentNoDotVersion() {
        return CURRENT_NODOT_VERSION;
    }
}

