/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.WinRegistryWrapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WinRegistryUtil {
    private static final int MAX_CLSID_NUMBER = 1000;
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_ITEM_EXISTED = 0;
    private static final int ERROR_ITEM_NOTEXISTED = 9;
    private static final int MAX_KEY_LENGTH = 255;
    private static final String VN_DEFAULT = "";
    private static final String SYS_USER_KN_PREFIX = "SOFTWARE\\Classes";
    private static final String VN_CONTENT = "Content type";
    private static final String KN_DEFAULTICON = "DefaultIcon";
    private static final String VN_DEFAULTGENERATOR = "Generated By";
    private static final String VALUE_DEFAULTGENERATOR = "Generated By Java-Association";
    private static final String KN_SHELL = "shell";
    private static final String KN_COMMAND = "command";
    private static final String KN_MIME = "MIME\\Database\\Content Type";
    private static final String VN_EXTENSION = "Extension";
    private static final String USER_FILE_EXT_KEY_PREFIX = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts";
    private static final String USER_FILE_EXT_VALUENAME = "Application";
    private static final String USER_FILE_EXT_APP_PREFIX = "Applications";
    private static final int USER_LEVEL = 1;
    private static final int SYSTEM_LEVEL = 2;
    private static final int ROOT_LEVEL = 3;
    private static final String osName = System.getProperty("os.name");
    private static final String WIN2KOS = "Windows 2000";

    private WinRegistryUtil() {
    }

    private static int getHKeyByLevel(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = -2147483647;
                break;
            }
            case 2: {
                n2 = -2147483646;
                break;
            }
            case 3: {
                n2 = Integer.MIN_VALUE;
                break;
            }
            default: {
                n2 = Integer.MIN_VALUE;
            }
        }
        return n2;
    }

    private static String genClassID(String string, int n) {
        boolean bl = true;
        String string2 = string.trim();
        if (string2.charAt(0) == '.') {
            string2 = string2.substring(1);
        }
        for (int i = 1; bl && i < 1000; ++i) {
            String string3;
            String string4 = Integer.toString(i);
            String string5 = "class" + string2 + string4;
            if (string5 == null || (string3 = WinRegistryUtil.getClsIDKey(string5, n)) == null || (bl = WinRegistryUtil.isSubKeyExist(string3, n))) continue;
            return string5;
        }
        return null;
    }

    private static boolean isSubKeyExist(String string, int n) {
        int n2 = WinRegistryUtil.getHKeyByLevel(n);
        return WinRegistryWrapper.WinRegSubKeyExist(n2, string);
    }

    private static boolean isValueExist(String string, String string2, int n) {
        int n2;
        return WinRegistryUtil.isSubKeyExist(string, n) && WinRegistryWrapper.WinRegValueExist(n2 = WinRegistryUtil.getHKeyByLevel(n), string, string2) == 0;
    }

    private static String getMimeTypeKey(String string, int n) {
        String string2 = "MIME\\Database\\Content Type\\" + string;
        if (n != 3) {
            string2 = "SOFTWARE\\Classes\\" + string2;
        }
        return string2;
    }

    private static String getFileExtKey(String string, int n) {
        String string2 = string;
        if (n != 3) {
            string2 = "SOFTWARE\\Classes\\" + string2;
        }
        return string2;
    }

    private static String getClsIDKey(String string, int n) {
        String string2 = string;
        if (n != 3) {
            string2 = "SOFTWARE\\Classes\\" + string2;
        }
        return string2;
    }

    private static String getIconKey(String string, int n) {
        String string2 = WinRegistryUtil.getClassIDByFileExt(string, n);
        if (string2 != null) {
            String string3 = string2 + "\\" + KN_DEFAULTICON;
            if (n != 3) {
                string3 = "SOFTWARE\\Classes\\" + string3;
            }
            return string3;
        }
        return null;
    }

    private static void regCreateKeyEx(String string, int n) throws RegisterFailedException {
        int n2 = WinRegistryUtil.getHKeyByLevel(n);
        if (WinRegistryWrapper.WinRegCreateKeyEx(n2, string) != 0) {
            throw new RegisterFailedException("Key " + string + " creation error!");
        }
    }

    private static void regDeleteKey(String string, int n) throws RegisterFailedException {
        int n2 = WinRegistryUtil.getHKeyByLevel(n);
        if (WinRegistryWrapper.WinRegDeleteKey(n2, string) != 0) {
            throw new RegisterFailedException("Key " + string + " delete error.");
        }
    }

    private static String regQueryValueEx(String string, String string2, int n) {
        if (WinRegistryUtil.isValueExist(string, string2, n)) {
            int n2 = WinRegistryUtil.getHKeyByLevel(n);
            return WinRegistryWrapper.WinRegQueryValueEx(n2, string, string2);
        }
        return null;
    }

    private static void regSetValueEx(String string, String string2, String string3, int n) throws RegisterFailedException {
        int n2;
        if (!WinRegistryUtil.isSubKeyExist(string, n)) {
            WinRegistryUtil.regCreateKeyEx(string, n);
        }
        if (WinRegistryWrapper.WinRegSetValueEx(n2 = WinRegistryUtil.getHKeyByLevel(n), string, string2, string3) != 0) {
            throw new RegisterFailedException("Value: valueName setting error");
        }
    }

    private static String[] regGetSubKeys(String string, int n) {
        int n2 = WinRegistryUtil.getHKeyByLevel(n);
        return WinRegistryWrapper.WinRegGetSubKeys(n2, string, 255);
    }

    private static String getDefaultValue(String string, int n) {
        int n2 = WinRegistryUtil.getHKeyByLevel(n);
        return WinRegistryWrapper.WinRegQueryValueEx(n2, string, VN_DEFAULT);
    }

    private static void setDefaultValue(String string, String string2, int n) throws RegisterFailedException {
        int n2;
        if (!WinRegistryUtil.isSubKeyExist(string, n)) {
            WinRegistryUtil.regCreateKeyEx(string, n);
        }
        if (WinRegistryWrapper.WinRegSetValueEx(n2 = WinRegistryUtil.getHKeyByLevel(n), string, VN_DEFAULT, string2) != 0) {
            throw new RegisterFailedException("Set default value for key " + string + " error.");
        }
        WinRegistryWrapper.WinRegFlushKey(n2, string);
    }

    private static void addActionByClsID(Action action, String string, int n) throws RegisterFailedException {
        String string2 = WinRegistryUtil.getClsIDKey(string, n);
        String string3 = action.getVerb();
        String string4 = action.getDescription();
        String string5 = action.getCommand();
        if (string2 != null && string3 != null) {
            String string6 = string2 + "\\" + KN_SHELL;
            String string7 = string6 + "\\" + string3;
            String string8 = string7 + "\\" + KN_COMMAND;
            if (string4 == null || string3.equalsIgnoreCase("open") || string3.equalsIgnoreCase("print") || string3.equalsIgnoreCase("printto")) {
                string4 = VN_DEFAULT;
            }
            if (string5 == null) {
                string5 = VN_DEFAULT;
            }
            WinRegistryUtil.regCreateKeyEx(string8, n);
            WinRegistryUtil.setDefaultValue(string8, string5, n);
            WinRegistryUtil.setDefaultValue(string7, string4, n);
        }
    }

    public static String getMimeTypeByFileExt(String string, int n) {
        String string2 = WinRegistryUtil.getFileExtKey(string, n);
        if (string2 != null) {
            return WinRegistryUtil.regQueryValueEx(string2, VN_CONTENT, n);
        }
        return null;
    }

    public static String getMimeTypeByFileExt(String string) {
        return WinRegistryUtil.getMimeTypeByFileExt(string, 3);
    }

    public static void setMimeTypeByFileExt(String string, String string2, int n) throws RegisterFailedException {
        String string3 = WinRegistryUtil.getFileExtKey(string2, n);
        if (string3 != null) {
            WinRegistryUtil.regSetValueEx(string3, VN_CONTENT, string, n);
        }
    }

    public static String getFileExtByMimeType(String string, int n) {
        String string2 = WinRegistryUtil.getMimeTypeKey(string, n);
        if (string2 != null) {
            return WinRegistryUtil.regQueryValueEx(string2, VN_EXTENSION, n);
        }
        return null;
    }

    public static String getFileExtByMimeType(String string) {
        return WinRegistryUtil.getFileExtByMimeType(string, 3);
    }

    public static void setFileExtByMimeType(String string, String string2, int n) throws RegisterFailedException {
        String string3 = WinRegistryUtil.getMimeTypeKey(string2, n);
        if (string3 != null) {
            WinRegistryUtil.regSetValueEx(string3, VN_EXTENSION, string, n);
        }
    }

    public static String getIconFileNameByFileExt(String string, int n) {
        String string2 = WinRegistryUtil.getIconKey(string, n);
        if (string2 != null) {
            return WinRegistryUtil.getDefaultValue(string2, n);
        }
        return null;
    }

    public static String getIconFileNameByFileExt(String string) {
        return WinRegistryUtil.getIconFileNameByFileExt(string, 3);
    }

    public static void setIconFileNameByFileExt(String string, String string2, int n) throws RegisterFailedException {
        String string3;
        String string4 = WinRegistryUtil.getIconKey(string2, n);
        if (string4 == null && (string3 = WinRegistryUtil.genClassID(string2, n)) != null) {
            WinRegistryUtil.setClassIDByFileExt(string2, string3, n);
            string4 = WinRegistryUtil.getIconKey(string2, n);
        }
        if (string4 != null) {
            WinRegistryUtil.setDefaultValue(string4, string, n);
        }
    }

    public static String getDescriptionByFileExt(String string, int n) {
        String string2;
        String string3 = WinRegistryUtil.getClassIDByFileExt(string, n);
        if (string3 != null && (string2 = WinRegistryUtil.getClsIDKey(string3, n)) != null) {
            return WinRegistryUtil.getDefaultValue(string2, n);
        }
        return null;
    }

    public static String getDescriptionByFileExt(String string) {
        return WinRegistryUtil.getDescriptionByFileExt(string, 3);
    }

    public static void setDescriptionByFileExt(String string, String string2, int n) throws RegisterFailedException {
        String string3;
        String string4 = WinRegistryUtil.getClassIDByFileExt(string2, n);
        if (string4 == null && (string4 = WinRegistryUtil.genClassID(string2, n)) != null) {
            WinRegistryUtil.setClassIDByFileExt(string2, string4, n);
        }
        if (string4 != null && (string3 = WinRegistryUtil.getClsIDKey(string4, n)) != null) {
            WinRegistryUtil.setDefaultValue(string3, string, n);
        }
    }

    public static void markGeneratorByFileExt(String string, int n) throws RegisterFailedException {
        String string2 = WinRegistryUtil.getClassIDByFileExt(string, n);
        String string3 = WinRegistryUtil.getClsIDKey(string2, n);
        if (string3 != null) {
            WinRegistryUtil.regSetValueEx(string3, VN_DEFAULTGENERATOR, VALUE_DEFAULTGENERATOR, n);
        }
    }

    public static List getActionListByFileExt(String string, int n) {
        ArrayList<Action> arrayList = null;
        String string2 = WinRegistryUtil.getClassIDByFileExt(string, n);
        if (string2 != null) {
            int n2;
            String string3 = WinRegistryUtil.getClsIDKey(string2, n);
            String string4 = string3 + "\\" + KN_SHELL;
            String[] stringArray = null;
            if (string4 != null) {
                stringArray = WinRegistryUtil.regGetSubKeys(string4, n);
            }
            if (stringArray != null && (n2 = stringArray.length) > 0) {
                arrayList = new ArrayList<Action>();
                for (int i = 0; i < n2; ++i) {
                    String string5 = string4 + "\\" + stringArray[i];
                    String string6 = string5 + "\\" + KN_COMMAND;
                    if (string6 == null) continue;
                    String string7 = WinRegistryUtil.getDefaultValue(string6, n);
                    if (string7 == null) {
                        string7 = VN_DEFAULT;
                    }
                    Action action = new Action(stringArray[i], string7, WinRegistryUtil.getDefaultValue(string5, n));
                    arrayList.add(action);
                }
            }
        }
        return arrayList;
    }

    public static List getActionListByFileExt(String string) {
        List list = WinRegistryUtil.getActionListByFileExt(string, 3);
        List list2 = WinRegistryUtil.getUserAddedActionListByFileExt(string);
        if (list2 != null) {
            return list2;
        }
        return list;
    }

    private static List getUserAddedActionListByFileExt(String string) {
        int n;
        String string2 = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + string;
        String string3 = USER_FILE_EXT_VALUENAME;
        int n2 = -2147483647;
        String string4 = WinRegistryWrapper.WinRegQueryValueEx(n2, string2, string3);
        String[] stringArray = null;
        String string5 = "Applications\\" + string4 + "\\" + KN_SHELL;
        n2 = Integer.MIN_VALUE;
        stringArray = WinRegistryWrapper.WinRegGetSubKeys(n2, string5, 255);
        ArrayList<Action> arrayList = null;
        if (stringArray != null && (n = stringArray.length) > 0) {
            arrayList = new ArrayList<Action>();
            for (int i = 0; i < n; ++i) {
                String string6 = string5 + "\\" + stringArray[i];
                String string7 = string6 + "\\" + KN_COMMAND;
                if (string7 == null) continue;
                String string8 = WinRegistryUtil.getDefaultValue(string7, 3);
                if (string8 == null) {
                    string8 = VN_DEFAULT;
                }
                Action action = new Action(stringArray[i], string8, WinRegistryUtil.getDefaultValue(string6, 3));
                arrayList.add(action);
            }
        }
        return arrayList;
    }

    public static void setActionListByFileExt(List list, String string, int n) throws RegisterFailedException {
        String string2 = WinRegistryUtil.getClassIDByFileExt(string, n);
        if (string2 == null && (string2 = WinRegistryUtil.genClassID(string, n)) != null) {
            WinRegistryUtil.setClassIDByFileExt(string, string2, n);
        }
        if (string2 != null && list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                if (action == null || string2 == null) continue;
                WinRegistryUtil.addActionByClsID(action, string2, n);
            }
        }
    }

    public static String getMimeTypeByURL(URL uRL) {
        return WinRegistryWrapper.WinFindMimeFromData(uRL);
    }

    public static String ExpandEnvironmentStrings(String string) {
        return WinRegistryWrapper.WinExpandEnvironmentStrings(string);
    }

    public static boolean isMimeTypeExist(String string, int n) {
        String string2 = WinRegistryUtil.getMimeTypeKey(string, n);
        if (string2 != null) {
            return WinRegistryUtil.isSubKeyExist(string2, n);
        }
        return false;
    }

    public static boolean isMimeTypeExist(String string) {
        return WinRegistryUtil.isMimeTypeExist(string, 3);
    }

    public static boolean isFileExtExist(String string, int n) {
        String string2 = WinRegistryUtil.getFileExtKey(string, n);
        if (string2 != null) {
            return WinRegistryUtil.isSubKeyExist(string2, n) || WinRegistryUtil.isWin2kUserDefinedFileExtExist(string);
        }
        return false;
    }

    public static boolean isWin2kUserDefinedFileExtExist(String string) {
        boolean bl = false;
        if (osName.equalsIgnoreCase(WIN2KOS)) {
            String string2 = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + string;
            bl = WinRegistryUtil.isSubKeyExist(string2, 1);
        }
        return bl;
    }

    public static boolean isFileExtExist(String string) {
        return WinRegistryUtil.isFileExtExist(string, 3);
    }

    public static void addFileExt(String string, int n) throws RegisterFailedException {
        String string2 = WinRegistryUtil.getFileExtKey(string, n);
        if (string2 != null) {
            WinRegistryUtil.regCreateKeyEx(string2, n);
        }
    }

    public static void removeFileExt(String string, int n) throws RegisterFailedException {
        if (WinRegistryUtil.isFileExtExist(string, n)) {
            String string2;
            String string3;
            String string4 = WinRegistryUtil.getFileExtKey(string, n);
            String string5 = WinRegistryUtil.getClassIDByFileExt(string, n);
            if (string5 != null && (string3 = WinRegistryUtil.getClsIDKey(string5, n)) != null && (string2 = WinRegistryUtil.regQueryValueEx(string3, VN_DEFAULTGENERATOR, n)).compareTo(VALUE_DEFAULTGENERATOR) == 0) {
                WinRegistryUtil.regDeleteKey(string3, n);
            }
            if (string4 != null && WinRegistryUtil.isSubKeyExist(string4, n)) {
                WinRegistryUtil.regDeleteKey(string4, n);
            }
            if (WinRegistryUtil.isWin2kUserDefinedFileExtExist(string)) {
                string4 = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + string;
                WinRegistryUtil.regDeleteKey(string4, 1);
            }
        }
    }

    public static void addMimeType(String string, int n) throws RegisterFailedException {
        String string2 = WinRegistryUtil.getMimeTypeKey(string, n);
        if (string2 != null) {
            WinRegistryUtil.regCreateKeyEx(string2, n);
        }
    }

    public static void removeMimeType(String string, int n) throws RegisterFailedException {
        String string2;
        if (WinRegistryUtil.isMimeTypeExist(string, n) && (string2 = WinRegistryUtil.getMimeTypeKey(string, n)) != null) {
            WinRegistryUtil.regDeleteKey(string2, n);
        }
    }

    public static void setClassIDByFileExt(String string, String string2, int n) throws RegisterFailedException {
        String string3 = WinRegistryUtil.getFileExtKey(string, n);
        String string4 = WinRegistryUtil.getClsIDKey(string2, n);
        if (string3 != null) {
            if (!WinRegistryUtil.isSubKeyExist(string3, n)) {
                WinRegistryUtil.addFileExt(string, n);
            }
            if (!WinRegistryUtil.isSubKeyExist(string4, n) && string4 != null) {
                WinRegistryUtil.regCreateKeyEx(string4, n);
            }
            WinRegistryUtil.setDefaultValue(string3, string2, n);
        }
    }

    public static String getClassIDByFileExt(String string, int n) {
        String string2 = WinRegistryUtil.getFileExtKey(string, n);
        if (string2 != null && WinRegistryUtil.isSubKeyExist(string2, n)) {
            return WinRegistryUtil.getDefaultValue(string2, n);
        }
        return null;
    }

    public static void setMutualRef(String string, String string2, int n) throws RegisterFailedException {
        String string3 = WinRegistryUtil.getMimeTypeKey(string2, n);
        String string4 = WinRegistryUtil.getFileExtKey(string, n);
        if (string3 != null && string4 != null && WinRegistryUtil.isSubKeyExist(string4, n) && WinRegistryUtil.isSubKeyExist(string3, n)) {
            WinRegistryUtil.setMimeTypeByFileExt(string2, string, n);
            WinRegistryUtil.setFileExtByMimeType(string, string2, n);
        }
    }
}

