/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.Property;
import com.sun.deploy.util.StringQuoteUtil;
import com.sun.javaws.ExtensionInstallHandler;
import com.sun.javaws.Globals;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.MatchJREIf;
import com.sun.javaws.util.GeneralUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class JnlpxArgs {
    public static final String ARG_JVM = "jnlpx.jvm";
    public static final String ARG_SPLASHPORT = "jnlpx.splashport";
    public static final String ARG_REMOVE = "jnlpx.remove";
    public static final String ARG_OFFLINE = "jnlpx.offline";
    public static final String ARG_HEAPSIZE = "jnlpx.heapsize";
    public static final String ARG_VMARGS = "jnlpx.vmargs";
    public static final String ARG_HOME = "jnlpx.home";
    public static final String ARG_RELAUNCH = "jnlpx.relaunch";
    private static File _currentJVMCommand = null;
    private static final String JAVAWS_JAR = "javaws.jar";
    private static final String DEPLOY_JAR = "deploy.jar";
    private static final String PLUGIN_JAR = "plugin.jar";
    private static final Vector fileReadWriteList = new Vector();
    public static boolean _verbose = false;

    public static int getSplashPort() {
        try {
            return Integer.parseInt(System.getProperty(ARG_SPLASHPORT, "-1"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String getVMArgs() {
        return StringQuoteUtil.unquoteIfNeeded((String)System.getProperty(ARG_VMARGS));
    }

    public static boolean getIsRelaunch() {
        return JnlpxArgs.getBooleanProperty(ARG_RELAUNCH);
    }

    public static File getJVMCommand() {
        if (_currentJVMCommand == null) {
            String string = System.getProperty(ARG_JVM, "").trim();
            if (string.startsWith("X")) {
                string = JREInfo.getDefaultJavaPath();
            }
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
            _currentJVMCommand = new File(string);
        }
        return _currentJVMCommand;
    }

    public static boolean shouldRemoveArgumentFile() {
        return JnlpxArgs.getBooleanProperty(ARG_REMOVE);
    }

    public static void setShouldRemoveArgumentFile(String string) {
        System.setProperty(ARG_REMOVE, string);
    }

    public static boolean isOffline() {
        return JnlpxArgs.getBooleanProperty(ARG_OFFLINE);
    }

    public static void SetIsOffline() {
        System.setProperty(ARG_OFFLINE, "true");
    }

    public static String getHeapSize() {
        return System.getProperty(ARG_HEAPSIZE);
    }

    public static void setVerbose(boolean bl) {
        _verbose = bl;
    }

    public static long getInitialHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(0, string2.lastIndexOf(44));
        return GeneralUtil.heapValToLong(string3);
    }

    public static long getMaxHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(string2.lastIndexOf(44) + 1, string2.length());
        return GeneralUtil.heapValToLong(string3);
    }

    private static boolean heapSizesValid(long l, long l2) {
        return l != -1L || l2 != -1L;
    }

    static List getArgumentList(String string, long l, long l2, JVMParameters jVMParameters, boolean bl, JfxRuntime jfxRuntime, boolean bl2, int n) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = "-Djnlpx.heapsize=NULL,NULL";
        if (JnlpxArgs.heapSizesValid(l, l2)) {
            string6 = "-Djnlpx.heapsize=" + l + "," + l2;
        }
        String string7 = JnlpxArgs.getVMArgs();
        List list = new ArrayList();
        if (string7 != null) {
            list = StringQuoteUtil.parseCommandLine((String)string7);
            jVMParameters = jVMParameters.copy();
            jVMParameters.parse(string7);
        }
        String string8 = (string5 = Environment.getForcedBootClassPath()) == null ? "-Xbootclasspath/a:" + Environment.getJavaHome() + File.separator + "lib" + File.separator + JAVAWS_JAR + File.pathSeparator + Environment.getJavaHome() + File.separator + "lib" + File.separator + DEPLOY_JAR + File.pathSeparator + Environment.getJavaHome() + File.separator + "lib" + File.separator + PLUGIN_JAR : "-Xbootclasspath/p:" + string5;
        String string9 = "";
        String string10 = "";
        if (jfxRuntime != null) {
            string9 = "-Djnlp.fx=" + jfxRuntime.getProductVersion().toString();
            if (!bl2) {
                string10 = "-Djnlp.tk=awt";
            }
        }
        String[] stringArray = new String[]{string8, string9, string10, "-classpath", Environment.getJavaHome() + File.separator + "lib" + File.separator + DEPLOY_JAR, null, "-Djnlpx.jvm=" + string, "-Djnlpx.splashport=" + JnlpxArgs.getSplashPort(), "-Djnlpx.home=" + Environment.getJavaHome() + File.separator + "bin", "-Djnlpx.remove=" + (JnlpxArgs.shouldRemoveArgumentFile() ? "true" : "false"), "-Djnlpx.offline=" + (JnlpxArgs.isOffline() ? "true" : "false"), "-Djnlpx.relaunch=true", string6, "-Djava.security.policy=" + JnlpxArgs.getPolicyURLString(), "-DtrustProxy=true", "-Xverify:remote", JnlpxArgs.useJCOV(), JnlpxArgs.useBootClassPath(), JnlpxArgs.useJpiProfile(), JnlpxArgs.useDebugMode(), JnlpxArgs.useDebugVMMode(), bl2 ? "" : "-Dsun.awt.warmup=true", "com.sun.javaws.Main", bl ? "-secure" : "", _verbose ? "-verbose" : "", JnlpxArgs.setTCKHarnessOption(), JnlpxArgs.useLogToHost()};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            n -= stringArray[i].length() + 1;
        }
        List list2 = jVMParameters.getCommandLineArguments(false, false, true, bl, n / 2 - 20);
        if (Environment.isJavaWebStart()) {
            for (int i = 0; i < list.size(); ++i) {
                string4 = (String)list.get(i);
                if (list2.contains(string4)) continue;
                list2.add(string4);
            }
        }
        if ((n -= (string3 = StringQuoteUtil.getStringByCommandList((List)list2)).length()) < (string2 = (string4 = new Property(ARG_VMARGS, string3)).toString(true)).length()) {
            string2 = null;
            Trace.println((String)("JnlpxArgs.getArgumentList: Internal Error:  remaining custArgsMaxLen: " + n + " < vmArgsPropertyStr.length: " + string2.length() + " dropping vmArgsPropertyStr"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                if (string2 == null) continue;
                list2.add(string2);
                string2 = null;
                continue;
            }
            if (stringArray[i].length() <= 0) continue;
            list2.add(stringArray[i]);
        }
        return list2;
    }

    static String getPolicyURLString() {
        String string;
        String string2 = string = Environment.getJavaHome() + File.separator + "lib" + File.separator + "security" + File.separator + "javaws.policy";
        try {
            URL uRL = new URL("file", "", string);
            string2 = uRL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String useLogToHost() {
        if (Globals.LogToHost != null) {
            return "-XX:LogToHost=" + Globals.LogToHost;
        }
        return "";
    }

    public static String setTCKHarnessOption() {
        if (Globals.TCKHarnessRun) {
            return "-XX:TCKHarnessRun=true";
        }
        return "";
    }

    public static String useBootClassPath() {
        if (Globals.BootClassPath.equals("NONE")) {
            return "";
        }
        return "-Xbootclasspath" + Globals.BootClassPath;
    }

    public static String useJpiProfile() {
        String string = System.getProperty("javaplugin.user.profile");
        if (string != null) {
            return "-Djavaplugin.user.profile=" + string;
        }
        return "";
    }

    public static String useJCOV() {
        if (Globals.JCOV.equals("NONE")) {
            return "";
        }
        return "-Xrunjcov:file=" + Globals.JCOV;
    }

    public static String useDebugMode() {
        if (Config.isDebugMode()) {
            return "-Ddeploy.debugMode=true";
        }
        return "";
    }

    public static String useDebugVMMode() {
        if (Config.isDebugVMMode()) {
            return "-Ddeploy.useDebugJavaVM=true";
        }
        return "";
    }

    public static void removeArgumentFile(String string) {
        if (JnlpxArgs.shouldRemoveArgumentFile() && string != null) {
            new File(string).delete();
        }
    }

    public static void verify() {
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)"Java part started", (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.jvm: " + JnlpxArgs.getJVMCommand()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.splashport: " + JnlpxArgs.getSplashPort()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.remove: " + JnlpxArgs.shouldRemoveArgumentFile()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.heapsize: " + JnlpxArgs.getHeapSize()), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private static boolean getBooleanProperty(String string) {
        String string2 = System.getProperty(string, "false");
        return string2 != null && string2.equals("true");
    }

    public static Vector getFileReadWriteList() {
        return fileReadWriteList;
    }

    protected static Process execProgram(JREInfo jREInfo, String[] stringArray, long l, long l2, JVMParameters jVMParameters, boolean bl) throws IOException {
        return JnlpxArgs.execProgram(jREInfo, stringArray, l, l2, jVMParameters, bl, null, false);
    }

    protected static Process execProgram(JREInfo jREInfo, String[] stringArray, long l, long l2, JVMParameters jVMParameters, boolean bl, JfxRuntime jfxRuntime, boolean bl2) throws IOException {
        int n;
        String string = null;
        String string2 = null;
        string2 = jREInfo.getPath();
        string = Config.isDebugMode() && Config.isDebugVMMode() ? jREInfo.getDebugJavaPath() : jREInfo.getPath();
        if (string.length() == 0 || string2.length() == 0) {
            throw new IllegalArgumentException("must exist");
        }
        int n2 = Config.getMaxCommandLineLength();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            n2 -= stringArray[i].length() + 1;
        }
        List list = JnlpxArgs.getArgumentList(string2, l, l2, jVMParameters, bl, jfxRuntime, bl2, n2 -= string.length() + 1);
        int n3 = 1 + list.size() + stringArray.length;
        String[] stringArray2 = new String[n3];
        int n4 = 0;
        stringArray2[n4++] = string;
        for (n = 0; n < list.size(); ++n) {
            stringArray2[n4++] = (String)list.get(n);
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n4++] = stringArray[n];
        }
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("Launching new JRE version: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("\t jvmParams: " + jVMParameters), (TraceLevel)TraceLevel.BASIC);
            for (n = 0; n < stringArray2.length; ++n) {
                Trace.println((String)("cmd " + n + " : " + stringArray2[n]), (TraceLevel)TraceLevel.BASIC);
            }
        }
        if (Globals.TCKHarnessRun) {
            Main.tckprintln("JVM Starting");
        }
        Trace.flush();
        return Runtime.getRuntime().exec(stringArray2);
    }

    public static void executeInstallers(ArrayList arrayList, Preloader preloader) throws ExitException {
        if (preloader.getOwner() != null) {
            try {
                preloader.handleEvent((PreloaderEvent)new InitEvent(2));
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, null);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
                localApplicationProperties.setExtensionInstalled(false);
                localApplicationProperties.store();
                Trace.println((String)("Installing extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                String[] stringArray = new String[]{"-installer", file.getAbsolutePath()};
                JREInfo jREInfo = launchDesc.selectJRE();
                if (jREInfo == null) {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                    LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(launchDescException, 3);
                }
                boolean bl = JnlpxArgs.shouldRemoveArgumentFile();
                JnlpxArgs.setShouldRemoveArgumentFile("false");
                MatchJREIf matchJREIf = launchDesc.getJREMatcher();
                JVMParameters jVMParameters = matchJREIf.getSelectedJVMParameters();
                JREDesc jREDesc = matchJREIf.getSelectedJREDesc();
                long l = jREDesc.getMinHeap();
                long l2 = jREDesc.getMaxHeap();
                Process process = JnlpxArgs.execProgram(jREInfo, stringArray, l, l2, jVMParameters, false);
                preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(bl));
                localApplicationProperties.refresh();
                if (localApplicationProperties.isRebootNeeded()) {
                    boolean bl2 = false;
                    ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                    if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions((Component)preloader.getOwner())) {
                        bl2 = true;
                    }
                    localApplicationProperties.setExtensionInstalled(true);
                    localApplicationProperties.setRebootNeeded(false);
                    localApplicationProperties.store();
                    if (bl2 && extensionInstallHandler.doReboot()) {
                        throw new ExitException(null, 1);
                    }
                }
                if (localApplicationProperties.isExtensionInstalled()) continue;
                preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                throw new ExitException(new LaunchDescException(launchDesc, ResourceManager.getString((String)"Launch.error.installfailed"), null), 3);
            }
            catch (JNLPException jNLPException) {
                try {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(jNLPException, 3);
            }
            catch (IOException iOException) {
                try {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(iOException, 3);
            }
            catch (InterruptedException interruptedException) {
                try {
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(interruptedException, 3);
            }
        }
    }

    public static void executeUninstallers(ArrayList arrayList) throws ExitException {
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                Object object;
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, null);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
                Trace.println((String)("uninstalling extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                if (!launchDesc.isInstaller()) {
                    throw new ExitException(null, 3);
                }
                String[] stringArray = new String[]{"-silent", "-installer", file.getAbsolutePath()};
                JREInfo jREInfo = launchDesc.selectJRE();
                if (jREInfo == null) {
                    object = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException((Throwable)object, 3);
                }
                object = launchDesc.getJREMatcher();
                JVMParameters jVMParameters = object.getSelectedJVMParameters();
                JREDesc jREDesc = object.getSelectedJREDesc();
                long l = jREDesc.getMinHeap();
                long l2 = jREDesc.getMaxHeap();
                Process process = JnlpxArgs.execProgram(jREInfo, stringArray, l, l2, jVMParameters, false);
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                localApplicationProperties.refresh();
                if (!localApplicationProperties.isRebootNeeded()) continue;
                boolean bl = false;
                ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions(null)) {
                    bl = true;
                }
                localApplicationProperties.setRebootNeeded(false);
                localApplicationProperties.setExtensionInstalled(false);
                localApplicationProperties.store();
                if (!bl || !extensionInstallHandler.doReboot()) continue;
                throw new ExitException(null, 1);
            }
            catch (JNLPException jNLPException) {
                throw new ExitException(jNLPException, 3);
            }
            catch (IOException iOException) {
                throw new ExitException(iOException, 3);
            }
            catch (InterruptedException interruptedException) {
                throw new ExitException(interruptedException, 3);
            }
        }
    }

    private static String sizeString(long l) {
        if (l > 0x100000L) {
            return "" + l / 0x100000L + "Mb";
        }
        return "" + l + "bytes";
    }

    private static class EatInput
    implements Runnable {
        private InputStream _is;

        EatInput(InputStream inputStream) {
            this._is = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[1024];
            try {
                int n = 0;
                while (n != -1) {
                    n = this._is.read(byArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void eatInput(InputStream inputStream) {
            EatInput eatInput = new EatInput(inputStream);
            new Thread(eatInput).start();
        }
    }
}

