/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.org.mozilla.javascript.internal.Arguments;
import sun.org.mozilla.javascript.internal.BaseFunction;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.ClassCache;
import sun.org.mozilla.javascript.internal.ClassShutter;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ContextFactory;
import sun.org.mozilla.javascript.internal.DToA;
import sun.org.mozilla.javascript.internal.DefaultErrorReporter;
import sun.org.mozilla.javascript.internal.EcmaError;
import sun.org.mozilla.javascript.internal.ErrorReporter;
import sun.org.mozilla.javascript.internal.Evaluator;
import sun.org.mozilla.javascript.internal.EvaluatorException;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.ImporterTopLevel;
import sun.org.mozilla.javascript.internal.JavaScriptException;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.LazilyLoadedCtor;
import sun.org.mozilla.javascript.internal.NativeArray;
import sun.org.mozilla.javascript.internal.NativeBoolean;
import sun.org.mozilla.javascript.internal.NativeCall;
import sun.org.mozilla.javascript.internal.NativeDate;
import sun.org.mozilla.javascript.internal.NativeError;
import sun.org.mozilla.javascript.internal.NativeFunction;
import sun.org.mozilla.javascript.internal.NativeGlobal;
import sun.org.mozilla.javascript.internal.NativeIterator;
import sun.org.mozilla.javascript.internal.NativeJSON;
import sun.org.mozilla.javascript.internal.NativeMath;
import sun.org.mozilla.javascript.internal.NativeNumber;
import sun.org.mozilla.javascript.internal.NativeObject;
import sun.org.mozilla.javascript.internal.NativeScript;
import sun.org.mozilla.javascript.internal.NativeString;
import sun.org.mozilla.javascript.internal.NativeWith;
import sun.org.mozilla.javascript.internal.ObjToIntMap;
import sun.org.mozilla.javascript.internal.Ref;
import sun.org.mozilla.javascript.internal.RefCallable;
import sun.org.mozilla.javascript.internal.RegExpProxy;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.Script;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.SpecialRef;
import sun.org.mozilla.javascript.internal.TokenStream;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.WrappedException;
import sun.org.mozilla.javascript.internal.Wrapper;
import sun.org.mozilla.javascript.internal.xml.XMLLib;
import sun.org.mozilla.javascript.internal.xml.XMLObject;

public class ScriptRuntime {
    private static BaseFunction THROW_TYPE_ERROR = null;
    public static final Class<?> BooleanClass = Kit.classOrNull("java.lang.Boolean");
    public static final Class<?> ByteClass = Kit.classOrNull("java.lang.Byte");
    public static final Class<?> CharacterClass = Kit.classOrNull("java.lang.Character");
    public static final Class<?> ClassClass = Kit.classOrNull("java.lang.Class");
    public static final Class<?> DoubleClass = Kit.classOrNull("java.lang.Double");
    public static final Class<?> FloatClass = Kit.classOrNull("java.lang.Float");
    public static final Class<?> IntegerClass = Kit.classOrNull("java.lang.Integer");
    public static final Class<?> LongClass = Kit.classOrNull("java.lang.Long");
    public static final Class<?> NumberClass = Kit.classOrNull("java.lang.Number");
    public static final Class<?> ObjectClass = Kit.classOrNull("java.lang.Object");
    public static final Class<?> ShortClass = Kit.classOrNull("java.lang.Short");
    public static final Class<?> StringClass = Kit.classOrNull("java.lang.String");
    public static final Class<?> DateClass = Kit.classOrNull("java.util.Date");
    public static final Class<?> ContextClass = Kit.classOrNull("sun.org.mozilla.javascript.internal.Context");
    public static final Class<?> ContextFactoryClass = Kit.classOrNull("sun.org.mozilla.javascript.internal.ContextFactory");
    public static final Class<?> FunctionClass = Kit.classOrNull("sun.org.mozilla.javascript.internal.Function");
    public static final Class<?> ScriptableObjectClass = Kit.classOrNull("sun.org.mozilla.javascript.internal.ScriptableObject");
    public static final Class<Scriptable> ScriptableClass = Scriptable.class;
    private static final String[] lazilyNames = new String[]{"RegExp", "sun.org.mozilla.javascript.internal.regexp.NativeRegExp", "Packages", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "java", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "javax", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "org", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "com", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "edu", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "net", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "getClass", "sun.org.mozilla.javascript.internal.NativeJavaTopPackage", "JavaAdapter", "sun.org.mozilla.javascript.internal.JavaAdapter", "JavaImporter", "sun.org.mozilla.javascript.internal.ImporterTopLevel", "Continuation", "sun.org.mozilla.javascript.internal.NativeContinuation", "XML", "(xml)", "XMLList", "(xml)", "Namespace", "(xml)", "QName", "(xml)"};
    public static Locale ROOT_LOCALE = new Locale("");
    private static final Object LIBRARY_SCOPE_KEY = "LIBRARY_SCOPE";
    public static final double NaN = Double.longBitsToDouble(9221120237041090560L);
    public static final double negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);
    public static final Double NaNobj = new Double(NaN);
    private static final boolean MSJVM_BUG_WORKAROUNDS = true;
    private static final String DEFAULT_NS_TAG = "__default_namespace__";
    public static final int ENUMERATE_KEYS = 0;
    public static final int ENUMERATE_VALUES = 1;
    public static final int ENUMERATE_ARRAY = 2;
    public static final int ENUMERATE_KEYS_NO_ITERATOR = 3;
    public static final int ENUMERATE_VALUES_NO_ITERATOR = 4;
    public static final int ENUMERATE_ARRAY_NO_ITERATOR = 5;
    public static MessageProvider messageProvider = new DefaultMessageProvider();
    public static final Object[] emptyArgs = new Object[0];
    public static final String[] emptyStrings = new String[0];

    protected ScriptRuntime() {
    }

    public static BaseFunction typeErrorThrower() {
        if (THROW_TYPE_ERROR == null) {
            BaseFunction baseFunction = new BaseFunction(){

                @Override
                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    throw ScriptRuntime.typeError0("msg.op.not.allowed");
                }

                @Override
                public int getLength() {
                    return 0;
                }
            };
            baseFunction.preventExtensions();
            THROW_TYPE_ERROR = baseFunction;
        }
        return THROW_TYPE_ERROR;
    }

    public static boolean isRhinoRuntimeType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz != Character.TYPE;
        }
        return clazz == StringClass || clazz == BooleanClass || NumberClass.isAssignableFrom(clazz) || ScriptableClass.isAssignableFrom(clazz);
    }

    public static ScriptableObject initStandardObjects(Context context, ScriptableObject scriptableObject, boolean bl) {
        if (scriptableObject == null) {
            scriptableObject = new NativeObject();
        }
        scriptableObject.associateValue(LIBRARY_SCOPE_KEY, scriptableObject);
        new ClassCache().associate(scriptableObject);
        BaseFunction.init(scriptableObject, bl);
        NativeObject.init(scriptableObject, bl);
        Scriptable scriptable = ScriptableObject.getObjectPrototype(scriptableObject);
        Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptableObject);
        scriptable2.setPrototype(scriptable);
        if (scriptableObject.getPrototype() == null) {
            scriptableObject.setPrototype(scriptable);
        }
        NativeError.init(scriptableObject, bl);
        NativeGlobal.init(context, scriptableObject, bl);
        NativeArray.init(scriptableObject, bl);
        if (context.getOptimizationLevel() > 0) {
            NativeArray.setMaximumInitialCapacity(200000);
        }
        NativeString.init(scriptableObject, bl);
        NativeBoolean.init(scriptableObject, bl);
        NativeNumber.init(scriptableObject, bl);
        NativeDate.init(context, scriptableObject, bl);
        NativeMath.init(scriptableObject, bl);
        NativeJSON.init(scriptableObject, bl);
        NativeWith.init(scriptableObject, bl);
        NativeCall.init(scriptableObject, bl);
        NativeScript.init(scriptableObject, bl);
        NativeIterator.init(scriptableObject, bl);
        boolean bl2 = context.hasFeature(6) && context.getE4xImplementationFactory() != null;
        for (int i = 0; i != lazilyNames.length; i += 2) {
            String string = lazilyNames[i];
            String string2 = lazilyNames[i + 1];
            if (!bl2 && string2.equals("(xml)")) continue;
            if (bl2 && string2.equals("(xml)")) {
                string2 = context.getE4xImplementationFactory().getImplementationClassName();
            }
            new LazilyLoadedCtor(scriptableObject, string, string2, bl, true);
        }
        return scriptableObject;
    }

    public static ScriptableObject getLibraryScopeOrNull(Scriptable scriptable) {
        ScriptableObject scriptableObject = (ScriptableObject)ScriptableObject.getTopScopeValue(scriptable, LIBRARY_SCOPE_KEY);
        return scriptableObject;
    }

    public static boolean isJSLineTerminator(int n) {
        if ((n & 0xDFD0) != 0) {
            return false;
        }
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    public static boolean isJSWhitespaceOrLineTerminator(int n) {
        return ScriptRuntime.isStrWhiteSpaceChar(n) || ScriptRuntime.isJSLineTerminator(n);
    }

    static boolean isStrWhiteSpaceChar(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: 
            case 160: 
            case 8232: 
            case 8233: 
            case 65279: {
                return true;
            }
        }
        return Character.getType(n) == 12;
    }

    public static Boolean wrapBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Integer wrapInt(int n) {
        return n;
    }

    public static Number wrapNumber(double d) {
        if (d != d) {
            return NaNobj;
        }
        return new Double(d);
    }

    public static boolean toBoolean(Object object) {
        block6: {
            do {
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
                if (object == null || object == Undefined.instance) {
                    return false;
                }
                if (object instanceof String) {
                    return ((String)object).length() != 0;
                }
                if (object instanceof Number) {
                    double d = ((Number)object).doubleValue();
                    return d == d && d != 0.0;
                }
                if (!(object instanceof Scriptable)) break block6;
                if (object instanceof ScriptableObject && ((ScriptableObject)object).avoidObjectDetection()) {
                    return false;
                }
                if (!Context.getContext().isVersionECMA1()) continue;
                return true;
            } while (!((object = ((Scriptable)object).getDefaultValue(BooleanClass)) instanceof Scriptable));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return true;
    }

    public static double toNumber(Object object) {
        block6: {
            do {
                if (object instanceof Number) {
                    return ((Number)object).doubleValue();
                }
                if (object == null) {
                    return 0.0;
                }
                if (object == Undefined.instance) {
                    return NaN;
                }
                if (object instanceof String) {
                    return ScriptRuntime.toNumber((String)object);
                }
                if (object instanceof Boolean) {
                    return (Boolean)object != false ? 1.0 : 0.0;
                }
                if (!(object instanceof Scriptable)) break block6;
            } while (!((object = ((Scriptable)object).getDefaultValue(NumberClass)) instanceof Scriptable));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return NaN;
    }

    public static double toNumber(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toNumber(objectArray[n]) : NaN;
    }

    static double stringToNumber(String string, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 57;
        int n7 = 97;
        int n8 = 65;
        int n9 = string.length();
        if (n2 < 10) {
            n6 = (char)(48 + n2 - 1);
        }
        if (n2 > 10) {
            n7 = (char)(97 + n2 - 10);
            n8 = (char)(65 + n2 - 10);
        }
        double d = 0.0;
        for (n5 = n; n5 < n9; ++n5) {
            n4 = string.charAt(n5);
            if (48 <= n4 && n4 <= n6) {
                n3 = n4 - 48;
            } else if (97 <= n4 && n4 < n7) {
                n3 = n4 - 97 + 10;
            } else {
                if (65 > n4 || n4 >= n8) break;
                n3 = n4 - 65 + 10;
            }
            d = d * (double)n2 + (double)n3;
        }
        if (n == n5) {
            return NaN;
        }
        if (d >= 9.007199254740992E15) {
            if (n2 == 10) {
                try {
                    return Double.valueOf(string.substring(n, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    return NaN;
                }
            }
            if (n2 == 2 || n2 == 4 || n2 == 8 || n2 == 16 || n2 == 32) {
                n4 = 1;
                n3 = 0;
                int n10 = 0;
                int n11 = 53;
                double d2 = 0.0;
                boolean bl = false;
                boolean bl2 = false;
                while (true) {
                    if (n4 == 1) {
                        if (n == n5) break;
                        n3 = 48 <= (n3 = (int)string.charAt(n++)) && n3 <= 57 ? (n3 -= 48) : (97 <= n3 && n3 <= 122 ? (n3 -= 87) : (n3 -= 55));
                        n4 = n2;
                    }
                    boolean bl3 = (n3 & (n4 >>= 1)) != 0;
                    switch (n10) {
                        case 0: {
                            if (!bl3) break;
                            --n11;
                            d = 1.0;
                            n10 = 1;
                            break;
                        }
                        case 1: {
                            d *= 2.0;
                            if (bl3) {
                                d += 1.0;
                            }
                            if (--n11 != 0) break;
                            bl = bl3;
                            n10 = 2;
                            break;
                        }
                        case 2: {
                            bl2 = bl3;
                            d2 = 2.0;
                            n10 = 3;
                            break;
                        }
                        case 3: {
                            if (bl3) {
                                n10 = 4;
                            }
                        }
                        case 4: {
                            d2 *= 2.0;
                        }
                    }
                }
                switch (n10) {
                    case 0: {
                        d = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bl2 & bl) {
                            d += 1.0;
                        }
                        d *= d2;
                        break;
                    }
                    case 4: {
                        if (bl2) {
                            d += 1.0;
                        }
                        d *= d2;
                    }
                }
            }
        }
        return d;
    }

    public static double toNumber(String string) {
        char c;
        int n;
        char c2;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            if (n3 == n2) {
                return 0.0;
            }
            c2 = string.charAt(n3);
            if (!ScriptRuntime.isStrWhiteSpaceChar(c2)) break;
            ++n3;
        }
        if (c2 == '0') {
            if (n3 + 2 < n2 && ((n = (int)string.charAt(n3 + 1)) == 120 || n == 88)) {
                return ScriptRuntime.stringToNumber(string, n3 + 2, 16);
            }
        } else if (!(c2 != '+' && c2 != '-' || n3 + 3 >= n2 || string.charAt(n3 + 1) != '0' || (n = (int)string.charAt(n3 + 2)) != 120 && n != 88)) {
            double d = ScriptRuntime.stringToNumber(string, n3 + 3, 16);
            return c2 == '-' ? -d : d;
        }
        n = n2 - 1;
        while (ScriptRuntime.isStrWhiteSpaceChar(c = string.charAt(n))) {
            --n;
        }
        if (c == 'y') {
            if (c2 == '+' || c2 == '-') {
                ++n3;
            }
            if (n3 + 7 == n && string.regionMatches(n3, "Infinity", 0, 8)) {
                return c2 == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return NaN;
        }
        String string2 = string.substring(n3, n + 1);
        for (int i = string2.length() - 1; i >= 0; --i) {
            char c3 = string2.charAt(i);
            if ('0' <= c3 && c3 <= '9' || c3 == '.' || c3 == 'e' || c3 == 'E' || c3 == '+' || c3 == '-') continue;
            return NaN;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return NaN;
        }
    }

    public static Object[] padArguments(Object[] objectArray, int n) {
        int n2;
        if (n < objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        while (n2 < n) {
            objectArray2[n2] = Undefined.instance;
            ++n2;
        }
        return objectArray2;
    }

    public static String escapeString(String string) {
        return ScriptRuntime.escapeString(string, '\"');
    }

    public static String escapeString(String string, char c) {
        if (c != '\"' && c != '\'') {
            Kit.codeBug();
        }
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            int n2;
            char c2 = string.charAt(i);
            if (' ' <= c2 && c2 <= '~' && c2 != c && c2 != '\\') {
                if (stringBuffer == null) continue;
                stringBuffer.append(c2);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append(string);
                stringBuffer.setLength(i);
            }
            int n3 = -1;
            switch (c2) {
                case '\b': {
                    n3 = 98;
                    break;
                }
                case '\f': {
                    n3 = 102;
                    break;
                }
                case '\n': {
                    n3 = 110;
                    break;
                }
                case '\r': {
                    n3 = 114;
                    break;
                }
                case '\t': {
                    n3 = 116;
                    break;
                }
                case '\u000b': {
                    n3 = 118;
                    break;
                }
                case ' ': {
                    n3 = 32;
                    break;
                }
                case '\\': {
                    n3 = 92;
                }
            }
            if (n3 >= 0) {
                stringBuffer.append('\\');
                stringBuffer.append((char)n3);
                continue;
            }
            if (c2 == c) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (c2 < '\u0100') {
                stringBuffer.append("\\x");
                n2 = 2;
            } else {
                stringBuffer.append("\\u");
                n2 = 4;
            }
            for (int j = (n2 - 1) * 4; j >= 0; j -= 4) {
                int n4 = 0xF & c2 >> j;
                int n5 = n4 < 10 ? 48 + n4 : 87 + n4;
                stringBuffer.append((char)n5);
            }
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    static boolean isValidIdentifierName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i != n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return !TokenStream.isKeyword(string);
    }

    public static String toString(Object object) {
        block5: {
            do {
                if (object == null) {
                    return "null";
                }
                if (object == Undefined.instance) {
                    return "undefined";
                }
                if (object instanceof String) {
                    return (String)object;
                }
                if (object instanceof Number) {
                    return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
                }
                if (!(object instanceof Scriptable)) break block5;
            } while (!((object = ((Scriptable)object).getDefaultValue(StringClass)) instanceof Scriptable));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        return object.toString();
    }

    static String defaultObjectToString(Scriptable scriptable) {
        return "[object " + scriptable.getClassName() + ']';
    }

    public static String toString(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toString(objectArray[n]) : "undefined";
    }

    public static String toString(double d) {
        return ScriptRuntime.numberToString(d, 10);
    }

    public static String numberToString(double d, int n) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(n));
        }
        if (n != 10) {
            return DToA.JS_dtobasestr(n, d);
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, 0, 0, d);
        return stringBuffer.toString();
    }

    static String uneval(Context context, Scriptable scriptable, Object object) {
        if (object == null) {
            return "null";
        }
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object instanceof String) {
            String string = ScriptRuntime.escapeString((String)object);
            StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d == 0.0 && 1.0 / d < 0.0) {
                return "-0";
            }
            return ScriptRuntime.toString(d);
        }
        if (object instanceof Boolean) {
            return ScriptRuntime.toString(object);
        }
        if (object instanceof Scriptable) {
            Object object2;
            Scriptable scriptable2 = (Scriptable)object;
            if (ScriptableObject.hasProperty(scriptable2, "toSource") && (object2 = ScriptableObject.getProperty(scriptable2, "toSource")) instanceof Function) {
                Function function = (Function)object2;
                return ScriptRuntime.toString(function.call(context, scriptable, scriptable2, emptyArgs));
            }
            return ScriptRuntime.toString(object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String defaultObjectToSource(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        boolean bl;
        boolean bl2;
        if (context.iterating == null) {
            bl2 = true;
            bl = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl2 = false;
            bl = context.iterating.has(scriptable2);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        if (bl2) {
            stringBuffer.append("(");
        }
        stringBuffer.append('{');
        try {
            if (!bl) {
                context.iterating.intern(scriptable2);
                Object[] objectArray2 = scriptable2.getIds();
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object;
                    Object object2 = objectArray2[i];
                    if (object2 instanceof Integer) {
                        int n = (Integer)object2;
                        object = scriptable2.get(n, scriptable2);
                        if (object == Scriptable.NOT_FOUND) continue;
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(n);
                    } else {
                        String string = (String)object2;
                        object = scriptable2.get(string, scriptable2);
                        if (object == Scriptable.NOT_FOUND) continue;
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        if (ScriptRuntime.isValidIdentifierName(string)) {
                            stringBuffer.append(string);
                        } else {
                            stringBuffer.append('\'');
                            stringBuffer.append(ScriptRuntime.escapeString(string, '\''));
                            stringBuffer.append('\'');
                        }
                    }
                    stringBuffer.append(':');
                    stringBuffer.append(ScriptRuntime.uneval(context, scriptable, object));
                }
            }
        }
        finally {
            if (bl2) {
                context.iterating = null;
            }
        }
        stringBuffer.append('}');
        if (bl2) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static Scriptable toObject(Scriptable scriptable, Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object);
    }

    public static Scriptable toObjectOrNull(Context context, Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object != null && object != Undefined.instance) {
            return ScriptRuntime.toObject(context, ScriptRuntime.getTopCallScope(context), object);
        }
        return null;
    }

    public static Scriptable toObjectOrNull(Context context, Object object, Scriptable scriptable) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object != null && object != Undefined.instance) {
            return ScriptRuntime.toObject(context, scriptable, object);
        }
        return null;
    }

    public static Scriptable toObject(Scriptable scriptable, Object object, Class<?> clazz) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object);
    }

    public static Scriptable toObject(Context context, Scriptable scriptable, Object object) {
        String string;
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object == null) {
            throw ScriptRuntime.typeError0("msg.null.to.object");
        }
        if (object == Undefined.instance) {
            throw ScriptRuntime.typeError0("msg.undef.to.object");
        }
        String string2 = object instanceof String ? "String" : (object instanceof Number ? "Number" : (string = object instanceof Boolean ? "Boolean" : null));
        if (string != null) {
            Object[] objectArray = new Object[]{object};
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
            return ScriptRuntime.newObject(context, scriptable, string, objectArray);
        }
        Object object2 = context.getWrapFactory().wrap(context, scriptable, object, null);
        if (object2 instanceof Scriptable) {
            return (Scriptable)object2;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static Scriptable toObject(Context context, Scriptable scriptable, Object object, Class<?> clazz) {
        return ScriptRuntime.toObject(context, scriptable, object);
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable) {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(ScriptRuntime.toString(object));
        }
        Function function = (Function)object;
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object2);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefCallError(scriptable2, "function");
        }
        return function.call(context, scriptable, scriptable2, objectArray);
    }

    public static Scriptable newObject(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(context, scriptable, string);
        if (objectArray == null) {
            objectArray = emptyArgs;
        }
        return function.construct(context, scriptable, objectArray);
    }

    public static double toInteger(Object object) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(object));
    }

    public static double toInteger(double d) {
        if (d != d) {
            return 0.0;
        }
        if (d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInteger(objectArray[n]) : 0.0;
    }

    public static int toInt32(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ScriptRuntime.toInt32(ScriptRuntime.toNumber(object));
    }

    public static int toInt32(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInt32(objectArray[n]) : 0;
    }

    public static int toInt32(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double d2 = 4.294967296E9;
        d = Math.IEEEremainder(d, d2);
        long l = (long)d;
        return (int)l;
    }

    public static long toUint32(double d) {
        long l = (long)d;
        if ((double)l == d) {
            return l & 0xFFFFFFFFL;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0L;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double d2 = 4.294967296E9;
        l = (long)Math.IEEEremainder(d, d2);
        return l & 0xFFFFFFFFL;
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(object));
    }

    public static char toUint16(Object object) {
        double d = ScriptRuntime.toNumber(object);
        int n = (int)d;
        if ((double)n == d) {
            return (char)n;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return '\u0000';
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        int n2 = 65536;
        n = (int)Math.IEEEremainder(d, n2);
        return (char)n;
    }

    public static Object setDefaultNamespace(Object object, Context context) {
        Scriptable scriptable = context.currentActivationCall;
        if (scriptable == null) {
            scriptable = ScriptRuntime.getTopCallScope(context);
        }
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        Object object2 = xMLLib.toDefaultXmlNamespace(context, object);
        if (!scriptable.has(DEFAULT_NS_TAG, scriptable)) {
            ScriptableObject.defineProperty(scriptable, DEFAULT_NS_TAG, object2, 6);
        } else {
            scriptable.put(DEFAULT_NS_TAG, scriptable, object2);
        }
        return Undefined.instance;
    }

    public static Object searchDefaultNamespace(Context context) {
        Object object;
        Scriptable scriptable = context.currentActivationCall;
        if (scriptable == null) {
            scriptable = ScriptRuntime.getTopCallScope(context);
        }
        while (true) {
            Scriptable scriptable2;
            if ((scriptable2 = scriptable.getParentScope()) == null) {
                object = ScriptableObject.getProperty(scriptable, DEFAULT_NS_TAG);
                if (object != Scriptable.NOT_FOUND) break;
                return null;
            }
            object = scriptable.get(DEFAULT_NS_TAG, scriptable);
            if (object != Scriptable.NOT_FOUND) break;
            scriptable = scriptable2;
        }
        return object;
    }

    public static Object getTopLevelProp(Scriptable scriptable, String string) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return ScriptableObject.getProperty(scriptable, string);
    }

    static Function getExistingCtor(Context context, Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object instanceof Function) {
            return (Function)object;
        }
        if (object == Scriptable.NOT_FOUND) {
            throw Context.reportRuntimeError1("msg.ctor.not.found", string);
        }
        throw Context.reportRuntimeError1("msg.not.ctor", string);
    }

    private static long indexFromString(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = 0;
            boolean bl = false;
            int n3 = string.charAt(0);
            if (n3 == 45 && n > 1) {
                n3 = string.charAt(1);
                n2 = 1;
                bl = true;
            }
            if (0 <= (n3 -= 48) && n3 <= 9 && n <= (bl ? 11 : 10)) {
                int n4 = -n3;
                int n5 = 0;
                ++n2;
                if (n4 != 0) {
                    while (n2 != n && 0 <= (n3 = string.charAt(n2) - 48) && n3 <= 9) {
                        n5 = n4;
                        n4 = 10 * n4 - n3;
                        ++n2;
                    }
                }
                if (n2 == n && (n5 > -214748364 || n5 == -214748364 && n3 <= (bl ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(bl ? n4 : -n4);
                }
            }
        }
        return -1L;
    }

    public static long testUint32String(String string) {
        int n = string.length();
        if (1 <= n && n <= 10) {
            int n2 = string.charAt(0);
            if ((n2 -= 48) == 0) {
                return n == 1 ? 0L : -1L;
            }
            if (1 <= n2 && n2 <= 9) {
                long l = n2;
                for (int i = 1; i != n; ++i) {
                    n2 = string.charAt(i) - 48;
                    if (0 > n2 || n2 > 9) {
                        return -1L;
                    }
                    l = 10L * l + (long)n2;
                }
                if (l >>> 32 == 0L) {
                    return l;
                }
            }
        }
        return -1L;
    }

    static Object getIndexObject(String string) {
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L) {
            return (int)l;
        }
        return string;
    }

    static Object getIndexObject(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        return ScriptRuntime.toString(d);
    }

    static String toStringIdOrIndex(Context context, Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                ScriptRuntime.storeIndexResult(context, n);
                return null;
            }
            return ScriptRuntime.toString(object);
        }
        String string = object instanceof String ? (String)object : ScriptRuntime.toString(object);
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L) {
            ScriptRuntime.storeIndexResult(context, (int)l);
            return null;
        }
        return string;
    }

    public static Object getObjectElem(Object object, Object object2, Context context) {
        return ScriptRuntime.getObjectElem(object, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectElem(Object object, Object object2, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, object2);
        }
        return ScriptRuntime.getObjectElem(scriptable2, object2, context);
    }

    public static Object getObjectElem(Scriptable scriptable, Object object, Context context) {
        Object object2;
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            return xMLObject.ecmaGet(context, object);
        }
        String string = ScriptRuntime.toStringIdOrIndex(context, object);
        if (string == null) {
            int n = ScriptRuntime.lastIndexResult(context);
            object2 = ScriptableObject.getProperty(scriptable, n);
        } else {
            object2 = ScriptableObject.getProperty(scriptable, string);
        }
        if (object2 == Scriptable.NOT_FOUND) {
            object2 = Undefined.instance;
        }
        return object2;
    }

    public static Object getObjectProp(Object object, String string, Context context) {
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        return ScriptRuntime.getObjectProp(scriptable, string, context);
    }

    public static Object getObjectProp(Object object, String string, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        return ScriptRuntime.getObjectProp(scriptable2, string, context);
    }

    public static Object getObjectProp(Scriptable scriptable, String string, Context context) {
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            return xMLObject.ecmaGet(context, string);
        }
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            if (context.hasFeature(11)) {
                Context.reportWarning(ScriptRuntime.getMessage1("msg.ref.undefined.prop", string));
            }
            object = Undefined.instance;
        }
        return object;
    }

    public static Object getObjectPropNoWarn(Object object, String string, Context context) {
        Object object2;
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        if (object instanceof XMLObject) {
            ScriptRuntime.getObjectProp(scriptable, string, context);
        }
        if ((object2 = ScriptableObject.getProperty(scriptable, string)) == Scriptable.NOT_FOUND) {
            return Undefined.instance;
        }
        return object2;
    }

    public static Object getObjectIndex(Object object, double d, Context context) {
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefReadError(object, ScriptRuntime.toString(d));
        }
        int n = (int)d;
        if ((double)n == d) {
            return ScriptRuntime.getObjectIndex(scriptable, n, context);
        }
        String string = ScriptRuntime.toString(d);
        return ScriptRuntime.getObjectProp(scriptable, string, context);
    }

    public static Object getObjectIndex(Scriptable scriptable, int n, Context context) {
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            return xMLObject.ecmaGet(context, n);
        }
        Object object = ScriptableObject.getProperty(scriptable, n);
        if (object == Scriptable.NOT_FOUND) {
            object = Undefined.instance;
        }
        return object;
    }

    public static Object setObjectElem(Object object, Object object2, Object object3, Context context) {
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefWriteError(object, object2, object3);
        }
        return ScriptRuntime.setObjectElem(scriptable, object2, object3, context);
    }

    public static Object setObjectElem(Scriptable scriptable, Object object, Object object2, Context context) {
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            xMLObject.ecmaPut(context, object, object2);
            return object2;
        }
        String string = ScriptRuntime.toStringIdOrIndex(context, object);
        if (string == null) {
            int n = ScriptRuntime.lastIndexResult(context);
            ScriptableObject.putProperty(scriptable, n, object2);
        } else {
            ScriptableObject.putProperty(scriptable, string, object2);
        }
        return object2;
    }

    public static Object setObjectProp(Object object, String string, Object object2, Context context) {
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefWriteError(object, string, object2);
        }
        return ScriptRuntime.setObjectProp(scriptable, string, object2, context);
    }

    public static Object setObjectProp(Scriptable scriptable, String string, Object object, Context context) {
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            xMLObject.ecmaPut(context, string, object);
        } else {
            ScriptableObject.putProperty(scriptable, string, object);
        }
        return object;
    }

    public static Object setObjectIndex(Object object, double d, Object object2, Context context) {
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefWriteError(object, String.valueOf(d), object2);
        }
        int n = (int)d;
        if ((double)n == d) {
            return ScriptRuntime.setObjectIndex(scriptable, n, object2, context);
        }
        String string = ScriptRuntime.toString(d);
        return ScriptRuntime.setObjectProp(scriptable, string, object2, context);
    }

    public static Object setObjectIndex(Scriptable scriptable, int n, Object object, Context context) {
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            xMLObject.ecmaPut(context, n, object);
        } else {
            ScriptableObject.putProperty(scriptable, n, object);
        }
        return object;
    }

    public static boolean deleteObjectElem(Scriptable scriptable, Object object, Context context) {
        if (!(scriptable instanceof XMLObject)) {
            String string = ScriptRuntime.toStringIdOrIndex(context, object);
            if (string == null) {
                int n = ScriptRuntime.lastIndexResult(context);
                scriptable.delete(n);
                return !scriptable.has(n, scriptable);
            }
            scriptable.delete(string);
            return !scriptable.has(string, scriptable);
        }
        XMLObject xMLObject = (XMLObject)scriptable;
        boolean bl = xMLObject.ecmaDelete(context, object);
        return bl;
    }

    public static boolean hasObjectElem(Scriptable scriptable, Object object, Context context) {
        boolean bl;
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            bl = xMLObject.ecmaHas(context, object);
        } else {
            String string = ScriptRuntime.toStringIdOrIndex(context, object);
            if (string == null) {
                int n = ScriptRuntime.lastIndexResult(context);
                bl = ScriptableObject.hasProperty(scriptable, n);
            } else {
                bl = ScriptableObject.hasProperty(scriptable, string);
            }
        }
        return bl;
    }

    public static Object refGet(Ref ref, Context context) {
        return ref.get(context);
    }

    public static Object refSet(Ref ref, Object object, Context context) {
        return ref.set(context, object);
    }

    public static Object refDel(Ref ref, Context context) {
        return ScriptRuntime.wrapBoolean(ref.delete(context));
    }

    static boolean isSpecialProperty(String string) {
        return string.equals("__proto__") || string.equals("__parent__");
    }

    public static Ref specialRef(Object object, String string, Context context) {
        return SpecialRef.createSpecial(context, object, string);
    }

    public static Object delete(Object object, Object object2, Context context) {
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            String string = object2 == null ? "null" : object2.toString();
            throw ScriptRuntime.typeError2("msg.undef.prop.delete", ScriptRuntime.toString(object), string);
        }
        boolean bl = ScriptRuntime.deleteObjectElem(scriptable, object2, context);
        return ScriptRuntime.wrapBoolean(bl);
    }

    public static Object name(Context context, Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable.getParentScope();
        if (scriptable2 == null) {
            Object object = ScriptRuntime.topScopeName(context, scriptable, string);
            if (object == Scriptable.NOT_FOUND) {
                throw ScriptRuntime.notFoundError(scriptable, string);
            }
            return object;
        }
        return ScriptRuntime.nameOrFunction(context, scriptable, scriptable2, string, false);
    }

    private static Object nameOrFunction(Context context, Scriptable scriptable, Scriptable scriptable2, String string, boolean bl) {
        Object object;
        Scriptable scriptable3;
        block17: {
            scriptable3 = scriptable;
            XMLObject xMLObject = null;
            do {
                if (scriptable instanceof NativeWith) {
                    Scriptable scriptable4 = scriptable.getPrototype();
                    if (scriptable4 instanceof XMLObject) {
                        XMLObject xMLObject2 = (XMLObject)scriptable4;
                        if (xMLObject2.ecmaHas(context, string)) {
                            scriptable3 = xMLObject2;
                            object = xMLObject2.ecmaGet(context, string);
                            break block17;
                        }
                        if (xMLObject == null) {
                            xMLObject = xMLObject2;
                        }
                    } else {
                        object = ScriptableObject.getProperty(scriptable4, string);
                        if (object != Scriptable.NOT_FOUND) {
                            scriptable3 = scriptable4;
                            break block17;
                        }
                    }
                } else if (scriptable instanceof NativeCall) {
                    object = scriptable.get(string, scriptable);
                    if (object != Scriptable.NOT_FOUND) {
                        if (bl) {
                            scriptable3 = ScriptableObject.getTopLevelScope(scriptable2);
                        }
                        break block17;
                    }
                } else {
                    object = ScriptableObject.getProperty(scriptable, string);
                    if (object != Scriptable.NOT_FOUND) {
                        scriptable3 = scriptable;
                        break block17;
                    }
                }
                scriptable = scriptable2;
            } while ((scriptable2 = scriptable2.getParentScope()) != null);
            object = ScriptRuntime.topScopeName(context, scriptable, string);
            if (object == Scriptable.NOT_FOUND) {
                if (xMLObject == null || bl) {
                    throw ScriptRuntime.notFoundError(scriptable, string);
                }
                object = xMLObject.ecmaGet(context, string);
            }
            scriptable3 = scriptable;
        }
        if (bl) {
            if (!(object instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(object, string);
            }
            ScriptRuntime.storeScriptable(context, scriptable3);
        }
        return object;
    }

    private static Object topScopeName(Context context, Scriptable scriptable, String string) {
        if (context.useDynamicScope) {
            scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
        }
        return ScriptableObject.getProperty(scriptable, string);
    }

    public static Scriptable bind(Context context, Scriptable scriptable, String string) {
        XMLObject xMLObject;
        block11: {
            xMLObject = null;
            Scriptable scriptable2 = scriptable.getParentScope();
            if (scriptable2 != null) {
                while (scriptable instanceof NativeWith) {
                    Scriptable scriptable3 = scriptable.getPrototype();
                    if (scriptable3 instanceof XMLObject) {
                        XMLObject xMLObject2 = (XMLObject)scriptable3;
                        if (xMLObject2.ecmaHas(context, string)) {
                            return xMLObject2;
                        }
                        if (xMLObject == null) {
                            xMLObject = xMLObject2;
                        }
                    } else if (ScriptableObject.hasProperty(scriptable3, string)) {
                        return scriptable3;
                    }
                    scriptable = scriptable2;
                    if ((scriptable2 = scriptable2.getParentScope()) != null) continue;
                    break block11;
                }
                do {
                    if (ScriptableObject.hasProperty(scriptable, string)) {
                        return scriptable;
                    }
                    scriptable = scriptable2;
                } while ((scriptable2 = scriptable2.getParentScope()) != null);
            }
        }
        if (context.useDynamicScope) {
            scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
        }
        if (ScriptableObject.hasProperty(scriptable, string)) {
            return scriptable;
        }
        return xMLObject;
    }

    public static Object setName(Scriptable scriptable, Object object, Context context, Scriptable scriptable2, String string) {
        if (scriptable != null) {
            if (scriptable instanceof XMLObject) {
                XMLObject xMLObject = (XMLObject)scriptable;
                xMLObject.ecmaPut(context, string, object);
            } else {
                ScriptableObject.putProperty(scriptable, string, object);
            }
        } else {
            if (context.hasFeature(11) || context.hasFeature(8)) {
                Context.reportWarning(ScriptRuntime.getMessage1("msg.assn.create.strict", string));
            }
            scriptable = ScriptableObject.getTopLevelScope(scriptable2);
            if (context.useDynamicScope) {
                scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
            }
            scriptable.put(string, scriptable, object);
        }
        return object;
    }

    public static Object strictSetName(Scriptable scriptable, Object object, Context context, Scriptable scriptable2, String string) {
        if (scriptable != null) {
            if (scriptable instanceof XMLObject) {
                XMLObject xMLObject = (XMLObject)scriptable;
                xMLObject.ecmaPut(context, string, object);
            } else {
                ScriptableObject.putProperty(scriptable, string, object);
            }
        } else {
            int[] nArray = new int[1];
            String string2 = Context.getSourcePositionFromStack(nArray);
            throw new JavaScriptException(context.newObject(scriptable2, "ReferenceError", new Object[]{string}), string2, nArray[0]);
        }
        return object;
    }

    public static Object setConst(Scriptable scriptable, Object object, Context context, String string) {
        if (scriptable instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable;
            xMLObject.ecmaPut(context, string, object);
        } else {
            ScriptableObject.putConstProperty(scriptable, string, object);
        }
        return object;
    }

    public static Scriptable toIterator(Context context, Scriptable scriptable, Scriptable scriptable2, boolean bl) {
        if (ScriptableObject.hasProperty(scriptable2, "__iterator__")) {
            Object object = ScriptableObject.getProperty(scriptable2, "__iterator__");
            if (!(object instanceof Callable)) {
                throw ScriptRuntime.typeError0("msg.invalid.iterator");
            }
            Callable callable = (Callable)object;
            Object[] objectArray = new Object[]{bl ? Boolean.TRUE : Boolean.FALSE};
            object = callable.call(context, scriptable, scriptable2, objectArray);
            if (!(object instanceof Scriptable)) {
                throw ScriptRuntime.typeError0("msg.iterator.primitive");
            }
            return (Scriptable)object;
        }
        return null;
    }

    public static Object enumInit(Object object, Context context, boolean bl) {
        return ScriptRuntime.enumInit(object, context, bl ? 1 : 0);
    }

    public static Object enumInit(Object object, Context context, int n) {
        IdEnumeration idEnumeration = new IdEnumeration();
        idEnumeration.obj = ScriptRuntime.toObjectOrNull(context, object);
        if (idEnumeration.obj == null) {
            return idEnumeration;
        }
        idEnumeration.enumType = n;
        idEnumeration.iterator = null;
        if (n != 3 && n != 4 && n != 5) {
            idEnumeration.iterator = ScriptRuntime.toIterator(context, idEnumeration.obj.getParentScope(), idEnumeration.obj, n == 0);
        }
        if (idEnumeration.iterator == null) {
            ScriptRuntime.enumChangeObject(idEnumeration);
        }
        return idEnumeration;
    }

    public static void setEnumNumbers(Object object, boolean bl) {
        ((IdEnumeration)object).enumNumbers = bl;
    }

    public static Boolean enumNext(Object object) {
        block9: {
            int n;
            IdEnumeration idEnumeration = (IdEnumeration)object;
            if (idEnumeration.iterator != null) {
                Object object2 = ScriptableObject.getProperty(idEnumeration.iterator, "next");
                if (!(object2 instanceof Callable)) {
                    return Boolean.FALSE;
                }
                Callable callable = (Callable)object2;
                Context context = Context.getContext();
                try {
                    idEnumeration.currentId = callable.call(context, idEnumeration.iterator.getParentScope(), idEnumeration.iterator, emptyArgs);
                    return Boolean.TRUE;
                }
                catch (JavaScriptException javaScriptException) {
                    if (javaScriptException.getValue() instanceof NativeIterator.StopIteration) {
                        return Boolean.FALSE;
                    }
                    throw javaScriptException;
                }
            }
            while (true) {
                if (idEnumeration.obj == null) {
                    return Boolean.FALSE;
                }
                if (idEnumeration.index == idEnumeration.ids.length) {
                    idEnumeration.obj = idEnumeration.obj.getPrototype();
                    ScriptRuntime.enumChangeObject(idEnumeration);
                    continue;
                }
                Object object3 = idEnumeration.ids[idEnumeration.index++];
                if (idEnumeration.used != null && idEnumeration.used.has(object3)) continue;
                if (object3 instanceof String) {
                    String string = (String)object3;
                    if (!idEnumeration.obj.has(string, idEnumeration.obj)) continue;
                    idEnumeration.currentId = string;
                    break block9;
                }
                n = ((Number)object3).intValue();
                if (idEnumeration.obj.has(n, idEnumeration.obj)) break;
            }
            idEnumeration.currentId = idEnumeration.enumNumbers ? Integer.valueOf(n) : String.valueOf(n);
        }
        return Boolean.TRUE;
    }

    public static Object enumId(Object object, Context context) {
        IdEnumeration idEnumeration = (IdEnumeration)object;
        if (idEnumeration.iterator != null) {
            return idEnumeration.currentId;
        }
        switch (idEnumeration.enumType) {
            case 0: 
            case 3: {
                return idEnumeration.currentId;
            }
            case 1: 
            case 4: {
                return ScriptRuntime.enumValue(object, context);
            }
            case 2: 
            case 5: {
                Object[] objectArray = new Object[]{idEnumeration.currentId, ScriptRuntime.enumValue(object, context)};
                return context.newArray(ScriptableObject.getTopLevelScope(idEnumeration.obj), objectArray);
            }
        }
        throw Kit.codeBug();
    }

    public static Object enumValue(Object object, Context context) {
        Object object2;
        IdEnumeration idEnumeration = (IdEnumeration)object;
        String string = ScriptRuntime.toStringIdOrIndex(context, idEnumeration.currentId);
        if (string == null) {
            int n = ScriptRuntime.lastIndexResult(context);
            object2 = idEnumeration.obj.get(n, idEnumeration.obj);
        } else {
            object2 = idEnumeration.obj.get(string, idEnumeration.obj);
        }
        return object2;
    }

    private static void enumChangeObject(IdEnumeration idEnumeration) {
        Object[] objectArray = null;
        while (idEnumeration.obj != null && (objectArray = idEnumeration.obj.getIds()).length == 0) {
            idEnumeration.obj = idEnumeration.obj.getPrototype();
        }
        if (idEnumeration.obj != null && idEnumeration.ids != null) {
            Object[] objectArray2 = idEnumeration.ids;
            int n = objectArray2.length;
            if (idEnumeration.used == null) {
                idEnumeration.used = new ObjToIntMap(n);
            }
            for (int i = 0; i != n; ++i) {
                idEnumeration.used.intern(objectArray2[i]);
            }
        }
        idEnumeration.ids = objectArray;
        idEnumeration.index = 0;
    }

    public static Callable getNameFunctionAndThis(String string, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = scriptable.getParentScope();
        if (scriptable2 == null) {
            Object object = ScriptRuntime.topScopeName(context, scriptable, string);
            if (!(object instanceof Callable)) {
                if (object == Scriptable.NOT_FOUND) {
                    throw ScriptRuntime.notFoundError(scriptable, string);
                }
                throw ScriptRuntime.notFunctionError(object, string);
            }
            Scriptable scriptable3 = scriptable;
            ScriptRuntime.storeScriptable(context, scriptable3);
            return (Callable)object;
        }
        return (Callable)ScriptRuntime.nameOrFunction(context, scriptable, scriptable2, string, true);
    }

    public static Callable getElemFunctionAndThis(Object object, Object object2, Context context) {
        XMLObject xMLObject;
        Scriptable scriptable;
        Object object3;
        String string = ScriptRuntime.toStringIdOrIndex(context, object2);
        if (string != null) {
            return ScriptRuntime.getPropFunctionAndThis(object, string, context);
        }
        int n = ScriptRuntime.lastIndexResult(context);
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefCallError(object, String.valueOf(n));
        }
        while ((object3 = ScriptableObject.getProperty(scriptable2, n)) == Scriptable.NOT_FOUND && scriptable2 instanceof XMLObject && (scriptable = (xMLObject = (XMLObject)scriptable2).getExtraMethodSource(context)) != null) {
            scriptable2 = scriptable;
        }
        if (!(object3 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object3, object2);
        }
        ScriptRuntime.storeScriptable(context, scriptable2);
        return (Callable)object3;
    }

    public static Callable getPropFunctionAndThis(Object object, String string, Context context) {
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        return ScriptRuntime.getPropFunctionAndThisHelper(object, string, context, scriptable);
    }

    public static Callable getPropFunctionAndThis(Object object, String string, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        return ScriptRuntime.getPropFunctionAndThisHelper(object, string, context, scriptable2);
    }

    private static Callable getPropFunctionAndThisHelper(Object object, String string, Context context, Scriptable scriptable) {
        Object object2;
        Scriptable scriptable2;
        Object object3;
        if (scriptable == null) {
            throw ScriptRuntime.undefCallError(object, string);
        }
        while ((object3 = ScriptableObject.getProperty(scriptable, string)) == Scriptable.NOT_FOUND && scriptable instanceof XMLObject && (scriptable2 = ((XMLObject)(object2 = (XMLObject)scriptable)).getExtraMethodSource(context)) != null) {
            scriptable = scriptable2;
        }
        if (!(object3 instanceof Callable)) {
            object2 = ScriptableObject.getProperty(scriptable, "__noSuchMethod__");
            if (object2 instanceof Callable) {
                object3 = new NoSuchMethodShim((Callable)object2, string);
            } else {
                throw ScriptRuntime.notFunctionError(scriptable, object3, string);
            }
        }
        ScriptRuntime.storeScriptable(context, scriptable);
        return (Callable)object3;
    }

    public static Callable getValueFunctionAndThis(Object object, Context context) {
        if (!(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Callable callable = (Callable)object;
        Scriptable scriptable = null;
        if (callable instanceof Scriptable) {
            scriptable = ((Scriptable)((Object)callable)).getParentScope();
        }
        if (scriptable == null) {
            if (context.topCallScope == null) {
                throw new IllegalStateException();
            }
            scriptable = context.topCallScope;
        }
        if (scriptable.getParentScope() != null && !(scriptable instanceof NativeWith) && scriptable instanceof NativeCall) {
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
        }
        ScriptRuntime.storeScriptable(context, scriptable);
        return callable;
    }

    public static Ref callRef(Callable callable, Scriptable scriptable, Object[] objectArray, Context context) {
        if (callable instanceof RefCallable) {
            RefCallable refCallable = (RefCallable)callable;
            Ref ref = refCallable.refCall(context, scriptable, objectArray);
            if (ref == null) {
                throw new IllegalStateException(refCallable.getClass().getName() + ".refCall() returned null");
            }
            return ref;
        }
        String string = ScriptRuntime.getMessage1("msg.no.ref.from.function", ScriptRuntime.toString(callable));
        throw ScriptRuntime.constructError("ReferenceError", string);
    }

    public static Scriptable newObject(Object object, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Function function = (Function)object;
        return function.construct(context, scriptable, objectArray);
    }

    public static Object callSpecial(Context context, Callable callable, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, Scriptable scriptable3, int n, String string, int n2) {
        if (n == 1) {
            if (scriptable.getParentScope() == null && NativeGlobal.isEvalFunction(callable)) {
                return ScriptRuntime.evalSpecial(context, scriptable2, scriptable3, objectArray, string, n2);
            }
        } else if (n == 2) {
            if (NativeWith.isWithFunction(callable)) {
                throw Context.reportRuntimeError1("msg.only.from.new", "With");
            }
        } else {
            throw Kit.codeBug();
        }
        return callable.call(context, scriptable2, scriptable, objectArray);
    }

    public static Object newSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable, int n) {
        if (n == 1) {
            if (NativeGlobal.isEvalFunction(object)) {
                throw ScriptRuntime.typeError1("msg.not.ctor", "eval");
            }
        } else if (n == 2) {
            if (NativeWith.isWithFunction(object)) {
                return NativeWith.newWithSpecial(context, scriptable, objectArray);
            }
        } else {
            throw Kit.codeBug();
        }
        return ScriptRuntime.newObject(object, context, scriptable, objectArray);
    }

    public static Object applyOrCall(boolean bl, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object[] objectArray2;
        int n = objectArray.length;
        Callable callable = ScriptRuntime.getCallable(scriptable2);
        Scriptable scriptable3 = null;
        if (n != 0) {
            scriptable3 = ScriptRuntime.toObjectOrNull(context, objectArray[0]);
        }
        if (scriptable3 == null) {
            scriptable3 = ScriptRuntime.getTopCallScope(context);
        }
        if (bl) {
            objectArray2 = n <= 1 ? emptyArgs : ScriptRuntime.getApplyArguments(context, objectArray[1]);
        } else if (n <= 1) {
            objectArray2 = emptyArgs;
        } else {
            objectArray2 = new Object[n - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, n - 1);
        }
        return callable.call(context, scriptable, scriptable3, objectArray2);
    }

    static Object[] getApplyArguments(Context context, Object object) {
        if (object == null || object == Undefined.instance) {
            return emptyArgs;
        }
        if (object instanceof NativeArray || object instanceof Arguments) {
            return context.getElements((Scriptable)object);
        }
        throw ScriptRuntime.typeError0("msg.arg.isnt.array");
    }

    static Callable getCallable(Scriptable scriptable) {
        Callable callable;
        if (scriptable instanceof Callable) {
            callable = (Callable)((Object)scriptable);
        } else {
            Object object = scriptable.getDefaultValue(FunctionClass);
            if (!(object instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(object, scriptable);
            }
            callable = (Callable)object;
        }
        return callable;
    }

    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] objectArray, String string, int n) {
        Object object2;
        if (objectArray.length < 1) {
            return Undefined.instance;
        }
        Object object3 = objectArray[0];
        if (!(object3 instanceof String)) {
            if (context.hasFeature(11) || context.hasFeature(9)) {
                throw Context.reportRuntimeError0("msg.eval.nonstring.strict");
            }
            String string2 = ScriptRuntime.getMessage0("msg.eval.nonstring");
            Context.reportWarning(string2);
            return object3;
        }
        if (string == null) {
            object2 = new int[1];
            string = Context.getSourcePositionFromStack(object2);
            if (string != null) {
                n = object2[0];
            } else {
                string = "";
            }
        }
        object2 = ScriptRuntime.makeUrlForGeneratedScript(true, string, n);
        ErrorReporter errorReporter = DefaultErrorReporter.forEval(context.getErrorReporter());
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator == null) {
            throw new JavaScriptException("Interpreter not present", string, n);
        }
        Script script = context.compileString((String)object3, evaluator, errorReporter, (String)object2, 1, null);
        evaluator.setEvalScriptFlag(script);
        Callable callable = (Callable)((Object)script);
        return callable.call(context, scriptable, (Scriptable)object, emptyArgs);
    }

    public static String typeof(Object object) {
        if (object == null) {
            return "object";
        }
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object instanceof ScriptableObject) {
            return ((ScriptableObject)object).getTypeOf();
        }
        if (object instanceof Scriptable) {
            return object instanceof Callable ? "function" : "object";
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static String typeofName(Scriptable scriptable, String string) {
        Context context = Context.getContext();
        Scriptable scriptable2 = ScriptRuntime.bind(context, scriptable, string);
        if (scriptable2 == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getObjectProp(scriptable2, string, context));
    }

    public static Object add(Object object, Object object2, Context context) {
        Object object3;
        if (object instanceof Number && object2 instanceof Number) {
            return ScriptRuntime.wrapNumber(((Number)object).doubleValue() + ((Number)object2).doubleValue());
        }
        if (object instanceof XMLObject && (object3 = ((XMLObject)object).addValues(context, true, object2)) != Scriptable.NOT_FOUND) {
            return object3;
        }
        if (object2 instanceof XMLObject && (object3 = ((XMLObject)object2).addValues(context, false, object)) != Scriptable.NOT_FOUND) {
            return object3;
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(null);
        }
        if (!(object instanceof String) && !(object2 instanceof String)) {
            if (object instanceof Number && object2 instanceof Number) {
                return ScriptRuntime.wrapNumber(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            return ScriptRuntime.wrapNumber(ScriptRuntime.toNumber(object) + ScriptRuntime.toNumber(object2));
        }
        return ScriptRuntime.toString(object).concat(ScriptRuntime.toString(object2));
    }

    public static String add(String string, Object object) {
        return string.concat(ScriptRuntime.toString(object));
    }

    public static String add(Object object, String string) {
        return ScriptRuntime.toString(object).concat(string);
    }

    public static Object nameIncrDecr(Scriptable scriptable, String string, int n) {
        return ScriptRuntime.nameIncrDecr(scriptable, string, Context.getContext(), n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object nameIncrDecr(Scriptable scriptable, String string, Context context, int n) {
        do {
            if (context.useDynamicScope && scriptable.getParentScope() == null) {
                scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
            }
            Scriptable scriptable2 = scriptable;
            do {
                Object object;
                if ((object = scriptable2.get(string, scriptable)) == Scriptable.NOT_FOUND) continue;
                return ScriptRuntime.doScriptableIncrDecr(scriptable2, string, scriptable, object, n);
            } while ((scriptable2 = scriptable2.getPrototype()) != null);
        } while ((scriptable = scriptable.getParentScope()) != null);
        throw ScriptRuntime.notFoundError(scriptable, string);
    }

    public static Object propIncrDecr(Object object, String string, Context context, int n) {
        Object object2;
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        Scriptable scriptable2 = scriptable;
        while ((object2 = scriptable2.get(string, scriptable)) == Scriptable.NOT_FOUND) {
            if ((scriptable2 = scriptable2.getPrototype()) != null) continue;
            scriptable.put(string, scriptable, (Object)NaNobj);
            return NaNobj;
        }
        return ScriptRuntime.doScriptableIncrDecr(scriptable2, string, scriptable, object2, n);
    }

    private static Object doScriptableIncrDecr(Scriptable scriptable, String string, Scriptable scriptable2, Object object, int n) {
        double d;
        boolean bl;
        boolean bl2 = bl = (n & 2) != 0;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            d = ScriptRuntime.toNumber(object);
            if (bl) {
                object = ScriptRuntime.wrapNumber(d);
            }
        }
        d = (n & 1) == 0 ? (d += 1.0) : (d -= 1.0);
        Number number = ScriptRuntime.wrapNumber(d);
        scriptable.put(string, scriptable2, (Object)number);
        if (bl) {
            return object;
        }
        return number;
    }

    public static Object elemIncrDecr(Object object, Object object2, Context context, int n) {
        double d;
        boolean bl;
        Object object3 = ScriptRuntime.getObjectElem(object, object2, context);
        boolean bl2 = bl = (n & 2) != 0;
        if (object3 instanceof Number) {
            d = ((Number)object3).doubleValue();
        } else {
            d = ScriptRuntime.toNumber(object3);
            if (bl) {
                object3 = ScriptRuntime.wrapNumber(d);
            }
        }
        d = (n & 1) == 0 ? (d += 1.0) : (d -= 1.0);
        Number number = ScriptRuntime.wrapNumber(d);
        ScriptRuntime.setObjectElem(object, object2, (Object)number, context);
        if (bl) {
            return object3;
        }
        return number;
    }

    public static Object refIncrDecr(Ref ref, Context context, int n) {
        double d;
        boolean bl;
        Object object = ref.get(context);
        boolean bl2 = bl = (n & 2) != 0;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            d = ScriptRuntime.toNumber(object);
            if (bl) {
                object = ScriptRuntime.wrapNumber(d);
            }
        }
        d = (n & 1) == 0 ? (d += 1.0) : (d -= 1.0);
        Number number = ScriptRuntime.wrapNumber(d);
        ref.set(context, number);
        if (bl) {
            return object;
        }
        return number;
    }

    public static Object toPrimitive(Object object) {
        return ScriptRuntime.toPrimitive(object, null);
    }

    public static Object toPrimitive(Object object, Class<?> clazz) {
        if (!(object instanceof Scriptable)) {
            return object;
        }
        Scriptable scriptable = (Scriptable)object;
        Object object2 = scriptable.getDefaultValue(clazz);
        if (object2 instanceof Scriptable) {
            throw ScriptRuntime.typeError0("msg.bad.default.value");
        }
        return object2;
    }

    public static boolean eq(Object object, Object object2) {
        if (object == null || object == Undefined.instance) {
            Object object3;
            if (object2 == null || object2 == Undefined.instance) {
                return true;
            }
            if (object2 instanceof ScriptableObject && (object3 = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                return (Boolean)object3;
            }
            return false;
        }
        if (object instanceof Number) {
            return ScriptRuntime.eqNumber(((Number)object).doubleValue(), object2);
        }
        if (object instanceof String) {
            return ScriptRuntime.eqString((String)object, object2);
        }
        if (object instanceof Boolean) {
            Object object4;
            boolean bl = (Boolean)object;
            if (object2 instanceof Boolean) {
                return bl == (Boolean)object2;
            }
            if (object2 instanceof ScriptableObject && (object4 = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                return (Boolean)object4;
            }
            return ScriptRuntime.eqNumber(bl ? 1.0 : 0.0, object2);
        }
        if (object instanceof Scriptable) {
            if (object2 instanceof Scriptable) {
                Object object5;
                if (object == object2) {
                    return true;
                }
                if (object instanceof ScriptableObject && (object5 = ((ScriptableObject)object).equivalentValues(object2)) != Scriptable.NOT_FOUND) {
                    return (Boolean)object5;
                }
                if (object2 instanceof ScriptableObject && (object5 = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                    return (Boolean)object5;
                }
                if (object instanceof Wrapper && object2 instanceof Wrapper) {
                    Object object6;
                    object5 = ((Wrapper)object).unwrap();
                    return object5 == (object6 = ((Wrapper)object2).unwrap()) || ScriptRuntime.isPrimitive(object5) && ScriptRuntime.isPrimitive(object6) && ScriptRuntime.eq(object5, object6);
                }
                return false;
            }
            if (object2 instanceof Boolean) {
                Object object7;
                if (object instanceof ScriptableObject && (object7 = ((ScriptableObject)object).equivalentValues(object2)) != Scriptable.NOT_FOUND) {
                    return (Boolean)object7;
                }
                double d = (Boolean)object2 != false ? 1.0 : 0.0;
                return ScriptRuntime.eqNumber(d, object);
            }
            if (object2 instanceof Number) {
                return ScriptRuntime.eqNumber(((Number)object2).doubleValue(), object);
            }
            if (object2 instanceof String) {
                return ScriptRuntime.eqString((String)object2, object);
            }
            return false;
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return object == object2;
    }

    public static boolean isPrimitive(Object object) {
        return object == null || object == Undefined.instance || object instanceof Number || object instanceof String || object instanceof Boolean;
    }

    static boolean eqNumber(double d, Object object) {
        while (true) {
            Number number;
            Object object2;
            if (object == null || object == Undefined.instance) {
                return false;
            }
            if (object instanceof Number) {
                return d == ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return d == ScriptRuntime.toNumber(object);
            }
            if (object instanceof Boolean) {
                return d == ((Boolean)object != false ? 1.0 : 0.0);
            }
            if (!(object instanceof Scriptable)) break;
            if (object instanceof ScriptableObject && (object2 = ((ScriptableObject)object).equivalentValues(number = ScriptRuntime.wrapNumber(d))) != Scriptable.NOT_FOUND) {
                return (Boolean)object2;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return false;
    }

    private static boolean eqString(String string, Object object) {
        while (true) {
            Object object2;
            if (object == null || object == Undefined.instance) {
                return false;
            }
            if (object instanceof String) {
                return string.equals(object);
            }
            if (object instanceof Number) {
                return ScriptRuntime.toNumber(string) == ((Number)object).doubleValue();
            }
            if (object instanceof Boolean) {
                return ScriptRuntime.toNumber(string) == ((Boolean)object != false ? 1.0 : 0.0);
            }
            if (!(object instanceof Scriptable)) break;
            if (object instanceof ScriptableObject && (object2 = ((ScriptableObject)object).equivalentValues(string)) != Scriptable.NOT_FOUND) {
                return (Boolean)object2;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return false;
    }

    public static boolean shallowEq(Object object, Object object2) {
        if (object == object2) {
            if (!(object instanceof Number)) {
                return true;
            }
            double d = ((Number)object).doubleValue();
            return d == d;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
            }
        } else if (object instanceof String) {
            if (object2 instanceof String) {
                return object.equals(object2);
            }
        } else if (object instanceof Boolean) {
            if (object2 instanceof Boolean) {
                return object.equals(object2);
            }
        } else if (object instanceof Scriptable) {
            if (object instanceof Wrapper && object2 instanceof Wrapper) {
                return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
            }
        } else {
            ScriptRuntime.warnAboutNonJSObject(object);
            return object == object2;
        }
        return false;
    }

    public static boolean instanceOf(Object object, Object object2, Context context) {
        if (!(object2 instanceof Scriptable)) {
            throw ScriptRuntime.typeError0("msg.instanceof.not.object");
        }
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)object2).hasInstance((Scriptable)object);
    }

    public static boolean jsDelegatesTo(Scriptable scriptable, Scriptable scriptable2) {
        for (Scriptable scriptable3 = scriptable.getPrototype(); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
            if (!scriptable3.equals(scriptable2)) continue;
            return true;
        }
        return false;
    }

    public static boolean in(Object object, Object object2, Context context) {
        if (!(object2 instanceof Scriptable)) {
            throw ScriptRuntime.typeError0("msg.instanceof.not.object");
        }
        return ScriptRuntime.hasObjectElem((Scriptable)object2, object, context);
    }

    public static boolean cmp_LT(Object object, Object object2) {
        double d;
        double d2;
        if (object instanceof Number && object2 instanceof Number) {
            d2 = ((Number)object).doubleValue();
            d = ((Number)object2).doubleValue();
        } else {
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(NumberClass);
            }
            if (object2 instanceof Scriptable) {
                object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
            }
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareTo((String)object2) < 0;
            }
            d2 = ScriptRuntime.toNumber(object);
            d = ScriptRuntime.toNumber(object2);
        }
        return d2 < d;
    }

    public static boolean cmp_LE(Object object, Object object2) {
        double d;
        double d2;
        if (object instanceof Number && object2 instanceof Number) {
            d2 = ((Number)object).doubleValue();
            d = ((Number)object2).doubleValue();
        } else {
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(NumberClass);
            }
            if (object2 instanceof Scriptable) {
                object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
            }
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareTo((String)object2) <= 0;
            }
            d2 = ScriptRuntime.toNumber(object);
            d = ScriptRuntime.toNumber(object2);
        }
        return d2 <= d;
    }

    public static ScriptableObject getGlobal(Context context) {
        Class<?> clazz = Kit.classOrNull("sun.org.mozilla.javascript.internal.tools.shell.Global");
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{ContextClass};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{context};
                return (ScriptableObject)constructor.newInstance(objectArray);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ImporterTopLevel(context);
    }

    public static boolean hasTopCall(Context context) {
        return context.topCallScope != null;
    }

    public static Scriptable getTopCallScope(Context context) {
        Scriptable scriptable = context.topCallScope;
        if (scriptable == null) {
            throw new IllegalStateException();
        }
        return scriptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doTopCall(Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        if (scriptable == null) {
            throw new IllegalArgumentException();
        }
        if (context.topCallScope != null) {
            throw new IllegalStateException();
        }
        context.topCallScope = ScriptableObject.getTopLevelScope(scriptable);
        context.useDynamicScope = context.hasFeature(7);
        ContextFactory contextFactory = context.getFactory();
        try {
            object = contextFactory.doTopCall(callable, context, scriptable, scriptable2, objectArray);
        }
        finally {
            context.topCallScope = null;
            context.cachedXMLLib = null;
            if (context.currentActivationCall != null) {
                throw new IllegalStateException();
            }
        }
        return object;
    }

    static Scriptable checkDynamicScope(Scriptable scriptable, Scriptable scriptable2) {
        if (scriptable == scriptable2) {
            return scriptable;
        }
        Scriptable scriptable3 = scriptable;
        do {
            if ((scriptable3 = scriptable3.getPrototype()) != scriptable2) continue;
            return scriptable;
        } while (scriptable3 != null);
        return scriptable2;
    }

    public static void addInstructionCount(Context context, int n) {
        context.instructionCount += n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    public static void initScript(NativeFunction nativeFunction, Scriptable scriptable, Context context, Scriptable scriptable2, boolean bl) {
        if (context.topCallScope == null) {
            throw new IllegalStateException();
        }
        int n = nativeFunction.getParamAndVarCount();
        if (n != 0) {
            Scriptable scriptable3 = scriptable2;
            while (scriptable3 instanceof NativeWith) {
                scriptable3 = scriptable3.getParentScope();
            }
            int n2 = n;
            while (n2-- != 0) {
                String string = nativeFunction.getParamOrVarName(n2);
                boolean bl2 = nativeFunction.getParamOrVarConst(n2);
                if (!ScriptableObject.hasProperty(scriptable2, string)) {
                    if (!bl) {
                        if (bl2) {
                            ScriptableObject.defineConstProperty(scriptable3, string);
                            continue;
                        }
                        ScriptableObject.defineProperty(scriptable3, string, Undefined.instance, 4);
                        continue;
                    }
                    scriptable3.put(string, scriptable3, Undefined.instance);
                    continue;
                }
                ScriptableObject.redefineProperty(scriptable2, string, bl2);
            }
        }
    }

    public static Scriptable createFunctionActivation(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray) {
        return new NativeCall(nativeFunction, scriptable, objectArray);
    }

    public static void enterActivationFunction(Context context, Scriptable scriptable) {
        if (context.topCallScope == null) {
            throw new IllegalStateException();
        }
        NativeCall nativeCall = (NativeCall)scriptable;
        nativeCall.parentActivationCall = context.currentActivationCall;
        context.currentActivationCall = nativeCall;
    }

    public static void exitActivationFunction(Context context) {
        NativeCall nativeCall = context.currentActivationCall;
        context.currentActivationCall = nativeCall.parentActivationCall;
        nativeCall.parentActivationCall = null;
    }

    static NativeCall findFunctionActivation(Context context, Function function) {
        NativeCall nativeCall = context.currentActivationCall;
        while (nativeCall != null) {
            if (nativeCall.function == function) {
                return nativeCall;
            }
            nativeCall = nativeCall.parentActivationCall;
        }
        return null;
    }

    public static Scriptable newCatchScope(Throwable throwable, Scriptable scriptable, String string, Context context, Scriptable scriptable2) {
        Serializable serializable;
        Object object;
        boolean bl;
        if (throwable instanceof JavaScriptException) {
            bl = false;
            object = ((JavaScriptException)throwable).getValue();
        } else {
            bl = true;
            if (scriptable != null) {
                serializable = (NativeObject)scriptable;
                object = ((ScriptableObject)serializable).getAssociatedValue(throwable);
                if (object == null) {
                    Kit.codeBug();
                }
            } else {
                Object object2;
                int n;
                String string2;
                String string3;
                Object object3;
                Throwable throwable2 = null;
                if (throwable instanceof EcmaError) {
                    object3 = (EcmaError)throwable;
                    serializable = object3;
                    string3 = ((EcmaError)object3).getName();
                    string2 = ((EcmaError)object3).getErrorMessage();
                } else if (throwable instanceof WrappedException) {
                    object3 = (WrappedException)throwable;
                    serializable = object3;
                    throwable2 = ((WrappedException)object3).getWrappedException();
                    string3 = "JavaException";
                    string2 = throwable2.getClass().getName() + ": " + throwable2.getMessage();
                } else if (throwable instanceof EvaluatorException) {
                    object3 = (EvaluatorException)throwable;
                    serializable = object3;
                    string3 = "InternalError";
                    string2 = ((RhinoException)object3).getMessage();
                } else if (context.hasFeature(13)) {
                    serializable = new WrappedException(throwable);
                    string3 = "JavaException";
                    string2 = throwable.toString();
                } else {
                    throw Kit.codeBug();
                }
                object3 = ((RhinoException)serializable).sourceName();
                if (object3 == null) {
                    object3 = "";
                }
                Object[] objectArray = (n = ((RhinoException)serializable).lineNumber()) > 0 ? new Object[]{string2, object3, n} : new Object[]{string2, object3};
                Scriptable scriptable3 = context.newObject(scriptable2, string3, objectArray);
                ScriptableObject.putProperty(scriptable3, "name", (Object)string3);
                if (scriptable3 instanceof NativeError) {
                    ((NativeError)scriptable3).setStackProvider((RhinoException)serializable);
                }
                if (throwable2 != null && ScriptRuntime.isVisible(context, throwable2)) {
                    object2 = context.getWrapFactory().wrap(context, scriptable2, throwable2, null);
                    ScriptableObject.defineProperty(scriptable3, "javaException", object2, 5);
                }
                if (ScriptRuntime.isVisible(context, serializable)) {
                    object2 = context.getWrapFactory().wrap(context, scriptable2, serializable, null);
                    ScriptableObject.defineProperty(scriptable3, "rhinoException", object2, 5);
                }
                object = scriptable3;
            }
        }
        serializable = new NativeObject();
        ((ScriptableObject)serializable).defineProperty(string, object, 4);
        if (ScriptRuntime.isVisible(context, throwable)) {
            ((ScriptableObject)serializable).defineProperty("__exception__", Context.javaToJS(throwable, scriptable2), 6);
        }
        if (bl) {
            ((ScriptableObject)serializable).associateValue(throwable, object);
        }
        return serializable;
    }

    private static boolean isVisible(Context context, Object object) {
        ClassShutter classShutter = context.getClassShutter();
        return classShutter == null || classShutter.visibleToScripts(object.getClass().getName());
    }

    public static Scriptable enterWith(Object object, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable2 == null) {
            throw ScriptRuntime.typeError1("msg.undef.with", ScriptRuntime.toString(object));
        }
        if (scriptable2 instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable2;
            return xMLObject.enterWith(scriptable);
        }
        return new NativeWith(scriptable, scriptable2);
    }

    public static Scriptable leaveWith(Scriptable scriptable) {
        NativeWith nativeWith = (NativeWith)scriptable;
        return nativeWith.getParentScope();
    }

    public static Scriptable enterDotQuery(Object object, Scriptable scriptable) {
        if (!(object instanceof XMLObject)) {
            throw ScriptRuntime.notXmlError(object);
        }
        XMLObject xMLObject = (XMLObject)object;
        return xMLObject.enterDotQuery(scriptable);
    }

    public static Object updateDotQuery(boolean bl, Scriptable scriptable) {
        NativeWith nativeWith = (NativeWith)scriptable;
        return nativeWith.updateDotQuery(bl);
    }

    public static Scriptable leaveDotQuery(Scriptable scriptable) {
        NativeWith nativeWith = (NativeWith)scriptable;
        return nativeWith.getParentScope();
    }

    public static void setFunctionProtoAndParent(BaseFunction baseFunction, Scriptable scriptable) {
        baseFunction.setParentScope(scriptable);
        baseFunction.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
    }

    public static void setObjectProtoAndParent(ScriptableObject scriptableObject, Scriptable scriptable) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        scriptableObject.setParentScope(scriptable);
        Scriptable scriptable2 = ScriptableObject.getClassPrototype(scriptable, scriptableObject.getClassName());
        scriptableObject.setPrototype(scriptable2);
    }

    public static void initFunction(Context context, Scriptable scriptable, NativeFunction nativeFunction, int n, boolean bl) {
        if (n == 1) {
            String string = nativeFunction.getFunctionName();
            if (string != null && string.length() != 0) {
                if (!bl) {
                    ScriptableObject.defineProperty(scriptable, string, nativeFunction, 4);
                } else {
                    scriptable.put(string, scriptable, (Object)nativeFunction);
                }
            }
        } else if (n == 3) {
            String string = nativeFunction.getFunctionName();
            if (string != null && string.length() != 0) {
                while (scriptable instanceof NativeWith) {
                    scriptable = scriptable.getParentScope();
                }
                scriptable.put(string, scriptable, (Object)nativeFunction);
            }
        } else {
            throw Kit.codeBug();
        }
    }

    public static Scriptable newArrayLiteral(Object[] objectArray, int[] nArray, Context context, Scriptable scriptable) {
        int n;
        int n2 = objectArray.length;
        int n3 = 0;
        if (nArray != null) {
            n3 = nArray.length;
        }
        if ((n = n2 + n3) > 1 && n3 * 2 < n) {
            Object[] objectArray2;
            if (n3 == 0) {
                objectArray2 = objectArray;
            } else {
                objectArray2 = new Object[n];
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i != n; ++i) {
                    if (n4 != n3 && nArray[n4] == i) {
                        objectArray2[i] = Scriptable.NOT_FOUND;
                        ++n4;
                        continue;
                    }
                    objectArray2[i] = objectArray[n5];
                    ++n5;
                }
            }
            NativeArray nativeArray = new NativeArray(objectArray2);
            ScriptRuntime.setObjectProtoAndParent(nativeArray, scriptable);
            return nativeArray;
        }
        NativeArray nativeArray = new NativeArray(n);
        ScriptRuntime.setObjectProtoAndParent(nativeArray, scriptable);
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i != n; ++i) {
            if (n6 != n3 && nArray[n6] == i) {
                ++n6;
                continue;
            }
            ScriptableObject.putProperty((Scriptable)nativeArray, i, objectArray[n7]);
            ++n7;
        }
        return nativeArray;
    }

    public static Scriptable newObjectLiteral(Object[] objectArray, Object[] objectArray2, Context context, Scriptable scriptable) {
        int[] nArray = new int[objectArray.length];
        return ScriptRuntime.newObjectLiteral(objectArray, objectArray2, nArray, context, scriptable);
    }

    public static Scriptable newObjectLiteral(Object[] objectArray, Object[] objectArray2, int[] nArray, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = context.newObject(scriptable);
        int n = objectArray.length;
        for (int i = 0; i != n; ++i) {
            Object object = objectArray[i];
            int n2 = nArray[i];
            Object object2 = objectArray2[i];
            if (object instanceof String) {
                if (n2 == 0) {
                    if (ScriptRuntime.isSpecialProperty((String)object)) {
                        ScriptRuntime.specialRef(scriptable2, (String)object, context).set(context, object2);
                        continue;
                    }
                    ScriptableObject.putProperty(scriptable2, (String)object, object2);
                    continue;
                }
                String string = n2 < 0 ? "__defineGetter__" : "__defineSetter__";
                Callable callable = ScriptRuntime.getPropFunctionAndThis(scriptable2, string, context);
                ScriptRuntime.lastStoredScriptable(context);
                Object[] objectArray3 = new Object[]{object, object2};
                callable.call(context, scriptable, scriptable2, objectArray3);
                continue;
            }
            int n3 = (Integer)object;
            ScriptableObject.putProperty(scriptable2, n3, object2);
        }
        return scriptable2;
    }

    public static boolean isArrayObject(Object object) {
        return object instanceof NativeArray || object instanceof Arguments;
    }

    public static Object[] getArrayElements(Scriptable scriptable) {
        Context context = Context.getContext();
        long l = NativeArray.getLengthProperty(context, scriptable);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int n = (int)l;
        if (n == 0) {
            return emptyArgs;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object = ScriptableObject.getProperty(scriptable, i);
            objectArray[i] = object == Scriptable.NOT_FOUND ? Undefined.instance : object;
        }
        return objectArray;
    }

    static void checkDeprecated(Context context, String string) {
        int n = context.getLanguageVersion();
        if (n >= 140 || n == 0) {
            String string2 = ScriptRuntime.getMessage1("msg.deprec.ctor", string);
            if (n == 0) {
                Context.reportWarning(string2);
            } else {
                throw Context.reportRuntimeError(string2);
            }
        }
    }

    public static String getMessage0(String string) {
        return ScriptRuntime.getMessage(string, null);
    }

    public static String getMessage1(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage2(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage3(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage4(String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    public static String getMessage(String string, Object[] objectArray) {
        return messageProvider.getMessage(string, objectArray);
    }

    public static EcmaError constructError(String string, String string2) {
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        return ScriptRuntime.constructError(string, string2, string3, nArray[0], null, 0);
    }

    public static EcmaError constructError(String string, String string2, int n) {
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        if (nArray[0] != 0) {
            nArray[0] = nArray[0] + n;
        }
        return ScriptRuntime.constructError(string, string2, string3, nArray[0], null, 0);
    }

    public static EcmaError constructError(String string, String string2, String string3, int n, String string4, int n2) {
        return new EcmaError(string, string2, string3, n, string4, n2);
    }

    public static EcmaError typeError(String string) {
        return ScriptRuntime.constructError("TypeError", string);
    }

    public static EcmaError typeError0(String string) {
        String string2 = ScriptRuntime.getMessage0(string);
        return ScriptRuntime.typeError(string2);
    }

    public static EcmaError typeError1(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        return ScriptRuntime.typeError(string3);
    }

    public static EcmaError typeError2(String string, String string2, String string3) {
        String string4 = ScriptRuntime.getMessage2(string, string2, string3);
        return ScriptRuntime.typeError(string4);
    }

    public static EcmaError typeError3(String string, String string2, String string3, String string4) {
        String string5 = ScriptRuntime.getMessage3(string, string2, string3, string4);
        return ScriptRuntime.typeError(string5);
    }

    public static RuntimeException undefReadError(Object object, Object object2) {
        String string = object2 == null ? "null" : object2.toString();
        return ScriptRuntime.typeError2("msg.undef.prop.read", ScriptRuntime.toString(object), string);
    }

    public static RuntimeException undefCallError(Object object, Object object2) {
        String string = object2 == null ? "null" : object2.toString();
        return ScriptRuntime.typeError2("msg.undef.method.call", ScriptRuntime.toString(object), string);
    }

    public static RuntimeException undefWriteError(Object object, Object object2, Object object3) {
        String string = object2 == null ? "null" : object2.toString();
        String string2 = object3 instanceof Scriptable ? object3.toString() : ScriptRuntime.toString(object3);
        return ScriptRuntime.typeError3("msg.undef.prop.write", ScriptRuntime.toString(object), string, string2);
    }

    public static RuntimeException notFoundError(Scriptable scriptable, String string) {
        String string2 = ScriptRuntime.getMessage1("msg.is.not.defined", string);
        throw ScriptRuntime.constructError("ReferenceError", string2);
    }

    public static RuntimeException notFunctionError(Object object) {
        return ScriptRuntime.notFunctionError(object, object);
    }

    public static RuntimeException notFunctionError(Object object, Object object2) {
        String string;
        String string2 = string = object2 == null ? "null" : object2.toString();
        if (object == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeError1("msg.function.not.found", string);
        }
        return ScriptRuntime.typeError2("msg.isnt.function", string, ScriptRuntime.typeof(object));
    }

    public static RuntimeException notFunctionError(Object object, Object object2, String string) {
        int n;
        String string2 = ScriptRuntime.toString(object);
        if (object instanceof NativeFunction && (n = string2.indexOf(123)) > -1) {
            string2 = string2.substring(0, n + 1) + "...}";
        }
        if (object2 == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeError2("msg.function.not.found.in", string, string2);
        }
        return ScriptRuntime.typeError3("msg.isnt.function.in", string, string2, ScriptRuntime.typeof(object2));
    }

    private static RuntimeException notXmlError(Object object) {
        throw ScriptRuntime.typeError1("msg.isnt.xml.object", ScriptRuntime.toString(object));
    }

    private static void warnAboutNonJSObject(Object object) {
        String string = "RHINO USAGE WARNING: Missed Context.javaToJS() conversion:\nRhino runtime detected object " + object + " of class " + object.getClass().getName() + " where it expected String, Number, Boolean or Scriptable instance. Please check your code for missing Context.javaToJS() call.";
        Context.reportWarning(string);
        System.err.println(string);
    }

    public static RegExpProxy getRegExpProxy(Context context) {
        return context.getRegExpProxy();
    }

    public static void setRegExpProxy(Context context, RegExpProxy regExpProxy) {
        if (regExpProxy == null) {
            throw new IllegalArgumentException();
        }
        context.regExpProxy = regExpProxy;
    }

    public static RegExpProxy checkRegExpProxy(Context context) {
        RegExpProxy regExpProxy = ScriptRuntime.getRegExpProxy(context);
        if (regExpProxy == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        return regExpProxy;
    }

    private static XMLLib currentXMLLib(Context context) {
        if (context.topCallScope == null) {
            throw new IllegalStateException();
        }
        XMLLib xMLLib = context.cachedXMLLib;
        if (xMLLib == null) {
            xMLLib = XMLLib.extractFromScope(context.topCallScope);
            if (xMLLib == null) {
                throw new IllegalStateException();
            }
            context.cachedXMLLib = xMLLib;
        }
        return xMLLib;
    }

    public static String escapeAttributeValue(Object object, Context context) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.escapeAttributeValue(object);
    }

    public static String escapeTextValue(Object object, Context context) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.escapeTextValue(object);
    }

    public static Ref memberRef(Object object, Object object2, Context context, int n) {
        if (!(object instanceof XMLObject)) {
            throw ScriptRuntime.notXmlError(object);
        }
        XMLObject xMLObject = (XMLObject)object;
        return xMLObject.memberRef(context, object2, n);
    }

    public static Ref memberRef(Object object, Object object2, Object object3, Context context, int n) {
        if (!(object instanceof XMLObject)) {
            throw ScriptRuntime.notXmlError(object);
        }
        XMLObject xMLObject = (XMLObject)object;
        return xMLObject.memberRef(context, object2, object3, n);
    }

    public static Ref nameRef(Object object, Context context, Scriptable scriptable, int n) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.nameRef(context, object, scriptable, n);
    }

    public static Ref nameRef(Object object, Object object2, Context context, Scriptable scriptable, int n) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.nameRef(context, object, object2, scriptable, n);
    }

    private static void storeIndexResult(Context context, int n) {
        context.scratchIndex = n;
    }

    static int lastIndexResult(Context context) {
        return context.scratchIndex;
    }

    public static void storeUint32Result(Context context, long l) {
        if (l >>> 32 != 0L) {
            throw new IllegalArgumentException();
        }
        context.scratchUint32 = l;
    }

    public static long lastUint32Result(Context context) {
        long l = context.scratchUint32;
        if (l >>> 32 != 0L) {
            throw new IllegalStateException();
        }
        return l;
    }

    private static void storeScriptable(Context context, Scriptable scriptable) {
        if (context.scratchScriptable != null) {
            throw new IllegalStateException();
        }
        context.scratchScriptable = scriptable;
    }

    public static Scriptable lastStoredScriptable(Context context) {
        Scriptable scriptable = context.scratchScriptable;
        context.scratchScriptable = null;
        return scriptable;
    }

    static String makeUrlForGeneratedScript(boolean bl, String string, int n) {
        if (bl) {
            return string + '#' + n + "(eval)";
        }
        return string + '#' + n + "(Function)";
    }

    static boolean isGeneratedScript(String string) {
        return string.indexOf("(eval)") >= 0 || string.indexOf("(Function)") >= 0;
    }

    private static RuntimeException errorWithClassName(String string, Object object) {
        return Context.reportRuntimeError1(string, object.getClass().getName());
    }

    public static JavaScriptException throwError(Context context, Scriptable scriptable, String string) {
        Scriptable scriptable2 = context.newObject(scriptable, "Error", new Object[]{string});
        return new JavaScriptException(scriptable2, ScriptableObject.getTypedProperty(scriptable2, "fileName", String.class), ScriptableObject.getTypedProperty(scriptable2, "lineNumber", Number.class).intValue());
    }

    private static class DefaultMessageProvider
    implements MessageProvider {
        private DefaultMessageProvider() {
        }

        @Override
        public String getMessage(String string, Object[] objectArray) {
            String string2;
            Context context = Context.getCurrentContext();
            final Locale locale = context != null ? context.getLocale() : Locale.getDefault();
            ResourceBundle resourceBundle = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

                @Override
                public ResourceBundle run() {
                    return ResourceBundle.getBundle("sun.org.mozilla.javascript.internal.resources.Messages", locale);
                }
            });
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                throw new RuntimeException("no message resource found for message property " + string);
            }
            MessageFormat messageFormat = new MessageFormat(string2);
            return messageFormat.format(objectArray);
        }
    }

    private static class IdEnumeration
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Scriptable obj;
        Object[] ids;
        int index;
        ObjToIntMap used;
        Object currentId;
        int enumType;
        boolean enumNumbers;
        Scriptable iterator;

        private IdEnumeration() {
        }
    }

    public static interface MessageProvider {
        public String getMessage(String var1, Object[] var2);
    }

    static class NoSuchMethodShim
    implements Callable {
        String methodName;
        Callable noSuchMethodMethod;

        NoSuchMethodShim(Callable callable, String string) {
            this.noSuchMethodMethod = callable;
            this.methodName = string;
        }

        @Override
        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            Object[] objectArray2 = new Object[]{this.methodName, ScriptRuntime.newArrayLiteral(objectArray, null, context, scriptable)};
            return this.noSuchMethodMethod.call(context, scriptable, scriptable2, objectArray2);
        }
    }
}

