/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;
import sun.net.ResourceManager;
import sun.security.action.LoadLibraryAction;

abstract class AbstractPlainDatagramSocketImpl
extends DatagramSocketImpl {
    int timeout = 0;
    boolean connected = false;
    private int trafficClass = 0;
    private InetAddress connectedAddress = null;
    private int connectedPort = -1;
    private int multicastInterface = 0;
    private boolean loopbackMode = true;
    private int ttl = -1;

    AbstractPlainDatagramSocketImpl() {
    }

    @Override
    protected synchronized void create() throws SocketException {
        ResourceManager.beforeUdpCreate();
        this.fd = new FileDescriptor();
        try {
            this.datagramSocketCreate();
        }
        catch (SocketException socketException) {
            ResourceManager.afterUdpClose();
            this.fd = null;
            throw socketException;
        }
    }

    @Override
    protected synchronized void bind(int n, InetAddress inetAddress) throws SocketException {
        this.bind0(n, inetAddress);
    }

    protected abstract void bind0(int var1, InetAddress var2) throws SocketException;

    @Override
    protected abstract void send(DatagramPacket var1) throws IOException;

    @Override
    protected void connect(InetAddress inetAddress, int n) throws SocketException {
        this.connect0(inetAddress, n);
        this.connectedAddress = inetAddress;
        this.connectedPort = n;
        this.connected = true;
    }

    @Override
    protected void disconnect() {
        this.disconnect0(this.connectedAddress.family);
        this.connected = false;
        this.connectedAddress = null;
        this.connectedPort = -1;
    }

    @Override
    protected abstract int peek(InetAddress var1) throws IOException;

    @Override
    protected abstract int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        this.receive0(datagramPacket);
    }

    protected abstract void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected abstract void setTimeToLive(int var1) throws IOException;

    @Override
    protected abstract int getTimeToLive() throws IOException;

    @Override
    protected abstract void setTTL(byte var1) throws IOException;

    @Override
    protected abstract byte getTTL() throws IOException;

    @Override
    protected void join(InetAddress inetAddress) throws IOException {
        this.join(inetAddress, null);
    }

    @Override
    protected void leave(InetAddress inetAddress) throws IOException {
        this.leave(inetAddress, null);
    }

    @Override
    protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.join(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    protected abstract void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.leave(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    protected abstract void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void close() {
        if (this.fd != null) {
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
        }
    }

    protected boolean isClosed() {
        return this.fd == null;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public void setOption(int n, Object object) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (n) {
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                return;
            }
            case 3: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)object;
                break;
            }
            case 4: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 32: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_BROADCAST");
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object >= 0) break;
                throw new SocketException("bad argument for SO_SNDBUF or SO_RCVBUF");
            }
            case 16: {
                if (object != null && object instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            case 31: {
                if (object != null && object instanceof NetworkInterface) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF2");
            }
            case 18: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for IP_MULTICAST_LOOP");
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        this.socketSetOption(n, object);
    }

    @Override
    public Object getOption(int n) throws SocketException {
        Object object;
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (n) {
            case 4102: {
                object = new Integer(this.timeout);
                break;
            }
            case 3: {
                object = this.socketGetOption(n);
                if ((Integer)object != -1) break;
                object = new Integer(this.trafficClass);
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 31: 
            case 32: 
            case 4097: 
            case 4098: {
                object = this.socketGetOption(n);
                break;
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        return object;
    }

    protected abstract void datagramSocketCreate() throws SocketException;

    protected abstract void datagramSocketClose();

    protected abstract void socketSetOption(int var1, Object var2) throws SocketException;

    protected abstract Object socketGetOption(int var1) throws SocketException;

    protected abstract void connect0(InetAddress var1, int var2) throws SocketException;

    protected abstract void disconnect0(int var1);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

