/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.impl.awt.ui.AWTDialog;
import com.sun.deploy.uitoolkit.ui.AbstractDialog;
import com.sun.deploy.uitoolkit.ui.ModalityHelper;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.SunToolkit;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.main.client.ModalityInterface;
import sun.plugin2.os.windows.FLASHWINFO;
import sun.plugin2.os.windows.Windows;
import sun.plugin2.util.SystemUtil;

public class AWTModalityHelper
implements ModalityHelper {
    private final LinkedList managersShowingSystemDialogs = new LinkedList();
    private static Reactivator reactivator;

    AWTModalityHelper() {
    }

    public boolean installModalityListener(ModalityInterface modalityInterface) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                SunToolkit sunToolkit = (SunToolkit)toolkit;
                sunToolkit.addModalityListener(new PluginModalityListener(modalityInterface));
                return true;
            }
            System.out.println("Not a SunToolkit?");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushManagerShowingSystemDialog() {
        Plugin2Manager plugin2Manager = Plugin2Manager.getCurrentManager();
        LinkedList linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            this.managersShowingSystemDialogs.addFirst(plugin2Manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin2Manager getManagerShowingSystemDialog() {
        LinkedList linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            if (!this.managersShowingSystemDialogs.isEmpty()) {
                return (Plugin2Manager)this.managersShowingSystemDialogs.getFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popManagerShowingSystemDialog() {
        Plugin2Manager plugin2Manager = Plugin2Manager.getCurrentManager();
        LinkedList linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            Iterator iterator = this.managersShowingSystemDialogs.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != plugin2Manager) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void reactivateDialog(AbstractDialog abstractDialog) {
        if (abstractDialog instanceof AWTDialog) {
            this.getReactivator().reactivate(((AWTDialog)abstractDialog).getDialog());
        } else {
            Trace.println((String)"reactivateDialog: not an AWTDialog");
        }
    }

    private Reactivator getReactivator() {
        if (reactivator == null) {
            reactivator = SystemUtil.getOSType() == 1 ? new WindowsReactivator() : new NoopReactivator();
        }
        return reactivator;
    }

    static class NoopReactivator
    implements Reactivator {
        NoopReactivator() {
        }

        public void reactivate(Dialog dialog) {
        }
    }

    static class PluginModalityListener
    implements ModalityListener {
        private ModalityInterface modality;

        PluginModalityListener(ModalityInterface modalityInterface) {
            this.modality = modalityInterface;
        }

        public void modalityPushed(ModalityEvent modalityEvent) {
            this.modality.modalityPushed((AbstractDialog)AWTDialog.getAWTDialog((Dialog)((Dialog)modalityEvent.getSource())));
        }

        public void modalityPopped(ModalityEvent modalityEvent) {
            this.modality.modalityPopped((AbstractDialog)AWTDialog.getAWTDialog((Dialog)((Dialog)modalityEvent.getSource())));
        }
    }

    static interface Reactivator {
        public void reactivate(Dialog var1);
    }

    static class WindowsReactivator
    implements Reactivator {
        private Method getHWndMethod;

        WindowsReactivator() {
        }

        public void reactivate(Dialog dialog) {
            if (this.getHWndMethod == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                Class<?> clazz = Class.forName("sun.awt.windows.WComponentPeer");
                                Method method = clazz.getDeclaredMethod("getHWnd", null);
                                method.setAccessible(true);
                                WindowsReactivator.this.getHWndMethod = method;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long l = 0L;
            try {
                l = (Long)this.getHWndMethod.invoke((Object)dialog.getPeer(), null);
                Windows.MessageBeep(0);
                FLASHWINFO fLASHWINFO = FLASHWINFO.create();
                fLASHWINFO.cbSize(FLASHWINFO.size());
                fLASHWINFO.hwnd(l);
                fLASHWINFO.dwFlags(1);
                fLASHWINFO.uCount(3);
                fLASHWINFO.dwTimeout(64);
                Windows.FlashWindowEx(fLASHWINFO);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

