/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.mscapi.Key;
import sun.security.mscapi.RSASignature;
import sun.security.rsa.RSAKeyFactory;

public final class RSACipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final String PAD_PKCS1 = "PKCS1Padding";
    private static final int PAD_PKCS1_LENGTH = 11;
    private int mode;
    private String paddingType = "PKCS1Padding";
    private int paddingLength = 0;
    private byte[] buffer;
    private int bufOfs;
    private int outputSize;
    private Key publicKey;
    private Key privateKey;

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase(PAD_PKCS1)) {
            throw new NoSuchPaddingException("Padding " + string + " not supported");
        }
        this.paddingType = PAD_PKCS1;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int n, java.security.Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.init(n, key);
    }

    @Override
    protected void engineInit(int n, java.security.Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(n, key);
    }

    @Override
    protected void engineInit(int n, java.security.Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(n, key);
    }

    private void init(int n, java.security.Key key) throws InvalidKeyException {
        boolean bl;
        switch (n) {
            case 1: 
            case 3: {
                this.paddingLength = 11;
                bl = true;
                break;
            }
            case 2: 
            case 4: {
                this.paddingLength = 0;
                bl = false;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + n);
            }
        }
        if (!(key instanceof Key)) {
            if (key instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                BigInteger bigInteger = rSAPublicKey.getModulus();
                BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
                RSAKeyFactory.checkKeyLengths(bigInteger.bitLength() + 7 & 0xFFFFFFF8, bigInteger2, -1, 16384);
                byte[] byArray = bigInteger.toByteArray();
                byte[] byArray2 = bigInteger2.toByteArray();
                int n2 = byArray[0] == 0 ? (byArray.length - 1) * 8 : byArray.length * 8;
                byte[] byArray3 = RSASignature.generatePublicKeyBlob(n2, byArray, byArray2);
                try {
                    key = RSASignature.importPublicKey(byArray3, n2);
                }
                catch (KeyStoreException keyStoreException) {
                    throw new InvalidKeyException(keyStoreException);
                }
            } else {
                throw new InvalidKeyException("Unsupported key type: " + key);
            }
        }
        if (key instanceof PublicKey) {
            this.mode = bl ? 1 : 4;
            this.publicKey = (Key)key;
            this.privateKey = null;
            this.outputSize = this.publicKey.bitLength() / 8;
        } else if (key instanceof PrivateKey) {
            this.mode = bl ? 3 : 2;
            this.privateKey = (Key)key;
            this.publicKey = null;
            this.outputSize = this.privateKey.bitLength() / 8;
        } else {
            throw new InvalidKeyException("Unknown key type: " + key);
        }
        this.bufOfs = 0;
        this.buffer = new byte[this.outputSize];
    }

    private void update(byte[] byArray, int n, int n2) {
        if (n2 == 0 || byArray == null) {
            return;
        }
        if (this.bufOfs + n2 > this.buffer.length - this.paddingLength) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufOfs, n2);
        this.bufOfs += n2;
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        if (this.bufOfs > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + (this.buffer.length - this.paddingLength) + " bytes");
        }
        try {
            byte[] byArray = this.buffer;
            switch (this.mode) {
                case 3: {
                    byte[] byArray2 = RSACipher.encryptDecrypt(byArray, this.bufOfs, this.privateKey.getHCryptKey(), true);
                    return byArray2;
                }
                case 4: {
                    byte[] byArray3 = RSACipher.encryptDecrypt(byArray, this.bufOfs, this.publicKey.getHCryptKey(), false);
                    return byArray3;
                }
                case 1: {
                    byte[] byArray4 = RSACipher.encryptDecrypt(byArray, this.bufOfs, this.publicKey.getHCryptKey(), true);
                    return byArray4;
                }
                case 2: {
                    byte[] byArray5 = RSACipher.encryptDecrypt(byArray, this.bufOfs, this.privateKey.getHCryptKey(), false);
                    return byArray5;
                }
            }
            try {
                throw new AssertionError((Object)"Internal error");
            }
            catch (KeyException keyException) {
                throw new ProviderException(keyException);
            }
        }
        finally {
            this.bufOfs = 0;
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.update(byArray, n, n2);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.update(byArray, n, n2);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        this.update(byArray, n, n2);
        return this.doFinal();
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (this.outputSize > byArray2.length - n3) {
            throw new ShortBufferException("Need " + this.outputSize + " bytes for output");
        }
        this.update(byArray, n, n2);
        byte[] byArray3 = this.doFinal();
        int n4 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
        return n4;
    }

    @Override
    protected byte[] engineWrap(java.security.Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (byArray.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for wrapping");
        }
        this.update(byArray, 0, byArray.length);
        try {
            return this.doFinal();
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrapping failed", badPaddingException);
        }
    }

    @Override
    protected java.security.Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (byArray.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        this.update(byArray, 0, byArray.length);
        try {
            byte[] byArray2 = this.doFinal();
            switch (n) {
                case 1: {
                    return RSACipher.constructPublicKey(byArray2, string);
                }
                case 2: {
                    return RSACipher.constructPrivateKey(byArray2, string);
                }
                case 3: {
                    return RSACipher.constructSecretKey(byArray2, string);
                }
            }
            throw new InvalidKeyException("Unknown key type " + n);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Unwrapping failed", badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Unwrapping failed", illegalBlockSizeException);
        }
    }

    @Override
    protected int engineGetKeySize(java.security.Key key) throws InvalidKeyException {
        if (key instanceof Key) {
            return ((Key)key).bitLength();
        }
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        throw new InvalidKeyException("Unsupported key type: " + key);
    }

    private static PublicKey constructPublicKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No installed provider supports the " + string + " algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct public key", invalidKeySpecException);
        }
    }

    private static PrivateKey constructPrivateKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No installed provider supports the " + string + " algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct private key", invalidKeySpecException);
        }
    }

    private static SecretKey constructSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    private static native byte[] encryptDecrypt(byte[] var0, int var1, long var2, boolean var4) throws KeyException;
}

