/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.util.HashMap;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class DeployUIManager {
    private static final String _v = System.getProperty("java.version");
    private static final boolean _isOldJava = _v.startsWith("1.2") || _v.startsWith("1.3") || _v.startsWith("1.4");

    public static void setLookAndFeel() {
        try {
            if (_isOldJava) {
                MetalLookAndFeel.setCurrentTheme(new DeployMetalTheme());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            if (Config.useSystemLookAndFeel()) {
                hashMap.put("defaultlaf", DeployUIManager.getSystemLookAndFeelClassName());
                hashMap.put("Slider.paintValue", Boolean.FALSE);
            } else {
                hashMap.put("defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel");
            }
            ToolkitStore.get().getAppContext().put("swing.lafdata", hashMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getSystemLookAndFeelClassName() {
        String string = System.getProperty("swing.systemlaf");
        if (string != null) {
            return string;
        }
        String string2 = System.getProperty("os.name");
        if (string2 != null) {
            if (string2.indexOf("Windows") != -1) {
                return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            }
            String string3 = System.getProperty("sun.desktop");
            if ("gnome".equals(string3)) {
                return "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            }
            if (string2.indexOf("Solaris") != -1 || string2.indexOf("SunOS") != -1) {
                return "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
        }
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    static class DeployMetalTheme
    extends DefaultMetalTheme {
        private FontUIResource controlTextFont = null;
        private FontUIResource menuTextFont = null;
        private FontUIResource windowTitleFont = null;

        DeployMetalTheme() {
            FontUIResource fontUIResource = super.getControlTextFont();
            this.controlTextFont = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle() & 0xFFFFFFFE, fontUIResource.getSize());
            fontUIResource = super.getMenuTextFont();
            this.menuTextFont = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle() & 0xFFFFFFFE, fontUIResource.getSize());
            fontUIResource = super.getWindowTitleFont();
            this.windowTitleFont = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle() & 0xFFFFFFFE, fontUIResource.getSize());
        }

        public FontUIResource getControlTextFont() {
            return this.controlTextFont;
        }

        public FontUIResource getMenuTextFont() {
            return this.menuTextFont;
        }

        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont;
        }
    }
}

