/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.jardiff.JarDiffPatcher;
import com.sun.deploy.jardiff.Patcher;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadHelper;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class DownloadEngine {
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    public static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final int BASIC_DOWNLOAD_PROTOCOL = 1;
    private static final int VERSION_DOWNLOAD_PROTOCOL = 2;
    private static final int EXTENSION_DOWNLOAD_PROTOCOL = 3;
    public static final int NORMAL_CONTENT_BIT = 1;
    public static final int NATIVE_CONTENT_BIT = 16;
    public static final int JAR_CONTENT_BIT = 256;
    public static final int PACK200_CONTENT_BIT = 4096;
    public static final int VERSION_CONTENT_BIT = 65536;
    private static int BUF_SIZE = 8192;
    private static final String defaultLocaleString = Locale.getDefault().toString();
    private static HttpRequest _httpRequestImpl;
    private static HttpDownload _httpDownloadImpl;
    public static final String BACKGROUND_STRING = "background";
    public static final String APPCONTEXT_BG_KEY = "deploy-bg-";
    private static InheritableThreadLocal backgroundUpdateThreadLocal;
    private static ThreadLocal processingState;
    private static final ThreadLocal internalUse;
    private static Hashtable noCacheJarFileList;
    private static Hashtable noCacheRedirectFinalURLs;

    public static boolean haveDownloadInProgress() {
        return processingState.get() != null;
    }

    private static void setDownloadInProgress(boolean bl) {
        if (bl) {
            processingState.set(Boolean.TRUE);
        } else {
            processingState.set(null);
        }
    }

    public static boolean isBackgroundThread() {
        return (Boolean)backgroundUpdateThreadLocal.get();
    }

    public static void setBackgroundThread(boolean bl) {
        backgroundUpdateThreadLocal.set(new Boolean(bl));
    }

    public static void setInternalUse() {
        internalUse.set(Boolean.TRUE);
    }

    public static void clearInternalUse() {
        internalUse.set(null);
    }

    public static boolean isInternalUse() {
        Boolean bl = (Boolean)internalUse.get();
        return bl != null && bl != false;
    }

    public static boolean isNativeContentType(int n) {
        return (n & 0x10) == 16;
    }

    public static boolean isJarContentType(int n) {
        return (n & 0x100) == 256;
    }

    public static boolean isPackContentType(int n) {
        return (n & 0x1000) == 4096;
    }

    private static boolean isVersionContentType(int n) {
        return (n & 0x10000) == 65536;
    }

    static boolean isPack200Supported() {
        return Config.isJavaVersionAtLeast15();
    }

    public static String getCachedResourceFilePath(URL uRL) throws IOException {
        return DownloadEngine.getCachedResourceFilePath(uRL, null);
    }

    public static String getCachedResourceFilePath(URL uRL, String string) throws IOException {
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, string);
            if (cacheEntry != null) {
                return cacheEntry.getResourceFilename();
            }
        } else {
            Object object = MemoryCache.getLoadedResource(uRL.toString());
            if (object != null) {
                if (object instanceof JarFile) {
                    return ((JarFile)object).getName();
                }
                if (object instanceof CacheEntry) {
                    return ((CacheEntry)object).getResourceFilename();
                }
            }
        }
        throw new IOException("Cannot find cached resource for URL: " + uRL.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarFile downloadJarFileWithoutCache(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, int n) throws IOException {
        JarFile jarFile = null;
        try {
            DownloadEngine.setDownloadInProgress(true);
            try {
                jarFile = DownloadEngine.getJarFileWithoutCache(uRL, string, string2, downloadDelegate, n);
            }
            catch (JARSigningException jARSigningException) {
                throw jARSigningException;
            }
            catch (IOException iOException) {
                jarFile = DownloadEngine.getJarFileWithoutCache(uRL, string, string2, downloadDelegate, 256);
            }
        }
        finally {
            DownloadEngine.setDownloadInProgress(false);
        }
        return jarFile;
    }

    public static URL getResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        return DownloadEngine.getResource(uRL, string, string2, downloadDelegate, bl, 1);
    }

    public static URL getResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, int n) throws IOException {
        JarFile jarFile;
        URL uRL2 = null;
        MemoryCache.removeLoadedResource(uRL.toString());
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, n);
            if (cacheEntry != null) {
                uRL2 = URLUtil.fileToURL(new File(cacheEntry.getResourceFilename()));
            }
        } else if ((DownloadEngine.isJarContentType(n) || DownloadEngine.isPackContentType(n) || DownloadEngine.isAlwaysCached(uRL.toString().toLowerCase())) && (jarFile = DownloadEngine.downloadJarFileWithoutCache(uRL, string, string2, downloadDelegate, n)) != null) {
            MemoryCache.addLoadedResource(uRL.toString(), jarFile);
        }
        return uRL2;
    }

    static boolean isZipFile(String string) {
        return string.toLowerCase().endsWith(".zip");
    }

    public static boolean isAlwaysCached(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(".jar") || string2.endsWith(".jarjar") || string2.endsWith(".zip");
    }

    public static long getCachedLastModified(URL uRL, String string, String string2) throws IOException {
        CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false);
        if (cacheEntry != null) {
            return cacheEntry.getLastModified();
        }
        return 0L;
    }

    public static long getCachedSize(URL uRL, String string, String string2, DownloadDelegate downloadDelegate) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, false);
        if (cacheEntry != null) {
            return cacheEntry.getSize();
        }
        return 0L;
    }

    public static URL getNonCacheRedirectFinalURL(URL uRL) {
        return (URL)noCacheRedirectFinalURLs.get(uRL.toString());
    }

    public static URL getKnownRedirectFinalURL(URL uRL) {
        URL uRL2 = null;
        Object object = MemoryCache.getLoadedResource(uRL.toString());
        if (object instanceof CacheEntry) {
            CacheEntry cacheEntry = (CacheEntry)object;
            try {
                uRL2 = new URL(cacheEntry.getURL());
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
        } else {
            uRL2 = DownloadEngine.getNonCacheRedirectFinalURL(uRL);
        }
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        return uRL2;
    }

    public static void clearNoCacheJarFileList() {
        noCacheJarFileList.clear();
        noCacheRedirectFinalURLs.clear();
    }

    private static URL deriveRequestURL(URL uRL, String string, String string2, int n) {
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, string2, null, null, null, null, false, null, string2 == null ? 1 : 2);
        if (DownloadEngine.isVersionContentType(n)) {
            uRL2 = DownloadEngine.getEmbeddedVersionUrl(uRL2, string2);
        }
        if (DownloadEngine.isPackContentType(n)) {
            uRL2 = DownloadEngine.getPack200Url(uRL2);
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFile getJarFileWithoutCache(final URL uRL, String string, final String string2, final DownloadDelegate downloadDelegate, int n) throws IOException {
        Object object;
        boolean bl = DownloadEngine.isPackContentType(n);
        byte[] byArray = new byte[8192];
        URL uRL2 = DownloadEngine.deriveRequestURL(uRL, string, string2, n);
        URLConnection uRLConnection = uRL2.openConnection();
        if (DownloadEngine.isPack200Supported()) {
            uRLConnection.setRequestProperty("accept-encoding", "pack200-gzip,gzip");
        } else {
            uRLConnection.setRequestProperty("accept-encoding", "gzip");
        }
        InputStream inputStream = uRLConnection.getInputStream();
        int n2 = uRLConnection.getContentLength();
        String string3 = uRLConnection.getContentEncoding();
        int n3 = 0;
        if (downloadDelegate != null) {
            downloadDelegate.setTotalSize(n2);
        }
        HttpDownloadListener httpDownloadListener = downloadDelegate == null ? null : new HttpDownloadListener(){

            public boolean downloadProgress(int n, int n2) throws CancelException {
                downloadDelegate.downloading(uRL, string2, n, n2, false);
                return true;
            }
        };
        OutputStream outputStream = null;
        File file = null;
        boolean bl2 = false;
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", uRL2.toString(), n2, string3), TraceLevel.NETWORK);
        }
        try {
            file = File.createTempFile("jar_cache", null);
            file.deleteOnExit();
            outputStream = new FileOutputStream(file);
            int n4 = 0;
            if (bl || string3 != null && string3.equals("pack200-gzip")) {
                object = new JarOutputStream(outputStream);
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                unpacker.unpack((InputStream)new GZIPInputStream(inputStream, BUF_SIZE), (JarOutputStream)object);
                ((ZipOutputStream)object).close();
            } else {
                if (string3 != null && string3.equals("gzip")) {
                    inputStream = new GZIPInputStream(inputStream, BUF_SIZE);
                }
                int n5 = 0;
                while ((n4 = inputStream.read(byArray)) != -1) {
                    if (n5 == 0 && !DownloadEngine.isJarHeaderValid(byArray)) {
                        throw new IOException("Invalid jar file");
                    }
                    outputStream.write(byArray, 0, n4);
                    if ((n3 += n4) > n2 && n2 != 0) {
                        n3 = n2;
                    }
                    if (httpDownloadListener != null) {
                        httpDownloadListener.downloadProgress(n3, n2);
                    }
                    ++n5;
                }
            }
            bl2 = true;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (!bl2 && file != null) {
                file.delete();
                file = null;
            }
        }
        if (file == null) {
            return null;
        }
        JarFile jarFile = JarVerifier.getValidatedJarFile(file, uRL, uRL2, string2, downloadDelegate);
        noCacheJarFileList.put(uRL.toString(), file);
        object = uRLConnection.getURL();
        if (!URLUtil.sameURLs((URL)object, uRL2)) {
            noCacheRedirectFinalURLs.put(uRL.toString(), object);
        }
        return jarFile;
    }

    public static void clearTemporaryResourceMaps(URL uRL) {
        noCacheJarFileList.remove(uRL.toString());
        noCacheRedirectFinalURLs.remove(uRL.toString());
    }

    public static JarFile getCachedJarFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedJarFile(uRL, string, false, 1);
    }

    public static String getLibraryDirForJar(String string, URL uRL, String string2) throws IOException {
        Object object;
        File file = DownloadEngine.getCachedFile(uRL, string2);
        if (file == null) {
            object = null;
            object = DownloadEngine.getResourceCacheEntry(uRL, null, string2, null, true, false, null, 272);
            if (object != null) {
                file = ((CacheEntry)object).getDataFile();
            }
        }
        if (file != null) {
            object = file.getPath() + "-n";
            File file2 = new File((String)object, string);
            Trace.println("Looking up native library in: " + file2, TraceLevel.NETWORK);
            if (file2.exists()) {
                return object;
            }
        }
        return null;
    }

    public static JarFile getUpdatedJarFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedJarFile(uRL, string, true, 1);
    }

    private static JarFile getCachedJarFile(URL uRL, String string, boolean bl, int n) throws IOException {
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = null;
            cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl, n);
            if (cacheEntry != null) {
                return cacheEntry.getJarFile();
            }
        } else {
            Object object = MemoryCache.getLoadedResource(uRL.toString());
            if (object != null && object instanceof JarFile) {
                return (JarFile)object;
            }
            JarFile jarFile = null;
            File file = (File)noCacheJarFileList.get(uRL.toString());
            if (file != null) {
                URL uRL2 = DownloadEngine.deriveRequestURL(uRL, null, string, 256);
                jarFile = JarVerifier.getValidatedJarFile(file, uRL, uRL2, string, null);
            } else {
                jarFile = DownloadEngine.getJarFileWithoutCache(uRL, null, string, null, 256);
            }
            MemoryCache.addLoadedResource(uRL.toString(), jarFile);
            return jarFile;
        }
        return null;
    }

    public static File getCachedShortcutImage(URL uRL, String string) throws IOException {
        return DownloadEngine.getShortcutImage(uRL, string, false);
    }

    public static File getUpdatedShortcutImage(URL uRL, String string) throws IOException {
        return DownloadEngine.getShortcutImage(uRL, string, true);
    }

    private static File getShortcutImage(URL uRL, String string, boolean bl) throws IOException {
        CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl);
        if (cacheEntry != null) {
            cacheEntry.generateShortcutImage();
            return cacheEntry.getDataFile();
        }
        return null;
    }

    public static File getCachedFileNative(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("jar")) {
            String string = uRL.getPath();
            int n = string.indexOf("!/");
            if (n > 0) {
                try {
                    String string2;
                    String string3 = string.substring(n + 2);
                    URL uRL2 = new URL(string.substring(0, n));
                    CacheEntry cacheEntry = Cache.getCacheEntry(uRL2, null, null);
                    if (cacheEntry != null && (string2 = cacheEntry.getNativeLibPath()) != null) {
                        return new File(string2, string3);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored(malformedURLException);
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
            return null;
        }
        return DownloadEngine.getCachedFile(uRL);
    }

    public static File getCachedFile(URL uRL) throws IOException {
        return DownloadEngine.getCachedFile(uRL, null);
    }

    public static File getCachedFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedFile(uRL, string, false, false, null);
    }

    public static File getUpdatedFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getUpdatedFile(uRL, string, false, null);
    }

    public static File getUpdatedFile(URL uRL, String string, boolean bl, String string2) throws IOException {
        return DownloadEngine.getCachedFile(uRL, string, true, bl, string2);
    }

    public static File getCachedFile(URL uRL, String string, boolean bl, boolean bl2, String string2) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl, bl2, string2, 1);
        if (cacheEntry != null) {
            return cacheEntry.getDataFile();
        }
        Trace.println("Cannot get resource from cache: " + uRL, TraceLevel.CACHE);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJarFileCorrupted(URL uRL, String string) {
        ZipFile zipFile = null;
        try {
            CacheEntry cacheEntry = null;
            cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, false);
            zipFile = new JarFile(cacheEntry.getResourceFilename(), false);
            if (zipFile != null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        return true;
    }

    public static boolean isResourceCached(URL uRL, String string, String string2) throws IOException {
        return DownloadEngine.isResourceCached(uRL, string, string2, 1);
    }

    public static boolean isResourceCached(URL uRL, String string, String string2, int n) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false, n);
        return cacheEntry != null;
    }

    public static void removeCachedResource(URL uRL, String string, String string2) {
        CacheEntry cacheEntry = null;
        try {
            cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        if (cacheEntry != null) {
            Cache.removeCacheEntry(cacheEntry);
        }
    }

    public static Map getCachedHeaders(URL uRL, String string) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, false);
        if (cacheEntry != null) {
            return cacheEntry.getHeaders();
        }
        return null;
    }

    public static HttpRequest getHttpRequestImpl() {
        return _httpRequestImpl;
    }

    public static HttpDownload getHttpDownloadImpl() {
        return _httpDownloadImpl;
    }

    public static File applyPatch(File file, File file2, final URL uRL, final String string, final DownloadDelegate downloadDelegate, String string2) throws FailedDownloadException {
        JarDiffPatcher jarDiffPatcher = new JarDiffPatcher();
        File file3 = new File(string2);
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(file3);
            Patcher.PatchDelegate patchDelegate = null;
            if (downloadDelegate != null) {
                downloadDelegate.patching(uRL, string, 0);
                patchDelegate = new Patcher.PatchDelegate(){

                    public void patching(int n) throws CancelException {
                        downloadDelegate.patching(uRL, string, n);
                    }
                };
            }
            try {
                jarDiffPatcher.applyPatch(patchDelegate, file.getPath(), file2.getPath(), fileOutputStream);
            }
            catch (IOException iOException) {
                throw new FailedDownloadException(uRL, string, iOException);
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw new FailedDownloadException(uRL, string, iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (!bl) {
                file3.delete();
            }
            file2.delete();
            if (downloadDelegate != null && !bl) {
                try {
                    downloadDelegate.downloadFailed(uRL, string);
                }
                catch (CancelException cancelException) {
                    throw new FailedDownloadException(uRL, string, cancelException);
                }
            }
        }
        return file3;
    }

    public static boolean isJnlpURL(URL uRL) {
        try {
            HttpResponse httpResponse = DownloadEngine.getHttpRequestImpl().doHeadRequest(uRL);
            return httpResponse.getContentType().equals(JNLP_MIME_TYPE);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isUrlInAppContext(URL uRL) {
        String string = (String)ToolkitStore.get().getAppContext().get(APPCONTEXT_BG_KEY + uRL);
        return string != null && string.equals(BACKGROUND_STRING);
    }

    public static boolean isUpdateAvailable(URL uRL, String string) throws IOException {
        return DownloadEngine.isUpdateAvailable(uRL, string, false, null);
    }

    public static boolean isUpdateAvailable(URL uRL, String string, boolean bl) throws IOException {
        return DownloadEngine.isUpdateAvailable(uRL, string, bl, null);
    }

    public static boolean isUpdateAvailable(URL uRL, String string, boolean bl, Map map) throws IOException {
        if (UpdateTracker.isUpdated(uRL.toString())) {
            return false;
        }
        if (string != null) {
            return false;
        }
        URL uRL2 = HttpUtils.removeQueryStringFromURL(uRL);
        if (!DownloadEngine.isBackgroundThread() && DownloadEngine.isUrlInAppContext(uRL)) {
            return false;
        }
        CacheEntry cacheEntry = null;
        if (Cache.isCacheEnabled()) {
            cacheEntry = Cache.getCacheEntry(string == null ? uRL : uRL2, null, string);
        }
        if (!DownloadEngine.isValidationRequired(cacheEntry)) {
            return false;
        }
        if (!DeployOfflineManager.promptUserGoOnline(uRL)) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        if (DeployOfflineManager.isGlobalOffline()) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        if (cacheEntry == null) {
            return true;
        }
        URL uRL3 = DownloadEngine.getRequestURL(uRL, null, string, null, null, null, null, false, null, string == null ? 1 : 2);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        long l = -1L;
        l = cacheEntry.getLastModified();
        URL uRL4 = null;
        if (bl) {
            uRL4 = DownloadEngine.getPack200Url(uRL3);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (map != null) {
            stringArray = map.keySet().toArray(new String[0]);
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object v = map.get(stringArray[i]);
                if (v == null || !(v instanceof List)) continue;
                stringArray2[i] = (String)((List)v).get(0);
            }
        }
        try {
            httpResponse = httpRequest.doGetRequestEX(uRL4 != null ? uRL4 : uRL3, stringArray, stringArray2, l);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (uRL4 == null) {
                throw fileNotFoundException;
            }
            httpResponse = httpRequest.doGetRequestEX(uRL3, l);
        }
        if (httpResponse == null) {
            return true;
        }
        int n = httpResponse.getStatusCode();
        httpResponse.disconnect();
        boolean bl2 = true;
        if (n == 304) {
            bl2 = false;
        } else if (n == 200) {
            int n2 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            if (l2 == l && n2 == cacheEntry.getContentLength()) {
                bl2 = false;
            }
        }
        if (!bl2) {
            UpdateTracker.checkDone(uRL.toString());
            long l3 = httpResponse.getExpiration();
            if (l3 != 0L) {
                cacheEntry.updateExpirationInIndexFile(l3);
            }
        }
        return bl2;
    }

    private static String getVersionJarPath(String string, String string2) {
        String string3 = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(0, string.lastIndexOf("/") + 1);
        String string4 = string3;
        String string5 = null;
        if (string3.lastIndexOf(".") != -1) {
            string5 = string3.substring(string3.lastIndexOf(".") + 1);
            string3 = string3.substring(0, string3.lastIndexOf("."));
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (string2 != null) {
            stringBuffer.append("__V");
            stringBuffer.append(string2);
        }
        if (string5 != null) {
            stringBuffer.append(".");
            stringBuffer.append(string5);
        }
        string = string + stringBuffer.toString();
        return string;
    }

    private static URL getEmbeddedVersionUrl(URL uRL, String string) {
        if (string == null || string.indexOf("*") != -1 || string.indexOf("+") != -1) {
            return uRL;
        }
        URL uRL2 = null;
        String string2 = uRL.getProtocol();
        String string3 = uRL.getHost();
        int n = uRL.getPort();
        String string4 = uRL.getPath();
        string4 = DownloadEngine.getVersionJarPath(string4, string);
        try {
            uRL2 = new URL(string2, string3, n, string4);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return uRL2;
    }

    public static URL getPack200Url(URL uRL) {
        URL uRL2 = null;
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = uRL.getPath();
        String string4 = uRL.getQuery();
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.append(".pack.gz");
        if (string4 != null) {
            stringBuffer.append("?");
            stringBuffer.append(string4);
        }
        try {
            uRL2 = new URL(string, string2, n, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return uRL2;
    }

    static CacheEntry actionDownload(CacheEntry cacheEntry, final URL uRL, URL uRL2, String string, String string2, final DownloadDelegate downloadDelegate, int n, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = false;
        int n2 = -1;
        boolean bl4 = false;
        String string3 = null;
        if (cacheEntry != null && string2 != null) {
            long l;
            if (cacheEntry.getVersion() != null && new VersionString(string2).contains(new VersionID(cacheEntry.getVersion()))) {
                return cacheEntry;
            }
            if (Environment.isJavaPlugin() && (l = cacheEntry.getExpirationDate()) != 0L && new Date().after(new Date(l))) {
                cacheEntry = null;
            }
        }
        if (cacheEntry != null) {
            string3 = cacheEntry.getVersion();
        }
        CacheEntry cacheEntry2 = null;
        try {
            Object object;
            boolean bl5;
            Object object2;
            DownloadEngine.setDownloadInProgress(true);
            HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
            HttpResponse httpResponse = null;
            long l = 0L;
            if (cacheEntry != null) {
                l = cacheEntry.getLastModified();
            }
            URL uRL3 = uRL2;
            if (DownloadEngine.isVersionContentType(n)) {
                uRL3 = DownloadEngine.getEmbeddedVersionUrl(uRL3, string2);
            }
            if (DownloadEngine.isPackContentType(n)) {
                uRL3 = DownloadEngine.getPack200Url(uRL3);
            }
            try {
                try {
                    httpResponse = httpRequest.doGetRequestEX(uRL3, l);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (uRL2.toString().equals(uRL3.toString())) {
                        throw fileNotFoundException;
                    }
                    httpResponse = httpRequest.doGetRequestEX(uRL2, l);
                    bl3 = true;
                    n2 = n;
                    if (DownloadEngine.isPackContentType(n) && (DownloadEngine.isNativeContentType(n) || DownloadEngine.isJarContentType(n))) {
                        n2 &= 0xFFFFEFFF;
                    }
                    if (DownloadEngine.isVersionContentType(n)) {
                        n2 &= 0xFFFEFFFF;
                    }
                }
            }
            catch (FailedDownloadException failedDownloadException) {
                throw failedDownloadException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                httpResponse = httpRequest.doGetRequest(uRL2, false);
            }
            int n3 = httpResponse.getStatusCode();
            if (n3 == 404) {
                throw new FailedDownloadException(uRL, string2, new IOException("HTTP response 404"));
            }
            if (n3 == 304) {
                httpResponse.disconnect();
                CacheEntry cacheEntry3 = cacheEntry;
                return cacheEntry3;
            }
            int n4 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            long l3 = httpResponse.getExpiration();
            boolean bl6 = JNLP_MIME_TYPE.equals(httpResponse.getContentType());
            if (!bl6 && Environment.isImportMode() && Environment.getImportModeExpiration() != null && l3 != 0L) {
                object2 = new Date(l3);
                if (((Date)object2).before(Environment.getImportModeExpiration())) {
                    httpResponse.disconnect();
                    CacheEntry cacheEntry4 = null;
                    return cacheEntry4;
                }
            } else if (!bl6 && Environment.isImportMode() && Environment.getImportModeTimestamp() != null && l2 != 0L && ((Date)(object2 = new Date(l2))).before(Environment.getImportModeTimestamp())) {
                httpResponse.disconnect();
                CacheEntry cacheEntry5 = null;
                return cacheEntry5;
            }
            object2 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
            if (string2 != null && object2 == null && Environment.getImportModeCodebaseOverride() != null && new VersionID(string2).isSimpleVersion()) {
                object2 = string2;
            }
            if (cacheEntry != null) {
                if (object2 != null && new VersionString((String)object2).contains(string3)) {
                    httpResponse.disconnect();
                    CacheEntry cacheEntry6 = cacheEntry;
                    return cacheEntry6;
                }
                if (n4 == cacheEntry.getContentLength() && l2 == l && string3 == null) {
                    httpResponse.disconnect();
                    CacheEntry cacheEntry7 = cacheEntry;
                    return cacheEntry7;
                }
                if (string3 == null) {
                    bl4 = true;
                }
            }
            if (downloadDelegate != null) {
                downloadDelegate.setTotalSize(n4);
            }
            if (object2 == null && (Environment.isJavaPlugin() || DownloadEngine.isVersionContentType(bl3 ? n2 : n))) {
                object2 = string2;
            }
            Object object3 = object2;
            String string4 = httpResponse.getContentType();
            boolean bl7 = bl5 = string4 != null && string4.equalsIgnoreCase(JARDIFF_MIME_TYPE);
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("downloadEngine.serverResponse", String.valueOf(n4), new Date(l2).toString(), (String)object2, string4), TraceLevel.NETWORK);
            }
            if (string4 != null && string4.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                String string5 = bufferedReader.readLine();
                bufferedReader.close();
                throw new FailedDownloadException(uRL2, string2, new IOException("Error returned: " + string5));
            }
            if (object2 == null && string2 != null && !DownloadEngine.isVersionContentType(bl3 ? n2 : n)) {
                throw new FailedDownloadException(uRL, string2, new IOException("missing version response from server"));
            }
            if (object2 != null && string2 != null && !bl) {
                if (!new VersionString(string2).contains((String)object2)) {
                    throw new FailedDownloadException(uRL, string2, new IOException("bad version response from server:" + (String)object2));
                }
                object = new VersionID((String)object2);
                if (!((VersionID)object).isSimpleVersion()) {
                    throw new FailedDownloadException(uRL, string2, new IOException("bad version response from server:" + (String)object2));
                }
            }
            Object object4 = object = downloadDelegate == null ? null : new HttpDownloadListener((String)object3){
                private final /* synthetic */ String val$responseVersion;
                {
                    this.val$responseVersion = string;
                }

                public boolean downloadProgress(int n, int n2) throws CancelException {
                    downloadDelegate.downloading(uRL, this.val$responseVersion, n, n2, false);
                    return true;
                }
            };
            if (bl2 && DownloadEngine.allowCaching(httpResponse)) {
                CacheEntry cacheEntry8 = Cache.downloadResourceToCache(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, bl4, uRL2, cacheEntry, bl5, bl3 ? n2 : n);
                return cacheEntry8;
            }
            CacheEntry cacheEntry9 = Cache.downloadResourceToTempFile(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, bl4, uRL2, cacheEntry, bl5, bl3 ? n2 : n);
            cacheEntry9.setBusy(0);
            cacheEntry9.setIncomplete(1);
            cacheEntry9.updateIndexHeaderOnDisk();
            CacheEntry cacheEntry10 = cacheEntry9;
            return cacheEntry10;
        }
        catch (Exception exception) {
            if (cacheEntry2 != null) {
                Cache.removeCacheEntry(cacheEntry2);
            }
            if (exception instanceof JARSigningException) {
                throw (JARSigningException)exception;
            }
            if (exception instanceof FailedDownloadException) {
                throw (FailedDownloadException)exception;
            }
            Trace.ignored(exception);
            throw new FailedDownloadException(uRL2, string2, exception);
        }
        finally {
            DownloadEngine.setDownloadInProgress(false);
        }
    }

    private static boolean allowCaching(HttpResponse httpResponse) {
        String string;
        if (httpResponse != null && (string = httpResponse.getResponseHeader("cache-control")) != null && string.toLowerCase().indexOf("no-store") != -1) {
            Trace.println("Not caching resource due to response header: cache-control: no-store", TraceLevel.NETWORK);
            return false;
        }
        return true;
    }

    private static void addURLArgument(StringBuffer stringBuffer, String string, String string2) {
        try {
            stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append('&');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.ignoredException(unsupportedEncodingException);
        }
    }

    private static URL getRequestURL(URL uRL, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 == null && string2 != null) {
            string3 = Cache.getCacheEntryVersion(uRL, string);
        }
        if (string2 != null && n == 2) {
            DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string2);
            if (string3 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_CURRENT_VERSION_ID, string3);
            }
        }
        if (string2 != null && n == 3) {
            if (bl) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_PLATFORM_VERSION_ID, string2);
            } else {
                DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string2);
            }
            DownloadEngine.addURLArgument(stringBuffer, ARG_ARCH, Config.getOSArch());
            DownloadEngine.addURLArgument(stringBuffer, ARG_OS, Config.getOSName());
            DownloadEngine.addURLArgument(stringBuffer, ARG_LOCALE, defaultLocaleString);
            if (string7 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_KNOWN_PLATFORMS, string7);
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, '?');
        }
        try {
            if (Environment.getImportModeCodebaseOverride() != null && Environment.getImportModeCodebase() != null) {
                return new URL(Environment.getImportModeCodebaseOverride() + uRL.getFile().substring(Environment.getImportModeCodebase().getFile().length()) + stringBuffer);
            }
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + stringBuffer);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return null;
        }
    }

    public static CacheEntry getResourceTempCacheEntry(URL uRL, String string, int n) throws IOException {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, string, n);
        CacheEntry cacheEntry2 = DownloadEngine.getCacheEntry(cacheEntry, uRL, null, string, null, false, null, n, false);
        return cacheEntry2;
    }

    public static CacheEntry getCacheEntryTemp(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, String string3, int n) throws IOException {
        return DownloadEngine.getCacheEntry(null, uRL, string, string2, downloadDelegate, bl, string3, n, false);
    }

    private static CacheEntry getCacheEntry(CacheEntry cacheEntry, URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, String string3, int n) throws IOException {
        return DownloadEngine.getCacheEntry(cacheEntry, uRL, string, string2, downloadDelegate, bl, string3, n, true);
    }

    private static CacheEntry getCacheEntry(CacheEntry cacheEntry, URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, String string3, int n, boolean bl2) throws IOException {
        int n2 = 1;
        if (string3 != null) {
            n2 = 3;
        } else if (string2 != null) {
            n2 = 2;
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, string2, null, null, null, null, bl, string3, n2);
        return DownloadEngine.actionDownload(cacheEntry, uRL, uRL2, string, string2, downloadDelegate, n, bl, bl2);
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, int n) throws IOException {
        return DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, false, null, n);
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        return DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, false, null, 1);
    }

    private static boolean isValidationRequired(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return true;
        }
        boolean bl = true;
        if (!cacheEntry.isExpired()) {
            bl = false;
        }
        if (cacheEntry.isHttpNoCacheEnabled()) {
            bl = true;
        }
        return bl;
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, boolean bl2, String string3, int n) throws IOException {
        boolean bl3;
        if (!Cache.isCacheEnabled() && !bl || uRL == null) {
            return null;
        }
        CacheEntry cacheEntry = null;
        boolean bl4 = bl3 = !Cache.isCacheEnabled() || bl && DownloadEngine.isUpdateAvailable(uRL, string2, DownloadEngine.isPackContentType(n));
        if (!bl3 && (cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(uRL.toString())) != null) {
            String string4 = cacheEntry.getVersion();
            if (string2 == null && string4 == null || string2 != null && string4 != null && string4.compareTo(string2) >= 0) {
                return cacheEntry;
            }
        }
        if (Cache.isCacheEnabled()) {
            cacheEntry = Cache.getCacheEntry(uRL, string, string2, n);
        }
        if (bl && (cacheEntry == null || DownloadEngine.isValidationRequired(cacheEntry))) {
            Environment.setDownloadInitiated(true);
            cacheEntry = Cache.isCacheEnabled() ? DownloadEngine.getCacheEntry(cacheEntry, uRL, string, string2, downloadDelegate, bl2, string3, n) : DownloadEngine.getCacheEntryTemp(uRL, string, string2, downloadDelegate, bl2, string3, n);
            Trace.println("Downloaded " + uRL + ": " + cacheEntry.getResourceFilename(), TraceLevel.NETWORK);
            MemoryCache.addLoadedResource(uRL.toString(), cacheEntry);
            if (cacheEntry != null && Cache.isCacheEnabled()) {
                Cache.touch(new File(cacheEntry.getResourceFilename() + Cache.getIndexFileExtension()));
            }
        }
        return cacheEntry;
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2) {
        int n = string2 != null ? 3 : 2;
        URL uRL2 = DownloadEngine.getRequestURL(uRL, null, string, null, null, null, null, bl, string2, n);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        String string3 = null;
        try {
            httpResponse = httpRequest.doGetRequest(uRL2);
            if (httpResponse != null) {
                string3 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
                httpResponse.disconnect();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
        return string3;
    }

    static boolean isJarHeaderValid(byte[] byArray) {
        return DownloadEngine.get32(byArray, 0) == 67324752L;
    }

    private static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n) {
        return (long)DownloadEngine.get16(byArray, n) | (long)DownloadEngine.get16(byArray, n + 2) << 16;
    }

    static {
        backgroundUpdateThreadLocal = new InheritableThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
        processingState = new ThreadLocal();
        internalUse = new ThreadLocal();
        noCacheJarFileList = new Hashtable();
        noCacheRedirectFinalURLs = new Hashtable();
        _httpRequestImpl = new BasicHttpRequest();
        _httpDownloadImpl = new HttpDownloadHelper(_httpRequestImpl);
    }

    public static interface DownloadDelegate {
        public void setTotalSize(long var1);

        public void downloading(URL var1, String var2, int var3, int var4, boolean var5) throws CancelException;

        public void validating(URL var1, int var2, int var3) throws CancelException;

        public void patching(URL var1, String var2, int var3) throws CancelException;

        public void downloadFailed(URL var1, String var2) throws CancelException;
    }
}

