/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.association.utility.WinRegistryWrapper;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.WinRegistry;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public final class WinPlatform
extends Platform {
    private String _userHome;
    private String _userHomeLocal;
    private String _systemHome;
    private String _osHome;
    private String _systemExeHome;
    private static boolean _loaded = false;
    private static final String JRE_SUBKEY = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    private static final String DEPLOYMENT_SUBKEY = "SOFTWARE\\JavaSoft\\Java Web Start";
    private static final String DEPLOYMENT_CACHE_UPGRADE_SUBKEY = "SOFTWARE\\JavaSoft\\Java Web Start\\Cache Upgrade";
    private static final String JAVA_HOME = "JavaHome";
    private static String SUN_JAVA_DEPLOYMENT = "Sun" + File.separator + "Java" + File.separator + "Deployment";
    private static String FX_SUBKEY = "Software\\Oracle\\JavaFX";
    private static String FX_VALUE_PATH = "Path";

    public WinPlatform() {
        this.loadDeployNativeLib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDeployNativeLib() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (_loaded) {
                return;
            }
            String string = Environment.getDeploymentHome() + File.separator + "bin" + File.separator;
            String string2 = string + "msvcr100.dll";
            try {
                if (new File(string2).exists()) {
                    System.load(string2);
                } else {
                    string2 = string + "msvcr71.dll";
                    System.load(string2);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.ignored(unsatisfiedLinkError);
            }
            try {
                System.load(string + "deploy.dll");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.ignored(unsatisfiedLinkError);
            }
            _loaded = true;
        }
    }

    public void resetJavaHome() {
        String string;
        String string2 = WinRegistry.getString(-2147483646, "Software\\Javasoft\\Java Runtime Environment", "CurrentVersion");
        if (string2 != null && (string = WinRegistry.getString(-2147483646, "Software\\Javasoft\\Java Runtime Environment\\" + string2, JAVA_HOME)) != null) {
            Trace.println("_javaHome set to: " + string, TraceLevel.NETWORK);
            Environment.setJavaHome(string);
        }
    }

    public String escapeBackslashAndQuoteString(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public String getUserHome() {
        if (this._userHome == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
            if (string == null || string.trim().equals("")) {
                String string2 = this.getPlatformUserHome();
                string = string2 != null ? string2 : AccessController.doPrivileged(new GetPropertyAction("user.home"));
            }
            this._userHome = string + (string.endsWith(File.separator) ? "" : File.separator) + SUN_JAVA_DEPLOYMENT;
        }
        return this._userHome;
    }

    public String getLocalStorageDir() {
        String string;
        String string2;
        if (this._userHomeLocal == null && (string2 = System.getProperty("os.name").toLowerCase()).startsWith("windows xp") && (string = WinRegistryWrapper.WinRegQueryValueEx(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Local AppData")) != null) {
            this._userHomeLocal = string + File.separator + SUN_JAVA_DEPLOYMENT;
        }
        if (this._userHomeLocal == null) {
            this._userHomeLocal = this.getUserHome();
        }
        return this._userHomeLocal;
    }

    public String getDefaultSystemCache() {
        return this.getLocalStorageDir() + File.separator + "SystemCache";
    }

    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = this.getPlatformSystemHome() + File.separator + "Sun" + File.separator + "Java" + File.separator + "Deployment";
        }
        return this._systemHome;
    }

    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = this.getPlatformSystemHome();
        }
        return this._osHome;
    }

    private static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public String getSystemJavawsPath() {
        String string;
        File file;
        if (this._systemExeHome == null) {
            this._systemExeHome = this.getSystemExecutableHome();
        }
        if ((file = new File(string = this._systemExeHome + File.separator + "javaws.exe")).exists()) {
            File file2 = new File(WinPlatform.replace(string, "system32", "SysWOW64"));
            if (file2.exists()) {
                return file2.getPath();
            }
            return file.getPath();
        }
        return Environment.getJavawsCommand();
    }

    public long getSysStartupTime() {
        return System.currentTimeMillis() - this.getSysTickCount();
    }

    public String getPlatformExtension() {
        return ".exe";
    }

    public String toExecArg(String string) {
        return "\"" + string + "\"";
    }

    public String getLibraryPrefix() {
        return "";
    }

    public String getLibrarySufix() {
        return ".dll";
    }

    public boolean useAltFileSystemView() {
        return true;
    }

    public boolean systemLookAndFeelDefault() {
        return true;
    }

    public String getPlatformSpecificJavaName() {
        return "javaw.exe";
    }

    public String getSessionSpecificString() {
        return "-" + System.getProperty("os.arch");
    }

    public String getDebugJavaPath(String string) {
        return string.substring(0, string.lastIndexOf(".")).concat(".exe");
    }

    public String getMozillaUserProfileDirectory() {
        String string = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String string2 = null;
        if (string != null) {
            try {
                File file = new File(string + "\\Mozilla\\registry.dat");
                if (file.exists()) {
                    string2 = NSPreferences.getNS6UserProfileDirectory(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    public String getFireFoxUserProfileDirectory() {
        String string = WinRegistry.getString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        String string2 = null;
        if (string != null) {
            try {
                File file = new File(string + "\\Mozilla\\Firefox\\profiles.ini");
                if (file.exists()) {
                    string2 = NSPreferences.getFireFoxUserProfileDirectory(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    private static void execute(String[] stringArray, int n) {
        Process process = null;
        boolean bl = false;
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            bl = true;
        }
        int n2 = -1;
        int n3 = n / 100;
        while (!bl) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                n2 = process.exitValue();
                bl = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (--n3 != 0) continue;
                bl = true;
                process.destroy();
            }
        }
    }

    public boolean canAutoDownloadJRE() {
        return this.canBecomeAdmin();
    }

    public int getSystemShortcutIconSize(boolean bl) {
        if (bl) {
            int n = this.getDesktopIconSize();
            if (n >= 16 && n <= 64) {
                return n;
            }
            return this.isPlatformWindowsVista() ? 48 : 32;
        }
        return 16;
    }

    public Vector getInstalledJREList() {
        String string;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while ((string = WinRegistryWrapper.WinRegEnumKeyEx(-2147483646, JRE_SUBKEY, n, 255)) != null) {
            vector.add(string);
            String string2 = WinRegistryWrapper.WinRegQueryValueEx(-2147483646, "SOFTWARE\\JavaSoft\\Java Runtime Environment\\" + string, JAVA_HOME);
            if (string2 != null) {
                vector.add(string2);
            } else {
                vector.add("");
            }
            ++n;
        }
        return vector;
    }

    public Collection detectInstalledJfxRuntimes() {
        ArrayList<JfxRuntime> arrayList = new ArrayList<JfxRuntime>();
        String[] stringArray = WinRegistryWrapper.WinRegGetSubKeys(-2147483646, FX_SUBKEY, 255);
        if (null == stringArray) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JfxRuntime jfxRuntime;
            String string = WinRegistryWrapper.WinRegQueryValueEx(-2147483646, FX_SUBKEY + "\\" + stringArray[i], FX_VALUE_PATH);
            if (null == string || !(jfxRuntime = new JfxRuntime(stringArray[i], string)).isValid()) continue;
            arrayList.add(jfxRuntime);
        }
        return arrayList;
    }

    public void sendJFXPing(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        this.sendJFXPingImpl(null, string, string2, string3, string4, string5, n, string6);
    }

    public String getUserHomeOverride() {
        return System.getenv("USERPROFILE");
    }

    public void setUserHomeOverride(String string) {
        Properties properties = System.getProperties();
        properties.put("user.home", string);
    }

    public boolean samePaths(String string, String string2) {
        try {
            return new File(string.toLowerCase()).getCanonicalPath().equals(new File(string2.toLowerCase()).getCanonicalPath());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public long getNativePID() {
        return this.getPlatformPID();
    }

    public boolean isLocalInstallSupported() {
        return true;
    }

    public boolean isPlatformIconType(String string) {
        return string.toLowerCase().endsWith(".ico");
    }

    public boolean isJavaFXEnabled() {
        String string = WinRegistry.getString(-2147483646, FX_SUBKEY, "Disabled");
        return string == null || !string.equalsIgnoreCase("true");
    }

    public native boolean enableFX(boolean var1);

    public void setJavaFXEnabled(boolean bl) {
        boolean bl2 = this.enableFX(bl);
        Trace.println("enableFX(" + bl + ") returned: " + bl2, TraceLevel.BASIC);
    }

    public void storeCacheUpgradeInfo(Properties properties) {
        if (properties == null) {
            WinRegistry.deleteKey(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY);
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            WinRegistry.setStringValue(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY, string, string2);
        }
    }

    public Properties getCacheUpgradeInfo(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = WinRegistry.getString(-2147483646, DEPLOYMENT_CACHE_UPGRADE_SUBKEY, stringArray[i]);
            if (string == null) continue;
            properties.setProperty(stringArray[i], string);
        }
        return properties;
    }

    public native boolean shouldPromptForAutoCheck();

    public native void handleUserResponse(int var1);

    public native boolean canBecomeAdmin();

    public native boolean hasAdminPrivileges();

    public native int applyBrowserSettings();

    public native void initBrowserSettings();

    public native boolean getJqsSettings();

    public native void setJqsSettings(boolean var1);

    public native boolean getJavaPluginSettings();

    public native int setJavaPluginSettings(boolean var1);

    public native String getLongPathName(String var1);

    public native void onLoad(Object var1);

    public native void onSave(Object var1);

    public native long getSysTickCount();

    public native boolean showDocument(String var1);

    public native String getBrowserPath();

    public native String getBrowserHomePath();

    public native void notifyJREInstalled(String var1);

    public native boolean isNativeModalDialogUp();

    public native int getPlatformMaxCommandLineLength();

    private native boolean sendJFXPingImpl(String var1, String var2, String var3, String var4, String var5, String var6, int var7, String var8);

    public native int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public native void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public native void addRemoveProgramsRemove(String var1, boolean var2);

    public native boolean canDownloadJRE();

    public native boolean isPlatformWindowsVista();

    public native boolean isBrowserFireFox();

    private native String getPlatformUserHome();

    private native String getPlatformSystemHome();

    private native String getSystemExecutableHome();

    protected native long getPlatformPID();

    protected native int getDesktopIconSize();

    public native String getLoadedNativeLibPath(String var1);
}

