/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class JfxRuntime {
    private final String version;
    private final VersionID versionId;
    private final String path;
    public static final String RT_JAR = "lib" + File.separator + "jfxrt.jar";

    public JfxRuntime(String string, String string2) {
        this.version = string;
        this.path = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
        this.versionId = new VersionID(string);
    }

    public boolean isValid() {
        File file = new File(this.path + RT_JAR);
        return file.canRead();
    }

    public String toString() {
        return "JavaFX " + this.version + " found at " + this.path;
    }

    public String getClassPath() {
        String string = Environment.getenv("FORCED_FX_ROOT");
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("rt");
            stringBuffer.append(File.separator);
            stringBuffer.append("jfxrt.jar");
            return stringBuffer.toString();
        }
        return this.path + RT_JAR;
    }

    public URL[] getURLs() {
        URL[] uRLArray = new URL[1];
        File file = new File(this.getClassPath());
        try {
            uRLArray[0] = file.getCanonicalFile().toURI().toURL();
        }
        catch (IOException iOException) {
            Trace.printException(iOException);
            return null;
        }
        return uRLArray;
    }

    public String getNativeLibPath() {
        return this.path + "bin";
    }

    public VersionID getProductVersion() {
        return this.versionId;
    }
}

