/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.Token;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class InfixExpression
extends AstNode {
    protected AstNode left;
    protected AstNode right;
    protected int operatorPosition = -1;

    public InfixExpression() {
    }

    public InfixExpression(int n) {
        super(n);
    }

    public InfixExpression(int n, int n2) {
        super(n, n2);
    }

    public InfixExpression(int n, int n2, AstNode astNode, AstNode astNode2) {
        super(n, n2);
        this.setLeft(astNode);
        this.setRight(astNode2);
    }

    public InfixExpression(AstNode astNode, AstNode astNode2) {
        this.setLeftAndRight(astNode, astNode2);
    }

    public InfixExpression(int n, AstNode astNode, AstNode astNode2, int n2) {
        this.setType(n);
        this.setOperatorPosition(n2 - astNode.getPosition());
        this.setLeftAndRight(astNode, astNode2);
    }

    public void setLeftAndRight(AstNode astNode, AstNode astNode2) {
        this.assertNotNull(astNode);
        this.assertNotNull(astNode2);
        int n = astNode.getPosition();
        int n2 = astNode2.getPosition() + astNode2.getLength();
        this.setBounds(n, n2);
        this.setLeft(astNode);
        this.setRight(astNode2);
    }

    public int getOperator() {
        return this.getType();
    }

    public void setOperator(int n) {
        if (!Token.isValidToken(n)) {
            throw new IllegalArgumentException("Invalid token: " + n);
        }
        this.setType(n);
    }

    public AstNode getLeft() {
        return this.left;
    }

    public void setLeft(AstNode astNode) {
        this.assertNotNull(astNode);
        this.left = astNode;
        astNode.setParent(this);
    }

    public AstNode getRight() {
        return this.right;
    }

    public void setRight(AstNode astNode) {
        this.assertNotNull(astNode);
        this.right = astNode;
        astNode.setParent(this);
    }

    public int getOperatorPosition() {
        return this.operatorPosition;
    }

    public void setOperatorPosition(int n) {
        this.operatorPosition = n;
    }

    @Override
    public boolean hasSideEffects() {
        switch (this.getType()) {
            case 89: {
                return this.right != null && this.right.hasSideEffects();
            }
            case 104: 
            case 105: {
                return this.left != null && this.left.hasSideEffects() || this.right != null && this.right.hasSideEffects();
            }
        }
        return super.hasSideEffects();
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.left.toSource());
        stringBuilder.append(" ");
        stringBuilder.append(InfixExpression.operatorToString(this.getType()));
        stringBuilder.append(" ");
        stringBuilder.append(this.right.toSource());
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.left.visit(nodeVisitor);
            this.right.visit(nodeVisitor);
        }
    }
}

