/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.PaintEventDispatcher;
import sun.awt.RepaintArea;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.event.IgnorePaintEvent;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WGlobalCursorManager;
import sun.awt.windows.WKeyboardFocusManagerPeer;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.java2d.InvalidPipeException;
import sun.java2d.ScreenUpdateManager;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.Region;
import sun.util.logging.PlatformLogger;

public abstract class WComponentPeer
extends WObjectPeer
implements ComponentPeer,
DropTargetPeer {
    protected volatile long hwnd;
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.windows.WComponentPeer");
    private static final PlatformLogger shapeLog = PlatformLogger.getLogger("sun.awt.windows.shape.WComponentPeer");
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.windows.focus.WComponentPeer");
    SurfaceData surfaceData;
    private RepaintArea paintArea;
    protected Win32GraphicsConfig winGraphicsConfig;
    boolean isLayouting = false;
    boolean paintPending = false;
    int oldWidth = -1;
    int oldHeight = -1;
    private int numBackBuffers = 0;
    private VolatileImage backBuffer = null;
    private BufferCapabilities backBufferCaps = null;
    private Color foreground;
    private Color background;
    private Font font;
    int nDropTargets;
    long nativeDropTargetContext;
    public int serialNum = 0;
    private static final double BANDING_DIVISOR = 4.0;
    static final Font defaultFont = new Font("Dialog", 0, 12);
    private int updateX1;
    private int updateY1;
    private int updateX2;
    private int updateY2;
    private volatile boolean isAccelCapable = true;

    @Override
    public native boolean isObscured();

    @Override
    public boolean canDetermineObscurity() {
        return true;
    }

    public synchronized native void pShow();

    public synchronized native void hide();

    public synchronized native void enable();

    public synchronized native void disable();

    public long getHWnd() {
        return this.hwnd;
    }

    @Override
    public native Point getLocationOnScreen();

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        Dimension dimension = ((Component)this.target).getSize();
        this.oldHeight = dimension.height;
        this.oldWidth = dimension.width;
        this.pShow();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private native void reshapeNoCheck(int var1, int var2, int var3, int var4);

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.paintPending = n3 != this.oldWidth || n4 != this.oldHeight;
        if ((n5 & 0x4000) != 0) {
            this.reshapeNoCheck(n, n2, n3, n4);
        } else {
            this.reshape(n, n2, n3, n4);
        }
        if (n3 != this.oldWidth || n4 != this.oldHeight) {
            try {
                this.replaceSurfaceData();
            }
            catch (InvalidPipeException invalidPipeException) {
                // empty catch block
            }
            this.oldWidth = n3;
            this.oldHeight = n4;
        }
        ++this.serialNum;
    }

    void dynamicallyLayoutContainer() {
        Container container;
        if (log.isLoggable(500) && (container = WToolkit.getNativeContainer((Component)this.target)) != null) {
            log.fine("Assertion (parent == null) failed");
        }
        container = (Container)this.target;
        WToolkit.executeOnEventHandlerThread(container, new Runnable(){

            @Override
            public void run() {
                container.invalidate();
                container.validate();
                if (WComponentPeer.this.surfaceData instanceof D3DSurfaceData.D3DWindowSurfaceData || WComponentPeer.this.surfaceData instanceof OGLSurfaceData) {
                    try {
                        WComponentPeer.this.replaceSurfaceData();
                    }
                    catch (InvalidPipeException invalidPipeException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void paintDamagedAreaImmediately() {
        this.updateWindow();
        WToolkit.getWToolkit();
        WToolkit.flushPendingEvents();
        this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
    }

    synchronized native void updateWindow();

    @Override
    public void paint(Graphics graphics) {
        ((Component)this.target).paint(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    private native int[] createPrintedPixels(int var1, int var2, int var3, int var4, int var5);

    @Override
    public void print(Graphics graphics) {
        Component component = (Component)this.target;
        int n = component.getWidth();
        int n2 = component.getHeight();
        int n3 = (int)((double)n2 / 4.0);
        if (n3 == 0) {
            n3 = n2;
        }
        for (int i = 0; i < n2; i += n3) {
            Color color;
            int n4;
            int[] nArray;
            int n5 = i + n3 - 1;
            if (n5 >= n2) {
                n5 = n2 - 1;
            }
            if ((nArray = this.createPrintedPixels(0, i, n, n4 = n5 - i + 1, (color = component.getBackground()) == null ? 255 : color.getAlpha())) == null) continue;
            BufferedImage bufferedImage = new BufferedImage(n, n4, 2);
            bufferedImage.setRGB(0, 0, n, n4, nArray, 0, n);
            graphics.drawImage(bufferedImage, 0, i, null);
            bufferedImage.flush();
        }
        component.print(graphics);
    }

    @Override
    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        if (!(paintEvent instanceof IgnorePaintEvent)) {
            this.paintArea.add(rectangle, paintEvent.getID());
        }
        if (log.isLoggable(300)) {
            switch (paintEvent.getID()) {
                case 801: {
                    log.finest("coalescePaintEvent: UPDATE: add: x = " + rectangle.x + ", y = " + rectangle.y + ", width = " + rectangle.width + ", height = " + rectangle.height);
                    return;
                }
                case 800: {
                    log.finest("coalescePaintEvent: PAINT: add: x = " + rectangle.x + ", y = " + rectangle.y + ", width = " + rectangle.width + ", height = " + rectangle.height);
                    return;
                }
            }
        }
    }

    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    public boolean handleJavaKeyEvent(KeyEvent keyEvent) {
        return false;
    }

    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.target != mouseEvent.getSource() || ((Component)this.target).isFocusOwner() || !WKeyboardFocusManagerPeer.shouldFocusOnClick((Component)this.target)) break;
                WKeyboardFocusManagerPeer.requestFocusFor((Component)this.target, CausedFocusEvent.Cause.MOUSE_EVENT);
            }
        }
    }

    native void nativeHandleEvent(AWTEvent var1);

    @Override
    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (aWTEvent instanceof InputEvent && !((InputEvent)aWTEvent).isConsumed() && ((Component)this.target).isEnabled()) {
            if (aWTEvent instanceof MouseEvent && !(aWTEvent instanceof MouseWheelEvent)) {
                this.handleJavaMouseEvent((MouseEvent)aWTEvent);
            } else if (aWTEvent instanceof KeyEvent && this.handleJavaKeyEvent((KeyEvent)aWTEvent)) {
                return;
            }
        }
        switch (n) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
                }
                return;
            }
            case 1004: 
            case 1005: {
                this.handleJavaFocusEvent((FocusEvent)aWTEvent);
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    void handleJavaFocusEvent(FocusEvent focusEvent) {
        if (focusLog.isLoggable(400)) {
            focusLog.finer(focusEvent.toString());
        }
        this.setFocus(focusEvent.getID() == 1004);
    }

    native void setFocus(boolean var1);

    @Override
    public Dimension getMinimumSize() {
        return ((Component)this.target).getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void layout() {
    }

    public Rectangle getBounds() {
        return ((Component)this.target).getBounds();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.winGraphicsConfig != null) {
            return this.winGraphicsConfig;
        }
        return ((Component)this.target).getGraphicsConfiguration();
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    public void replaceSurfaceData() {
        this.replaceSurfaceData(this.numBackBuffers, this.backBufferCaps);
    }

    public void createScreenSurface(boolean bl) {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
        this.surfaceData = screenUpdateManager.createScreenSurface(win32GraphicsConfig, this, this.numBackBuffers, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSurfaceData(int n, BufferCapabilities bufferCapabilities) {
        SurfaceData surfaceData = null;
        VolatileImage volatileImage = null;
        Object object = ((Component)this.target).getTreeLock();
        synchronized (object) {
            WComponentPeer wComponentPeer = this;
            synchronized (wComponentPeer) {
                if (this.pData == 0L) {
                    return;
                }
                this.numBackBuffers = n;
                ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
                surfaceData = this.surfaceData;
                screenUpdateManager.dropScreenSurface(surfaceData);
                this.createScreenSurface(true);
                if (surfaceData != null) {
                    surfaceData.invalidate();
                }
                volatileImage = this.backBuffer;
                if (this.numBackBuffers > 0) {
                    this.backBufferCaps = bufferCapabilities;
                    Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
                    this.backBuffer = win32GraphicsConfig.createBackBuffer(this);
                } else if (this.backBuffer != null) {
                    this.backBufferCaps = null;
                    this.backBuffer = null;
                }
            }
        }
        if (surfaceData != null) {
            surfaceData.flush();
            surfaceData = null;
        }
        if (volatileImage != null) {
            volatileImage.flush();
            surfaceData = null;
        }
    }

    public void replaceSurfaceDataLater() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!WComponentPeer.this.isDisposed()) {
                    try {
                        WComponentPeer.this.replaceSurfaceData();
                    }
                    catch (InvalidPipeException invalidPipeException) {
                        // empty catch block
                    }
                }
            }
        };
        if (!PaintEventDispatcher.getPaintEventDispatcher().queueSurfaceDataReplacing((Component)this.target, runnable)) {
            this.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
        }
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        this.winGraphicsConfig = (Win32GraphicsConfig)graphicsConfiguration;
        try {
            this.replaceSurfaceData();
        }
        catch (InvalidPipeException invalidPipeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return null;
    }

    public ColorModel getDeviceColorModel() {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig.getDeviceColorModel();
        }
        return null;
    }

    public ColorModel getColorModel(int n) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel(n);
        }
        return null;
    }

    @Override
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    @Override
    public Graphics getGraphics() {
        Object object;
        if (this.isDisposed()) {
            return null;
        }
        Component component = (Component)this.getTarget();
        Window window = SunToolkit.getContainingWindow(component);
        if (window != null && (object = ((WWindowPeer)window.getPeer()).getTranslucentGraphics()) != null) {
            int n = 0;
            int n2 = 0;
            for (Component component2 = component; component2 != window; component2 = component2.getParent()) {
                n += component2.getX();
                n2 += component2.getY();
            }
            ((Graphics)object).translate(n, n2);
            ((Graphics)object).clipRect(0, 0, component.getWidth(), component.getHeight());
            return object;
        }
        object = this.surfaceData;
        if (object != null) {
            Font font;
            Color color;
            Color color2 = this.background;
            if (color2 == null) {
                color2 = SystemColor.window;
            }
            if ((color = this.foreground) == null) {
                color = SystemColor.windowText;
            }
            if ((font = this.font) == null) {
                font = defaultFont;
            }
            ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
            return screenUpdateManager.createGraphics((SurfaceData)object, this, color, color2, font);
        }
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    private synchronized native void _dispose();

    @Override
    protected void disposeImpl() {
        SurfaceData surfaceData = this.surfaceData;
        this.surfaceData = null;
        ScreenUpdateManager.getInstance().dropScreenSurface(surfaceData);
        surfaceData.invalidate();
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public void disposeLater() {
        this.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), new Runnable(){

            @Override
            public void run() {
                WComponentPeer.this.dispose();
            }
        }));
    }

    @Override
    public synchronized void setForeground(Color color) {
        this.foreground = color;
        this._setForeground(color.getRGB());
    }

    @Override
    public synchronized void setBackground(Color color) {
        this.background = color;
        this._setBackground(color.getRGB());
    }

    public Color getBackgroundNoSync() {
        return this.background;
    }

    public native void _setForeground(int var1);

    public native void _setBackground(int var1);

    @Override
    public synchronized void setFont(Font font) {
        this.font = font;
        this._setFont(font);
    }

    public synchronized native void _setFont(Font var1);

    @Override
    public final void updateCursorImmediately() {
        WGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    @Override
    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        if (WKeyboardFocusManagerPeer.processSynchronousLightweightTransfer((Component)this.target, component, bl, bl2, l)) {
            return true;
        }
        int n = WKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight((Component)this.target, component, bl, bl2, l, cause);
        switch (n) {
            case 0: {
                return false;
            }
            case 2: {
                Window window;
                if (focusLog.isLoggable(400)) {
                    focusLog.finer("Proceeding with request to " + component + " in " + this.target);
                }
                if ((window = SunToolkit.getContainingWindow((Component)this.target)) == null) {
                    return this.rejectFocusRequestHelper("WARNING: Parent window is null");
                }
                WWindowPeer wWindowPeer = (WWindowPeer)window.getPeer();
                if (wWindowPeer == null) {
                    return this.rejectFocusRequestHelper("WARNING: Parent window's peer is null");
                }
                boolean bl3 = wWindowPeer.requestWindowFocus(cause);
                if (focusLog.isLoggable(400)) {
                    focusLog.finer("Requested window focus: " + bl3);
                }
                if (!bl3 || !window.isFocused()) {
                    return this.rejectFocusRequestHelper("Waiting for asynchronous processing of the request");
                }
                return WKeyboardFocusManagerPeer.deliverFocus(component, (Component)this.target, bl, bl2, l, cause);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private boolean rejectFocusRequestHelper(String string) {
        if (focusLog.isLoggable(400)) {
            focusLog.finer(string);
        }
        WKeyboardFocusManagerPeer.removeLastFocusRequest((Component)this.target);
        return false;
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    @Override
    public Image createImage(int n, int n2) {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        return win32GraphicsConfig.createAcceleratedImage((Component)this.target, n, n2);
    }

    @Override
    public VolatileImage createVolatileImage(int n, int n2) {
        return new SunVolatileImage((Component)this.target, n, n2);
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    WComponentPeer(Component component) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = WToolkit.getNativeContainer(component);
        WComponentPeer wComponentPeer = (WComponentPeer)WToolkit.targetToPeer(container);
        this.create(wComponentPeer);
        this.checkCreation();
        this.createScreenSurface(false);
        this.initialize();
        this.start();
    }

    abstract void create(WComponentPeer var1);

    protected void checkCreation() {
        if (this.hwnd == 0L || this.pData == 0L) {
            if (this.createError != null) {
                throw this.createError;
            }
            throw new InternalError("couldn't create component peer");
        }
    }

    synchronized native void start();

    void initialize() {
        Font font;
        Color color;
        if (((Component)this.target).isVisible()) {
            this.show();
        }
        if ((color = ((Component)this.target).getForeground()) != null) {
            this.setForeground(color);
        }
        if ((font = ((Component)this.target).getFont()) != null) {
            this.setFont(font);
        }
        if (!((Component)this.target).isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = ((Component)this.target).getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 3);
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        this.postPaintIfNecessary(n, n2, n3, n4);
    }

    public void handlePaint(int n, int n2, int n3, int n4) {
        this.postPaintIfNecessary(n, n2, n3, n4);
    }

    private void postPaintIfNecessary(int n, int n2, int n3, int n4) {
        PaintEvent paintEvent;
        if (!AWTAccessor.getComponentAccessor().getIgnoreRepaint((Component)this.target) && (paintEvent = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent((Component)this.target, n, n2, n3, n4)) != null) {
            this.postEvent(paintEvent);
        }
    }

    void postEvent(AWTEvent aWTEvent) {
        this.preprocessPostEvent(aWTEvent);
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), aWTEvent);
    }

    void preprocessPostEvent(AWTEvent aWTEvent) {
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintArea.isEmpty() || this.paintPending || ((Component)this.target).getIgnoreRepaint())) {
            this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public native void beginValidate();

    public native void endValidate();

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    @Override
    public synchronized void addDropTarget(DropTarget dropTarget) {
        if (this.nDropTargets == 0) {
            this.nativeDropTargetContext = this.addNativeDropTarget();
        }
        ++this.nDropTargets;
    }

    @Override
    public synchronized void removeDropTarget(DropTarget dropTarget) {
        --this.nDropTargets;
        if (this.nDropTargets == 0) {
            this.removeNativeDropTarget();
            this.nativeDropTargetContext = 0L;
        }
    }

    native long addNativeDropTarget();

    native void removeNativeDropTarget();

    native boolean nativeHandlesWheelScrolling();

    @Override
    public boolean handlesWheelScrolling() {
        return this.nativeHandlesWheelScrolling();
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    @Override
    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        win32GraphicsConfig.assertOperationSupported((Component)this.target, n, bufferCapabilities);
        try {
            this.replaceSurfaceData(n - 1, bufferCapabilities);
        }
        catch (InvalidPipeException invalidPipeException) {
            throw new AWTException(invalidPipeException.getMessage());
        }
    }

    @Override
    public void destroyBuffers() {
        this.replaceSurfaceData(0, null);
    }

    @Override
    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        VolatileImage volatileImage = this.backBuffer;
        if (volatileImage == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        win32GraphicsConfig.flip(this, (Component)this.target, volatileImage, n, n2, n3, n4, flipContents);
    }

    @Override
    public synchronized Image getBackBuffer() {
        VolatileImage volatileImage = this.backBuffer;
        if (volatileImage == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return volatileImage;
    }

    public BufferCapabilities getBackBufferCaps() {
        return this.backBufferCaps;
    }

    public int getBackBuffersNum() {
        return this.numBackBuffers;
    }

    public boolean shouldClearRectBeforePaint() {
        return true;
    }

    native void pSetParent(ComponentPeer var1);

    @Override
    public void reparent(ContainerPeer containerPeer) {
        this.pSetParent(containerPeer);
    }

    @Override
    public boolean isReparentSupported() {
        return true;
    }

    public void setBoundsOperation(int n) {
    }

    public boolean isAccelCapable() {
        if (!this.isAccelCapable || !WComponentPeer.isContainingTopLevelAccelCapable((Component)this.target)) {
            return false;
        }
        boolean bl = SunToolkit.isContainingTopLevelTranslucent((Component)this.target);
        return !bl || Win32GraphicsEnvironment.isVistaOS();
    }

    public void disableAcceleration() {
        this.isAccelCapable = false;
    }

    native void setRectangularShape(int var1, int var2, int var3, int var4, Region var5);

    private static final boolean isContainingTopLevelAccelCapable(Component component) {
        while (component != null && !(component instanceof WEmbeddedFrame)) {
            component = component.getParent();
        }
        if (component == null) {
            return true;
        }
        return ((WEmbeddedFramePeer)component.getPeer()).isAccelCapable();
    }

    @Override
    public void applyShape(Region region) {
        if (shapeLog.isLoggable(400)) {
            shapeLog.finer("*** INFO: Setting shape: PEER: " + this + "; TARGET: " + this.target + "; SHAPE: " + region);
        }
        if (region != null) {
            this.setRectangularShape(region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), region.isRectangular() ? null : region);
        } else {
            this.setRectangularShape(0, 0, 0, 0, null);
        }
    }

    @Override
    public void setZOrder(ComponentPeer componentPeer) {
        long l = componentPeer != null ? ((WComponentPeer)componentPeer).getHWnd() : 0L;
        this.setZOrder(l);
    }

    private native void setZOrder(long var1);
}

