/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;

public class GroupLayout
implements LayoutManager2 {
    private static final int MIN_SIZE = 0;
    private static final int PREF_SIZE = 1;
    private static final int MAX_SIZE = 2;
    private static final int SPECIFIC_SIZE = 3;
    private static final int UNSET = Integer.MIN_VALUE;
    public static final int DEFAULT_SIZE = -1;
    public static final int PREFERRED_SIZE = -2;
    private boolean autocreatePadding;
    private boolean autocreateContainerPadding;
    private Group horizontalGroup;
    private Group verticalGroup;
    private Map<Component, ComponentInfo> componentInfos;
    private Container host;
    private Set<Spring> tmpParallelSet;
    private boolean springsChanged;
    private boolean isValid;
    private boolean hasPreferredPaddingSprings;
    private LayoutStyle layoutStyle;
    private boolean honorsVisibility;

    private static void checkSize(int n, int n2, int n3, boolean bl) {
        GroupLayout.checkResizeType(n, bl);
        if (!bl && n2 < 0) {
            throw new IllegalArgumentException("Pref must be >= 0");
        }
        if (bl) {
            GroupLayout.checkResizeType(n2, true);
        }
        GroupLayout.checkResizeType(n3, bl);
        GroupLayout.checkLessThan(n, n2);
        GroupLayout.checkLessThan(n2, n3);
    }

    private static void checkResizeType(int n, boolean bl) {
        if (n < 0 && (bl && n != -1 && n != -2 || !bl && n != -2)) {
            throw new IllegalArgumentException("Invalid size");
        }
    }

    private static void checkLessThan(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n > n2) {
            throw new IllegalArgumentException("Following is not met: min<=pref<=max");
        }
    }

    public GroupLayout(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Container must be non-null");
        }
        this.honorsVisibility = true;
        this.host = container;
        this.setHorizontalGroup(this.createParallelGroup(Alignment.LEADING, true));
        this.setVerticalGroup(this.createParallelGroup(Alignment.LEADING, true));
        this.componentInfos = new HashMap<Component, ComponentInfo>();
        this.tmpParallelSet = new HashSet<Spring>();
    }

    public void setHonorsVisibility(boolean bl) {
        if (this.honorsVisibility != bl) {
            this.honorsVisibility = bl;
            this.springsChanged = true;
            this.isValid = false;
            this.invalidateHost();
        }
    }

    public boolean getHonorsVisibility() {
        return this.honorsVisibility;
    }

    public void setHonorsVisibility(Component component, Boolean bl) {
        if (component == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        this.getComponentInfo(component).setHonorsVisibility(bl);
        this.springsChanged = true;
        this.isValid = false;
        this.invalidateHost();
    }

    public void setAutoCreateGaps(boolean bl) {
        if (this.autocreatePadding != bl) {
            this.autocreatePadding = bl;
            this.invalidateHost();
        }
    }

    public boolean getAutoCreateGaps() {
        return this.autocreatePadding;
    }

    public void setAutoCreateContainerGaps(boolean bl) {
        if (this.autocreateContainerPadding != bl) {
            this.autocreateContainerPadding = bl;
            this.horizontalGroup = this.createTopLevelGroup(this.getHorizontalGroup());
            this.verticalGroup = this.createTopLevelGroup(this.getVerticalGroup());
            this.invalidateHost();
        }
    }

    public boolean getAutoCreateContainerGaps() {
        return this.autocreateContainerPadding;
    }

    public void setHorizontalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.horizontalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    private Group getHorizontalGroup() {
        int n = 0;
        if (this.horizontalGroup.springs.size() > 1) {
            n = 1;
        }
        return (Group)this.horizontalGroup.springs.get(n);
    }

    public void setVerticalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.verticalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    private Group getVerticalGroup() {
        int n = 0;
        if (this.verticalGroup.springs.size() > 1) {
            n = 1;
        }
        return (Group)this.verticalGroup.springs.get(n);
    }

    private Group createTopLevelGroup(Group group) {
        SequentialGroup sequentialGroup = this.createSequentialGroup();
        if (this.getAutoCreateContainerGaps()) {
            sequentialGroup.addSpring(new ContainerAutoPreferredGapSpring());
            sequentialGroup.addGroup(group);
            sequentialGroup.addSpring(new ContainerAutoPreferredGapSpring());
        } else {
            sequentialGroup.addGroup(group);
        }
        return sequentialGroup;
    }

    public SequentialGroup createSequentialGroup() {
        return new SequentialGroup();
    }

    public ParallelGroup createParallelGroup() {
        return this.createParallelGroup(Alignment.LEADING);
    }

    public ParallelGroup createParallelGroup(Alignment alignment) {
        return this.createParallelGroup(alignment, true);
    }

    public ParallelGroup createParallelGroup(Alignment alignment, boolean bl) {
        if (alignment == null) {
            throw new IllegalArgumentException("alignment must be non null");
        }
        if (alignment == Alignment.BASELINE) {
            return new BaselineGroup(bl);
        }
        return new ParallelGroup(alignment, bl);
    }

    public ParallelGroup createBaselineGroup(boolean bl, boolean bl2) {
        return new BaselineGroup(bl, bl2);
    }

    public void linkSize(Component ... componentArray) {
        this.linkSize(0, componentArray);
        this.linkSize(1, componentArray);
    }

    public void linkSize(int n, Component ... componentArray) {
        Object object;
        int n2;
        if (componentArray == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        for (n2 = componentArray.length - 1; n2 >= 0; --n2) {
            object = componentArray[n2];
            if (componentArray[n2] == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.getComponentInfo((Component)object);
        }
        if (n == 0) {
            n2 = 0;
        } else if (n == 1) {
            n2 = 1;
        } else {
            throw new IllegalArgumentException("Axis must be one of SwingConstants.HORIZONTAL or SwingConstants.VERTICAL");
        }
        object = this.getComponentInfo(componentArray[componentArray.length - 1]).getLinkInfo(n2);
        for (int i = componentArray.length - 2; i >= 0; --i) {
            ((LinkInfo)object).add(this.getComponentInfo(componentArray[i]));
        }
        this.invalidateHost();
    }

    public void replace(Component component, Component component2) {
        ComponentInfo componentInfo;
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 0);
            this.registerComponents(this.verticalGroup, 1);
        }
        if ((componentInfo = this.componentInfos.remove(component)) == null) {
            throw new IllegalArgumentException("Component must already exist");
        }
        this.host.remove(component);
        if (component2.getParent() != this.host) {
            this.host.add(component2);
        }
        componentInfo.setComponent(component2);
        this.componentInfos.put(component2, componentInfo);
        this.invalidateHost();
    }

    public void setLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyle = layoutStyle;
        this.invalidateHost();
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    private LayoutStyle getLayoutStyle0() {
        LayoutStyle layoutStyle = this.getLayoutStyle();
        if (layoutStyle == null) {
            layoutStyle = LayoutStyle.getInstance();
        }
        return layoutStyle;
    }

    private void invalidateHost() {
        if (this.host instanceof JComponent) {
            ((JComponent)this.host).revalidate();
        } else {
            this.host.invalidate();
        }
        this.host.repaint();
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        ComponentInfo componentInfo = this.componentInfos.remove(component);
        if (componentInfo != null) {
            componentInfo.dispose();
            this.springsChanged = true;
            this.isValid = false;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(1);
        return this.adjustSize(this.horizontalGroup.getPreferredSize(0), this.verticalGroup.getPreferredSize(1));
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(0);
        return this.adjustSize(this.horizontalGroup.getMinimumSize(0), this.verticalGroup.getMinimumSize(1));
    }

    @Override
    public void layoutContainer(Container container) {
        this.prepare(3);
        Insets insets = container.getInsets();
        int n = container.getWidth() - insets.left - insets.right;
        int n2 = container.getHeight() - insets.top - insets.bottom;
        boolean bl = this.isLeftToRight();
        if (this.getAutoCreateGaps() || this.getAutoCreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.calculateAutopadding(this.horizontalGroup, 0, 3, 0, n);
            this.calculateAutopadding(this.verticalGroup, 1, 3, 0, n2);
        }
        this.horizontalGroup.setSize(0, 0, n);
        this.verticalGroup.setSize(1, 0, n2);
        for (ComponentInfo componentInfo : this.componentInfos.values()) {
            componentInfo.setBounds(insets, n, bl);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(2);
        return this.adjustSize(this.horizontalGroup.getMaximumSize(0), this.verticalGroup.getMaximumSize(1));
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        this.checkParent(container);
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        this.checkParent(container);
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateLayout(Container container) {
        this.checkParent(container);
        Object object = container.getTreeLock();
        synchronized (object) {
            this.isValid = false;
        }
    }

    private void prepare(int n) {
        boolean bl = false;
        if (!this.isValid) {
            this.isValid = true;
            this.horizontalGroup.setSize(0, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.verticalGroup.setSize(1, Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (ComponentInfo componentInfo : this.componentInfos.values()) {
                if (componentInfo.updateVisibility()) {
                    bl = true;
                }
                componentInfo.clearCachedSize();
            }
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 0);
            this.registerComponents(this.verticalGroup, 1);
        }
        if (this.springsChanged || bl) {
            this.checkComponents();
            this.horizontalGroup.removeAutopadding();
            this.verticalGroup.removeAutopadding();
            if (this.getAutoCreateGaps()) {
                this.insertAutopadding(true);
            } else if (this.hasPreferredPaddingSprings || this.getAutoCreateContainerGaps()) {
                this.insertAutopadding(false);
            }
            this.springsChanged = false;
        }
        if (n != 3 && (this.getAutoCreateGaps() || this.getAutoCreateContainerGaps() || this.hasPreferredPaddingSprings)) {
            this.calculateAutopadding(this.horizontalGroup, 0, n, 0, 0);
            this.calculateAutopadding(this.verticalGroup, 1, n, 0, 0);
        }
    }

    private void calculateAutopadding(Group group, int n, int n2, int n3, int n4) {
        group.unsetAutopadding();
        switch (n2) {
            case 0: {
                n4 = group.getMinimumSize(n);
                break;
            }
            case 1: {
                n4 = group.getPreferredSize(n);
                break;
            }
            case 2: {
                n4 = group.getMaximumSize(n);
                break;
            }
        }
        group.setSize(n, n3, n4);
        group.calculateAutopadding(n);
    }

    private void checkComponents() {
        for (ComponentInfo componentInfo : this.componentInfos.values()) {
            if (componentInfo.horizontalSpring == null) {
                throw new IllegalStateException(componentInfo.component + " is not attached to a horizontal group");
            }
            if (componentInfo.verticalSpring != null) continue;
            throw new IllegalStateException(componentInfo.component + " is not attached to a vertical group");
        }
    }

    private void registerComponents(Group group, int n) {
        List<Spring> list = group.springs;
        for (int i = list.size() - 1; i >= 0; --i) {
            Spring spring = list.get(i);
            if (spring instanceof ComponentSpring) {
                ((ComponentSpring)spring).installIfNecessary(n);
                continue;
            }
            if (!(spring instanceof Group)) continue;
            this.registerComponents((Group)spring, n);
        }
    }

    private Dimension adjustSize(int n, int n2) {
        Insets insets = this.host.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    private void checkParent(Container container) {
        if (container != this.host) {
            throw new IllegalArgumentException("GroupLayout can only be used with one Container at a time");
        }
    }

    private ComponentInfo getComponentInfo(Component component) {
        ComponentInfo componentInfo = this.componentInfos.get(component);
        if (componentInfo == null) {
            componentInfo = new ComponentInfo(component);
            this.componentInfos.put(component, componentInfo);
            if (component.getParent() != this.host) {
                this.host.add(component);
            }
        }
        return componentInfo;
    }

    private void insertAutopadding(boolean bl) {
        this.horizontalGroup.insertAutopadding(0, new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<ComponentSpring>(1), new ArrayList<ComponentSpring>(1), bl);
        this.verticalGroup.insertAutopadding(1, new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<ComponentSpring>(1), new ArrayList<ComponentSpring>(1), bl);
    }

    private boolean areParallelSiblings(Component component, Component component2, int n) {
        Spring spring;
        ComponentSpring componentSpring;
        ComponentSpring componentSpring2;
        ComponentInfo componentInfo = this.getComponentInfo(component);
        ComponentInfo componentInfo2 = this.getComponentInfo(component2);
        if (n == 0) {
            componentSpring2 = componentInfo.horizontalSpring;
            componentSpring = componentInfo2.horizontalSpring;
        } else {
            componentSpring2 = componentInfo.verticalSpring;
            componentSpring = componentInfo2.verticalSpring;
        }
        Set<Spring> set = this.tmpParallelSet;
        set.clear();
        for (spring = componentSpring2.getParent(); spring != null; spring = spring.getParent()) {
            set.add(spring);
        }
        for (spring = componentSpring.getParent(); spring != null; spring = spring.getParent()) {
            if (!set.contains(spring)) continue;
            set.clear();
            while (spring != null) {
                if (spring instanceof ParallelGroup) {
                    return true;
                }
                spring = spring.getParent();
            }
            return false;
        }
        set.clear();
        return false;
    }

    private boolean isLeftToRight() {
        return this.host.getComponentOrientation().isLeftToRight();
    }

    public String toString() {
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 0);
            this.registerComponents(this.verticalGroup, 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HORIZONTAL\n");
        this.createSpringDescription(stringBuffer, this.horizontalGroup, "  ", 0);
        stringBuffer.append("\nVERTICAL\n");
        this.createSpringDescription(stringBuffer, this.verticalGroup, "  ", 1);
        return stringBuffer.toString();
    }

    private void createSpringDescription(StringBuffer stringBuffer, Spring spring, String string, int n) {
        Object object;
        String string2 = "";
        String string3 = "";
        if (spring instanceof ComponentSpring) {
            object = (ComponentSpring)spring;
            string2 = Integer.toString(((ComponentSpring)object).getOrigin()) + " ";
            String string4 = ((ComponentSpring)object).getComponent().getName();
            if (string4 != null) {
                string2 = "name=" + string4 + ", ";
            }
        }
        if (spring instanceof AutoPreferredGapSpring) {
            object = (AutoPreferredGapSpring)spring;
            string3 = ", userCreated=" + ((AutoPreferredGapSpring)object).getUserCreated() + ", matches=" + ((AutoPreferredGapSpring)object).getMatchDescription();
        }
        stringBuffer.append(string + spring.getClass().getName() + " " + Integer.toHexString(spring.hashCode()) + " " + string2 + ", size=" + spring.getSize() + ", alignment=" + (Object)((Object)spring.getAlignment()) + " prefs=[" + spring.getMinimumSize(n) + " " + spring.getPreferredSize(n) + " " + spring.getMaximumSize(n) + string3 + "]\n");
        if (spring instanceof Group) {
            object = ((Group)spring).springs;
            string = string + "  ";
            for (int i = 0; i < object.size(); ++i) {
                this.createSpringDescription(stringBuffer, (Spring)object.get(i), string, n);
            }
        }
    }

    public static enum Alignment {
        LEADING,
        TRAILING,
        CENTER,
        BASELINE;

    }

    private static final class AutoPreferredGapMatch {
        public final ComponentSpring source;
        public final ComponentSpring target;

        AutoPreferredGapMatch(ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            this.source = componentSpring;
            this.target = componentSpring2;
        }

        private String toString(ComponentSpring componentSpring) {
            return componentSpring.getComponent().getName();
        }

        public String toString() {
            return "[" + this.toString(this.source) + "-" + this.toString(this.target) + "]";
        }
    }

    private class AutoPreferredGapSpring
    extends Spring {
        List<ComponentSpring> sources;
        ComponentSpring source;
        private List<AutoPreferredGapMatch> matches;
        int size;
        int lastSize;
        private final int pref;
        private final int max;
        private LayoutStyle.ComponentPlacement type;
        private boolean userCreated;

        private AutoPreferredGapSpring() {
            this.pref = -2;
            this.max = -2;
            this.type = LayoutStyle.ComponentPlacement.RELATED;
        }

        AutoPreferredGapSpring(int n, int n2) {
            this.pref = n;
            this.max = n2;
        }

        AutoPreferredGapSpring(LayoutStyle.ComponentPlacement componentPlacement, int n, int n2) {
            this.type = componentPlacement;
            this.pref = n;
            this.max = n2;
            this.userCreated = true;
        }

        public void setSource(ComponentSpring componentSpring) {
            this.source = componentSpring;
        }

        public void setSources(List<ComponentSpring> list) {
            this.sources = new ArrayList<ComponentSpring>(list);
        }

        public void setUserCreated(boolean bl) {
            this.userCreated = bl;
        }

        public boolean getUserCreated() {
            return this.userCreated;
        }

        @Override
        void unset() {
            this.lastSize = this.getSize();
            super.unset();
            this.size = 0;
        }

        public void reset() {
            this.size = 0;
            this.sources = null;
            this.source = null;
            this.matches = null;
        }

        public void calculatePadding(int n) {
            this.size = Integer.MIN_VALUE;
            int n2 = Integer.MIN_VALUE;
            if (this.matches != null) {
                LayoutStyle layoutStyle = GroupLayout.this.getLayoutStyle0();
                int n3 = n == 0 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                for (int i = this.matches.size() - 1; i >= 0; --i) {
                    AutoPreferredGapMatch autoPreferredGapMatch = this.matches.get(i);
                    n2 = Math.max(n2, this.calculatePadding(layoutStyle, n3, autoPreferredGapMatch.source, autoPreferredGapMatch.target));
                }
            }
            if (this.size == Integer.MIN_VALUE) {
                this.size = 0;
            }
            if (n2 == Integer.MIN_VALUE) {
                n2 = 0;
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(n2, this.lastSize);
            }
        }

        private int calculatePadding(LayoutStyle layoutStyle, int n, ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            int n2 = componentSpring2.getOrigin() - (componentSpring.getOrigin() + componentSpring.getSize());
            if (n2 >= 0) {
                int n3 = componentSpring.getComponent() instanceof JComponent && componentSpring2.getComponent() instanceof JComponent ? layoutStyle.getPreferredGap((JComponent)componentSpring.getComponent(), (JComponent)componentSpring2.getComponent(), this.type, n, GroupLayout.this.host) : 10;
                if (n3 > n2) {
                    this.size = Math.max(this.size, n3 - n2);
                }
                return n3;
            }
            return 0;
        }

        public void addTarget(ComponentSpring componentSpring, int n) {
            int n2;
            int n3 = n2 = n == 0 ? 1 : 0;
            if (this.source != null) {
                if (GroupLayout.this.areParallelSiblings(this.source.getComponent(), componentSpring.getComponent(), n2)) {
                    this.addValidTarget(this.source, componentSpring);
                }
            } else {
                Component component = componentSpring.getComponent();
                for (int i = this.sources.size() - 1; i >= 0; --i) {
                    ComponentSpring componentSpring2 = this.sources.get(i);
                    if (!GroupLayout.this.areParallelSiblings(componentSpring2.getComponent(), component, n2)) continue;
                    this.addValidTarget(componentSpring2, componentSpring);
                }
            }
        }

        private void addValidTarget(ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            if (this.matches == null) {
                this.matches = new ArrayList<AutoPreferredGapMatch>(1);
            }
            this.matches.add(new AutoPreferredGapMatch(componentSpring, componentSpring2));
        }

        @Override
        int calculateMinimumSize(int n) {
            return this.size;
        }

        @Override
        int calculatePreferredSize(int n) {
            if (this.pref == -2 || this.pref == -1) {
                return this.size;
            }
            return Math.max(this.size, this.pref);
        }

        @Override
        int calculateMaximumSize(int n) {
            if (this.max >= 0) {
                return Math.max(this.getPreferredSize(n), this.max);
            }
            return this.size;
        }

        String getMatchDescription() {
            return this.matches == null ? "" : this.matches.toString();
        }

        public String toString() {
            return super.toString() + this.getMatchDescription();
        }

        @Override
        boolean willHaveZeroSize(boolean bl) {
            return bl;
        }
    }

    private class BaselineGroup
    extends ParallelGroup {
        private boolean allSpringsHaveBaseline;
        private int prefAscent;
        private int prefDescent;
        private boolean baselineAnchorSet;
        private boolean baselineAnchoredToTop;
        private boolean calcedBaseline;

        BaselineGroup(boolean bl) {
            super(Alignment.LEADING, bl);
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        BaselineGroup(boolean bl, boolean bl2) {
            this(bl);
            this.baselineAnchoredToTop = bl2;
            this.baselineAnchorSet = true;
        }

        @Override
        void unset() {
            super.unset();
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        @Override
        void setValidSize(int n, int n2, int n3) {
            this.checkAxis(n);
            if (this.prefAscent == -1) {
                super.setValidSize(n, n2, n3);
            } else {
                this.baselineLayout(n2, n3);
            }
        }

        @Override
        int calculateSize(int n, int n2) {
            this.checkAxis(n);
            if (!this.calcedBaseline) {
                this.calculateBaselineAndResizeBehavior();
            }
            if (n2 == 0) {
                return this.calculateMinSize();
            }
            if (n2 == 2) {
                return this.calculateMaxSize();
            }
            if (this.allSpringsHaveBaseline) {
                return this.prefAscent + this.prefDescent;
            }
            return Math.max(this.prefAscent + this.prefDescent, super.calculateSize(n, n2));
        }

        private void calculateBaselineAndResizeBehavior() {
            this.prefAscent = 0;
            this.prefDescent = 0;
            int n = 0;
            Component.BaselineResizeBehavior baselineResizeBehavior = null;
            for (Spring spring : this.springs) {
                int n2;
                if (spring.getAlignment() != null && spring.getAlignment() != Alignment.BASELINE || (n2 = spring.getBaseline()) < 0) continue;
                if (spring.isResizable(1)) {
                    Component.BaselineResizeBehavior baselineResizeBehavior2 = spring.getBaselineResizeBehavior();
                    if (baselineResizeBehavior == null) {
                        baselineResizeBehavior = baselineResizeBehavior2;
                    } else if (baselineResizeBehavior2 != baselineResizeBehavior) {
                        baselineResizeBehavior = Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                    }
                }
                this.prefAscent = Math.max(this.prefAscent, n2);
                this.prefDescent = Math.max(this.prefDescent, spring.getPreferredSize(1) - n2);
                ++n;
            }
            if (!this.baselineAnchorSet) {
                this.baselineAnchoredToTop = baselineResizeBehavior != Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
            this.allSpringsHaveBaseline = n == this.springs.size();
            this.calcedBaseline = true;
        }

        private int calculateMaxSize() {
            int n = this.prefAscent;
            int n2 = this.prefDescent;
            int n3 = 0;
            for (Spring spring : this.springs) {
                int n4;
                int n5 = spring.getMaximumSize(1);
                if ((spring.getAlignment() == null || spring.getAlignment() == Alignment.BASELINE) && (n4 = spring.getBaseline()) >= 0) {
                    int n6 = spring.getPreferredSize(1);
                    if (n6 == n5) continue;
                    switch (spring.getBaselineResizeBehavior()) {
                        case CONSTANT_ASCENT: {
                            if (!this.baselineAnchoredToTop) break;
                            n2 = Math.max(n2, n5 - n4);
                            break;
                        }
                        case CONSTANT_DESCENT: {
                            if (this.baselineAnchoredToTop) break;
                            n = Math.max(n, n5 - n6 + n4);
                            break;
                        }
                    }
                    continue;
                }
                n3 = Math.max(n3, n5);
            }
            return Math.max(n3, n + n2);
        }

        private int calculateMinSize() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.baselineAnchoredToTop) {
                n = this.prefAscent;
            } else {
                n2 = this.prefDescent;
            }
            for (Spring spring : this.springs) {
                int n4;
                int n5 = spring.getMinimumSize(1);
                if ((spring.getAlignment() == null || spring.getAlignment() == Alignment.BASELINE) && (n4 = spring.getBaseline()) >= 0) {
                    int n6 = spring.getPreferredSize(1);
                    Component.BaselineResizeBehavior baselineResizeBehavior = spring.getBaselineResizeBehavior();
                    switch (baselineResizeBehavior) {
                        case CONSTANT_ASCENT: {
                            if (this.baselineAnchoredToTop) {
                                n2 = Math.max(n5 - n4, n2);
                                break;
                            }
                            n = Math.max(n4, n);
                            break;
                        }
                        case CONSTANT_DESCENT: {
                            if (!this.baselineAnchoredToTop) {
                                n = Math.max(n4 - (n6 - n5), n);
                                break;
                            }
                            n2 = Math.max(n6 - n4, n2);
                            break;
                        }
                        default: {
                            n = Math.max(n4, n);
                            n2 = Math.max(n6 - n4, n2);
                            break;
                        }
                    }
                    continue;
                }
                n3 = Math.max(n3, n5);
            }
            return Math.max(n3, n + n2);
        }

        private void baselineLayout(int n, int n2) {
            int n3;
            int n4;
            if (this.baselineAnchoredToTop) {
                n4 = this.prefAscent;
                n3 = n2 - n4;
            } else {
                n4 = n2 - this.prefDescent;
                n3 = this.prefDescent;
            }
            for (Spring spring : this.springs) {
                Alignment alignment = spring.getAlignment();
                if (alignment == null || alignment == Alignment.BASELINE) {
                    int n5 = spring.getBaseline();
                    if (n5 >= 0) {
                        int n6;
                        int n7;
                        int n8 = spring.getMaximumSize(1);
                        int n9 = n7 = spring.getPreferredSize(1);
                        switch (spring.getBaselineResizeBehavior()) {
                            case CONSTANT_ASCENT: {
                                n6 = n + n4 - n5;
                                n9 = Math.min(n3, n8 - n5) + n5;
                                break;
                            }
                            case CONSTANT_DESCENT: {
                                n9 = Math.min(n4, n8 - n7 + n5) + (n7 - n5);
                                n6 = n + n4 + (n7 - n5) - n9;
                                break;
                            }
                            default: {
                                n6 = n + n4 - n5;
                            }
                        }
                        spring.setSize(1, n6, n9);
                        continue;
                    }
                    this.setChildSize(spring, 1, n, n2);
                    continue;
                }
                this.setChildSize(spring, 1, n, n2);
            }
        }

        @Override
        int getBaseline() {
            if (this.springs.size() > 1) {
                this.getPreferredSize(1);
                return this.prefAscent;
            }
            if (this.springs.size() == 1) {
                return ((Spring)this.springs.get(0)).getBaseline();
            }
            return -1;
        }

        @Override
        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            if (this.springs.size() == 1) {
                return ((Spring)this.springs.get(0)).getBaselineResizeBehavior();
            }
            if (this.baselineAnchoredToTop) {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
        }

        private void checkAxis(int n) {
            if (n == 0) {
                throw new IllegalStateException("Baseline must be used along vertical axis");
            }
        }
    }

    private class ComponentInfo {
        private Component component;
        ComponentSpring horizontalSpring;
        ComponentSpring verticalSpring;
        private LinkInfo horizontalMaster;
        private LinkInfo verticalMaster;
        private boolean visible;
        private Boolean honorsVisibility;

        ComponentInfo(Component component) {
            this.component = component;
            this.updateVisibility();
        }

        public void dispose() {
            this.removeSpring(this.horizontalSpring);
            this.horizontalSpring = null;
            this.removeSpring(this.verticalSpring);
            this.verticalSpring = null;
            if (this.horizontalMaster != null) {
                this.horizontalMaster.remove(this);
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.remove(this);
            }
        }

        void setHonorsVisibility(Boolean bl) {
            this.honorsVisibility = bl;
        }

        private void removeSpring(Spring spring) {
            if (spring != null) {
                ((Group)spring.getParent()).springs.remove(spring);
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        boolean updateVisibility() {
            boolean bl;
            boolean bl2 = this.honorsVisibility == null ? GroupLayout.this.getHonorsVisibility() : this.honorsVisibility.booleanValue();
            boolean bl3 = bl = bl2 ? this.component.isVisible() : true;
            if (this.visible != bl) {
                this.visible = bl;
                return true;
            }
            return false;
        }

        public void setBounds(Insets insets, int n, boolean bl) {
            int n2 = this.horizontalSpring.getOrigin();
            int n3 = this.horizontalSpring.getSize();
            int n4 = this.verticalSpring.getOrigin();
            int n5 = this.verticalSpring.getSize();
            if (!bl) {
                n2 = n - n2 - n3;
            }
            this.component.setBounds(n2 + insets.left, n4 + insets.top, n3, n5);
        }

        public void setComponent(Component component) {
            this.component = component;
            if (this.horizontalSpring != null) {
                this.horizontalSpring.setComponent(component);
            }
            if (this.verticalSpring != null) {
                this.verticalSpring.setComponent(component);
            }
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean isLinked(int n) {
            if (n == 0) {
                return this.horizontalMaster != null;
            }
            assert (n == 1);
            return this.verticalMaster != null;
        }

        private void setLinkInfo(int n, LinkInfo linkInfo) {
            if (n == 0) {
                this.horizontalMaster = linkInfo;
            } else {
                assert (n == 1);
                this.verticalMaster = linkInfo;
            }
        }

        public LinkInfo getLinkInfo(int n) {
            return this.getLinkInfo(n, true);
        }

        private LinkInfo getLinkInfo(int n, boolean bl) {
            if (n == 0) {
                if (this.horizontalMaster == null && bl) {
                    new LinkInfo(0).add(this);
                }
                return this.horizontalMaster;
            }
            assert (n == 1);
            if (this.verticalMaster == null && bl) {
                new LinkInfo(1).add(this);
            }
            return this.verticalMaster;
        }

        public void clearCachedSize() {
            if (this.horizontalMaster != null) {
                this.horizontalMaster.clearCachedSize();
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.clearCachedSize();
            }
        }

        int getLinkSize(int n, int n2) {
            if (n == 0) {
                return this.horizontalMaster.getSize(n);
            }
            assert (n == 1);
            return this.verticalMaster.getSize(n);
        }
    }

    private final class ComponentSpring
    extends Spring {
        private Component component;
        private int origin;
        private final int min;
        private final int pref;
        private final int max;
        private int baseline;
        private boolean installed;

        private ComponentSpring(Component component, int n, int n2, int n3) {
            this.baseline = -1;
            this.component = component;
            if (component == null) {
                throw new IllegalArgumentException("Component must be non-null");
            }
            GroupLayout.checkSize(n, n2, n3, true);
            this.min = n;
            this.max = n3;
            this.pref = n2;
            GroupLayout.this.getComponentInfo(component);
        }

        @Override
        int calculateMinimumSize(int n) {
            if (this.isLinked(n)) {
                return this.getLinkSize(n, 0);
            }
            return this.calculateNonlinkedMinimumSize(n);
        }

        @Override
        int calculatePreferredSize(int n) {
            if (this.isLinked(n)) {
                return this.getLinkSize(n, 1);
            }
            int n2 = this.getMinimumSize(n);
            int n3 = this.calculateNonlinkedPreferredSize(n);
            int n4 = this.getMaximumSize(n);
            return Math.min(n4, Math.max(n2, n3));
        }

        @Override
        int calculateMaximumSize(int n) {
            if (this.isLinked(n)) {
                return this.getLinkSize(n, 2);
            }
            return Math.max(this.getMinimumSize(n), this.calculateNonlinkedMaximumSize(n));
        }

        boolean isVisible() {
            return GroupLayout.this.getComponentInfo(this.getComponent()).isVisible();
        }

        int calculateNonlinkedMinimumSize(int n) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.min >= 0) {
                return this.min;
            }
            if (this.min == -2) {
                return this.calculateNonlinkedPreferredSize(n);
            }
            assert (this.min == -1);
            return this.getSizeAlongAxis(n, this.component.getMinimumSize());
        }

        int calculateNonlinkedPreferredSize(int n) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.pref >= 0) {
                return this.pref;
            }
            assert (this.pref == -1 || this.pref == -2);
            return this.getSizeAlongAxis(n, this.component.getPreferredSize());
        }

        int calculateNonlinkedMaximumSize(int n) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.max >= 0) {
                return this.max;
            }
            if (this.max == -2) {
                return this.calculateNonlinkedPreferredSize(n);
            }
            assert (this.max == -1);
            return this.getSizeAlongAxis(n, this.component.getMaximumSize());
        }

        private int getSizeAlongAxis(int n, Dimension dimension) {
            return n == 0 ? dimension.width : dimension.height;
        }

        private int getLinkSize(int n, int n2) {
            if (!this.isVisible()) {
                return 0;
            }
            ComponentInfo componentInfo = GroupLayout.this.getComponentInfo(this.component);
            return componentInfo.getLinkSize(n, n2);
        }

        @Override
        void setSize(int n, int n2, int n3) {
            super.setSize(n, n2, n3);
            this.origin = n2;
            if (n3 == Integer.MIN_VALUE) {
                this.baseline = -1;
            }
        }

        int getOrigin() {
            return this.origin;
        }

        void setComponent(Component component) {
            this.component = component;
        }

        Component getComponent() {
            return this.component;
        }

        @Override
        int getBaseline() {
            if (this.baseline == -1) {
                ComponentSpring componentSpring = ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring;
                int n = componentSpring.getPreferredSize(0);
                int n2 = this.getPreferredSize(1);
                if (n > 0 && n2 > 0) {
                    this.baseline = this.component.getBaseline(n, n2);
                }
            }
            return this.baseline;
        }

        @Override
        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            return this.getComponent().getBaselineResizeBehavior();
        }

        private boolean isLinked(int n) {
            return GroupLayout.this.getComponentInfo(this.component).isLinked(n);
        }

        void installIfNecessary(int n) {
            if (!this.installed) {
                this.installed = true;
                if (n == 0) {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).horizontalSpring = this;
                } else {
                    ((GroupLayout)GroupLayout.this).getComponentInfo((Component)this.component).verticalSpring = this;
                }
            }
        }

        @Override
        boolean willHaveZeroSize(boolean bl) {
            return !this.isVisible();
        }
    }

    private class ContainerAutoPreferredGapSpring
    extends AutoPreferredGapSpring {
        private List<ComponentSpring> targets;

        ContainerAutoPreferredGapSpring() {
            this.setUserCreated(true);
        }

        ContainerAutoPreferredGapSpring(int n, int n2) {
            super(n, n2);
            this.setUserCreated(true);
        }

        @Override
        public void addTarget(ComponentSpring componentSpring, int n) {
            if (this.targets == null) {
                this.targets = new ArrayList<ComponentSpring>(1);
            }
            this.targets.add(componentSpring);
        }

        @Override
        public void calculatePadding(int n) {
            LayoutStyle layoutStyle = GroupLayout.this.getLayoutStyle0();
            int n2 = 0;
            this.size = 0;
            if (this.targets != null) {
                int n3 = n == 0 ? (GroupLayout.this.isLeftToRight() ? 7 : 3) : 5;
                for (int i = this.targets.size() - 1; i >= 0; --i) {
                    ComponentSpring componentSpring = this.targets.get(i);
                    int n4 = 10;
                    if (componentSpring.getComponent() instanceof JComponent) {
                        n4 = layoutStyle.getContainerGap((JComponent)componentSpring.getComponent(), n3, GroupLayout.this.host);
                        n2 = Math.max(n4, n2);
                        n4 -= componentSpring.getOrigin();
                    } else {
                        n2 = Math.max(n4, n2);
                    }
                    this.size = Math.max(this.size, n4);
                }
            } else {
                int n5 = n == 0 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                if (this.sources != null) {
                    for (int i = this.sources.size() - 1; i >= 0; --i) {
                        ComponentSpring componentSpring = (ComponentSpring)this.sources.get(i);
                        n2 = Math.max(n2, this.updateSize(layoutStyle, componentSpring, n5));
                    }
                } else if (this.source != null) {
                    n2 = this.updateSize(layoutStyle, this.source, n5);
                }
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(n2, this.lastSize);
            }
        }

        private int updateSize(LayoutStyle layoutStyle, ComponentSpring componentSpring, int n) {
            int n2 = 10;
            if (componentSpring.getComponent() instanceof JComponent) {
                n2 = layoutStyle.getContainerGap((JComponent)componentSpring.getComponent(), n, GroupLayout.this.host);
            }
            int n3 = Math.max(0, this.getParent().getSize() - componentSpring.getSize() - componentSpring.getOrigin());
            this.size = Math.max(this.size, n2 - n3);
            return n2;
        }

        @Override
        String getMatchDescription() {
            if (this.targets != null) {
                return "leading: " + this.targets.toString();
            }
            if (this.sources != null) {
                return "trailing: " + this.sources.toString();
            }
            return "--";
        }
    }

    private class GapSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;

        GapSpring(int n, int n2, int n3) {
            GroupLayout.checkSize(n, n2, n3, false);
            this.min = n;
            this.pref = n2;
            this.max = n3;
        }

        @Override
        int calculateMinimumSize(int n) {
            if (this.min == -2) {
                return this.getPreferredSize(n);
            }
            return this.min;
        }

        @Override
        int calculatePreferredSize(int n) {
            return this.pref;
        }

        @Override
        int calculateMaximumSize(int n) {
            if (this.max == -2) {
                return this.getPreferredSize(n);
            }
            return this.max;
        }

        @Override
        boolean willHaveZeroSize(boolean bl) {
            return false;
        }
    }

    public abstract class Group
    extends Spring {
        List<Spring> springs;

        Group() {
            this.springs = new ArrayList<Spring>();
        }

        public Group addGroup(Group group) {
            return this.addSpring(group);
        }

        public Group addComponent(Component component) {
            return this.addComponent(component, -1, -1, -1);
        }

        public Group addComponent(Component component, int n, int n2, int n3) {
            return this.addSpring(new ComponentSpring(component, n, n2, n3));
        }

        public Group addGap(int n) {
            return this.addGap(n, n, n);
        }

        public Group addGap(int n, int n2, int n3) {
            return this.addSpring(new GapSpring(n, n2, n3));
        }

        Spring getSpring(int n) {
            return this.springs.get(n);
        }

        int indexOf(Spring spring) {
            return this.springs.indexOf(spring);
        }

        Group addSpring(Spring spring) {
            this.springs.add(spring);
            spring.setParent(this);
            if (!(spring instanceof AutoPreferredGapSpring) || !((AutoPreferredGapSpring)spring).getUserCreated()) {
                GroupLayout.this.springsChanged = true;
            }
            return this;
        }

        @Override
        void setSize(int n, int n2, int n3) {
            super.setSize(n, n2, n3);
            if (n3 == Integer.MIN_VALUE) {
                for (int i = this.springs.size() - 1; i >= 0; --i) {
                    this.getSpring(i).setSize(n, n2, n3);
                }
            } else {
                this.setValidSize(n, n2, n3);
            }
        }

        abstract void setValidSize(int var1, int var2, int var3);

        @Override
        int calculateMinimumSize(int n) {
            return this.calculateSize(n, 0);
        }

        @Override
        int calculatePreferredSize(int n) {
            return this.calculateSize(n, 1);
        }

        @Override
        int calculateMaximumSize(int n) {
            return this.calculateSize(n, 2);
        }

        int calculateSize(int n, int n2) {
            int n3 = this.springs.size();
            if (n3 == 0) {
                return 0;
            }
            if (n3 == 1) {
                return this.getSpringSize(this.getSpring(0), n, n2);
            }
            int n4 = this.constrain(this.operator(this.getSpringSize(this.getSpring(0), n, n2), this.getSpringSize(this.getSpring(1), n, n2)));
            for (int i = 2; i < n3; ++i) {
                n4 = this.constrain(this.operator(n4, this.getSpringSize(this.getSpring(i), n, n2)));
            }
            return n4;
        }

        int getSpringSize(Spring spring, int n, int n2) {
            switch (n2) {
                case 0: {
                    return spring.getMinimumSize(n);
                }
                case 1: {
                    return spring.getPreferredSize(n);
                }
                case 2: {
                    return spring.getMaximumSize(n);
                }
            }
            assert (false);
            return 0;
        }

        abstract int operator(int var1, int var2);

        abstract void insertAutopadding(int var1, List<AutoPreferredGapSpring> var2, List<AutoPreferredGapSpring> var3, List<ComponentSpring> var4, List<ComponentSpring> var5, boolean var6);

        void removeAutopadding() {
            this.unset();
            for (int i = this.springs.size() - 1; i >= 0; --i) {
                Spring spring = this.springs.get(i);
                if (spring instanceof AutoPreferredGapSpring) {
                    if (((AutoPreferredGapSpring)spring).getUserCreated()) {
                        ((AutoPreferredGapSpring)spring).reset();
                        continue;
                    }
                    this.springs.remove(i);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).removeAutopadding();
            }
        }

        void unsetAutopadding() {
            this.unset();
            for (int i = this.springs.size() - 1; i >= 0; --i) {
                Spring spring = this.springs.get(i);
                if (spring instanceof AutoPreferredGapSpring) {
                    spring.unset();
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).unsetAutopadding();
            }
        }

        void calculateAutopadding(int n) {
            for (int i = this.springs.size() - 1; i >= 0; --i) {
                Spring spring = this.springs.get(i);
                if (spring instanceof AutoPreferredGapSpring) {
                    spring.unset();
                    ((AutoPreferredGapSpring)spring).calculatePadding(n);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).calculateAutopadding(n);
            }
            this.unset();
        }

        @Override
        boolean willHaveZeroSize(boolean bl) {
            for (int i = this.springs.size() - 1; i >= 0; --i) {
                Spring spring = this.springs.get(i);
                if (spring.willHaveZeroSize(bl)) continue;
                return false;
            }
            return true;
        }
    }

    private static class LinkInfo {
        private final int axis;
        private final List<ComponentInfo> linked = new ArrayList<ComponentInfo>();
        private int size = Integer.MIN_VALUE;

        LinkInfo(int n) {
            this.axis = n;
        }

        public void add(ComponentInfo componentInfo) {
            LinkInfo linkInfo = componentInfo.getLinkInfo(this.axis, false);
            if (linkInfo == null) {
                this.linked.add(componentInfo);
                componentInfo.setLinkInfo(this.axis, this);
            } else if (linkInfo != this) {
                this.linked.addAll(linkInfo.linked);
                for (ComponentInfo componentInfo2 : linkInfo.linked) {
                    componentInfo2.setLinkInfo(this.axis, this);
                }
            }
            this.clearCachedSize();
        }

        public void remove(ComponentInfo componentInfo) {
            this.linked.remove(componentInfo);
            componentInfo.setLinkInfo(this.axis, null);
            if (this.linked.size() == 1) {
                this.linked.get(0).setLinkInfo(this.axis, null);
            }
            this.clearCachedSize();
        }

        public void clearCachedSize() {
            this.size = Integer.MIN_VALUE;
        }

        public int getSize(int n) {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.calculateLinkedSize(n);
            }
            return this.size;
        }

        private int calculateLinkedSize(int n) {
            int n2 = 0;
            for (ComponentInfo componentInfo : this.linked) {
                ComponentSpring componentSpring;
                if (n == 0) {
                    componentSpring = componentInfo.horizontalSpring;
                } else {
                    assert (n == 1);
                    componentSpring = componentInfo.verticalSpring;
                }
                n2 = Math.max(n2, componentSpring.calculateNonlinkedPreferredSize(n));
            }
            return n2;
        }
    }

    public class ParallelGroup
    extends Group {
        private final Alignment childAlignment;
        private final boolean resizable;

        ParallelGroup(Alignment alignment, boolean bl) {
            this.childAlignment = alignment;
            this.resizable = bl;
        }

        @Override
        public ParallelGroup addGroup(Group group) {
            return (ParallelGroup)super.addGroup(group);
        }

        @Override
        public ParallelGroup addComponent(Component component) {
            return (ParallelGroup)super.addComponent(component);
        }

        @Override
        public ParallelGroup addComponent(Component component, int n, int n2, int n3) {
            return (ParallelGroup)super.addComponent(component, n, n2, n3);
        }

        @Override
        public ParallelGroup addGap(int n) {
            return (ParallelGroup)super.addGap(n);
        }

        @Override
        public ParallelGroup addGap(int n, int n2, int n3) {
            return (ParallelGroup)super.addGap(n, n2, n3);
        }

        public ParallelGroup addGroup(Alignment alignment, Group group) {
            this.checkChildAlignment(alignment);
            group.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup addComponent(Component component, Alignment alignment) {
            return this.addComponent(component, alignment, -1, -1, -1);
        }

        public ParallelGroup addComponent(Component component, Alignment alignment, int n, int n2, int n3) {
            this.checkChildAlignment(alignment);
            ComponentSpring componentSpring = new ComponentSpring(component, n, n2, n3);
            componentSpring.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(componentSpring);
        }

        boolean isResizable() {
            return this.resizable;
        }

        @Override
        int operator(int n, int n2) {
            return Math.max(n, n2);
        }

        @Override
        int calculateMinimumSize(int n) {
            if (!this.isResizable()) {
                return this.getPreferredSize(n);
            }
            return super.calculateMinimumSize(n);
        }

        @Override
        int calculateMaximumSize(int n) {
            if (!this.isResizable()) {
                return this.getPreferredSize(n);
            }
            return super.calculateMaximumSize(n);
        }

        @Override
        void setValidSize(int n, int n2, int n3) {
            for (Spring spring : this.springs) {
                this.setChildSize(spring, n, n2, n3);
            }
        }

        void setChildSize(Spring spring, int n, int n2, int n3) {
            Alignment alignment = spring.getAlignment();
            int n4 = Math.min(Math.max(spring.getMinimumSize(n), n3), spring.getMaximumSize(n));
            if (alignment == null) {
                alignment = this.childAlignment;
            }
            switch (alignment) {
                case TRAILING: {
                    spring.setSize(n, n2 + n3 - n4, n4);
                    break;
                }
                case CENTER: {
                    spring.setSize(n, n2 + (n3 - n4) / 2, n4);
                    break;
                }
                default: {
                    spring.setSize(n, n2, n4);
                }
            }
        }

        @Override
        void insertAutopadding(int n, List<AutoPreferredGapSpring> list, List<AutoPreferredGapSpring> list2, List<ComponentSpring> list3, List<ComponentSpring> list4, boolean bl) {
            for (Spring spring : this.springs) {
                if (spring instanceof ComponentSpring) {
                    if (!((ComponentSpring)spring).isVisible()) continue;
                    for (AutoPreferredGapSpring autoPreferredGapSpring : list) {
                        autoPreferredGapSpring.addTarget((ComponentSpring)spring, n);
                    }
                    list4.add((ComponentSpring)spring);
                    continue;
                }
                if (spring instanceof Group) {
                    ((Group)spring).insertAutopadding(n, list, list2, list3, list4, bl);
                    continue;
                }
                if (!(spring instanceof AutoPreferredGapSpring)) continue;
                ((AutoPreferredGapSpring)spring).setSources(list3);
                list2.add((AutoPreferredGapSpring)spring);
            }
        }

        private void checkChildAlignment(Alignment alignment) {
            this.checkChildAlignment(alignment, this instanceof BaselineGroup);
        }

        private void checkChildAlignment(Alignment alignment, boolean bl) {
            if (alignment == null) {
                throw new IllegalArgumentException("Alignment must be non-null");
            }
            if (!bl && alignment == Alignment.BASELINE) {
                throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
            }
        }
    }

    private class PreferredGapSpring
    extends Spring {
        private final JComponent source;
        private final JComponent target;
        private final LayoutStyle.ComponentPlacement type;
        private final int pref;
        private final int max;

        PreferredGapSpring(JComponent jComponent, JComponent jComponent2, LayoutStyle.ComponentPlacement componentPlacement, int n, int n2) {
            this.source = jComponent;
            this.target = jComponent2;
            this.type = componentPlacement;
            this.pref = n;
            this.max = n2;
        }

        @Override
        int calculateMinimumSize(int n) {
            return this.getPadding(n);
        }

        @Override
        int calculatePreferredSize(int n) {
            if (this.pref == -1 || this.pref == -2) {
                return this.getMinimumSize(n);
            }
            int n2 = this.getMinimumSize(n);
            int n3 = this.getMaximumSize(n);
            return Math.min(n3, Math.max(n2, this.pref));
        }

        @Override
        int calculateMaximumSize(int n) {
            if (this.max == -2 || this.max == -1) {
                return this.getPadding(n);
            }
            return Math.max(this.getMinimumSize(n), this.max);
        }

        private int getPadding(int n) {
            int n2 = n == 0 ? 3 : 5;
            return GroupLayout.this.getLayoutStyle0().getPreferredGap(this.source, this.target, this.type, n2, GroupLayout.this.host);
        }

        @Override
        boolean willHaveZeroSize(boolean bl) {
            return false;
        }
    }

    public class SequentialGroup
    extends Group {
        private Spring baselineSpring;

        SequentialGroup() {
        }

        @Override
        public SequentialGroup addGroup(Group group) {
            return (SequentialGroup)super.addGroup(group);
        }

        public SequentialGroup addGroup(boolean bl, Group group) {
            super.addGroup(group);
            if (bl) {
                this.baselineSpring = group;
            }
            return this;
        }

        @Override
        public SequentialGroup addComponent(Component component) {
            return (SequentialGroup)super.addComponent(component);
        }

        public SequentialGroup addComponent(boolean bl, Component component) {
            super.addComponent(component);
            if (bl) {
                this.baselineSpring = (Spring)this.springs.get(this.springs.size() - 1);
            }
            return this;
        }

        @Override
        public SequentialGroup addComponent(Component component, int n, int n2, int n3) {
            return (SequentialGroup)super.addComponent(component, n, n2, n3);
        }

        public SequentialGroup addComponent(boolean bl, Component component, int n, int n2, int n3) {
            super.addComponent(component, n, n2, n3);
            if (bl) {
                this.baselineSpring = (Spring)this.springs.get(this.springs.size() - 1);
            }
            return this;
        }

        @Override
        public SequentialGroup addGap(int n) {
            return (SequentialGroup)super.addGap(n);
        }

        @Override
        public SequentialGroup addGap(int n, int n2, int n3) {
            return (SequentialGroup)super.addGap(n, n2, n3);
        }

        public SequentialGroup addPreferredGap(JComponent jComponent, JComponent jComponent2, LayoutStyle.ComponentPlacement componentPlacement) {
            return this.addPreferredGap(jComponent, jComponent2, componentPlacement, -1, -2);
        }

        public SequentialGroup addPreferredGap(JComponent jComponent, JComponent jComponent2, LayoutStyle.ComponentPlacement componentPlacement, int n, int n2) {
            if (componentPlacement == null) {
                throw new IllegalArgumentException("Type must be non-null");
            }
            if (jComponent == null || jComponent2 == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.checkPreferredGapValues(n, n2);
            return (SequentialGroup)this.addSpring(new PreferredGapSpring(jComponent, jComponent2, componentPlacement, n, n2));
        }

        public SequentialGroup addPreferredGap(LayoutStyle.ComponentPlacement componentPlacement) {
            return this.addPreferredGap(componentPlacement, -1, -1);
        }

        public SequentialGroup addPreferredGap(LayoutStyle.ComponentPlacement componentPlacement, int n, int n2) {
            if (componentPlacement != LayoutStyle.ComponentPlacement.RELATED && componentPlacement != LayoutStyle.ComponentPlacement.UNRELATED) {
                throw new IllegalArgumentException("Type must be one of LayoutStyle.ComponentPlacement.RELATED or LayoutStyle.ComponentPlacement.UNRELATED");
            }
            this.checkPreferredGapValues(n, n2);
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new AutoPreferredGapSpring(componentPlacement, n, n2));
        }

        public SequentialGroup addContainerGap() {
            return this.addContainerGap(-1, -1);
        }

        public SequentialGroup addContainerGap(int n, int n2) {
            if (n < 0 && n != -1 || n2 < 0 && n2 != -1 && n2 != -2 || n >= 0 && n2 >= 0 && n > n2) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new ContainerAutoPreferredGapSpring(n, n2));
        }

        @Override
        int operator(int n, int n2) {
            return this.constrain(n) + this.constrain(n2);
        }

        @Override
        void setValidSize(int n, int n2, int n3) {
            int n4 = this.getPreferredSize(n);
            if (n3 == n4) {
                for (Spring spring : this.springs) {
                    int n5 = spring.getPreferredSize(n);
                    spring.setSize(n, n2, n5);
                    n2 += n5;
                }
            } else if (this.springs.size() == 1) {
                Spring spring = this.getSpring(0);
                spring.setSize(n, n2, Math.min(Math.max(n3, spring.getMinimumSize(n)), spring.getMaximumSize(n)));
            } else if (this.springs.size() > 1) {
                this.setValidSizeNotPreferred(n, n2, n3);
            }
        }

        private void setValidSizeNotPreferred(int n, int n2, int n3) {
            List<SpringDelta> list;
            int n4;
            int n5 = n3 - this.getPreferredSize(n);
            assert (n5 != 0);
            boolean bl = n5 < 0;
            int n6 = this.springs.size();
            if (bl) {
                n5 *= -1;
            }
            if ((n4 = (list = this.buildResizableList(n, bl)).size()) > 0) {
                Object object;
                int n7;
                int n8 = n5 / n4;
                int n9 = n5 - n8 * n4;
                int[] nArray = new int[n6];
                int n10 = bl ? -1 : 1;
                for (n7 = 0; n7 < n4; ++n7) {
                    object = list.get(n7);
                    if (n7 + 1 == n4) {
                        n8 += n9;
                    }
                    ((SpringDelta)object).delta = Math.min(n8, ((SpringDelta)object).delta);
                    n5 -= ((SpringDelta)object).delta;
                    if (((SpringDelta)object).delta != n8 && n7 + 1 < n4) {
                        n8 = n5 / (n4 - n7 - 1);
                        n9 = n5 - n8 * (n4 - n7 - 1);
                    }
                    nArray[((SpringDelta)object).index] = n10 * ((SpringDelta)object).delta;
                }
                for (n7 = 0; n7 < n6; ++n7) {
                    object = this.getSpring(n7);
                    int n11 = ((Spring)object).getPreferredSize(n) + nArray[n7];
                    ((Spring)object).setSize(n, n2, n11);
                    n2 += n11;
                }
            } else {
                for (int i = 0; i < n6; ++i) {
                    Spring spring = this.getSpring(i);
                    int n12 = bl ? spring.getMinimumSize(n) : spring.getMaximumSize(n);
                    spring.setSize(n, n2, n12);
                    n2 += n12;
                }
            }
        }

        private List<SpringDelta> buildResizableList(int n, boolean bl) {
            int n2 = this.springs.size();
            ArrayList<SpringDelta> arrayList = new ArrayList<SpringDelta>(n2);
            for (int i = 0; i < n2; ++i) {
                Spring spring = this.getSpring(i);
                int n3 = bl ? spring.getPreferredSize(n) - spring.getMinimumSize(n) : spring.getMaximumSize(n) - spring.getPreferredSize(n);
                if (n3 <= 0) continue;
                arrayList.add(new SpringDelta(i, n3));
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        private int indexOfNextNonZeroSpring(int n, boolean bl) {
            while (n < this.springs.size()) {
                Spring spring = (Spring)this.springs.get(n);
                if (!spring.willHaveZeroSize(bl)) {
                    return n;
                }
                ++n;
            }
            return n;
        }

        @Override
        void insertAutopadding(int n, List<AutoPreferredGapSpring> list, List<AutoPreferredGapSpring> list2, List<ComponentSpring> list3, List<ComponentSpring> list4, boolean bl) {
            ArrayList<AutoPreferredGapSpring> arrayList = new ArrayList<AutoPreferredGapSpring>(list);
            ArrayList<AutoPreferredGapSpring> arrayList2 = new ArrayList<AutoPreferredGapSpring>(1);
            ArrayList<ComponentSpring> arrayList3 = new ArrayList<ComponentSpring>(list3);
            ArrayList<ComponentSpring> arrayList4 = null;
            int n2 = 0;
            while (n2 < this.springs.size()) {
                Spring spring;
                Spring spring2 = this.getSpring(n2);
                if (spring2 instanceof AutoPreferredGapSpring) {
                    if (arrayList.size() == 0) {
                        spring = (AutoPreferredGapSpring)spring2;
                        ((AutoPreferredGapSpring)spring).setSources(arrayList3);
                        arrayList3.clear();
                        n2 = this.indexOfNextNonZeroSpring(n2 + 1, true);
                        if (n2 == this.springs.size()) {
                            if (spring instanceof ContainerAutoPreferredGapSpring) continue;
                            list2.add((AutoPreferredGapSpring)spring);
                            continue;
                        }
                        arrayList.clear();
                        arrayList.add((AutoPreferredGapSpring)spring);
                        continue;
                    }
                    n2 = this.indexOfNextNonZeroSpring(n2 + 1, true);
                    continue;
                }
                if (arrayList3.size() > 0 && bl) {
                    spring = new AutoPreferredGapSpring();
                    this.springs.add(n2, spring);
                    continue;
                }
                if (spring2 instanceof ComponentSpring) {
                    spring = (ComponentSpring)spring2;
                    if (!((ComponentSpring)spring).isVisible()) {
                        ++n2;
                        continue;
                    }
                    for (AutoPreferredGapSpring autoPreferredGapSpring : arrayList) {
                        autoPreferredGapSpring.addTarget((ComponentSpring)spring, n);
                    }
                    arrayList3.clear();
                    arrayList.clear();
                    n2 = this.indexOfNextNonZeroSpring(n2 + 1, false);
                    if (n2 == this.springs.size()) {
                        list4.add((ComponentSpring)spring);
                        continue;
                    }
                    arrayList3.add((ComponentSpring)spring);
                    continue;
                }
                if (spring2 instanceof Group) {
                    if (arrayList4 == null) {
                        arrayList4 = new ArrayList<ComponentSpring>(1);
                    } else {
                        arrayList4.clear();
                    }
                    arrayList2.clear();
                    ((Group)spring2).insertAutopadding(n, arrayList, arrayList2, arrayList3, arrayList4, bl);
                    arrayList3.clear();
                    arrayList.clear();
                    n2 = this.indexOfNextNonZeroSpring(n2 + 1, arrayList4.size() == 0);
                    if (n2 == this.springs.size()) {
                        list4.addAll(arrayList4);
                        list2.addAll(arrayList2);
                        continue;
                    }
                    arrayList3.addAll(arrayList4);
                    arrayList.addAll(arrayList2);
                    continue;
                }
                arrayList.clear();
                arrayList3.clear();
                ++n2;
            }
        }

        @Override
        int getBaseline() {
            int n;
            if (this.baselineSpring != null && (n = this.baselineSpring.getBaseline()) >= 0) {
                int n2 = 0;
                for (Spring spring : this.springs) {
                    if (spring == this.baselineSpring) {
                        return n2 + n;
                    }
                    n2 += spring.getPreferredSize(1);
                }
            }
            return -1;
        }

        @Override
        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            if (this.isResizable(1)) {
                if (!this.baselineSpring.isResizable(1)) {
                    Spring spring;
                    Spring spring2;
                    boolean bl = false;
                    Iterator iterator = this.springs.iterator();
                    while (iterator.hasNext() && (spring2 = (Spring)iterator.next()) != this.baselineSpring) {
                        if (!spring2.isResizable(1)) continue;
                        bl = true;
                        break;
                    }
                    boolean bl2 = false;
                    for (int i = this.springs.size() - 1; i >= 0 && (spring = (Spring)this.springs.get(i)) != this.baselineSpring; --i) {
                        if (!spring.isResizable(1)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl && !bl2) {
                        return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
                    }
                    if (!bl && bl2) {
                        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                    }
                } else {
                    Component.BaselineResizeBehavior baselineResizeBehavior = this.baselineSpring.getBaselineResizeBehavior();
                    if (baselineResizeBehavior == Component.BaselineResizeBehavior.CONSTANT_ASCENT) {
                        for (Spring spring : this.springs) {
                            if (spring == this.baselineSpring) {
                                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                            }
                            if (!spring.isResizable(1)) continue;
                            return Component.BaselineResizeBehavior.OTHER;
                        }
                    } else if (baselineResizeBehavior == Component.BaselineResizeBehavior.CONSTANT_DESCENT) {
                        for (int i = this.springs.size() - 1; i >= 0; --i) {
                            Spring spring = (Spring)this.springs.get(i);
                            if (spring == this.baselineSpring) {
                                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
                            }
                            if (!spring.isResizable(1)) continue;
                            return Component.BaselineResizeBehavior.OTHER;
                        }
                    }
                }
                return Component.BaselineResizeBehavior.OTHER;
            }
            return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
        }

        private void checkPreferredGapValues(int n, int n2) {
            if (n < 0 && n != -1 && n != -2 || n2 < 0 && n2 != -1 && n2 != -2 || n >= 0 && n2 >= 0 && n > n2) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_SIZE, PREFERRED_SIZE, or >= 0 and pref <= max");
            }
        }
    }

    private abstract class Spring {
        private int size;
        private int min;
        private int max = Integer.MIN_VALUE;
        private int pref = Integer.MIN_VALUE;
        private Spring parent;
        private Alignment alignment;

        Spring() {
            this.min = Integer.MIN_VALUE;
        }

        abstract int calculateMinimumSize(int var1);

        abstract int calculatePreferredSize(int var1);

        abstract int calculateMaximumSize(int var1);

        void setParent(Spring spring) {
            this.parent = spring;
        }

        Spring getParent() {
            return this.parent;
        }

        void setAlignment(Alignment alignment) {
            this.alignment = alignment;
        }

        Alignment getAlignment() {
            return this.alignment;
        }

        final int getMinimumSize(int n) {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.constrain(this.calculateMinimumSize(n));
            }
            return this.min;
        }

        final int getPreferredSize(int n) {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.constrain(this.calculatePreferredSize(n));
            }
            return this.pref;
        }

        final int getMaximumSize(int n) {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.constrain(this.calculateMaximumSize(n));
            }
            return this.max;
        }

        void setSize(int n, int n2, int n3) {
            this.size = n3;
            if (n3 == Integer.MIN_VALUE) {
                this.unset();
            }
        }

        void unset() {
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
            this.size = Integer.MIN_VALUE;
        }

        int getSize() {
            return this.size;
        }

        int constrain(int n) {
            return Math.min(n, Short.MAX_VALUE);
        }

        int getBaseline() {
            return -1;
        }

        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            return Component.BaselineResizeBehavior.OTHER;
        }

        final boolean isResizable(int n) {
            int n2;
            int n3 = this.getMinimumSize(n);
            return n3 != (n2 = this.getPreferredSize(n)) || n2 != this.getMaximumSize(n);
        }

        abstract boolean willHaveZeroSize(boolean var1);
    }

    private static final class SpringDelta
    implements Comparable<SpringDelta> {
        public final int index;
        public int delta;

        public SpringDelta(int n, int n2) {
            this.index = n;
            this.delta = n2;
        }

        @Override
        public int compareTo(SpringDelta springDelta) {
            return this.delta - springDelta.delta;
        }

        public String toString() {
            return super.toString() + "[index=" + this.index + ", delta=" + this.delta + "]";
        }
    }
}

