/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetPermission;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import sun.security.action.LoadLibraryAction;

public final class NetworkInterface {
    private String name;
    private String displayName;
    private int index;
    private InetAddress[] addrs;
    private InterfaceAddress[] bindings;
    private NetworkInterface[] childs;
    private NetworkInterface parent = null;
    private boolean virtual = false;

    NetworkInterface() {
    }

    NetworkInterface(String string, int n, InetAddress[] inetAddressArray) {
        this.name = string;
        this.index = n;
        this.addrs = inetAddressArray;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        class CheckedAddresses
        implements Enumeration<InetAddress> {
            private int i = 0;
            private int count = 0;
            private InetAddress[] local_addrs;

            CheckedAddresses() {
                this.local_addrs = new InetAddress[NetworkInterface.this.addrs.length];
                boolean bl = true;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkPermission(new NetPermission("getNetworkInformation"));
                    }
                    catch (SecurityException securityException) {
                        bl = false;
                    }
                }
                for (int i = 0; i < NetworkInterface.this.addrs.length; ++i) {
                    try {
                        if (securityManager != null && !bl) {
                            securityManager.checkConnect(NetworkInterface.this.addrs[i].getHostAddress(), -1);
                        }
                        this.local_addrs[this.count++] = NetworkInterface.this.addrs[i];
                        continue;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public InetAddress nextElement() {
                if (this.i < this.count) {
                    return this.local_addrs[this.i++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < this.count;
            }
        }
        return new CheckedAddresses();
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        ArrayList<InterfaceAddress> arrayList = new ArrayList<InterfaceAddress>(1);
        SecurityManager securityManager = System.getSecurityManager();
        for (int i = 0; i < this.bindings.length; ++i) {
            try {
                if (securityManager != null) {
                    securityManager.checkConnect(this.bindings[i].getAddress().getHostAddress(), -1);
                }
                arrayList.add(this.bindings[i]);
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public Enumeration<NetworkInterface> getSubInterfaces() {
        class SubIFs
        implements Enumeration<NetworkInterface> {
            private int i = 0;

            SubIFs() {
            }

            @Override
            public NetworkInterface nextElement() {
                if (this.i < NetworkInterface.this.childs.length) {
                    return NetworkInterface.this.childs[this.i++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < NetworkInterface.this.childs.length;
            }
        }
        return new SubIFs();
    }

    public NetworkInterface getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDisplayName() {
        return "".equals(this.displayName) ? null : this.displayName;
    }

    public static NetworkInterface getByName(String string) throws SocketException {
        if (string == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByName0(string);
    }

    public static NetworkInterface getByIndex(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("Interface index can't be negative");
        }
        return NetworkInterface.getByIndex0(n);
    }

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        if (!(inetAddress instanceof Inet4Address) && !(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("invalid address type");
        }
        return NetworkInterface.getByInetAddress0(inetAddress);
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        final NetworkInterface[] networkInterfaceArray = NetworkInterface.getAll();
        if (networkInterfaceArray == null) {
            return null;
        }
        return new Enumeration<NetworkInterface>(){
            private int i = 0;

            @Override
            public NetworkInterface nextElement() {
                if (networkInterfaceArray != null && this.i < networkInterfaceArray.length) {
                    NetworkInterface networkInterface = networkInterfaceArray[this.i++];
                    return networkInterface;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return networkInterfaceArray != null && this.i < networkInterfaceArray.length;
            }
        };
    }

    private static native NetworkInterface[] getAll() throws SocketException;

    private static native NetworkInterface getByName0(String var0) throws SocketException;

    private static native NetworkInterface getByIndex0(int var0) throws SocketException;

    private static native NetworkInterface getByInetAddress0(InetAddress var0) throws SocketException;

    public boolean isUp() throws SocketException {
        return NetworkInterface.isUp0(this.name, this.index);
    }

    public boolean isLoopback() throws SocketException {
        return NetworkInterface.isLoopback0(this.name, this.index);
    }

    public boolean isPointToPoint() throws SocketException {
        return NetworkInterface.isP2P0(this.name, this.index);
    }

    public boolean supportsMulticast() throws SocketException {
        return NetworkInterface.supportsMulticast0(this.name, this.index);
    }

    public byte[] getHardwareAddress() throws SocketException {
        block4: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPermission(new NetPermission("getNetworkInformation"));
                }
                catch (SecurityException securityException) {
                    if (this.getInetAddresses().hasMoreElements()) break block4;
                    return null;
                }
            }
        }
        for (InetAddress inetAddress : this.addrs) {
            if (!(inetAddress instanceof Inet4Address)) continue;
            return NetworkInterface.getMacAddr0(((Inet4Address)inetAddress).getAddress(), this.name, this.index);
        }
        return NetworkInterface.getMacAddr0(null, this.name, this.index);
    }

    public int getMTU() throws SocketException {
        return NetworkInterface.getMTU0(this.name, this.index);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    private static native boolean isUp0(String var0, int var1) throws SocketException;

    private static native boolean isLoopback0(String var0, int var1) throws SocketException;

    private static native boolean supportsMulticast0(String var0, int var1) throws SocketException;

    private static native boolean isP2P0(String var0, int var1) throws SocketException;

    private static native byte[] getMacAddr0(byte[] var0, String var1, int var2) throws SocketException;

    private static native int getMTU0(String var0, int var1) throws SocketException;

    public boolean equals(Object object) {
        if (!(object instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface networkInterface = (NetworkInterface)object;
        if (this.name != null ? !this.name.equals(networkInterface.name) : networkInterface.name != null) {
            return false;
        }
        if (this.addrs == null) {
            return networkInterface.addrs == null;
        }
        if (networkInterface.addrs == null) {
            return false;
        }
        if (this.addrs.length != networkInterface.addrs.length) {
            return false;
        }
        InetAddress[] inetAddressArray = networkInterface.addrs;
        int n = inetAddressArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (!this.addrs[i].equals(inetAddressArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String toString() {
        String string = "name:";
        string = string + (this.name == null ? "null" : this.name);
        if (this.displayName != null) {
            string = string + " (" + this.displayName + ")";
        }
        return string;
    }

    private static native void init();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        NetworkInterface.init();
    }
}

