/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.decoder.DocumentHandler;
import java.beans.ExceptionListener;
import java.beans.Statement;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDecoder
implements AutoCloseable {
    private final DocumentHandler handler = new DocumentHandler();
    private final InputSource input;
    private Object owner;
    private Object[] array;
    private int index;

    public XMLDecoder(InputStream inputStream) {
        this(inputStream, null);
    }

    public XMLDecoder(InputStream inputStream, Object object) {
        this(inputStream, object, null);
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener) {
        this(inputStream, object, exceptionListener, null);
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener, ClassLoader classLoader) {
        this(new InputSource(inputStream), object, exceptionListener, classLoader);
    }

    public XMLDecoder(InputSource inputSource) {
        this(inputSource, null, null, null);
    }

    private XMLDecoder(InputSource inputSource, Object object, ExceptionListener exceptionListener, ClassLoader classLoader) {
        this.input = inputSource;
        this.owner = object;
        this.setExceptionListener(exceptionListener);
        this.handler.setClassLoader(classLoader);
        this.handler.setOwner(this);
    }

    @Override
    public void close() {
        if (this.parsingComplete()) {
            this.close(this.input.getCharacterStream());
            this.close(this.input.getByteStream());
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                this.getExceptionListener().exceptionThrown(iOException);
            }
        }
    }

    private boolean parsingComplete() {
        if (this.input == null) {
            return false;
        }
        if (this.array == null) {
            this.handler.parse(this.input);
            this.array = this.handler.getObjects();
        }
        return true;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener == null) {
            exceptionListener = Statement.defaultExceptionListener;
        }
        this.handler.setExceptionListener(exceptionListener);
    }

    public ExceptionListener getExceptionListener() {
        return this.handler.getExceptionListener();
    }

    public Object readObject() {
        return this.parsingComplete() ? this.array[this.index++] : null;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public Object getOwner() {
        return this.owner;
    }

    public static DefaultHandler createHandler(Object object, ExceptionListener exceptionListener, ClassLoader classLoader) {
        DocumentHandler documentHandler = new DocumentHandler();
        documentHandler.setOwner(object);
        documentHandler.setExceptionListener(exceptionListener);
        documentHandler.setClassLoader(classLoader);
        return documentHandler;
    }
}

