/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class UnicodeDecoder
extends CharsetDecoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int NONE = 0;
    protected static final int BIG = 1;
    protected static final int LITTLE = 2;
    private final int expectedByteOrder;
    private int currentByteOrder;
    private int defaultByteOrder = 1;

    public UnicodeDecoder(Charset charset, int n) {
        super(charset, 0.5f, 1.0f);
        this.expectedByteOrder = this.currentByteOrder = n;
    }

    public UnicodeDecoder(Charset charset, int n, int n2) {
        this(charset, n);
        this.defaultByteOrder = n2;
    }

    private char decode(int n, int n2) {
        if (this.currentByteOrder == 1) {
            return (char)(n << 8 | n2);
        }
        return (char)(n2 << 8 | n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.remaining() > 1) {
                char c;
                int n2 = byteBuffer.get() & 0xFF;
                int n3 = byteBuffer.get() & 0xFF;
                if (this.currentByteOrder == 0) {
                    c = (char)(n2 << 8 | n3);
                    if (c == '\ufeff') {
                        this.currentByteOrder = 1;
                        n += 2;
                        continue;
                    }
                    if (c == '\ufffe') {
                        this.currentByteOrder = 2;
                        n += 2;
                        continue;
                    }
                    this.currentByteOrder = this.defaultByteOrder;
                }
                if ((c = this.decode(n2, n3)) == '\ufffe') {
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (Surrogate.isHigh(c)) {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        char c2 = this.decode(byteBuffer.get() & 0xFF, byteBuffer.get() & 0xFF);
                        if (!Surrogate.isLow(c2)) {
                            CoderResult coderResult = CoderResult.malformedForLength(4);
                            return coderResult;
                        }
                        if (charBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        n += 4;
                        charBuffer.put(c);
                        charBuffer.put(c2);
                        continue;
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += 2;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
    }
}

