/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.UserInputFileFilter;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleFileInputField
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 4673684743657328492L;
    boolean isDirectory;
    InstallerFrame parentFrame;
    List<ValidatorContainer> validators;
    DefaultListModel model;
    JList fileList;
    JButton browseBtn;
    JButton deleteBtn;
    String set;
    int size;
    InstallData data;
    String fileExtension;
    String fileExtensionDescription;
    boolean allowEmpty;
    boolean createMultipleVariables;
    int visibleRows = 10;
    int preferredX = 200;
    int preferredY = 200;
    String labeltext;

    public MultipleFileInputField(InstallerFrame installerFrame, InstallData installData, boolean bl, String string, int n, List<ValidatorContainer> list, String string2, String string3, boolean bl2, int n2, int n3, int n4, String string4) {
        this.parentFrame = installerFrame;
        this.data = installData;
        this.validators = list;
        this.set = string;
        this.size = n;
        this.fileExtension = string2;
        this.fileExtensionDescription = string3;
        this.isDirectory = bl;
        this.createMultipleVariables = bl2;
        this.visibleRows = n2;
        this.preferredX = n3;
        this.preferredY = n4;
        this.labeltext = string4;
        this.initialize();
    }

    public void clearFiles() {
        this.model.clear();
    }

    public void addFile(String string) {
        this.model.addElement(string);
    }

    public void initialize() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel(this.labeltext);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        this.model = new DefaultListModel();
        this.fileList = new JList(this.model);
        this.fileList.setSelectionMode(0);
        this.fileList.setVisibleRowCount(this.visibleRows);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.browseBtn = ButtonFactory.createButton(this.data.langpack.getString("UserInputPanel.button.browse"), this.data.buttonsHColor);
        this.browseBtn.addActionListener(this);
        this.deleteBtn = ButtonFactory.createButton(this.data.langpack.getString("UserInputPanel.button.delete"), this.data.buttonsHColor);
        this.deleteBtn.addActionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setPreferredSize(new Dimension(this.preferredX, this.preferredY));
        jPanel3.add(jScrollPane);
        jPanel4.add(this.browseBtn);
        jPanel4.add(this.deleteBtn);
        jPanel4.add(Box.createVerticalGlue());
        jPanel3.add(jPanel4);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalGlue());
        this.add(jPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseBtn) {
            Object object;
            Debug.trace("Show dirchooser");
            String string = ".";
            if (this.fileList.getSelectedValue() != null) {
                string = (String)this.fileList.getSelectedValue();
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            if (this.isDirectory) {
                jFileChooser.setFileSelectionMode(1);
            } else {
                jFileChooser.setFileSelectionMode(0);
                if (this.fileExtension != null && this.fileExtensionDescription != null) {
                    object = new UserInputFileFilter();
                    ((UserInputFileFilter)object).setFileExt(this.fileExtension);
                    ((UserInputFileFilter)object).setFileExtDesc(this.fileExtensionDescription);
                    jFileChooser.setFileFilter((FileFilter)object);
                }
            }
            if (jFileChooser.showOpenDialog(this.parentFrame) == 0) {
                object = jFileChooser.getSelectedFile().getAbsolutePath();
                this.model.addElement(object);
                Debug.trace("Setting current file chooser directory to: " + (String)object);
            }
        }
        if (actionEvent.getSource() == this.deleteBtn) {
            Debug.trace("Delete selected file from list");
            if (this.fileList.getSelectedValue() != null) {
                this.model.removeElement(this.fileList.getSelectedValue());
            }
        }
    }

    public List<String> getSelectedFiles() {
        ArrayList<String> arrayList = null;
        if (this.model.size() > 0) {
            arrayList = new ArrayList<String>();
            Enumeration enumeration = this.model.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this.parentFrame, this.parentFrame.langpack.getString("UserInputPanel." + string + ".message"), this.parentFrame.langpack.getString("UserInputPanel." + string + ".caption"), 2);
    }

    private boolean validateFile(String string) {
        boolean bl = false;
        if (this.allowEmpty && (string == null || string.length() == 0)) {
            bl = true;
        } else if (string != null) {
            File file = new File(string);
            if (this.isDirectory && !file.isDirectory()) {
                bl = false;
                this.showMessage("dir.notdirectory");
            } else if (!this.isDirectory && !file.isFile()) {
                bl = false;
                this.showMessage("file.notfile");
            } else {
                StringInputProcessingClient stringInputProcessingClient = new StringInputProcessingClient(string, this.validators);
                boolean bl2 = stringInputProcessingClient.validate();
                if (!bl2) {
                    JOptionPane.showMessageDialog(this.parentFrame, stringInputProcessingClient.getValidationMessage(), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
                }
                bl = bl2;
            }
        } else if (this.isDirectory) {
            this.showMessage("dir.nodirectory");
        } else {
            this.showMessage("file.nofile");
        }
        return bl;
    }

    public boolean validateField() {
        boolean bl = false;
        int n = this.model.getSize();
        if (n == 0 && this.allowEmpty) {
            return true;
        }
        for (int i = 0; i < n && (bl = this.validateFile((String)this.model.getElementAt(i))); ++i) {
        }
        return bl;
    }

    public boolean isAllowEmptyInput() {
        return this.allowEmpty;
    }

    public void setAllowEmptyInput(boolean bl) {
        this.allowEmpty = bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isCreateMultipleVariables() {
        return this.createMultipleVariables;
    }

    public void setCreateMultipleVariables(boolean bl) {
        this.createMultipleVariables = bl;
    }
}

