/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.Attribute;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeList
extends ArrayList<Object> {
    private transient boolean typeSafe;
    private transient boolean tainted;
    private static final long serialVersionUID = -4077085769279709076L;

    public AttributeList() {
    }

    public AttributeList(int n) {
        super(n);
    }

    public AttributeList(AttributeList attributeList) {
        super(attributeList);
    }

    public AttributeList(List<Attribute> list) {
        if (list == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        AttributeList.checkTypeSafe(list);
        super.addAll(list);
    }

    public List<Attribute> asList() {
        if (!this.typeSafe) {
            if (this.tainted) {
                AttributeList.checkTypeSafe(this);
            }
            this.typeSafe = true;
        }
        return this;
    }

    public void add(Attribute attribute) {
        super.add(attribute);
    }

    @Override
    public void add(int n, Attribute attribute) {
        try {
            super.add(n, attribute);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeOperationsException(indexOutOfBoundsException, "The specified index is out of range");
        }
    }

    @Override
    public void set(int n, Attribute attribute) {
        try {
            super.set(n, attribute);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeOperationsException(indexOutOfBoundsException, "The specified index is out of range");
        }
    }

    public boolean addAll(AttributeList attributeList) {
        return super.addAll(attributeList);
    }

    public boolean addAll(int n, AttributeList attributeList) {
        try {
            return super.addAll(n, attributeList);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeOperationsException(indexOutOfBoundsException, "The specified index is out of range");
        }
    }

    @Override
    public boolean add(Object object) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(object);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(object);
        }
        return super.add(object);
    }

    @Override
    public void add(int n, Object object) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(object);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(object);
        }
        super.add(n, object);
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(collection);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(collection);
        }
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<?> collection) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(collection);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(collection);
        }
        return super.addAll(n, collection);
    }

    @Override
    public Object set(int n, Object object) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(object);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(object);
        }
        return super.set(n, object);
    }

    private static void checkTypeSafe(Object object) {
        try {
            object = (Attribute)object;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    private static void checkTypeSafe(Collection<?> collection) {
        try {
            for (Object obj : collection) {
                Attribute attribute = (Attribute)obj;
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    private static boolean isTainted(Object object) {
        try {
            AttributeList.checkTypeSafe(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return false;
    }

    private static boolean isTainted(Collection<?> collection) {
        try {
            AttributeList.checkTypeSafe(collection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return false;
    }
}

