/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    private final E[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    final int inc(int n) {
        return ++n == this.items.length ? 0 : n;
    }

    private void insert(E e) {
        this.items[this.putIndex] = e;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private E extract() {
        E[] EArray = this.items;
        E e = EArray[this.takeIndex];
        EArray[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return e;
    }

    void removeAt(int n) {
        E[] EArray = this.items;
        if (n == this.takeIndex) {
            EArray[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int n2;
            while ((n2 = this.inc(n)) != this.putIndex) {
                EArray[n] = EArray[n2];
                n = n2;
            }
            EArray[n] = null;
            this.putIndex = n;
        }
        --this.count;
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int n) {
        this(n, false);
    }

    public ArrayBlockingQueue(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[n];
        this.lock = new ReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public ArrayBlockingQueue(int n, boolean bl, Collection<? extends E> collection) {
        this(n, bl);
        if (n < collection.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (this.count == this.items.length) {
                boolean bl = false;
                return bl;
            }
            this.insert(e);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            try {
                while (this.count == EArray.length) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notFull.signal();
                throw interruptedException;
            }
            this.insert(e);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            if (this.count == 0) {
                E e2 = null;
                return e2;
            }
            E e3 = e = this.extract();
            return e3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notEmpty.signal();
                throw interruptedException;
            }
            E e2 = e = this.extract();
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.items[this.takeIndex];
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = 0;
            while (true) {
                if (n2++ >= this.count) {
                    boolean bl = false;
                    return bl;
                }
                if (object.equals(EArray[n])) {
                    this.removeAt(n);
                    boolean bl = true;
                    return bl;
                }
                n = this.inc(n);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = 0;
            while (n2++ < this.count) {
                if (object.equals(EArray[n])) {
                    boolean bl = true;
                    return bl;
                }
                n = this.inc(n);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n = 0;
            int n2 = this.takeIndex;
            while (n < this.count) {
                objectArray[n++] = EArray[n2];
                n2 = this.inc(n2);
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            int n2 = this.takeIndex;
            while (n < this.count) {
                objectArray[n++] = EArray[n2];
                n2 = this.inc(n2);
            }
            if (objectArray.length > this.count) {
                objectArray[this.count] = null;
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            int n2 = this.count;
            while (n2-- > 0) {
                EArray[n] = null;
                n = this.inc(n);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
            this.notFull.signalAll();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            int n2 = this.takeIndex;
            int n3 = this.count;
            for (n = 0; n < n3; ++n) {
                collection.add(EArray[n2]);
                EArray[n2] = null;
                n2 = this.inc(n2);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n4 = n;
            return n4;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        E[] EArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            int n3;
            int n4 = this.takeIndex;
            int n5 = this.count;
            int n6 = n3 = n < this.count ? n : this.count;
            for (n2 = 0; n2 < n3; ++n2) {
                collection.add(EArray[n4]);
                EArray[n4] = null;
                n4 = this.inc(n4);
            }
            if (n2 > 0) {
                this.count -= n2;
                this.takeIndex = n4;
                this.notFull.signalAll();
            }
            int n7 = n2;
            return n7;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Itr itr = new Itr();
            return itr;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private int remaining;
        private int nextIndex;
        private E nextItem;
        private E lastItem;
        private int lastRet = -1;

        Itr() {
            this.remaining = ArrayBlockingQueue.this.count;
            if (this.remaining > 0) {
                this.nextIndex = ArrayBlockingQueue.this.takeIndex;
                this.nextItem = ArrayBlockingQueue.this.items[this.nextIndex];
            }
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                this.lastRet = this.nextIndex;
                this.lastItem = this.nextItem;
                Object e = this.lastItem;
                while (--this.remaining > 0) {
                    this.nextIndex = ArrayBlockingQueue.this.inc(this.nextIndex);
                    this.nextItem = ArrayBlockingQueue.this.items[this.nextIndex];
                    if (this.nextItem == null) continue;
                }
                Object e2 = e;
                return e2;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                int n = this.lastRet;
                if (n == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                if (this.lastItem == ArrayBlockingQueue.this.items[n]) {
                    ArrayBlockingQueue.this.removeAt(n);
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }
}

