/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;

public class JulianCalendar
extends BaseCalendar {
    private static final int BCE = 0;
    private static final int CE = 1;
    private static final Era[] eras = new Era[]{new Era("BeforeCommonEra", "B.C.E.", Long.MIN_VALUE, false), new Era("CommonEra", "C.E.", -62135709175808L, true)};
    private static final int JULIAN_EPOCH = -1;

    JulianCalendar() {
        this.setEras(eras);
    }

    public String getName() {
        return "julian";
    }

    public Date getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    public Date getCalendarDate(long l) {
        return this.getCalendarDate(l, this.newCalendarDate());
    }

    public Date getCalendarDate(long l, CalendarDate calendarDate) {
        return (Date)super.getCalendarDate(l, calendarDate);
    }

    public Date getCalendarDate(long l, TimeZone timeZone) {
        return this.getCalendarDate(l, this.newCalendarDate(timeZone));
    }

    public Date newCalendarDate() {
        return new Date();
    }

    public Date newCalendarDate(TimeZone timeZone) {
        return new Date(timeZone);
    }

    public long getFixedDate(int n, int n2, int n3, BaseCalendar.Date date) {
        boolean bl;
        boolean bl2 = bl = n2 == 1 && n3 == 1;
        if (date != null && date.hit(n)) {
            if (bl) {
                return date.getCachedJan1();
            }
            return date.getCachedJan1() + this.getDayOfYear(n, n2, n3) - 1L;
        }
        long l = n;
        long l2 = -2L + 365L * (l - 1L) + (long)n3;
        l2 = l > 0L ? (l2 += (l - 1L) / 4L) : (l2 += CalendarUtils.floorDivide(l - 1L, 4L));
        l2 = n2 > 0 ? (l2 += (367L * (long)n2 - 362L) / 12L) : (l2 += CalendarUtils.floorDivide(367L * (long)n2 - 362L, 12L));
        if (n2 > 2) {
            l2 -= CalendarUtils.isJulianLeapYear(n) ? 1L : 2L;
        }
        if (date != null && bl) {
            date.setCache(n, l2, CalendarUtils.isJulianLeapYear(n) ? 366 : 365);
        }
        return l2;
    }

    public void getCalendarDateFromFixedDate(CalendarDate calendarDate, long l) {
        int n;
        Date date = (Date)calendarDate;
        long l2 = 4L * (l - -1L) + 1464L;
        int n2 = l2 >= 0L ? (int)(l2 / 1461L) : (int)CalendarUtils.floorDivide(l2, 1461L);
        int n3 = (int)(l - this.getFixedDate(n2, 1, 1, date));
        boolean bl = CalendarUtils.isJulianLeapYear(n2);
        if (l >= this.getFixedDate(n2, 3, 1, date)) {
            n3 += bl ? 1 : 2;
        }
        n = (n = 12 * n3 + 373) > 0 ? (n /= 367) : CalendarUtils.floorDivide(n, 367);
        int n4 = (int)(l - this.getFixedDate(n2, n, 1, date)) + 1;
        int n5 = JulianCalendar.getDayOfWeekFromFixedDate(l);
        assert (n5 > 0) : "negative day of week " + n5;
        date.setNormalizedYear(n2);
        date.setMonth(n);
        date.setDayOfMonth(n4);
        date.setDayOfWeek(n5);
        date.setLeapYear(bl);
        date.setNormalized(true);
    }

    public int getYearFromFixedDate(long l) {
        int n = (int)CalendarUtils.floorDivide(4L * (l - -1L) + 1464L, 1461L);
        return n;
    }

    public int getDayOfWeek(CalendarDate calendarDate) {
        long l = this.getFixedDate(calendarDate);
        return JulianCalendar.getDayOfWeekFromFixedDate(l);
    }

    boolean isLeapYear(int n) {
        return CalendarUtils.isJulianLeapYear(n);
    }

    private static class Date
    extends BaseCalendar.Date {
        protected Date() {
            this.setCache(1, -1L, 365);
        }

        protected Date(TimeZone timeZone) {
            super(timeZone);
            this.setCache(1, -1L, 365);
        }

        public Date setEra(Era era) {
            if (era == null) {
                throw new NullPointerException();
            }
            if (era != eras[0] || era != eras[1]) {
                throw new IllegalArgumentException("unknown era: " + era);
            }
            super.setEra(era);
            return this;
        }

        protected void setKnownEra(Era era) {
            super.setEra(era);
        }

        public int getNormalizedYear() {
            if (this.getEra() == eras[0]) {
                return 1 - this.getYear();
            }
            return this.getYear();
        }

        public void setNormalizedYear(int n) {
            if (n <= 0) {
                this.setYear(1 - n);
                this.setKnownEra(eras[0]);
            } else {
                this.setYear(n);
                this.setKnownEra(eras[1]);
            }
        }

        public String toString() {
            String string;
            String string2 = super.toString();
            string2 = string2.substring(string2.indexOf(84));
            StringBuffer stringBuffer = new StringBuffer();
            Era era = this.getEra();
            if (era != null && (string = era.getAbbreviation()) != null) {
                stringBuffer.append(string).append(' ');
            }
            stringBuffer.append(this.getYear()).append('-');
            CalendarUtils.sprintf0d(stringBuffer, this.getMonth(), 2).append('-');
            CalendarUtils.sprintf0d(stringBuffer, this.getDayOfMonth(), 2);
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
    }
}

