/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.spi.MidiFileReader;

public class RmfFileReader
extends MidiFileReader {
    static final int RMF_MAGIC = 1230128474;
    private static final int MIDI_TYPE_1 = 1;
    private static final int bisBufferSize = 1024;
    private static final int[] types = new int[]{1};

    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        if (JSSecurityManager.useNewAudioEngine()) {
            throw new InvalidMidiDataException("RMF is not supported");
        }
        int n = 16;
        int n2 = -1;
        float f = -1.0f;
        int n3 = -1;
        int n4 = -1;
        MidiFileFormat midiFileFormat = null;
        int n5 = types[0];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n);
        int n6 = dataInputStream.readInt();
        if (n6 != 1230128474) {
            dataInputStream.reset();
            throw new InvalidMidiDataException("not a valid RMF file");
        }
        dataInputStream.reset();
        midiFileFormat = new MidiFileFormat(n5, f, n3, n2, n4);
        return midiFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        if (JSSecurityManager.useNewAudioEngine()) {
            throw new InvalidMidiDataException("RMF is not supported");
        }
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        MidiFileFormat midiFileFormat = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        try {
            midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
        return midiFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        if (JSSecurityManager.useNewAudioEngine()) {
            throw new InvalidMidiDataException("RMF is not supported");
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        MidiFileFormat midiFileFormat = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        try {
            midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
        return midiFileFormat;
    }

    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        if (JSSecurityManager.useNewAudioEngine()) {
            throw new InvalidMidiDataException("RMF is not supported");
        }
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }

    public Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        if (JSSecurityManager.useNewAudioEngine()) {
            throw new InvalidMidiDataException("RMF is not supported");
        }
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        if (JSSecurityManager.useNewAudioEngine()) {
            throw new InvalidMidiDataException("RMF is not supported");
        }
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }
}

